/* DUPLICATOR MYSQL SCRIPT CREATED ON : 2015-11-17 14:15:18 */

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `bupg_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `bupg_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `bupg_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

CREATE TABLE `bupg_layerslider` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `author` int(10) NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL,
  `slug` varchar(100) NOT NULL,
  `data` mediumtext NOT NULL,
  `date_c` int(10) NOT NULL,
  `date_m` int(11) NOT NULL,
  `flag_hidden` tinyint(1) NOT NULL DEFAULT '0',
  `flag_deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

CREATE TABLE `bupg_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `bupg_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(64) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=4724 DEFAULT CHARSET=utf8;

CREATE TABLE `bupg_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=InnoDB AUTO_INCREMENT=18634 DEFAULT CHARSET=utf8;

CREATE TABLE `bupg_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(20) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=11431 DEFAULT CHARSET=utf8;

CREATE TABLE `bupg_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` text,
  `hover` text,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=utf8;

CREATE TABLE `bupg_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `bupg_revslider_settings` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `general` text NOT NULL,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `bupg_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `bupg_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` text NOT NULL,
  `layers` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `bupg_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` text NOT NULL,
  `layers` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `bupg_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `bupg_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8;

CREATE TABLE `bupg_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`),
  KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8;

CREATE TABLE `bupg_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=utf8;

CREATE TABLE `bupg_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(64) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(60) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;


/* INSERT TABLE DATA: bupg_comments */
INSERT INTO `bupg_comments` VALUES("1", "1", "Mr WordPress", "", "https://wordpress.org/", "", "2015-04-04 03:05:05", "2015-04-04 03:05:05", "Hi, this is a comment.\nTo delete a comment, just log in and view the post&#039;s comments. There you will have the option to edit or delete them.", "0", "1", "", "", "0", "0");

/* INSERT TABLE DATA: bupg_duplicator_packages */
INSERT INTO `bupg_duplicator_packages` VALUES("2", "20150626_birminghamupg", "558de149a76fe4169150626233329", "100", "2015-06-26 23:34:29", "dunamis", "O:11:\"DUP_Package\":16:{s:2:\"ID\";i:2;s:4:\"Name\";s:22:\"20150626_birminghamupg\";s:4:\"Hash\";s:29:\"558de149a76fe4169150626233329\";s:8:\"NameHash\";s:52:\"20150626_birminghamupg_558de149a76fe4169150626233329\";s:7:\"Version\";s:6:\"0.5.22\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:70:\"/hsphere/local/home/dunamis/birminghamupg.com/bhamupg/wp-snapshots/tmp\";s:8:\"StoreURL\";s:46:\"http://birminghamupg.com/bhamupg/wp-snapshots/\";s:8:\"ScanFile\";s:62:\"20150626_birminghamupg_558de149a76fe4169150626233329_scan.json\";s:7:\"Runtime\";s:10:\"49.08 sec.\";s:7:\"ExeSize\";s:8:\"318.02KB\";s:7:\"ZipSize\";s:7:\"53.26MB\";s:7:\"Archive\";O:11:\"DUP_Archive\":17:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"File\";s:64:\"20150626_birminghamupg_558de149a76fe4169150626233329_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:53:\"/hsphere/local/home/dunamis/birminghamupg.com/bhamupg\";s:4:\"Size\";i:55849875;s:12:\"WarnFileSize\";a:0:{}s:12:\"WarnFileName\";a:0:{}s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:5:\"Links\";a:0:{}s:8:\"OmitDirs\";a:0:{}s:9:\"OmitFiles\";a:0:{}s:10:\"\0*\0Package\";r:1;s:28:\"\0DUP_Archive\0filterDirsArray\";a:0:{}s:28:\"\0DUP_Archive\0filterExtsArray\";a:0:{}}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:66:\"20150626_birminghamupg_558de149a76fe4169150626233329_installer.php\";s:4:\"Size\";i:325654;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":11:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:3075488;s:4:\"File\";s:65:\"20150626_birminghamupg_558de149a76fe4169150626233329_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:136:\"/hsphere/local/home/dunamis/birminghamupg.com/bhamupg/wp-snapshots/tmp/20150626_birminghamupg_558de149a76fe4169150626233329_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `bupg_duplicator_packages` VALUES("3", "20151117_birminghamupg", "564b2e2558b7c4767151117133949", "100", "2015-11-17 13:44:17", "dunamis", "O:11:\"DUP_Package\":16:{s:2:\"ID\";i:3;s:4:\"Name\";s:22:\"20151117_birminghamupg\";s:4:\"Hash\";s:29:\"564b2e2558b7c4767151117133949\";s:8:\"NameHash\";s:52:\"20151117_birminghamupg_564b2e2558b7c4767151117133949\";s:7:\"Version\";s:6:\"0.5.22\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:70:\"/hsphere/local/home/dunamis/birminghamupg.com/bhamupg/wp-snapshots/tmp\";s:8:\"StoreURL\";s:46:\"http://birminghamupg.com/bhamupg/wp-snapshots/\";s:8:\"ScanFile\";s:62:\"20151117_birminghamupg_564b2e2558b7c4767151117133949_scan.json\";s:7:\"Runtime\";s:10:\"77.19 sec.\";s:7:\"ExeSize\";s:8:\"318.11KB\";s:7:\"ZipSize\";s:7:\"54.79MB\";s:7:\"Archive\";O:11:\"DUP_Archive\":17:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"File\";s:64:\"20151117_birminghamupg_564b2e2558b7c4767151117133949_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:53:\"/hsphere/local/home/dunamis/birminghamupg.com/bhamupg\";s:4:\"Size\";i:57452723;s:12:\"WarnFileSize\";a:0:{}s:12:\"WarnFileName\";a:0:{}s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:5:\"Links\";a:0:{}s:8:\"OmitDirs\";a:0:{}s:9:\"OmitFiles\";a:0:{}s:10:\"\0*\0Package\";r:1;s:28:\"\0DUP_Archive\0filterDirsArray\";a:0:{}s:28:\"\0DUP_Archive\0filterExtsArray\";a:0:{}}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:66:\"20151117_birminghamupg_564b2e2558b7c4767151117133949_installer.php\";s:4:\"Size\";i:325745;s:10:\"OptsDBHost\";s:26:\"mysql1306.ixwebhosting.com\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:21:\"dunamis_birminghamupg\";s:10:\"OptsDBUser\";s:16:\"dunamis_bhamcomo\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:24:\"http://birminghamupg.com\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":11:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:2969972;s:4:\"File\";s:65:\"20151117_birminghamupg_564b2e2558b7c4767151117133949_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:136:\"/hsphere/local/home/dunamis/birminghamupg.com/bhamupg/wp-snapshots/tmp/20151117_birminghamupg_564b2e2558b7c4767151117133949_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `bupg_duplicator_packages` VALUES("4", "20151117new_birminghamupg", "564b3622dcb341940151117141354", "20", "2015-11-17 14:15:18", "dunamis", "O:11:\"DUP_Package\":16:{s:2:\"ID\";i:4;s:4:\"Name\";s:25:\"20151117new_birminghamupg\";s:4:\"Hash\";s:29:\"564b3622dcb341940151117141354\";s:8:\"NameHash\";s:55:\"20151117new_birminghamupg_564b3622dcb341940151117141354\";s:7:\"Version\";s:6:\"0.5.34\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:70:\"/hsphere/local/home/dunamis/birminghamupg.com/bhamupg/wp-snapshots/tmp\";s:8:\"StoreURL\";s:46:\"http://birminghamupg.com/bhamupg/wp-snapshots/\";s:8:\"ScanFile\";s:65:\"20151117new_birminghamupg_564b3622dcb341940151117141354_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:67:\"20151117new_birminghamupg_564b3622dcb341940151117141354_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:53:\"/hsphere/local/home/dunamis/birminghamupg.com/bhamupg\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":16:{s:2:\"ID\";N;s:4:\"Name\";s:25:\"20151117new_birminghamupg\";s:4:\"Hash\";s:29:\"564b3622dcb341940151117141354\";s:8:\"NameHash\";s:55:\"20151117new_birminghamupg_564b3622dcb341940151117141354\";s:7:\"Version\";s:6:\"0.5.34\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:70:\"/hsphere/local/home/dunamis/birminghamupg.com/bhamupg/wp-snapshots/tmp\";s:8:\"StoreURL\";s:46:\"http://birminghamupg.com/bhamupg/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:7:\"Archive\";r:15;s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:69:\"20151117new_birminghamupg_564b3622dcb341940151117141354_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:45;}s:8:\"Database\";O:12:\"DUP_Database\":11:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:68:\"20151117new_birminghamupg_564b3622dcb341940151117141354_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}}s:9:\"Installer\";r:60;s:8:\"Database\";r:73;}");

/* INSERT TABLE DATA: bupg_layerslider */
INSERT INTO `bupg_layerslider` VALUES("1", "1", "Avada Captions Tall", "", "{\"properties\":{\"post_taxonomy\":\"0\",\"post_orderby\":\"date\",\"post_order\":\"DESC\",\"post_offset\":\"-1\",\"title\":\"Avada Captions Tall\",\"slug\":\"\",\"width\":\"615px\",\"height\":\"434px\",\"responsive\":\"on\",\"maxwidth\":\"\",\"responsiveunder\":\"0\",\"sublayercontainer\":\"0\",\"autostart\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"loops\":\"0\",\"forceloopnum\":\"on\",\"twowayslideshow\":\"on\",\"skin\":\"borderlesslight\",\"backgroundcolor\":\"transparent\",\"backgroundimage\":\"\",\"sliderstyle\":\"margin-bottom: 50px;\",\"thumb_nav\":\"disabled\",\"thumb_container_width\":\"60%\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"imgpreload\":\"on\",\"yourlogoId\":\"\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: 10px; top: 10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":10950,\"background\":\"http:\\/\\/birminghamupg.com\\/bhamupg_base\\/wp-content\\/uploads\\/layerslider\\/Avada-Captions-Tall\\/portfolio_2.jpg\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"timeshift\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #3\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Avada Theme\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"500\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"267px\",\"left\":\"31px\",\"style\":\"color: #fff; \\r\\ntext-shadow: none; \\r\\nfont-size: 22px; \\r\\nline-height: 34px; \\r\\npadding: 0px 10px; \\r\\npadding-top: 1px;\\r\\nmargin: 0px; \\r\\nborder-width: 0px; \\r\\nborder-style: none; \\r\\nbackground-color:#000;\\t\\r\\nfont-family: PTSansRegular, Arial, Helvetica, sans-serif;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #1\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Amazingly Flexible\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"left\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"color\\\\\\\":\\\\\\\"#333333\\\\\\\"}\",\"top\":\"310px\",\"left\":\"31px\",\"style\":\"font-size: 42px; \\r\\nline-height: 45px; \\r\\nfont-family: museoslab500regular;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #2\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"We include so many features, shortcodes and options <br> that provides endless combinations for page layouts\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"bottom\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"21px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#333333\\\\\\\"}\",\"top\":\"364px\",\"left\":\"32px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":10949,\"background\":\"http:\\/\\/birminghamupg.com\\/bhamupg_base\\/wp-content\\/uploads\\/layerslider\\/Avada-Captions-Tall\\/portfolio_1.jpg\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"timeshift\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #3\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Avada Is\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"500\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"267px\",\"left\":\"31px\",\"style\":\"color: #fff; \\r\\ntext-shadow: none; \\r\\nfont-size: 22px; \\r\\nline-height: 34px; \\r\\npadding: 0px 10px; \\r\\npadding-top: 1px;\\r\\nmargin: 0px; \\r\\nborder-width: 0px; \\r\\nborder-style: none; \\r\\nbackground-color:#000;\\t\\r\\nfont-family: PTSansRegular, Arial, Helvetica, sans-serif;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #1\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Built For You\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"left\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"museoslab500regular\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"42px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#333333\\\\\\\"}\",\"top\":\"310px\",\"left\":\"31px\",\"style\":\"\\r\\n\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #2\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"We\\\\\'ve put so much thought and care into <br> making Avada user friendly for everyone\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"bottom\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"21px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#333333\\\\\\\"}\",\"top\":\"364px\",\"left\":\"32px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]}]}", "1428116979", "1428116979", "0", "0");
INSERT INTO `bupg_layerslider` VALUES("2", "1", "Avada Full Width", "", "{\"properties\":{\"post_taxonomy\":\"0\",\"post_orderby\":\"date\",\"post_order\":\"DESC\",\"post_offset\":\"-1\",\"title\":\"Avada Full Width\",\"slug\":\"\",\"width\":\"100%\",\"height\":\"400px\",\"maxwidth\":\"\",\"forceresponsive\":\"on\",\"responsiveunder\":\"960\",\"sublayercontainer\":\"960\",\"autostart\":\"on\",\"pauseonhover\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"loops\":\"0\",\"forceloopnum\":\"on\",\"twowayslideshow\":\"on\",\"skin\":\"avada\",\"backgroundcolor\":\"#f6f6f6\",\"backgroundimage\":\"\",\"sliderstyle\":\"margin-bottom: 0px;\",\"navprevnext\":\"on\",\"navstartstop\":\"on\",\"navbuttons\":\"on\",\"circletimer\":\"on\",\"thumb_nav\":\"hover\",\"thumb_container_width\":\"60%\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"imgpreload\":\"on\",\"yourlogoId\":\"\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: -10px; top: -10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":\"\",\"background\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"6000\",\"timeshift\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Clouds\",\"media\":\"img\",\"type\":\"p\",\"imageId\":10956,\"image\":\"http:\\/\\/birminghamupg.com\\/bhamupg_base\\/wp-content\\/uploads\\/layerslider\\/Avada-Full-Width\\/slide_4.jpg\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"0px\",\"left\":\"0px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Mac\",\"media\":\"img\",\"type\":\"p\",\"imageId\":10954,\"image\":\"http:\\/\\/birminghamupg.com\\/bhamupg_base\\/wp-content\\/uploads\\/layerslider\\/Avada-Full-Width\\/mac.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"left\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"34px\",\"left\":\"506px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"iPad\",\"media\":\"img\",\"type\":\"p\",\"imageId\":10952,\"image\":\"http:\\/\\/birminghamupg.com\\/bhamupg_base\\/wp-content\\/uploads\\/layerslider\\/Avada-Full-Width\\/ipad2.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"top\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"157px\",\"left\":\"457px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"iPhone\",\"media\":\"img\",\"type\":\"p\",\"imageId\":10953,\"image\":\"http:\\/\\/birminghamupg.com\\/bhamupg_base\\/wp-content\\/uploads\\/layerslider\\/Avada-Full-Width\\/iphone.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"800\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"209px\",\"left\":\"403px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Avada Wordpress Theme\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Avada WP Theme\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"top\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1400\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"40\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#333333\\\\\\\"}\",\"top\":\"83px\",\"left\":\"1px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Made With Care...\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Made With Care For Our Users\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"bottom\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1800\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"357\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"38\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"24\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"38\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#a0ce4e\\\\\\\"}\",\"top\":\"135px\",\"left\":\"1px\",\"style\":\"text-align: center; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Lid est laborum ...\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Lid est laborum dolo rumes fugats untras. Et harums ser quidem<br \\/> \\r\\nrerum facilisdolores nemis omnis fugiats vitaes nemo minima<br \\/> \\r\\nrerums unsers sadips amets sadips ipsums\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"2200\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"color\\\\\\\":\\\\\\\"#333333\\\\\\\"}\",\"top\":\"195px\",\"left\":\"2px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Purchase Now\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"[button link=\\\\\\\"http:\\/\\/themeforest.net\\/item\\/avada-responsive-multipurpose-theme\\/2833226?ref=ThemeFusion\\\\\\\" color=\\\\\\\"default\\\\\\\" size=\\\\\\\"\\\\\\\" type=\\\\\\\"\\\\\\\" shape=\\\\\\\"\\\\\\\" target=\\\\\\\"_self\\\\\\\" title=\\\\\\\"\\\\\\\" gradient_colors=\\\\\\\"|\\\\\\\" gradient_hover_colors=\\\\\\\"|\\\\\\\" accent_color=\\\\\\\"\\\\\\\" accent_hover_color=\\\\\\\"\\\\\\\" bevel_color=\\\\\\\"\\\\\\\" border_width=\\\\\\\"1px\\\\\\\" shadow=\\\\\\\"\\\\\\\" icon=\\\\\\\"\\\\\\\" icon_divider=\\\\\\\"yes\\\\\\\" icon_position=\\\\\\\"left\\\\\\\" modal=\\\\\\\"\\\\\\\" animation_type=\\\\\\\"0\\\\\\\" animation_direction=\\\\\\\"down\\\\\\\" animation_speed=\\\\\\\"0.1\\\\\\\" class=\\\\\\\"\\\\\\\" id=\\\\\\\"\\\\\\\"]Purchase Now![\\/button]\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"bottom\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"2000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"2400\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"279px\",\"left\":\"1px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":10957,\"background\":\"http:\\/\\/birminghamupg.com\\/bhamupg_base\\/wp-content\\/uploads\\/layerslider\\/Avada-Full-Width\\/slide_5.jpg\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"timeshift\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"iPad\",\"media\":\"img\",\"type\":\"p\",\"imageId\":10951,\"image\":\"http:\\/\\/birminghamupg.com\\/bhamupg_base\\/wp-content\\/uploads\\/layerslider\\/Avada-Full-Width\\/ipad.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"2000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\".2\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\".2\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"54px\",\"left\":\"-1px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Avada Is Better ...\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Avada Is Better Than Ever\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"top\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"700\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"295\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"22px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#a0ce4e\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#333333\\\\\\\"}\",\"top\":\"67px\",\"left\":\"666px\",\"style\":\"text-align: center; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"100% Fully Responsive\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"100% Fully Responsive\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"bottom\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1100\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"250\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"22px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#a0ce4e\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#333333\\\\\\\"}\",\"top\":\"106px\",\"left\":\"711px\",\"style\":\"text-align: center; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"With Numerous\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"With Numerous\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"top\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"190\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"22px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#333333\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#a0ce4e\\\\\\\"}\",\"top\":\"175px\",\"left\":\"770px\",\"style\":\"text-align: center; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Additions & Optimizations\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Additions & Optimizations\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"bottom\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1800\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"285\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"22px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#333333\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#a0ce4e\\\\\\\"}\",\"top\":\"215px\",\"left\":\"675px\",\"style\":\"text-align: center; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"It Doesn\\\\\'t Get Better\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"It Doesn\\\\\'t Get Better Than This\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"top\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"2100\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"342\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"22px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#a0ce4e\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#333333\\\\\\\"}\",\"top\":\"289px\",\"left\":\"617px\",\"style\":\"text-align: center; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":10955,\"background\":\"http:\\/\\/birminghamupg.com\\/bhamupg_base\\/wp-content\\/uploads\\/layerslider\\/Avada-Full-Width\\/slide_3.jpg\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"timeshift\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Create Fantastic...\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Create Fantastic Sliders With Animations\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"top\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"200\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"430\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"21px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#000000\\\\\\\"}\",\"top\":\"82px\",\"left\":\"270px\",\"style\":\"text-align: center; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Be Creative\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"BE CREATIVE\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"700\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":\\\\\\\"150px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"178px\",\"left\":\"81px\",\"style\":\"text-align: center; font-weight: normal; text-shadow: 0px 2px 5px rgba(0, 0, 0, 1);\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"The Possibilities Are...\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"The Possibilities Are Endless And Results Stunning\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"bottom\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":false,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"right\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":false,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1.0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"515\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"21px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#000000\\\\\\\"}\",\"top\":\"275px\",\"left\":\"232px\",\"style\":\"text-align: center; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]}]}", "1428116980", "1428116980", "0", "0");
INSERT INTO `bupg_layerslider` VALUES("3", "1", "Avada Small Slider", "", "{\"properties\":{\"title\":\"Avada Small Slider\",\"width\":\"451px\",\"height\":\"220px\",\"responsive\":\"on\",\"responsiveunder\":\"0\",\"sublayercontainer\":\"0\",\"autostart\":\"on\",\"pauseonhover\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"twowayslideshow\":\"on\",\"loops\":\"0\",\"forceloopnum\":\"on\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"skin\":\"borderlesslight3d\",\"backgroundcolor\":\"#f6f6f6\",\"backgroundimage\":\"\",\"sliderstyle\":\"\",\"navstartstop\":\"on\",\"navbuttons\":\"on\",\"hoverprevnext\":\"on\",\"circletimer\":\"on\",\"thumb_nav\":\"hover\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_container_width\":\"60%\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"imgpreload\":\"on\",\"bodyinclude\":\"on\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: 10px; top: 10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"\",\"thumbnail\":\"http:\\/\\/birminghamupg.com\\/bhamupg_base\\/wp-content\\/uploads\\/layerslider\\/Avada-Small-Slider\\/iphone.png\",\"slidedelay\":\"4000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\",\"thumbnailId\":10959},\"sublayers\":[{\"subtitle\":\"iPhone\",\"type\":\"img\",\"image\":\"http:\\/\\/birminghamupg.com\\/bhamupg_base\\/wp-content\\/uploads\\/layerslider\\/Avada-Small-Slider\\/iphone.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"200\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"28px\",\"left\":\"73px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"imageId\":10959},{\"subtitle\":\"Logo\",\"type\":\"img\",\"image\":\"http:\\/\\/birminghamupg.com\\/bhamupg_base\\/wp-content\\/uploads\\/layerslider\\/Avada-Small-Slider\\/logo.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"500\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"66px\",\"left\":\"194px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"imageId\":10960},{\"subtitle\":\"Wordpress Theme\",\"type\":\"p\",\"image\":\"\",\"html\":\"Wordpress Theme\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1000\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":\\\\\\\"23px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#a0ce4e\\\\\\\"}\",\"top\":\"114px\",\"left\":\"195px\",\"style\":\"font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"\",\"thumbnail\":\"http:\\/\\/birminghamupg.com\\/bhamupg_base\\/wp-content\\/uploads\\/layerslider\\/Avada-Small-Slider\\/ipad2.png\",\"slidedelay\":\"4000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\",\"thumbnailId\":10958},\"sublayers\":[{\"subtitle\":\"iPad\",\"type\":\"img\",\"image\":\"http:\\/\\/birminghamupg.com\\/bhamupg_base\\/wp-content\\/uploads\\/layerslider\\/Avada-Small-Slider\\/ipad2.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"200\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"33px\",\"left\":\"40px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"imageId\":10958},{\"subtitle\":\"Logo\",\"type\":\"img\",\"image\":\"http:\\/\\/birminghamupg.com\\/bhamupg_base\\/wp-content\\/uploads\\/layerslider\\/Avada-Small-Slider\\/logo.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"500\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"70px\",\"left\":\"235px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"imageId\":10960},{\"subtitle\":\"#1 Selling Theme\",\"type\":\"p\",\"image\":\"\",\"html\":\"#1 Selling Theme\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1000\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":\\\\\\\"23px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#a0ce4e\\\\\\\"}\",\"top\":\"115px\",\"left\":\"234px\",\"style\":\"font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]}]}", "1428116980", "1428116980", "0", "0");
INSERT INTO `bupg_layerslider` VALUES("4", "1", "Avada Transparent Header", "", "{\"properties\":{\"post_type\":[\"attachment\"],\"post_taxonomy\":\"0\",\"post_orderby\":\"date\",\"post_order\":\"DESC\",\"post_offset\":\"-1\",\"title\":\"Avada Transparent Header\",\"slug\":\"\",\"width\":\"100%\",\"height\":\"650px\",\"maxwidth\":\"\",\"forceresponsive\":\"on\",\"responsiveunder\":\"940\",\"sublayercontainer\":\"1100\",\"autostart\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"loops\":\"0\",\"skin\":\"v5\",\"backgroundcolor\":\"\",\"backgroundimage\":\"\",\"sliderstyle\":\"margin-bottom: 0px;\",\"navprevnext\":\"on\",\"navstartstop\":\"on\",\"navbuttons\":\"on\",\"hoverprevnext\":\"on\",\"circletimer\":\"on\",\"thumb_nav\":\"hover\",\"thumb_container_width\":\"60%\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"imgpreload\":\"on\",\"lazyload\":\"on\",\"yourlogoId\":\"\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: -10px; top: -10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) {\\r\\n\\r\\n}\",\"cbstart\":\"function(data) {\\r\\n\\r\\n}\",\"cbstop\":\"function(data) {\\r\\n\\r\\n}\",\"cbpause\":\"function(data) {\\r\\n\\r\\n}\",\"cbanimstart\":\"function(data) {\\r\\n\\r\\n}\",\"cbanimstop\":\"function(data) {\\r\\n\\r\\n}\",\"cbprev\":\"function(data) {\\r\\n\\r\\n}\",\"cbnext\":\"function(data) {\\r\\n\\r\\n}\"},\"layers\":[{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"75,79\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":10971,\"background\":\"http:\\/\\/birminghamupg.com\\/bhamupg_base\\/wp-content\\/uploads\\/layerslider\\/Avada-Transparent-Header\\/ls_bkgd_color1.jpg\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"11000\",\"timeshift\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"5-1\",\"media\":\"img\",\"type\":\"p\",\"imageId\":10961,\"image\":\"http:\\/\\/birminghamupg.com\\/bhamupg_base\\/wp-content\\/uploads\\/layerslider\\/Avada-Transparent-Header\\/A2_1.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"left 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"right -50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"390px\",\"left\":\"0px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"5-2\",\"media\":\"img\",\"type\":\"p\",\"imageId\":10962,\"image\":\"http:\\/\\/birminghamupg.com\\/bhamupg_base\\/wp-content\\/uploads\\/layerslider\\/Avada-Transparent-Header\\/A2_2.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1300\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"left 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"left -50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"390px\",\"left\":\"135px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"5-3\",\"media\":\"img\",\"type\":\"p\",\"imageId\":10963,\"image\":\"http:\\/\\/birminghamupg.com\\/bhamupg_base\\/wp-content\\/uploads\\/layerslider\\/Avada-Transparent-Header\\/A2_3.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1600\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% bottom 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"500\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"left 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"267px\",\"left\":\"135px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"5-4\",\"media\":\"img\",\"type\":\"p\",\"imageId\":10964,\"image\":\"http:\\/\\/birminghamupg.com\\/bhamupg_base\\/wp-content\\/uploads\\/layerslider\\/Avada-Transparent-Header\\/A2_4.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1900\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"-90\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"right 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"right 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"267px\",\"left\":\"0px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"5-5\",\"media\":\"img\",\"type\":\"p\",\"imageId\":10965,\"image\":\"http:\\/\\/birminghamupg.com\\/bhamupg_base\\/wp-content\\/uploads\\/layerslider\\/Avada-Transparent-Header\\/A2_5.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"2200\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% bottom 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"right 150% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"145px\",\"left\":\"0px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"5-6\",\"media\":\"img\",\"type\":\"p\",\"imageId\":10966,\"image\":\"http:\\/\\/birminghamupg.com\\/bhamupg_base\\/wp-content\\/uploads\\/layerslider\\/Avada-Transparent-Header\\/A2_6.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"2500\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"left 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"left 150% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"145px\",\"left\":\"135px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"AVADA\",\"media\":\"text\",\"type\":\"h1\",\"imageId\":\"\",\"image\":\"\",\"html\":\"AVADA\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"2500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"3000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeOutElastic\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% bottom 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"-90\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"left bottom 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"340px\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"70px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#000\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"5px\\\\\\\"}\",\"top\":\"132px\",\"left\":\"294px\",\"style\":\"font-weight: 500; text-align: center;  \\r\\nletter-spacing: .1em;\\r\\nfont-family: museoslab500regular; line-height: 115%;\\r\\nopacity: .3;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"POWERFUL OPTIONS\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"POWERFUL OPTIONS\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"4000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"30\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"left 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.5\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.5\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"-30\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"left 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"height\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"37px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#fa6b4b\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"4px\\\\\\\"}\",\"top\":\"242px\",\"left\":\"325px\",\"style\":\"font-weight: 300;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"for just about anything you need!\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"for just about anything you need to help customize!\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"4400\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"25% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"60\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"100\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"60\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"24\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#333\\\\\\\"}\",\"top\":\"288px\",\"left\":\"325px\",\"style\":\"font-weight: 300;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"AMAZING SLIDERS\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"AMAZING SLIDERS\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"4700\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"30\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"left 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.5\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.5\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"-30\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"left 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"height\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"37px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#fa6b4b\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"4px\\\\\\\"}\",\"top\":\"343px\",\"left\":\"325px\",\"style\":\"font-weight: 300;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"slide, fade, scale, skew and rotate layers!\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"slide, fade, scale, skew and rotate your individual layers!\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"5100\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"25% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"60\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"100\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"60\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"24\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#333\\\\\\\"}\",\"top\":\"391px\",\"left\":\"325px\",\"style\":\"font-weight: 300;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"OUTSTANDING SUPPORT\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"OUTSTANDING SUPPORT\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"5400\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"30\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"left 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.5\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1.5\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"-30\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"left 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"height\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"37px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#fa6b4b\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"4px\\\\\\\"}\",\"top\":\"445px\",\"left\":\"325px\",\"style\":\"font-weight: 300;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"trust in us for after sale support!\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"trust in us for after sale support, we got your back!\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"5800\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"25% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"60\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"100\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"750\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"60\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"24\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#333\\\\\\\"}\",\"top\":\"490px\",\"left\":\"325px\",\"style\":\"font-weight: 300;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #14\",\"media\":\"img\",\"type\":\"p\",\"imageId\":10969,\"image\":\"http:\\/\\/birminghamupg.com\\/bhamupg_base\\/wp-content\\/uploads\\/layerslider\\/Avada-Transparent-Header\\/html5-color.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"-100\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"6300\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutCubic\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"-180\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"189px\",\"left\":\"990px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #14 copy\",\"media\":\"img\",\"type\":\"p\",\"imageId\":10972,\"image\":\"http:\\/\\/birminghamupg.com\\/bhamupg_base\\/wp-content\\/uploads\\/layerslider\\/Avada-Transparent-Header\\/vimeo-color.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"-100\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"6500\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutCubic\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"-180\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"305px\",\"left\":\"990px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #14 copy copy\",\"media\":\"img\",\"type\":\"p\",\"imageId\":10973,\"image\":\"http:\\/\\/birminghamupg.com\\/bhamupg_base\\/wp-content\\/uploads\\/layerslider\\/Avada-Transparent-Header\\/youtube-color.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"-100\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"6700\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutCubic\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"-180\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"430px\",\"left\":\"990px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"21,105\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":10967,\"background\":\"http:\\/\\/birminghamupg.com\\/bhamupg_base\\/wp-content\\/uploads\\/layerslider\\/Avada-Transparent-Header\\/bg6b.jpg\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"8000\",\"timeshift\":\"-1000\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"circle\",\"media\":\"img\",\"type\":\"p\",\"imageId\":10968,\"image\":\"http:\\/\\/birminghamupg.com\\/bhamupg_base\\/wp-content\\/uploads\\/layerslider\\/Avada-Transparent-Header\\/circle.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"3000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"linear\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"linear\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"115px\",\"left\":\"50%\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"circle 2\",\"media\":\"img\",\"type\":\"p\",\"imageId\":10968,\"image\":\"http:\\/\\/birminghamupg.com\\/bhamupg_base\\/wp-content\\/uploads\\/layerslider\\/Avada-Transparent-Header\\/circle.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"4000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"linear\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"linear\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"115px\",\"left\":\"50%\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"&\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"&\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"2500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"200px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#f06a52\\\\\\\"}\",\"top\":\"65px\",\"left\":\"2px\",\"style\":\"font-weight: 300; opacity: .4\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"all these features\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"ALL THIS\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"-50\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"2000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-50\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"height\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"29px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"37px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#bd5949\\\\\\\"}\",\"top\":\"149px\",\"left\":\"0px\",\"style\":\"font-weight: 300; background: white; background: rgba(255,255,255,.85)\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"much more!\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"much more!\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"50\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"2000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"-60\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-50\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"-60\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"29px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#bd5949\\\\\\\"}\",\"top\":\"199px\",\"left\":\"45px\",\"style\":\"font-weight: 500;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"to create\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"...to create\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"2500\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"right bottom 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"right bottom 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#bd5949\\\\\\\"}\",\"top\":\"422px\",\"left\":\"958px\",\"style\":\"font-weight: 500; text-align: right;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"the best slider\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"THE BEST SLIDER\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"2500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"3250\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeOutElastic\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% top 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"90\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% bottom 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"260px\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Lato, \\\\\'Open Sans\\\\\', sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"37px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#f06a52\\\\\\\"}\",\"top\":\"463px\",\"left\":\"828px\",\"style\":\"font-weight: 300; text-align: right;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"with no compromises\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"with no compromises!\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"-50\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"3500\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"60\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1.5\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-50\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"60\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1.5\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"\\\\\'Indie Flower\\\\\'\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#d9482b\\\\\\\"}\",\"top\":\"512px\",\"left\":\"829px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"ls5box\",\"media\":\"img\",\"type\":\"p\",\"imageId\":10970,\"image\":\"http:\\/\\/birminghamupg.com\\/bhamupg_base\\/wp-content\\/uploads\\/layerslider\\/Avada-Transparent-Header\\/ipad.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"80\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\".8\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\".8\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"-80\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\".8\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\".8\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"147px\",\"left\":\"289px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]}]}", "1428116980", "1428116980", "0", "0");

/* INSERT TABLE DATA: bupg_options */
INSERT INTO `bupg_options` VALUES("1", "siteurl", "http://birminghamupg.com/bhamupg", "yes");
INSERT INTO `bupg_options` VALUES("2", "home", "http://birminghamupg.com", "yes");
INSERT INTO `bupg_options` VALUES("3", "blogname", "Birmingham Peoples", "yes");
INSERT INTO `bupg_options` VALUES("4", "blogdescription", "Discover Welcome Engage", "yes");
INSERT INTO `bupg_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `bupg_options` VALUES("6", "admin_email", "ken@dunamis-studio.com", "yes");
INSERT INTO `bupg_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `bupg_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `bupg_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `bupg_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `bupg_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `bupg_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `bupg_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `bupg_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `bupg_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `bupg_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `bupg_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `bupg_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `bupg_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `bupg_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `bupg_options` VALUES("21", "default_pingback_flag", "0", "yes");
INSERT INTO `bupg_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `bupg_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `bupg_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `bupg_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `bupg_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `bupg_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `bupg_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `bupg_options` VALUES("29", "gzipcompression", "0", "yes");
INSERT INTO `bupg_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `bupg_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `bupg_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `bupg_options` VALUES("33", "active_plugins", "a:6:{i:0;s:27:\"LayerSlider/layerslider.php\";i:1;s:36:\"contact-form-7/wp-contact-form-7.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:27:\"fusion-core/fusion-core.php\";i:4;s:23:\"revslider/revslider.php\";i:5;s:24:\"wordpress-seo/wp-seo.php\";}", "yes");
INSERT INTO `bupg_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `bupg_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `bupg_options` VALUES("36", "advanced_edit", "0", "yes");
INSERT INTO `bupg_options` VALUES("37", "comment_max_links", "2", "yes");
INSERT INTO `bupg_options` VALUES("38", "gmt_offset", "0", "yes");
INSERT INTO `bupg_options` VALUES("39", "default_email_category", "1", "yes");
INSERT INTO `bupg_options` VALUES("40", "recently_edited", "a:2:{i:0;s:87:\"/hsphere/local/home/dunamis/birminghamupg.com/bhamupg/wp-content/themes/Avada/style.css\";i:2;s:0:\"\";}", "no");
INSERT INTO `bupg_options` VALUES("41", "template", "Avada", "yes");
INSERT INTO `bupg_options` VALUES("42", "stylesheet", "Avada", "yes");
INSERT INTO `bupg_options` VALUES("43", "comment_whitelist", "1", "yes");
INSERT INTO `bupg_options` VALUES("44", "blacklist_keys", "", "no");
INSERT INTO `bupg_options` VALUES("45", "comment_registration", "0", "yes");
INSERT INTO `bupg_options` VALUES("46", "html_type", "text/html", "yes");
INSERT INTO `bupg_options` VALUES("47", "use_trackback", "0", "yes");
INSERT INTO `bupg_options` VALUES("48", "default_role", "subscriber", "yes");
INSERT INTO `bupg_options` VALUES("49", "db_version", "30135", "yes");
INSERT INTO `bupg_options` VALUES("50", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `bupg_options` VALUES("51", "upload_path", "", "yes");
INSERT INTO `bupg_options` VALUES("52", "blog_public", "1", "yes");
INSERT INTO `bupg_options` VALUES("53", "default_link_category", "2", "yes");
INSERT INTO `bupg_options` VALUES("54", "show_on_front", "page", "yes");
INSERT INTO `bupg_options` VALUES("55", "tag_base", "", "yes");
INSERT INTO `bupg_options` VALUES("56", "show_avatars", "1", "yes");
INSERT INTO `bupg_options` VALUES("57", "avatar_rating", "G", "yes");
INSERT INTO `bupg_options` VALUES("58", "upload_url_path", "", "yes");
INSERT INTO `bupg_options` VALUES("59", "thumbnail_size_w", "150", "yes");
INSERT INTO `bupg_options` VALUES("60", "thumbnail_size_h", "150", "yes");
INSERT INTO `bupg_options` VALUES("61", "thumbnail_crop", "1", "yes");
INSERT INTO `bupg_options` VALUES("62", "medium_size_w", "300", "yes");
INSERT INTO `bupg_options` VALUES("63", "medium_size_h", "300", "yes");
INSERT INTO `bupg_options` VALUES("64", "avatar_default", "mystery", "yes");
INSERT INTO `bupg_options` VALUES("65", "large_size_w", "1024", "yes");
INSERT INTO `bupg_options` VALUES("66", "large_size_h", "1024", "yes");
INSERT INTO `bupg_options` VALUES("67", "image_default_link_type", "file", "yes");
INSERT INTO `bupg_options` VALUES("68", "image_default_size", "", "yes");
INSERT INTO `bupg_options` VALUES("69", "image_default_align", "", "yes");
INSERT INTO `bupg_options` VALUES("70", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `bupg_options` VALUES("71", "close_comments_days_old", "14", "yes");
INSERT INTO `bupg_options` VALUES("72", "thread_comments", "1", "yes");
INSERT INTO `bupg_options` VALUES("73", "thread_comments_depth", "5", "yes");
INSERT INTO `bupg_options` VALUES("74", "page_comments", "0", "yes");
INSERT INTO `bupg_options` VALUES("75", "comments_per_page", "50", "yes");
INSERT INTO `bupg_options` VALUES("76", "default_comments_page", "newest", "yes");
INSERT INTO `bupg_options` VALUES("77", "comment_order", "asc", "yes");
INSERT INTO `bupg_options` VALUES("78", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `bupg_options` VALUES("79", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bupg_options` VALUES("80", "widget_text", "a:14:{i:6;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:1099:\"[accordian][toggle title=\"Our Company Mission\"]Fugiat dapibus, tellus ac cursus commodo, mauris sit condim eser ntumsi nibh, uum a justo vitaes amet risus amets un. Posi sectetut amet fermntum orem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia nons.[/toggle]\r\n[toggle title=\"The Avada Philosophy\"]Fugiat dapibus, tellus ac cursus commodo, mauris sit condim eser ntumsi nibh, uum a justo vitaes amet risus amets un. Posi sectetut amet fermntum orem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia nons.[/toggle]\r\n[toggle title=\"The Avada Promise\"]Fugiat dapibus, tellus ac cursus commodo, mauris sit condim eser ntumsi nibh, uum a justo vitaes amet risus amets un. Posi sectetut amet fermntum orem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia nons.[/toggle]\r\n[toggle title=\"We Can Deliver On Projects\"]Fugiat dapibus, tellus ac cursus commodo, mauris sit condim eser ntumsi nibh, uum a justo vitaes amet risus amets un. Posi sectetut amet fermntum orem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia nons.[/toggle][/accordian]\";s:6:\"filter\";b:0;}i:7;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:489:\"[testimonials]\r\n[testimonial name=\"John Doe\" company=\"My Company\"]Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consec tetur, adipisci velit, sed quia non numquam eius modi tempora voluptas amets unser. [/testimonial]\r\n[testimonial name=\"Luke Beck\" company=\"Theme Fusion\"]Aliquam erat volutpat. Quisque at est id ligula facilisis laoreet eget pulvinar nibh. Suspendisse at ultrices dui. Curabitur ac felis arcu sadips ipsums fugiats nemis.[/testimonial]\r\n[/testimonials]\";s:6:\"filter\";b:0;}i:10;a:3:{s:5:\"title\";s:23:\"This Is A Custom Widget\";s:4:\"text\";s:364:\"This Sliding Bar can be switched on or off in theme options, and can take any widget you throw at it or even fill it with your custom HTML Code. Its perfect for grabbing the attention of your viewers. Choose between 1, 2, 3 or 4 columns, set the background color, widget divider color, activate transparency, a top border or fully disable it on desktop and mobile.\";s:6:\"filter\";b:0;}i:11;a:3:{s:5:\"title\";s:23:\"This Is A Custom Widget\";s:4:\"text\";s:364:\"This Sliding Bar can be switched on or off in theme options, and can take any widget you throw at it or even fill it with your custom HTML Code. Its perfect for grabbing the attention of your viewers. Choose between 1, 2, 3 or 4 columns, set the background color, widget divider color, activate transparency, a top border or fully disable it on desktop and mobile.\";s:6:\"filter\";b:0;}i:8;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:547:\"<script src=\'http://legacy.joshuaproject.net/widget/upgotd_customizer.php?cfc=7b7670&chc=7b7670&clc=000000&cbg=EEEEEE&bbg=e26e00&blc=FFFFFF&bhc=000000&fbg=e26e00&ffc=FFFFFF&flc=FFFFFF&fhc=000000&oft=Tahoma, Geneva, sans-serif&tfsz=14px&pfsz=13px&ifsz=11.5px&ffsz=11px&ori=vert&wpw=240px&bdrtl=15px&bdrtr=15px&bdrbl=15px&bdrbr=15px&bdc=7b7670&bdw=0px&pop=1&lan=1&relg=1&eva=1&stat=1\' type=\'text/javascript\' charset=\'utf-8\'></script><noscript><a href=\'http://legacy.joshuaproject.net/upgotdfeed.php\'>View Unreached People of the Day</a></noscript>\r\n\";s:6:\"filter\";b:0;}i:5;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:489:\"[testimonials]\r\n[testimonial name=\"John Doe\" company=\"My Company\"]Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consec tetur, adipisci velit, sed quia non numquam eius modi tempora voluptas amets unser. [/testimonial]\r\n[testimonial name=\"Luke Beck\" company=\"Theme Fusion\"]Aliquam erat volutpat. Quisque at est id ligula facilisis laoreet eget pulvinar nibh. Suspendisse at ultrices dui. Curabitur ac felis arcu sadips ipsums fugiats nemis.[/testimonial]\r\n[/testimonials]\";s:6:\"filter\";b:0;}i:9;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:1099:\"[accordian][toggle title=\"Our Company Mission\"]Fugiat dapibus, tellus ac cursus commodo, mauris sit condim eser ntumsi nibh, uum a justo vitaes amet risus amets un. Posi sectetut amet fermntum orem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia nons.[/toggle]\r\n[toggle title=\"The Avada Philosophy\"]Fugiat dapibus, tellus ac cursus commodo, mauris sit condim eser ntumsi nibh, uum a justo vitaes amet risus amets un. Posi sectetut amet fermntum orem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia nons.[/toggle]\r\n[toggle title=\"The Avada Promise\"]Fugiat dapibus, tellus ac cursus commodo, mauris sit condim eser ntumsi nibh, uum a justo vitaes amet risus amets un. Posi sectetut amet fermntum orem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia nons.[/toggle]\r\n[toggle title=\"We Can Deliver On Projects\"]Fugiat dapibus, tellus ac cursus commodo, mauris sit condim eser ntumsi nibh, uum a justo vitaes amet risus amets un. Posi sectetut amet fermntum orem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia nons.[/toggle][/accordian]\";s:6:\"filter\";b:0;}i:4;a:3:{s:5:\"title\";s:17:\"Basic Text Widget\";s:4:\"text\";s:189:\"Fugiat dapibus, tellus ac cursus commo do, mauris sit condime ntum nibh, uter sitse fermentum massa justo vitaes amet r quia consequuntur magni uns mauris sit condime ntum nibh, uter sitse.\";s:6:\"filter\";b:0;}i:13;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:349:\"[map address=\"new york city, ny | 579 Allen Road Basking Ridge, NJ 07920 | Mount Arlington, NJ 07856\" type=\"roadmap\" width=\"244px\" height=\"150px\" zoom=\"8\" scrollwheel=\"false\" scale=\"false\" zoom_pancontrol=\"false\" popup=\"false\"][/map]\r\n<br />\r\n<strong>Come Check Us out!</strong><br />\r\nMonday Through Friday: 8am-8pm<br />\r\nPhone: 800-555-5555\r\n\r\n\r\n\";s:6:\"filter\";b:0;}i:12;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:345:\"<img src=\"http://theme-fusion.com/avadaxml/wp-content/uploads/2012/07/blog_6.jpg\" alt=\"\" />\r\n<p>Lorem ipsum ex vix illud nonummy, novum tation et his. At vix scriptaset patrioque scribentur, at pro fugit erts verterem molestiae, sed et vivendo ali Lorem ipsum ex vix illud nonummy, novum tation et his. At vix scripta patrioque scribentur...</p>\";s:6:\"filter\";b:0;}i:14;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;}i:15;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;}i:17;a:3:{s:5:\"title\";s:114:\"You will be shocked to learn about the number of unreached peoples and least reached places right here in America.\";s:4:\"text\";s:1057:\"[content_boxes layout=\"\" title_size=\"\" icon_circle=\"\" icon_size=\"\" icon_align=\"\" columns=\"0\" margin_top=\"0px\" margin_bottom=\"0px\" class=\"\" id=\"\"]\r\n[content_box title=\"\" icon=\"\" backgroundcolor=\"\" iconcolor=\"\" circlecolor=\"\" circlebordercolor=\"\" iconflip=\"\" iconrotate=\"\" iconspin=\"\" image=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/05/UnreachedPeoplesLeastReachedAreas280.jpg\" image_width=\"100%\" image_height=\"100%\" link=\"http://www.jdpayne.org/wp-content/uploads/2014/04/Unreached-Peoples-Least-Reached-Places-Payne.pdf\" linktarget=\" _blank\" linktext=\"\" animation_type=\"\" animation_direction=\"\" animation_speed=\"\"]<a href=\"http://www.jdpayne.org/wp-content/uploads/2014/04/Unreached-Peoples-Least-Reached-Places-Payne.pdf\" target=\" _blank\">Free Downloadable 50 page eBook by Pastor and Author J.D. Payne.</a> &nbsp <br><br><a href=\"http://www.jdpayne.org/\" target=\" _blank\" title=\"Missiologically Thinking - equipping the Church for the multiplication of disciples, leaders, and churches\">J. D. \'s WEBSITE</a>[/content_box]\r\n[/content_boxes]\";s:6:\"filter\";b:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bupg_options` VALUES("81", "widget_rss", "a:0:{}", "yes");
INSERT INTO `bupg_options` VALUES("82", "uninstall_plugins", "a:1:{s:27:\"LayerSlider/layerslider.php\";s:29:\"layerslider_uninstall_scripts\";}", "no");
INSERT INTO `bupg_options` VALUES("83", "timezone_string", "", "yes");
INSERT INTO `bupg_options` VALUES("84", "page_for_posts", "0", "yes");
INSERT INTO `bupg_options` VALUES("85", "page_on_front", "10995", "yes");
INSERT INTO `bupg_options` VALUES("86", "default_post_format", "0", "yes");
INSERT INTO `bupg_options` VALUES("87", "link_manager_enabled", "0", "yes");
INSERT INTO `bupg_options` VALUES("88", "initial_db_version", "30133", "yes");
INSERT INTO `bupg_options` VALUES("89", "bupg_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:63:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:9:\"add_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:15:\"wpseo_bulk_edit\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `bupg_options` VALUES("90", "widget_search", "a:4:{i:2;a:1:{s:5:\"title\";s:0:\"\";}i:3;a:1:{s:5:\"title\";s:0:\"\";}i:4;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bupg_options` VALUES("91", "widget_recent-posts", "a:4:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}i:5;a:3:{s:5:\"title\";s:12:\"Recent Posts\";s:6:\"number\";i:5;s:9:\"show_date\";b:0;}i:3;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bupg_options` VALUES("92", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bupg_options` VALUES("93", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bupg_options` VALUES("94", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bupg_options` VALUES("95", "sidebars_widgets", "a:21:{s:19:\"wp_inactive_widgets\";a:4:{i:0;s:7:\"text-15\";i:1;s:7:\"text-14\";i:2;s:21:\"contact_info-widget-2\";i:3;s:21:\"social_links-widget-3\";}s:18:\"avada-blog-sidebar\";a:12:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";i:6;s:18:\"pyre_tabs-widget-6\";i:7;s:6:\"text-6\";i:8;s:21:\"recent_works-widget-4\";i:9;s:14:\"recent-posts-5\";i:10;s:6:\"text-7\";i:11;s:21:\"contact_info-widget-3\";}s:21:\"avada-footer-widget-1\";a:0:{}s:21:\"avada-footer-widget-2\";a:0:{}s:21:\"avada-footer-widget-3\";a:0:{}s:21:\"avada-footer-widget-4\";a:1:{i:0;s:21:\"recent_works-widget-6\";}s:21:\"avada-footer-widget-5\";a:0:{}s:21:\"avada-footer-widget-6\";a:0:{}s:25:\"avada-slidingbar-widget-1\";a:1:{i:0;s:7:\"text-10\";}s:25:\"avada-slidingbar-widget-2\";a:1:{i:0;s:7:\"text-11\";}s:25:\"avada-slidingbar-widget-3\";a:0:{}s:25:\"avada-slidingbar-widget-4\";a:0:{}s:25:\"avada-slidingbar-widget-5\";a:0:{}s:25:\"avada-slidingbar-widget-6\";a:0:{}s:35:\"avada-custom-sidebar-contactsidebar\";a:2:{i:0;s:6:\"text-8\";i:1;s:7:\"text-17\";}s:24:\"avada-custom-sidebar-faq\";a:2:{i:0;s:8:\"search-3\";i:1;s:18:\"pyre_tabs-widget-5\";}s:36:\"avada-custom-sidebar-homepagesidebar\";a:5:{i:0;s:8:\"search-4\";i:1;s:18:\"pyre_tabs-widget-4\";i:2;s:21:\"recent_works-widget-5\";i:3;s:14:\"recent-posts-3\";i:4;s:6:\"text-5\";}s:30:\"avada-custom-sidebar-portfolio\";a:3:{i:0;s:18:\"pyre_tabs-widget-3\";i:1;s:6:\"text-9\";i:2;s:6:\"text-4\";}s:30:\"avada-custom-sidebar-megamenu1\";a:1:{i:0;s:7:\"text-13\";}s:30:\"avada-custom-sidebar-megamenu2\";a:1:{i:0;s:7:\"text-12\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `bupg_options` VALUES("96", "cron", "a:5:{i:1447772707;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1447789440;a:1:{s:20:\"wp_maybe_auto_update\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1447797126;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1447815925;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `bupg_options` VALUES("113", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:22:\"ken@dunamis-studio.com\";s:7:\"version\";s:5:\"4.1.8\";s:9:\"timestamp\";i:1442331674;}", "yes");
INSERT INTO `bupg_options` VALUES("127", "recently_activated", "a:0:{}", "yes");
INSERT INTO `bupg_options` VALUES("135", "theme_mods_twentyfifteen", "a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1428116839;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO `bupg_options` VALUES("136", "current_theme", "Avada", "yes");
INSERT INTO `bupg_options` VALUES("137", "theme_mods_Avada", "a:2:{i:0;b:0;s:18:\"nav_menu_locations\";a:3:{s:9:\"404_pages\";s:2:\"33\";s:15:\"main_navigation\";i:36;s:14:\"top_navigation\";s:2:\"34\";}}", "yes");
INSERT INTO `bupg_options` VALUES("138", "theme_switched", "", "yes");
INSERT INTO `bupg_options` VALUES("139", "avada_theme_version", "3.7.4", "yes");
INSERT INTO `bupg_options` VALUES("140", "Avada_options", "a:651:{s:10:\"responsive\";s:1:\"1\";s:12:\"ipad_potrait\";s:1:\"0\";s:16:\"google_analytics\";s:417:\"<script>\r\n  (function(i,s,o,g,r,a,m){i[\'GoogleAnalyticsObject\']=r;i[r]=i[r]||function(){\r\n  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),\r\n  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)\r\n  })(window,document,\'script\',\'//www.google-analytics.com/analytics.js\',\'ga\');\r\n\r\n  ga(\'create\', \'UA-31171807-5\', \'auto\');\r\n  ga(\'send\', \'pageview\');\r\n\r\n</script>\";s:10:\"space_head\";s:0:\"\";s:10:\"space_body\";s:0:\"\";s:6:\"layout\";s:4:\"Wide\";s:10:\"site_width\";s:6:\"1100px\";s:13:\"content_width\";s:2:\"77\";s:13:\"sidebar_width\";s:2:\"23\";s:15:\"content_width_2\";s:2:\"58\";s:17:\"sidebar_2_1_width\";s:2:\"21\";s:17:\"sidebar_2_2_width\";s:2:\"21\";s:15:\"header_position\";s:3:\"Top\";s:13:\"header_layout\";s:2:\"v1\";s:17:\"side_header_width\";s:5:\"280px\";s:13:\"header_shadow\";s:1:\"0\";s:16:\"header_100_width\";s:1:\"0\";s:15:\"slider_position\";s:5:\"Below\";s:19:\"header_left_content\";s:12:\"Contact Info\";s:20:\"header_right_content\";s:10:\"Navigation\";s:17:\"header_v4_content\";s:7:\"Tagline\";s:13:\"header_number\";s:28:\"Call Us Today! 1.555.555.555\";s:12:\"header_email\";s:19:\"info@yourdomain.com\";s:18:\"header_banner_code\";s:0:\"\";s:14:\"header_tagline\";s:19:\"Insert Tagline Here\";s:15:\"header_bg_image\";s:0:\"\";s:14:\"header_bg_full\";s:1:\"0\";s:18:\"header_bg_parallax\";s:1:\"1\";s:16:\"header_bg_repeat\";s:6:\"repeat\";s:17:\"margin_header_top\";s:3:\"0px\";s:20:\"margin_header_bottom\";s:3:\"0px\";s:19:\"padding_header_left\";s:3:\"0px\";s:20:\"padding_header_right\";s:3:\"0px\";s:30:\"header_social_links_icon_color\";s:7:\"#bebdbd\";s:25:\"header_social_links_boxed\";s:2:\"No\";s:29:\"header_social_links_box_color\";s:7:\"#e8e8e8\";s:32:\"header_social_links_boxed_radius\";s:3:\"4px\";s:37:\"header_social_links_tooltip_placement\";s:6:\"Bottom\";s:13:\"header_sticky\";s:1:\"1\";s:20:\"header_sticky_tablet\";s:1:\"0\";s:20:\"header_sticky_mobile\";s:1:\"0\";s:25:\"header_sticky_nav_padding\";s:0:\"\";s:27:\"header_sticky_nav_font_size\";s:0:\"\";s:28:\"header_sticky_logo_max_width\";s:0:\"\";s:4:\"logo\";s:80:\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/05/EngageLogoRGB250.png\";s:11:\"logo_retina\";s:0:\"\";s:17:\"retina_logo_width\";s:0:\"\";s:18:\"retina_logo_height\";s:0:\"\";s:14:\"logo_alignment\";s:4:\"Left\";s:16:\"margin_logo_left\";s:3:\"0px\";s:17:\"margin_logo_right\";s:3:\"0px\";s:15:\"margin_logo_top\";s:4:\"31px\";s:18:\"margin_logo_bottom\";s:4:\"31px\";s:7:\"favicon\";s:71:\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/06/favicon.ico\";s:11:\"iphone_icon\";s:0:\"\";s:18:\"iphone_icon_retina\";s:0:\"\";s:9:\"ipad_icon\";s:0:\"\";s:16:\"ipad_icon_retina\";s:0:\"\";s:18:\"mobile_menu_design\";s:7:\"classic\";s:10:\"nav_height\";s:2:\"90\";s:20:\"nav_highlight_border\";s:1:\"3\";s:11:\"nav_padding\";s:2:\"40\";s:18:\"mobile_nav_padding\";s:2:\"25\";s:19:\"dropdown_menu_width\";s:5:\"170px\";s:23:\"topmenu_dropwdown_width\";s:5:\"100px\";s:18:\"megamenu_max_width\";s:6:\"1100px\";s:19:\"megamenu_title_size\";s:4:\"18px\";s:15:\"megamenu_shadow\";s:1:\"1\";s:20:\"main_nav_search_icon\";s:1:\"1\";s:20:\"main_nav_icon_circle\";s:1:\"0\";s:27:\"mobile_nav_submenu_slideout\";s:1:\"1\";s:14:\"page_title_bar\";s:1:\"1\";s:20:\"page_title_100_width\";s:1:\"0\";s:17:\"page_title_height\";s:4:\"87px\";s:20:\"page_title_alignment\";s:4:\"left\";s:13:\"page_title_bg\";s:81:\"http://theme-fusion.com/avadaxml/wp-content/themes/Avada/images/page_title_bg.png\";s:20:\"page_title_bg_retina\";s:0:\"\";s:18:\"page_title_bg_full\";s:1:\"0\";s:22:\"page_title_bg_parallax\";s:1:\"0\";s:17:\"page_title_fading\";s:1:\"0\";s:10:\"breadcrumb\";s:1:\"1\";s:17:\"page_title_bar_bs\";s:11:\"Breadcrumbs\";s:17:\"breadcrumb_mobile\";s:1:\"0\";s:16:\"breacrumb_prefix\";s:0:\"\";s:18:\"slidingbar_widgets\";s:1:\"0\";s:25:\"mobile_slidingbar_widgets\";s:1:\"1\";s:21:\"slidingbar_top_border\";s:1:\"0\";s:23:\"slidingbar_open_on_load\";s:1:\"0\";s:26:\"slidingbar_widgets_columns\";s:1:\"2\";s:14:\"footer_widgets\";s:1:\"0\";s:16:\"footer_100_width\";s:1:\"0\";s:22:\"footer_widgets_columns\";s:1:\"1\";s:16:\"footerw_bg_image\";s:0:\"\";s:15:\"footerw_bg_full\";s:1:\"0\";s:23:\"footer_area_bg_parallax\";s:1:\"1\";s:17:\"footerw_bg_repeat\";s:6:\"repeat\";s:14:\"footerw_bg_pos\";s:13:\"center center\";s:23:\"footer_area_top_padding\";s:3:\"0px\";s:26:\"footer_area_bottom_padding\";s:4:\"40px\";s:24:\"footer_area_left_padding\";s:3:\"0px\";s:25:\"footer_area_right_padding\";s:3:\"0px\";s:16:\"footer_copyright\";s:1:\"1\";s:11:\"footer_text\";s:110:\"Copyright 2015 | All Rights Reserved | <a href=\"http://dunamis-studio.com\" target=\"_blank\">Web Development</a>\";s:21:\"copyright_top_padding\";s:4:\"18px\";s:24:\"copyright_bottom_padding\";s:4:\"16px\";s:12:\"icons_footer\";s:1:\"0\";s:30:\"footer_social_links_icon_color\";s:7:\"#46494a\";s:25:\"footer_social_links_boxed\";s:2:\"No\";s:29:\"footer_social_links_box_color\";s:7:\"#222222\";s:32:\"footer_social_links_boxed_radius\";s:3:\"4px\";s:37:\"footer_social_links_tooltip_placement\";s:3:\"Top\";s:20:\"pages_global_sidebar\";s:1:\"0\";s:13:\"pages_sidebar\";s:4:\"None\";s:15:\"pages_sidebar_2\";s:4:\"None\";s:19:\"default_sidebar_pos\";s:5:\"Right\";s:24:\"portfolio_global_sidebar\";s:1:\"0\";s:17:\"portfolio_sidebar\";s:4:\"None\";s:19:\"portfolio_sidebar_2\";s:4:\"None\";s:26:\"portfolio_sidebar_position\";s:5:\"Right\";s:25:\"portfolio_archive_sidebar\";s:4:\"None\";s:27:\"portfolio_archive_sidebar_2\";s:4:\"None\";s:20:\"posts_global_sidebar\";s:1:\"0\";s:13:\"posts_sidebar\";s:4:\"None\";s:15:\"posts_sidebar_2\";s:4:\"None\";s:21:\"blog_sidebar_position\";s:5:\"Right\";s:20:\"blog_archive_sidebar\";s:12:\"Blog Sidebar\";s:22:\"blog_archive_sidebar_2\";s:4:\"None\";s:18:\"woo_global_sidebar\";s:1:\"0\";s:11:\"woo_sidebar\";s:4:\"None\";s:13:\"woo_sidebar_2\";s:4:\"None\";s:20:\"woo_sidebar_position\";s:5:\"Right\";s:27:\"woocommerce_archive_sidebar\";s:4:\"None\";s:29:\"woocommerce_archive_sidebar_2\";s:4:\"None\";s:22:\"bbpress_global_sidebar\";s:1:\"0\";s:15:\"ppbress_sidebar\";s:4:\"None\";s:17:\"ppbress_sidebar_2\";s:4:\"None\";s:24:\"bbpress_sidebar_position\";s:5:\"Right\";s:14:\"search_sidebar\";s:12:\"Blog Sidebar\";s:16:\"search_sidebar_2\";s:4:\"None\";s:23:\"search_sidebar_position\";s:5:\"Right\";s:8:\"bg_image\";s:0:\"\";s:7:\"bg_full\";s:1:\"0\";s:9:\"bg_repeat\";s:6:\"repeat\";s:8:\"bg_color\";s:7:\"#d7d6d6\";s:17:\"bg_pattern_option\";s:1:\"0\";s:10:\"bg_pattern\";s:8:\"pattern1\";s:16:\"content_bg_image\";s:0:\"\";s:15:\"content_bg_full\";s:1:\"0\";s:17:\"content_bg_repeat\";s:6:\"repeat\";s:16:\"custom_font_woff\";s:0:\"\";s:15:\"custom_font_ttf\";s:0:\"\";s:15:\"custom_font_svg\";s:0:\"\";s:15:\"custom_font_eot\";s:0:\"\";s:11:\"google_body\";s:7:\"PT Sans\";s:10:\"google_nav\";s:10:\"Antic Slab\";s:15:\"google_headings\";s:10:\"Antic Slab\";s:22:\"google_footer_headings\";s:7:\"PT Sans\";s:14:\"gfont_settings\";s:92:\"400,400italic,700,700italic:latin,greek-ext,cyrillic,latin-ext,greek,cyrillic-ext,vietnamese\";s:13:\"standard_body\";s:11:\"Select Font\";s:12:\"standard_nav\";s:11:\"Select Font\";s:17:\"standard_headings\";s:11:\"Select Font\";s:24:\"standard_footer_headings\";s:11:\"Select Font\";s:14:\"body_font_size\";s:2:\"13\";s:13:\"nav_font_size\";s:2:\"14\";s:22:\"nav_dropdown_font_size\";s:2:\"13\";s:14:\"snav_font_size\";s:2:\"12\";s:18:\"side_nav_font_size\";s:2:\"14\";s:21:\"breadcrumbs_font_size\";s:2:\"10\";s:15:\"sidew_font_size\";s:2:\"13\";s:20:\"slidingbar_font_size\";s:2:\"13\";s:15:\"footw_font_size\";s:2:\"13\";s:19:\"copyright_font_size\";s:2:\"12\";s:12:\"h1_font_size\";s:2:\"34\";s:12:\"h2_font_size\";s:2:\"18\";s:12:\"h3_font_size\";s:2:\"16\";s:12:\"h4_font_size\";s:2:\"13\";s:12:\"h5_font_size\";s:2:\"12\";s:12:\"h6_font_size\";s:2:\"11\";s:17:\"tagline_font_size\";s:2:\"16\";s:14:\"meta_font_size\";s:2:\"12\";s:20:\"page_title_font_size\";s:2:\"18\";s:30:\"page_title_subheader_font_size\";s:2:\"14\";s:20:\"pagination_font_size\";s:2:\"12\";s:18:\"woo_icon_font_size\";s:2:\"12\";s:12:\"body_font_lh\";s:2:\"20\";s:10:\"h1_font_lh\";s:2:\"48\";s:10:\"h2_font_lh\";s:2:\"27\";s:10:\"h3_font_lh\";s:2:\"24\";s:10:\"h4_font_lh\";s:2:\"20\";s:10:\"h5_font_lh\";s:2:\"18\";s:10:\"h6_font_lh\";s:2:\"17\";s:11:\"sec_menu_lh\";s:2:\"44\";s:11:\"scheme_type\";s:5:\"Light\";s:12:\"color_scheme\";s:5:\"Green\";s:13:\"primary_color\";s:7:\"#a0ce4e\";s:19:\"slidingbar_bg_color\";a:2:{s:5:\"color\";s:7:\"#363839\";s:7:\"opacity\";s:1:\"1\";}s:15:\"header_bg_color\";a:2:{s:5:\"color\";s:7:\"#ffffff\";s:7:\"opacity\";s:1:\"1\";}s:22:\"header_sticky_bg_color\";a:2:{s:5:\"color\";s:7:\"#ffffff\";s:7:\"opacity\";s:1:\"1\";}s:19:\"header_border_color\";s:7:\"#e5e5e5\";s:19:\"header_top_bg_color\";s:7:\"#a0ce4e\";s:19:\"page_title_bg_color\";s:7:\"#F6F6F6\";s:23:\"page_title_border_color\";s:7:\"#d2d3d4\";s:16:\"content_bg_color\";s:7:\"#ffffff\";s:16:\"sidebar_bg_color\";s:11:\"transparent\";s:15:\"footer_bg_color\";s:7:\"#363839\";s:19:\"footer_border_color\";s:7:\"#e9eaee\";s:18:\"copyright_bg_color\";s:7:\"#282a2b\";s:22:\"copyright_border_color\";s:7:\"#4b4c4d\";s:24:\"image_gradient_top_color\";a:2:{s:5:\"color\";s:7:\"#a0ce4e\";s:7:\"opacity\";s:3:\".85\";}s:27:\"image_gradient_bottom_color\";s:7:\"#a0ce4e\";s:25:\"image_rollover_text_color\";s:7:\"#333333\";s:24:\"slidingbar_divider_color\";s:7:\"#282A2B\";s:20:\"footer_divider_color\";s:7:\"#505152\";s:13:\"form_bg_color\";s:7:\"#ffffff\";s:15:\"form_text_color\";s:7:\"#aaa9a9\";s:17:\"form_border_color\";s:7:\"#d2d2d2\";s:17:\"timeline_bg_color\";s:11:\"transparent\";s:14:\"timeline_color\";s:7:\"#ebeaea\";s:12:\"qty_bg_color\";s:7:\"#fbfaf9\";s:18:\"qty_bg_hover_color\";s:7:\"#ffffff\";s:19:\"bbp_forum_header_bg\";s:7:\"#ebeaea\";s:22:\"bbp_forum_border_color\";s:7:\"#ebeaea\";s:16:\"main_top_padding\";s:4:\"55px\";s:19:\"main_bottom_padding\";s:4:\"40px\";s:16:\"hundredp_padding\";s:4:\"20px\";s:15:\"sidebar_padding\";s:1:\"0\";s:22:\"slidingbar_text_shadow\";s:1:\"1\";s:20:\"rollover_text_shadow\";s:1:\"1\";s:18:\"footer_text_shadow\";s:1:\"1\";s:18:\"tagline_font_color\";s:7:\"#747474\";s:16:\"page_title_color\";s:7:\"#333333\";s:8:\"h1_color\";s:7:\"#333333\";s:8:\"h2_color\";s:7:\"#333333\";s:8:\"h3_color\";s:7:\"#333333\";s:8:\"h4_color\";s:7:\"#333333\";s:8:\"h5_color\";s:7:\"#333333\";s:8:\"h6_color\";s:7:\"#333333\";s:15:\"body_text_color\";s:7:\"#747474\";s:10:\"link_color\";s:7:\"#333333\";s:22:\"breadcrumbs_text_color\";s:7:\"#333333\";s:25:\"slidingbar_headings_color\";s:7:\"#DDDDDD\";s:21:\"slidingbar_text_color\";s:7:\"#8C8989\";s:21:\"slidingbar_link_color\";s:7:\"#BFBFBF\";s:21:\"sidebar_heading_color\";s:7:\"#333333\";s:21:\"footer_headings_color\";s:7:\"#DDDDDD\";s:17:\"footer_text_color\";s:7:\"#8C8989\";s:17:\"footer_link_color\";s:7:\"#BFBFBF\";s:17:\"menu_h45_bg_color\";s:7:\"#FFFFFF\";s:16:\"menu_first_color\";s:7:\"#333333\";s:22:\"menu_hover_first_color\";s:7:\"#a0ce4e\";s:17:\"menu_sub_bg_color\";s:7:\"#f2efef\";s:19:\"menu_bg_hover_color\";s:7:\"#f8f8f8\";s:14:\"menu_sub_color\";s:7:\"#333333\";s:18:\"menu_sub_sep_color\";s:7:\"#dcdadb\";s:17:\"woo_cart_bg_color\";s:7:\"#fafafa\";s:10:\"snav_color\";s:7:\"#747474\";s:29:\"header_top_first_border_color\";s:7:\"#e5e5e5\";s:23:\"header_top_sub_bg_color\";s:7:\"#ffffff\";s:25:\"header_top_menu_sub_color\";s:7:\"#747474\";s:30:\"header_top_menu_bg_hover_color\";s:7:\"#fafafa\";s:31:\"header_top_menu_sub_hover_color\";s:7:\"#333333\";s:29:\"header_top_menu_sub_sep_color\";s:7:\"#e5e5e5\";s:28:\"mobile_menu_background_color\";s:7:\"#f9f9f9\";s:24:\"mobile_menu_border_color\";s:7:\"#dadada\";s:23:\"mobile_menu_hover_color\";s:7:\"#f6f6f6\";s:15:\"dates_box_color\";s:7:\"#eef0f2\";s:11:\"button_size\";s:5:\"Large\";s:12:\"button_shape\";s:5:\"Round\";s:11:\"button_type\";s:4:\"Flat\";s:25:\"button_gradient_top_color\";s:7:\"#a0ce4e\";s:28:\"button_gradient_bottom_color\";s:7:\"#a0ce4e\";s:31:\"button_gradient_top_color_hover\";s:7:\"#96c346\";s:34:\"button_gradient_bottom_color_hover\";s:7:\"#96c346\";s:19:\"button_accent_color\";s:4:\"#fff\";s:25:\"button_accent_hover_color\";s:4:\"#fff\";s:18:\"button_bevel_color\";s:7:\"#54770F\";s:19:\"button_border_width\";s:3:\"0px\";s:18:\"button_text_shadow\";s:1:\"1\";s:18:\"carousel_nav_color\";s:7:\"#999999\";s:20:\"carousel_hover_color\";s:7:\"#808080\";s:20:\"content_box_bg_color\";s:11:\"transparent\";s:16:\"checklist_circle\";s:1:\"1\";s:22:\"checklist_circle_color\";s:7:\"#a0ce4e\";s:21:\"checklist_icons_color\";s:7:\"#ffffff\";s:20:\"counter_filled_color\";s:7:\"#a0ce4e\";s:22:\"counter_unfilled_color\";s:7:\"#f6f6f6\";s:17:\"counter_box_color\";s:7:\"#a0ce4e\";s:22:\"counter_box_title_size\";s:2:\"50\";s:21:\"counter_box_icon_size\";s:2:\"50\";s:22:\"counter_box_body_color\";s:7:\"#747474\";s:21:\"counter_box_body_size\";s:2:\"13\";s:24:\"counter_box_border_color\";s:7:\"#e0dede\";s:13:\"dropcap_color\";s:7:\"#a0ce4e\";s:19:\"flip_boxes_front_bg\";s:7:\"#f6f6f6\";s:24:\"flip_boxes_front_heading\";s:7:\"#333333\";s:21:\"flip_boxes_front_text\";s:7:\"#747474\";s:18:\"flip_boxes_back_bg\";s:7:\"#a0ce4e\";s:23:\"flip_boxes_back_heading\";s:7:\"#eeeded\";s:20:\"flip_boxes_back_text\";s:7:\"#ffffff\";s:22:\"flip_boxes_border_size\";s:3:\"1px\";s:23:\"flip_boxes_border_color\";s:11:\"transparent\";s:24:\"flip_boxes_border_radius\";s:3:\"4px\";s:19:\"full_width_bg_color\";s:0:\"\";s:22:\"full_width_border_size\";s:3:\"0px\";s:23:\"full_width_border_color\";s:7:\"#eae9e9\";s:17:\"icon_circle_color\";s:7:\"#333333\";s:17:\"icon_border_color\";s:7:\"#333333\";s:10:\"icon_color\";s:7:\"#ffffff\";s:21:\"imgframe_border_color\";s:7:\"#f6f6f6\";s:22:\"imageframe_border_size\";s:1:\"0\";s:24:\"imageframe_border_radius\";s:1:\"0\";s:20:\"imgframe_style_color\";s:7:\"#000000\";s:14:\"modal_bg_color\";s:7:\"#f6f6f6\";s:18:\"modal_border_color\";s:7:\"#ebebeb\";s:19:\"person_border_color\";s:7:\"#f6f6f6\";s:18:\"person_border_size\";s:1:\"0\";s:20:\"person_border_radius\";s:1:\"0\";s:18:\"person_style_color\";s:7:\"#000000\";s:24:\"popover_heading_bg_color\";s:7:\"#f6f6f6\";s:24:\"popover_content_bg_color\";s:7:\"#ffffff\";s:20:\"popover_border_color\";s:7:\"#ebebeb\";s:18:\"popover_text_color\";s:7:\"#747474\";s:17:\"popover_placement\";s:3:\"Top\";s:36:\"full_boxed_pricing_box_heading_color\";s:7:\"#333333\";s:29:\"sep_pricing_box_heading_color\";s:7:\"#333333\";s:17:\"pricing_box_color\";s:7:\"#a0ce4e\";s:16:\"pricing_bg_color\";s:7:\"#ffffff\";s:20:\"pricing_border_color\";s:7:\"#f8f8f8\";s:21:\"pricing_divider_color\";s:7:\"#ededed\";s:24:\"progressbar_filled_color\";s:7:\"#a0ce4e\";s:26:\"progressbar_unfilled_color\";s:7:\"#f6f6f6\";s:22:\"progressbar_text_color\";s:7:\"#ffffff\";s:9:\"sep_color\";s:7:\"#e0dede\";s:23:\"section_sep_border_size\";s:3:\"1px\";s:14:\"section_sep_bg\";s:7:\"#f6f6f6\";s:24:\"section_sep_border_color\";s:7:\"#f6f6f6\";s:20:\"sharing_box_bg_color\";s:7:\"#f6f6f6\";s:30:\"sharing_box_tagline_text_color\";s:7:\"#333333\";s:23:\"social_links_icon_color\";s:7:\"#bebdbd\";s:18:\"social_links_boxed\";s:2:\"No\";s:22:\"social_links_box_color\";s:7:\"#e8e8e8\";s:25:\"social_links_boxed_radius\";s:3:\"4px\";s:30:\"social_links_tooltip_placement\";s:3:\"Top\";s:13:\"tabs_bg_color\";s:7:\"#ffffff\";s:19:\"tabs_inactive_color\";s:7:\"#ebeaea\";s:17:\"tabs_border_color\";s:7:\"#ebeaea\";s:10:\"tagline_bg\";s:7:\"#f6f6f6\";s:20:\"tagline_border_color\";s:7:\"#f6f6f6\";s:20:\"testimonial_bg_color\";s:7:\"#f6f6f6\";s:22:\"testimonial_text_color\";s:7:\"#747474\";s:18:\"testimonials_speed\";s:4:\"4000\";s:18:\"title_border_color\";s:7:\"#e0dede\";s:24:\"accordian_inactive_color\";s:7:\"#333333\";s:10:\"blog_title\";s:4:\"Blog\";s:13:\"blog_subtitle\";s:0:\"\";s:24:\"blog_show_page_title_bar\";s:1:\"1\";s:11:\"blog_layout\";s:5:\"Large\";s:19:\"blog_archive_layout\";s:4:\"Grid\";s:20:\"blog_pagination_type\";s:10:\"Pagination\";s:17:\"blog_grid_columns\";s:1:\"2\";s:24:\"blog_grid_column_spacing\";s:2:\"40\";s:14:\"content_length\";s:7:\"Excerpt\";s:19:\"excerpt_length_blog\";s:2:\"55\";s:18:\"strip_html_excerpt\";s:1:\"1\";s:15:\"featured_images\";s:1:\"1\";s:32:\"alternate_date_format_month_year\";s:4:\"m, Y\";s:25:\"alternate_date_format_day\";s:1:\"j\";s:20:\"timeline_date_format\";s:3:\"F Y\";s:22:\"featured_images_single\";s:1:\"1\";s:11:\"blog_pn_nav\";s:1:\"0\";s:15:\"blog_post_title\";s:1:\"1\";s:11:\"author_info\";s:1:\"1\";s:18:\"social_sharing_box\";s:1:\"1\";s:13:\"related_posts\";s:1:\"1\";s:13:\"blog_comments\";s:1:\"1\";s:9:\"post_meta\";s:1:\"1\";s:16:\"post_meta_author\";s:1:\"0\";s:14:\"post_meta_date\";s:1:\"0\";s:14:\"post_meta_cats\";s:1:\"0\";s:18:\"post_meta_comments\";s:1:\"0\";s:14:\"post_meta_read\";s:1:\"0\";s:14:\"post_meta_tags\";s:1:\"1\";s:11:\"date_format\";s:7:\"F jS, Y\";s:15:\"portfolio_items\";s:2:\"10\";s:24:\"portfolio_archive_layout\";s:20:\"Portfolio One Column\";s:24:\"portfolio_column_spacing\";s:2:\"12\";s:24:\"portfolio_content_length\";s:7:\"Excerpt\";s:24:\"excerpt_length_portfolio\";s:2:\"55\";s:20:\"grid_pagination_type\";s:10:\"Pagination\";s:21:\"portfolio_text_layout\";s:7:\"unboxed\";s:14:\"portfolio_slug\";s:15:\"portfolio-items\";s:29:\"portfolio_featured_image_size\";s:4:\"full\";s:25:\"portfolio_featured_images\";s:1:\"1\";s:16:\"portfolio_pn_nav\";s:1:\"0\";s:18:\"portfolio_comments\";s:1:\"0\";s:16:\"portfolio_author\";s:1:\"0\";s:28:\"portfolio_social_sharing_box\";s:1:\"1\";s:23:\"portfolio_related_posts\";s:1:\"1\";s:15:\"social_bg_color\";s:7:\"#f6f6f6\";s:31:\"sharing_social_links_icon_color\";s:7:\"#bebdbd\";s:26:\"sharing_social_links_boxed\";s:2:\"No\";s:30:\"sharing_social_links_box_color\";s:7:\"#e8e8e8\";s:33:\"sharing_social_links_boxed_radius\";s:3:\"4px\";s:38:\"sharing_social_links_tooltip_placement\";s:3:\"Top\";s:16:\"sharing_facebook\";s:1:\"1\";s:15:\"sharing_twitter\";s:1:\"1\";s:14:\"sharing_reddit\";s:1:\"1\";s:16:\"sharing_linkedin\";s:1:\"1\";s:14:\"sharing_google\";s:1:\"1\";s:14:\"sharing_tumblr\";s:1:\"1\";s:17:\"sharing_pinterest\";s:1:\"1\";s:10:\"sharing_vk\";s:1:\"1\";s:13:\"sharing_email\";s:1:\"1\";s:13:\"facebook_link\";s:1:\"#\";s:15:\"social_sorter_1\";s:13:\"facebook_link\";s:11:\"flickr_link\";s:0:\"\";s:15:\"social_sorter_2\";s:11:\"flickr_link\";s:8:\"rss_link\";s:1:\"#\";s:15:\"social_sorter_3\";s:8:\"rss_link\";s:12:\"twitter_link\";s:1:\"#\";s:15:\"social_sorter_4\";s:12:\"twitter_link\";s:10:\"vimeo_link\";s:0:\"\";s:15:\"social_sorter_5\";s:10:\"vimeo_link\";s:12:\"youtube_link\";s:1:\"#\";s:15:\"social_sorter_6\";s:12:\"youtube_link\";s:14:\"instagram_link\";s:1:\"#\";s:15:\"social_sorter_7\";s:14:\"instagram_link\";s:14:\"pinterest_link\";s:1:\"#\";s:15:\"social_sorter_8\";s:14:\"pinterest_link\";s:11:\"tumblr_link\";s:0:\"\";s:15:\"social_sorter_9\";s:11:\"tumblr_link\";s:11:\"google_link\";s:0:\"\";s:16:\"social_sorter_10\";s:11:\"google_link\";s:13:\"dribbble_link\";s:1:\"#\";s:16:\"social_sorter_11\";s:13:\"dribbble_link\";s:9:\"digg_link\";s:0:\"\";s:16:\"social_sorter_12\";s:9:\"digg_link\";s:13:\"linkedin_link\";s:0:\"\";s:16:\"social_sorter_13\";s:13:\"linkedin_link\";s:12:\"blogger_link\";s:0:\"\";s:16:\"social_sorter_14\";s:12:\"blogger_link\";s:10:\"skype_link\";s:0:\"\";s:16:\"social_sorter_15\";s:10:\"skype_link\";s:11:\"forrst_link\";s:0:\"\";s:16:\"social_sorter_16\";s:11:\"forrst_link\";s:12:\"myspace_link\";s:0:\"\";s:16:\"social_sorter_17\";s:12:\"myspace_link\";s:15:\"deviantart_link\";s:0:\"\";s:16:\"social_sorter_18\";s:15:\"deviantart_link\";s:10:\"yahoo_link\";s:0:\"\";s:16:\"social_sorter_19\";s:10:\"yahoo_link\";s:11:\"reddit_link\";s:0:\"\";s:16:\"social_sorter_20\";s:11:\"reddit_link\";s:11:\"paypal_link\";s:0:\"\";s:16:\"social_sorter_21\";s:11:\"paypal_link\";s:12:\"dropbox_link\";s:0:\"\";s:16:\"social_sorter_22\";s:12:\"dropbox_link\";s:15:\"soundcloud_link\";s:0:\"\";s:16:\"social_sorter_23\";s:15:\"soundcloud_link\";s:7:\"vk_link\";s:0:\"\";s:16:\"social_sorter_24\";s:7:\"vk_link\";s:10:\"email_link\";s:0:\"\";s:16:\"social_sorter_25\";s:10:\"email_link\";s:13:\"social_sorter\";s:415:\"social_sorter_1,social_sorter_2,social_sorter_3,social_sorter_4,social_sorter_5,social_sorter_6,social_sorter_7,social_sorter_8,social_sorter_9,social_sorter_10,social_sorter_11,social_sorter_12,social_sorter_13,social_sorter_14,social_sorter_15,social_sorter_16,social_sorter_17,social_sorter_18,social_sorter_19,social_sorter_20,social_sorter_21,social_sorter_22,social_sorter_23,social_sorter_24,social_sorter_25\";s:16:\"custom_icon_name\";s:0:\"\";s:17:\"custom_icon_image\";s:0:\"\";s:24:\"custom_icon_image_retina\";s:0:\"\";s:17:\"retina_icon_width\";s:0:\"\";s:18:\"retina_icon_height\";s:0:\"\";s:16:\"custom_icon_link\";s:0:\"\";s:22:\"posts_slideshow_number\";s:1:\"5\";s:18:\"slideshow_autoplay\";s:1:\"1\";s:23:\"slideshow_smooth_height\";s:1:\"0\";s:15:\"slideshow_speed\";s:4:\"7000\";s:22:\"pagination_video_slide\";s:1:\"0\";s:17:\"tfes_slider_width\";s:4:\"100%\";s:18:\"tfes_slider_height\";s:5:\"400px\";s:14:\"tfes_animation\";s:5:\"sides\";s:13:\"tfes_autoplay\";s:1:\"1\";s:13:\"tfes_interval\";s:4:\"3000\";s:10:\"tfes_speed\";s:3:\"800\";s:10:\"tfes_width\";s:3:\"150\";s:18:\"es_title_font_size\";s:2:\"42\";s:20:\"es_caption_font_size\";s:2:\"20\";s:14:\"es_title_color\";s:7:\"#333333\";s:16:\"es_caption_color\";s:7:\"#747474\";s:15:\"status_lightbox\";s:1:\"0\";s:22:\"status_lightbox_mobile\";s:1:\"1\";s:22:\"status_lightbox_single\";s:1:\"0\";s:24:\"lightbox_animation_speed\";s:4:\"Fast\";s:16:\"lightbox_gallery\";s:1:\"1\";s:17:\"lightbox_autoplay\";s:1:\"0\";s:24:\"lightbox_slideshow_speed\";s:4:\"5000\";s:16:\"lightbox_opacity\";s:3:\"0.8\";s:14:\"lightbox_title\";s:1:\"1\";s:13:\"lightbox_desc\";s:1:\"1\";s:15:\"lightbox_social\";s:1:\"1\";s:20:\"lightbox_deeplinking\";s:1:\"1\";s:20:\"lightbox_post_images\";s:1:\"1\";s:9:\"gmap_type\";s:7:\"roadmap\";s:10:\"gmap_width\";s:0:\"\";s:11:\"gmap_height\";s:0:\"\";s:14:\"gmap_topmargin\";s:0:\"\";s:12:\"gmap_address\";s:0:\"\";s:13:\"email_address\";s:0:\"\";s:14:\"map_zoom_level\";s:0:\"\";s:7:\"map_pin\";s:1:\"0\";s:9:\"map_popup\";s:1:\"0\";s:15:\"map_scrollwheel\";s:1:\"0\";s:9:\"map_scale\";s:1:\"0\";s:15:\"map_zoomcontrol\";s:1:\"0\";s:11:\"map_styling\";s:6:\"custom\";s:17:\"map_overlay_color\";s:7:\"#70b260\";s:19:\"map_infobox_styling\";s:6:\"custom\";s:19:\"map_infobox_content\";s:0:\"\";s:20:\"map_infobox_bg_color\";s:20:\"rgba(000,000,000,.5)\";s:22:\"map_infobox_text_color\";s:0:\"\";s:22:\"map_custom_marker_icon\";s:5:\"theme\";s:16:\"recaptcha_public\";s:0:\"\";s:17:\"recaptcha_private\";s:0:\"\";s:22:\"recaptcha_color_scheme\";s:3:\"red\";s:13:\"search_layout\";s:4:\"Grid\";s:14:\"search_content\";s:10:\"Only Posts\";s:14:\"search_excerpt\";s:1:\"0\";s:23:\"search_results_per_page\";s:2:\"10\";s:22:\"search_featured_images\";s:1:\"0\";s:16:\"sidenav_behavior\";s:5:\"Hover\";s:20:\"number_related_posts\";s:1:\"5\";s:12:\"excerpt_base\";s:5:\"Words\";s:16:\"disable_excerpts\";s:1:\"0\";s:14:\"link_read_more\";s:1:\"0\";s:14:\"comments_pages\";s:1:\"0\";s:21:\"featured_images_pages\";s:1:\"0\";s:18:\"faq_featured_image\";s:1:\"0\";s:21:\"nofollow_social_links\";s:1:\"0\";s:16:\"social_icons_new\";s:1:\"1\";s:14:\"image_rollover\";s:1:\"1\";s:24:\"image_rollover_direction\";s:4:\"left\";s:19:\"link_image_rollover\";s:1:\"0\";s:19:\"zoom_image_rollover\";s:1:\"0\";s:20:\"title_image_rollover\";s:1:\"0\";s:19:\"cats_image_rollover\";s:1:\"0\";s:15:\"disable_builder\";s:1:\"0\";s:16:\"disable_megamenu\";s:1:\"0\";s:16:\"avada_rev_styles\";s:1:\"0\";s:22:\"avada_styles_dropdowns\";s:1:\"0\";s:8:\"ubermenu\";s:1:\"0\";s:15:\"use_animate_css\";s:1:\"0\";s:26:\"disable_mobile_animate_css\";s:1:\"1\";s:9:\"status_yt\";s:1:\"0\";s:12:\"status_vimeo\";s:1:\"0\";s:11:\"status_gmap\";s:1:\"0\";s:12:\"status_totop\";s:1:\"0\";s:19:\"status_totop_mobile\";s:1:\"0\";s:20:\"status_fusion_slider\";s:1:\"0\";s:14:\"status_eslider\";s:1:\"0\";s:18:\"status_fontawesome\";s:1:\"0\";s:16:\"status_opengraph\";s:1:\"0\";s:31:\"disable_date_rich_snippet_pages\";s:1:\"0\";s:19:\"disable_woo_gallery\";s:1:\"0\";s:9:\"woo_items\";s:2:\"12\";s:29:\"woocommerce_shop_page_columns\";s:1:\"4\";s:27:\"woocommerce_related_columns\";s:1:\"4\";s:32:\"woocommerce_archive_page_columns\";s:1:\"3\";s:26:\"woocommerce_avada_ordering\";s:1:\"0\";s:29:\"woocommerce_one_page_checkout\";s:1:\"0\";s:30:\"woocommerce_enable_order_notes\";s:1:\"1\";s:28:\"woocommerce_acc_link_top_nav\";s:1:\"1\";s:29:\"woocommerce_cart_link_top_nav\";s:1:\"1\";s:29:\"woocommerce_acc_link_main_nav\";s:1:\"0\";s:30:\"woocommerce_cart_link_main_nav\";s:1:\"1\";s:24:\"woocommerce_social_links\";s:1:\"1\";s:13:\"woo_acc_msg_1\";s:55:\"Need Assistance? Call customer service at 888-555-5555.\";s:13:\"woo_acc_msg_2\";s:32:\"E-mail them at info@yourshop.com\";s:10:\"custom_css\";s:6390:\"body, .post .post-content, .post-content blockquote, #wrapper .fusion-tabs-widget .tab-holder .news-list li .post-holder .meta, .sidebar .jtwt, #wrapper .meta, .review blockquote div, .search input, .project-content .project-info h4, .title-row, .simple-products-slider .price .amount, .quantity .qty, .quantity .minus, .quantity .plus, .timeline-layout h3.timeline-title, .blog-timeline-layout h3.timeline-title, #reviews #comments > h2, .sidebar .widget_nav_menu li, .sidebar .widget_categories li, .sidebar .widget_product_categories li, .sidebar .widget_meta li, .sidebar .widget .recentcomments, .sidebar .widget_recent_entries li, .sidebar .widget_archive li, .sidebar .widget_pages li, .sidebar .widget_links li, .sidebar .widget_layered_nav li, .sidebar .widget_product_categories li { \r\ncolor: #535151;\r\n}\r\n.sidebar .widget h3, .sidebar .widget .heading h3 {\r\n    color: rgb(83, 81, 81);\r\n}\r\n#wrapper .post-content h2, #wrapper .fusion-title h2, #wrapper #main .post-content .fusion-title h2, #wrapper .title h2, #wrapper #main .post-content .title h2, #wrapper #main .post h2, #wrapper.woocommerce .checkout h3, .cart-empty, #main .fusion-portfolio h2, h2.entry-title {\r\n    font-size: 28px;\r\n    line-height: 34px;\r\n}\r\n.transparent {\r\n  -khtml-opacity:.80; \r\n  -moz-opacity:.80; \r\n  -ms-filter:”alpha(opacity=80)”;\r\n  filter:alpha(opacity=80);\r\n  filter: progid:DXImageTransform.Microsoft.Alpha(opacity=0.8);\r\n  opacity:.80; \r\n}\r\n.post-content blockquote {\r\n    border-color: #db2532;\r\n    color: #db2532;\r\n    line-height: 24px;\r\n    font-size: 1.2em;\r\n    font-style: italic;\r\n}\r\na:hover, .tooltip-shortcode, #mobile-nav li.mobile-nav-item .open-submenu:hover {\r\n    color: #db2532;\r\n}\r\na:hover { color: #db2532; }\r\n\r\nbody, .sidebar .slide-excerpt h2, .footer-area .slide-excerpt h2, #slidingbar-area .slide-excerpt h2, .jtwt .jtwt_tweet, .sidebar .jtwt .jtwt_tweet {\r\n    font-size: 15px;\r\n    line-height: 20px;\r\n}\r\n#nav, #sticky-nav, .navigation { font-size: 18px; }\r\n#nav ul li > a, #sticky-nav ul li > a, .side-nav li a, #header-sticky .cart-content a, #header-sticky .cart-content a:hover, #header .cart-content a, #header .cart-content a:hover, #side-header .cart-content a:hover, #small-nav .cart-content a, #small-nav .cart-content a:hover, #wrapper .header-social .top-menu .cart > a, #wrapper .header-social .top-menu .cart > a > .amount, #wrapper .fusion-megamenu-wrapper .fusion-megamenu-title, #wrapper .fusion-megamenu-wrapper .fusion-megamenu-title a, .my-cart-link::after, a.search-link::after, .top-menu .cart > a::before, .top-menu .cart > a::after {\r\n    color: #FFF;\r\n}\r\n#nav ul .current-menu-ancestor > a, .navigation li.current-menu-ancestor > a, #sticky-nav li.current-menu-ancestor > a, #nav ul .current_page_item > a, #nav ul .current-menu-item > a, #nav ul > .current-menu-parent > a, #nav ul ul, #wrapper .fusion-megamenu-wrapper .fusion-megamenu-holder, .navigation li.current-menu-ancestor > a, #nav ul li > a:hover, #sticky-nav ul .current_page_item > a, #sticky-nav ul .current-menu-item > a, #sticky-nav ul > .current-menu-parent > a, #sticky-nav ul ul, #sticky-nav li.current-menu-ancestor > a, .navigation li.current-menu-ancestor > a, #sticky-nav ul li > a:hover, #header-sticky .my-cart-link-active::after, .header-wrapper .my-cart-link-active::after, #side-header .my-cart-link-active::after {\r\n    color: #FF991A;\r\n    border-color: #FF991A;\r\n}\r\nbody #header-sticky.sticky-header .sticky-shadow {\r\n    background: none repeat scroll 0% 0% #111;\r\n}\r\n#wrapper .post-content blockquote { border-color: #fff; }\r\n.post-content blockquote {\r\n    color: #db2532;\r\n    line-height: 24px;\r\n    font-size: 1.4em;\r\n    font-style: italic;\r\n    padding: 6px;\r\n}\r\n.input-text, input[type=\"text\"], textarea, input.s, #comment-input input, #comment-textarea textarea, .comment-form-comment textarea, .post-password-form .password, .wpcf7-form .wpcf7-text, .wpcf7-form .wpcf7-quiz, .wpcf7-form .wpcf7-number, .wpcf7-form textarea, .wpcf7-form .wpcf7-select, .wpcf7-captchar, .wpcf7-form .wpcf7-date, .gform_wrapper .gfield input[type=\"text\"], .gform_wrapper .gfield input[type=\"email\"], .gform_wrapper .gfield textarea, .gform_wrapper .gfield select, #bbpress-forums .bbp-search-form #bbp_search, .bbp-reply-form input#bbp_topic_tags, .bbp-topic-form input#bbp_topic_title, .bbp-topic-form input#bbp_topic_tags, .bbp-topic-form select#bbp_stick_topic_select, .bbp-topic-form select#bbp_topic_status_select, #bbpress-forums div.bbp-the-content-wrapper textarea.bbp-the-content, .bbp-login-form input, .main-nav-search-form input, .search-page-search-form input, .chzn-container-single .chzn-single, .chzn-container .chzn-drop, .avada-select-parent select, .avada-select-parent .select-arrow, #wrapper .select-arrow, .avada-select .select2-container .select2-choice, .avada-select .select2-container .select2-choice2, select, #lang_sel_click a.lang_sel_sel, #lang_sel_click ul ul a, #lang_sel_click ul ul a:visited, #lang_sel_click a, #lang_sel_click a:visited, #wrapper .search-table .search-field input {\r\n    background-color: #3E3E3E;\r\n}\r\n.fusion-portfolio-one .fusion-button, #main .comment-submit, #reviews input#submit, .comment-form input[type=\"submit\"], .wpcf7-form input[type=\"submit\"], .wpcf7-submit, .bbp-submit-wrapper .button, .button-default, .fusion-button-default, .button.default, .price_slider_amount button, .gform_wrapper .gform_button, .woocommerce .single_add_to_cart_button, .woocommerce button.button, .woocommerce .shipping-calculator-form .button, .woocommerce .checkout #place_order, .woocommerce .checkout_coupon .button, .woocommerce .login .button, .woocommerce .register .button, .woocommerce .avada-order-details .order-again .button, .woocommerce .avada-order-details .order-again .button, .woocommerce .lost_reset_password input[type=\"submit\"], #bbp_user_edit_submit, .ticket-selector-submit-btn[type=\"submit\"], .gform_page_footer input[type=\"button\"] {\r\n    background: #E8C090 linear-gradient(to top, #D69E5A, #E8C090) repeat scroll 0% 0%;\r\n    color: #784910;\r\n    transition: all 0.2s ease 0s;\r\n}\r\n.button.default, .fusion-button-default, .woocommerce .checkout #place_order, .wpcf7-form input[type=\"submit\"], .wpcf7-submit, .fusion-body #main .gform_wrapper .gform_button, .fusion-body #main .gform_wrapper .gform_footer .gform_button {\r\n    padding: 13px 29px;\r\n    line-height: 17px;\r\n    font-size: 14px;\r\n}\r\n\";s:11:\"tf_username\";s:0:\"\";s:6:\"tf_api\";s:0:\"\";s:16:\"tf_purchase_code\";s:0:\"\";s:0:\"\";s:0:\"\";s:9:\"demo_data\";s:0:\"\";s:4:\"code\";s:81:\"<h3 style=\'margin: 0;\'>Tracking / Space Before Head / Space Before Body Code</h3>\";s:21:\"content_sidebar_width\";s:139:\"<h3 style=\'margin: 0;\'>Content + Sidebar Width</h3><p>These settings are used on pages with 1 sidebar. Total values must add up to 100.</p>\";s:29:\"content_sidebar_sidebar_width\";s:150:\"<h3 style=\'margin: 0;\'>Content + Sidebar + Sidebar Width</h3><p>These settings are used on pages with 2 sidebars. Total values must add up to 100.</p>\";s:13:\"header_info_1\";s:50:\"<h3 style=\'margin: 0;\'>Header Content Options</h3>\";s:13:\"header_info_2\";s:45:\"<h3 style=\'margin: 0;\'>Header Background</h3>\";s:13:\"header_info_3\";s:47:\"<h3 style=\'margin: 0;\'>Header Social Icons</h3>\";s:18:\"sticky_header_info\";s:49:\"<h3 style=\'margin: 0;\'>Sticky Header Options</h3>\";s:11:\"header_info\";s:46:\"<h3 style=\'margin: 0;\'>Breadcrumb Options</h3>\";s:8:\"favicons\";s:43:\"<h3 style=\'margin: 0;\'>Favicon Options</h3>\";s:11:\"sliding_bar\";s:47:\"<h3 style=\'margin: 0;\'>Sliding Bar Options</h3>\";s:25:\"footer_widgets_area_title\";s:55:\"<h3 style=\'margin: 0;\'>Footer Widgets Area Options</h3>\";s:20:\"copyright_area_title\";s:45:\"<h3 style=\'margin: 0;\'>Copyright Options</h3>\";s:24:\"footer_social_icon_title\";s:47:\"<h3 style=\'margin: 0;\'>Social Icon Options</h3>\";s:12:\"bbpress_only\";s:35:\"<h3 style=\'margin: 0;\'>BBPress</h3>\";s:11:\"search_only\";s:39:\"<h3 style=\'margin: 0;\'>Search Page</h3>\";s:15:\"boxed_mode_only\";s:76:\"<h3 style=\'margin: 0;\'>Background options below only work in boxed mode</h3>\";s:15:\"both_modes_only\";s:79:\"<h3 style=\'margin: 0;\'>Background Options Below Work For Boxed & Wide Mode</h3>\";s:19:\"custom_heading_font\";s:175:\"<h3 style=\'margin: 0;\'>Custom Font For Menus And Headings.</h3><p style=\'margin-bottom:0;\'>This will override the google / standard font options. All 4 files are required.</p>\";s:18:\"google_fonts_intro\";s:113:\"<h3 style=\'margin: 0;\'>Google Fonts</h3><p style=\'margin-bottom:0;\'>This will override standard font options.</p>\";s:20:\"standard_fonts_intro\";s:37:\"<h3 style=\'margin: 0;\'>Standards</h3>\";s:15:\"font_size_intro\";s:38:\"<h3 style=\'margin: 0;\'>Font Sizes</h3>\";s:25:\"font_line_heights_wrapper\";s:46:\"<h3 style=\'margin: 0;\'\'>Font Line Heights</h3>\";s:17:\"bg_colors_wrapper\";s:45:\"<h3 style=\'margin: 0;\'>Background Colors</h3>\";s:22:\"element_colors_wrapper\";s:42:\"<h3 style=\'margin: 0;\'>Element Colors</h3>\";s:23:\"element_options_wrapper\";s:42:\"<h3 style=\'margin: 0;\'>Layout Options</h3>\";s:19:\"font_colors_wrapper\";s:39:\"<h3 style=\'margin: 0;\'>Font Colors</h3>\";s:24:\"main_menu_colors_wrapper\";s:44:\"<h3 style=\'margin: 0;\'>Main Menu Colors</h3>\";s:17:\"menu_colors_intro\";s:49:\"<h3 style=\'margin: 0;\'>Secondary Menu Colors</h3>\";s:26:\"mobile_menu_colors_wrapper\";s:46:\"<h3 style=\'margin: 0;\'>Mobile Menu Colors</h3>\";s:14:\"blog_shortcode\";s:42:\"<h3 style=\'margin: 0;\'>Blog Shortcode</h3>\";s:16:\"button_shortcode\";s:44:\"<h3 style=\'margin: 0;\'>Button Shortcode</h3>\";s:18:\"carousel_shortcode\";s:46:\"<h3 style=\'margin: 0;\'>Carousel Shortcode</h3>\";s:12:\"cb_shortcode\";s:49:\"<h3 style=\'margin: 0;\'>Content Box Shortcode</h3>\";s:19:\"checklist_shortcode\";s:47:\"<h3 style=\'margin: 0;\'>Checklist Shortcode</h3>\";s:12:\"cc_shortcode\";s:52:\"<h3 style=\'margin: 0;\'>Counter Circle Shortcode</h3>\";s:18:\"counterb_shortcode\";s:51:\"<h3 style=\'margin: 0;\'>Counter Boxes Shortcode</h3>\";s:17:\"dropcap_shortcode\";s:45:\"<h3 style=\'margin: 0;\'>Dropcap Shortcode</h3>\";s:15:\"flipb_shortcode\";s:48:\"<h3 style=\'margin: 0;\'>Flip Boxes Shortcode</h3>\";s:19:\"fullwidth_shortcode\";s:48:\"<h3 style=\'margin: 0;\'>Full Width Shortcode</h3>\";s:14:\"icon_shortcode\";s:42:\"<h3 style=\'margin: 0;\'>Icon Shortcode</h3>\";s:14:\"imgf_shortcode\";s:49:\"<h3 style=\'margin: 0;\'>Image Frame Shortcode</h3>\";s:15:\"modal_shortcode\";s:43:\"<h3 style=\'margin: 0;\'>Modal Shortcode</h3>\";s:16:\"person_shortcode\";s:44:\"<h3 style=\'margin: 0;\'>Person Shortcode</h3>\";s:17:\"popover_shortcode\";s:45:\"<h3 style=\'margin: 0;\'>Popover Shortcode</h3>\";s:22:\"pricingtable_shortcode\";s:51:\"<h3 style=\'margin: 0;\'>Pricing Table Shortcode</h3>\";s:21:\"progressbar_shortcode\";s:50:\"<h3 style=\'margin: 0;\'>Progress Bar Shortcode</h3>\";s:19:\"separator_shortcode\";s:47:\"<h3 style=\'margin: 0;\'>Separator Shortcode</h3>\";s:26:\"sectionseparator_shortcode\";s:55:\"<h3 style=\'margin: 0;\'>Section Separator Shortcode</h3>\";s:20:\"sharingbox_shortcode\";s:49:\"<h3 style=\'margin: 0;\'>Sharing Box Shortcode</h3>\";s:21:\"sociallinks_shortcode\";s:50:\"<h3 style=\'margin: 0;\'>Social Links Shortcode</h3>\";s:14:\"tabs_shortcode\";s:42:\"<h3 style=\'margin: 0;\'>Tabs Shortcode</h3>\";s:17:\"tagline_shortcode\";s:45:\"<h3 style=\'margin: 0;\'>Tagline Shortcode</h3>\";s:22:\"testimonials_shortcode\";s:50:\"<h3 style=\'margin: 0;\'>Testimonials Shortcode</h3>\";s:15:\"title_shortcode\";s:43:\"<h3 style=\'margin: 0;\'>Title Shortcode</h3>\";s:19:\"accordion_shortcode\";s:45:\"<h3 style=\'margin: 0;\'>Toggles Shortcode</h3>\";s:16:\"blog_single_post\";s:62:\"<h3 style=\'margin: 0;\'>Portfolio Single Post Page Options</h3>\";s:9:\"blog_meta\";s:45:\"<h3 style=\'margin: 0;\'>Blog Meta Options</h3>\";s:35:\"social_share_box_icon_options_title\";s:57:\"<h3 style=\'margin: 0;\'>Social Share Box Icon Options</h3>\";s:28:\"social_share_box_links_title\";s:50:\"<h3 style=\'margin: 0;\'>Social Share Box Links</h3>\";s:27:\"custom_color_scheme_element\";s:46:\"<h3 style=\'margin: 0;\'>Custom Social Icon</h3>\";s:8:\"lightbox\";s:44:\"<h3 style=\'margin: 0;\'>Lightbox Options</h3>\";s:10:\"google_map\";s:53:\"<h3 style=\'margin: 0;\'>Google Map Design Styling</h3>\";s:9:\"recaptcha\";s:50:\"<h3 style=\'margin: 0;\'>ReCaptcha Spam Options</h3>\";s:6:\"search\";s:42:\"<h3 style=\'margin: 0;\'>Search Options</h3>\";s:12:\"misc_options\";s:49:\"<h3 style=\'margin: 0;\'>Miscellaneous Options</h3>\";s:9:\"rollovers\";s:50:\"<h3 style=\'margin: 0;\'>Image Rollover Options</h3>\";s:22:\"enable_disable_heading\";s:76:\"<h3 style=\'margin: 0;\'>Enable / Disable Theme Features & Plugin Support</h3>\";s:18:\"advanced_css_intro\";s:55:\"<h3 style=\'margin: 0;\'>Advanced CSS Customizations</h3>\";s:9:\"of_backup\";s:0:\"\";s:11:\"of_transfer\";s:0:\"\";s:13:\"theme_updater\";s:62:\"<h3 style=\'margin: 0;\'>Enter all 3 required fields below!</h3>\";}", "yes");
INSERT INTO `bupg_options` VALUES("141", "shop_catalog_image_size", "a:3:{s:5:\"width\";i:500;s:6:\"height\";s:0:\"\";i:0;i:0;}", "yes");
INSERT INTO `bupg_options` VALUES("142", "shop_single_image_size", "a:3:{s:5:\"width\";i:500;s:6:\"height\";s:0:\"\";i:0;i:0;}", "yes");
INSERT INTO `bupg_options` VALUES("143", "shop_thumbnail_image_size", "a:3:{s:5:\"width\";i:120;s:6:\"height\";s:0:\"\";i:0;i:0;}", "yes");
INSERT INTO `bupg_options` VALUES("146", "ls-plugin-version", "5.3.2", "yes");
INSERT INTO `bupg_options` VALUES("147", "ls-db-version", "5.0.0", "yes");
INSERT INTO `bupg_options` VALUES("148", "ls-installed", "1", "yes");
INSERT INTO `bupg_options` VALUES("149", "ls-google-fonts", "a:4:{i:0;a:2:{s:5:\"param\";s:28:\"Lato:100,300,regular,700,900\";s:5:\"admin\";b:0;}i:1;a:2:{s:5:\"param\";s:13:\"Open+Sans:300\";s:5:\"admin\";b:0;}i:2;a:2:{s:5:\"param\";s:20:\"Indie+Flower:regular\";s:5:\"admin\";b:0;}i:3;a:2:{s:5:\"param\";s:22:\"Oswald:300,regular,700\";s:5:\"admin\";b:0;}}", "yes");
INSERT INTO `bupg_options` VALUES("150", "ls-date-installed", "1428116865", "yes");
INSERT INTO `bupg_options` VALUES("153", "revslider_checktables", "1", "yes");
INSERT INTO `bupg_options` VALUES("154", "revslider-static-css", ".tp-caption a {\ncolor:#ff7302;\ntext-shadow:none;\n-webkit-transition:all 0.2s ease-out;\n-moz-transition:all 0.2s ease-out;\n-o-transition:all 0.2s ease-out;\n-ms-transition:all 0.2s ease-out;\n}\n\n.tp-caption a:hover {\ncolor:#ffa902;\n}\n.avada_huge_white_text{\n			position: absolute; \n			color: #ffffff; \n			font-size: 130px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n            text-shadow: 0px 2px 5px rgba(0, 0, 0, 1);\n		}\n\n.avada_huge_black_text{\n			position: absolute; \n			color: #000000; \n			font-size: 130px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n		}\n\n.avada_big_black_text{\n			position: absolute; \n			color: #333333; \n			font-size: 42px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n		}\n\n.avada_big_white_text{\n			position: absolute; \n			color: #fff; \n			font-size: 42px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n		}\n\n.avada_big_black_text_center{\n			position: absolute; \n			color: #333333; \n			font-size: 38px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n                        text-align: center;\n		}\n\n\n.avada_med_green_text{\n			position: absolute; \n			color: #A0CE4E; \n			font-size: 24px; \n			line-height: 24px; \n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n		}\n\n\n.avada_small_gray_text{\n			position: absolute; \n			color: #747474; \n			font-size: 13px; 			\n            line-height: 20px; \n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n		}\n\n.avada_small_white_text{\n			position: absolute; \n			color: #fff; \n			font-size: 13px; 			\n            line-height: 20px; \n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n    		text-shadow: 0px 2px 5px rgba(0, 0, 0, 0.5);\n  			font-weight: 700; \n\n		}\n\n\n.avada_block_black{\n			position: absolute; \n			color: #A0CE4E; \n			text-shadow: none; \n			font-size: 22px; \n			line-height: 34px; \n			padding: 0px 10px; \n			padding-top: 1px;\n			margin: 0px; \n			border-width: 0px; \n			border-style: none; \n			background-color:#000;	\n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n	}\n\n.avada_block_green{\n			position: absolute; \n			color: #000; \n			text-shadow: none; \n			font-size: 22px; \n			line-height: 34px; \n			padding: 0px 10px; \n			padding-top: 1px;\n			margin: 0px; \n			border-width: 0px; \n			border-style: none; \n			background-color:#A0CE4E;	\n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n	}\n\n.avada_block_white{\n			position: absolute; \n			color: #fff; \n			text-shadow: none; \n			font-size: 22px; \n			line-height: 34px; \n			padding: 0px 10px; \n			padding-top: 1px;\n			margin: 0px; \n			border-width: 0px; \n			border-style: none; \n			background-color:#000;	\n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n	}\n\n\n.avada_block_white_trans{\n			position: absolute; \n			color: #fff; \n			text-shadow: none; \n			font-size: 22px; \n			line-height: 34px; \n			padding: 0px 10px; \n			padding-top: 1px;\n			margin: 0px; \n			border-width: 0px; \n			border-style: none; \n			background-color:rgba(0, 0, 0, 0.6);    		\n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n	}\n.avada_huge_white_text{\n			position: absolute; \n			color: #ffffff; \n			font-size: 130px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n            text-shadow: 0px 2px 5px rgba(0, 0, 0, 1);\n		}\n\n.avada_huge_black_text{\n			position: absolute; \n			color: #000000; \n			font-size: 130px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n		}\n\n.avada_big_black_text{\n			position: absolute; \n			color: #333333; \n			font-size: 42px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n		}\n\n.avada_big_white_text{\n			position: absolute; \n			color: #fff; \n			font-size: 42px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n		}\n\n.avada_big_black_text_center{\n			position: absolute; \n			color: #333333; \n			font-size: 38px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n                        text-align: center;\n		}\n\n\n.avada_med_green_text{\n			position: absolute; \n			color: #A0CE4E; \n			font-size: 24px; \n			line-height: 24px; \n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n		}\n\n\n.avada_small_gray_text{\n			position: absolute; \n			color: #747474; \n			font-size: 13px; 			\n            line-height: 20px; \n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n		}\n\n.avada_small_white_text{\n			position: absolute; \n			color: #fff; \n			font-size: 13px; 			\n            line-height: 20px; \n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n    		text-shadow: 0px 2px 5px rgba(0, 0, 0, 0.5);\n  			font-weight: 700; \n\n		}\n\n\n.avada_block_black{\n			position: absolute; \n			color: #A0CE4E; \n			text-shadow: none; \n			font-size: 22px; \n			line-height: 34px; \n			padding: 0px 10px; \n			padding-top: 1px;\n			margin: 0px; \n			border-width: 0px; \n			border-style: none; \n			background-color:#000;	\n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n	}\n\n.avada_block_green{\n			position: absolute; \n			color: #000; \n			text-shadow: none; \n			font-size: 22px; \n			line-height: 34px; \n			padding: 0px 10px; \n			padding-top: 1px;\n			margin: 0px; \n			border-width: 0px; \n			border-style: none; \n			background-color:#A0CE4E;	\n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n	}\n\n.avada_block_white{\n			position: absolute; \n			color: #fff; \n			text-shadow: none; \n			font-size: 22px; \n			line-height: 34px; \n			padding: 0px 10px; \n			padding-top: 1px;\n			margin: 0px; \n			border-width: 0px; \n			border-style: none; \n			background-color:#000;	\n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n	}\n\n\n.avada_block_white_trans{\n			position: absolute; \n			color: #fff; \n			text-shadow: none; \n			font-size: 22px; \n			line-height: 34px; \n			padding: 0px 10px; \n			padding-top: 1px;\n			margin: 0px; \n			border-width: 0px; \n			border-style: none; \n			background-color:rgba(0, 0, 0, 0.6);    		\n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n	}\n.avada_huge_white_text{\n			position: absolute; \n			color: #ffffff; \n			font-size: 130px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n            text-shadow: 0px 2px 5px rgba(0, 0, 0, 1);\n		}\n\n.avada_huge_black_text{\n			position: absolute; \n			color: #000000; \n			font-size: 130px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n		}\n\n.avada_big_black_text{\n			position: absolute; \n			color: #333333; \n			font-size: 42px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n		}\n\n.avada_big_white_text{\n			position: absolute; \n			color: #fff; \n			font-size: 42px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n		}\n\n.avada_big_black_text_center{\n			position: absolute; \n			color: #333333; \n			font-size: 38px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n                        text-align: center;\n		}\n\n\n.avada_med_green_text{\n			position: absolute; \n			color: #A0CE4E; \n			font-size: 24px; \n			line-height: 24px; \n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n		}\n\n\n.avada_small_gray_text{\n			position: absolute; \n			color: #747474; \n			font-size: 13px; 			\n            line-height: 20px; \n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n		}\n\n.avada_small_white_text{\n			position: absolute; \n			color: #fff; \n			font-size: 13px; 			\n            line-height: 20px; \n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n    		text-shadow: 0px 2px 5px rgba(0, 0, 0, 0.5);\n  			font-weight: 700; \n\n		}\n\n\n.avada_block_black{\n			position: absolute; \n			color: #A0CE4E; \n			text-shadow: none; \n			font-size: 22px; \n			line-height: 34px; \n			padding: 0px 10px; \n			padding-top: 1px;\n			margin: 0px; \n			border-width: 0px; \n			border-style: none; \n			background-color:#000;	\n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n	}\n\n.avada_block_green{\n			position: absolute; \n			color: #000; \n			text-shadow: none; \n			font-size: 22px; \n			line-height: 34px; \n			padding: 0px 10px; \n			padding-top: 1px;\n			margin: 0px; \n			border-width: 0px; \n			border-style: none; \n			background-color:#A0CE4E;	\n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n	}\n\n.avada_block_white{\n			position: absolute; \n			color: #fff; \n			text-shadow: none; \n			font-size: 22px; \n			line-height: 34px; \n			padding: 0px 10px; \n			padding-top: 1px;\n			margin: 0px; \n			border-width: 0px; \n			border-style: none; \n			background-color:#000;	\n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n	}\n\n\n.avada_block_white_trans{\n			position: absolute; \n			color: #fff; \n			text-shadow: none; \n			font-size: 22px; \n			line-height: 34px; \n			padding: 0px 10px; \n			padding-top: 1px;\n			margin: 0px; \n			border-width: 0px; \n			border-style: none; \n			background-color:rgba(0, 0, 0, 0.6);    		\n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n	}\n.avada_huge_white_text{\n			position: absolute; \n			color: #ffffff; \n			font-size: 130px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n            text-shadow: 0px 2px 5px rgba(0, 0, 0, 1);\n		}\n\n.avada_huge_black_text{\n			position: absolute; \n			color: #000000; \n			font-size: 130px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n		}\n\n.avada_big_black_text{\n			position: absolute; \n			color: #333333; \n			font-size: 42px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n		}\n\n.avada_big_white_text{\n			position: absolute; \n			color: #fff; \n			font-size: 42px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n		}\n\n.avada_big_black_text_center{\n			position: absolute; \n			color: #333333; \n			font-size: 38px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n                        text-align: center;\n		}\n\n\n.avada_med_green_text{\n			position: absolute; \n			color: #A0CE4E; \n			font-size: 24px; \n			line-height: 24px; \n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n		}\n\n\n.avada_small_gray_text{\n			position: absolute; \n			color: #747474; \n			font-size: 13px; 			\n            line-height: 20px; \n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n		}\n\n.avada_small_white_text{\n			position: absolute; \n			color: #fff; \n			font-size: 13px; 			\n            line-height: 20px; \n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n    		text-shadow: 0px 2px 5px rgba(0, 0, 0, 0.5);\n  			font-weight: 700; \n\n		}\n\n\n.avada_block_black{\n			position: absolute; \n			color: #A0CE4E; \n			text-shadow: none; \n			font-size: 22px; \n			line-height: 34px; \n			padding: 0px 10px; \n			padding-top: 1px;\n			margin: 0px; \n			border-width: 0px; \n			border-style: none; \n			background-color:#000;	\n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n	}\n\n.avada_block_green{\n			position: absolute; \n			color: #000; \n			text-shadow: none; \n			font-size: 22px; \n			line-height: 34px; \n			padding: 0px 10px; \n			padding-top: 1px;\n			margin: 0px; \n			border-width: 0px; \n			border-style: none; \n			background-color:#A0CE4E;	\n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n	}\n\n.avada_block_white{\n			position: absolute; \n			color: #fff; \n			text-shadow: none; \n			font-size: 22px; \n			line-height: 34px; \n			padding: 0px 10px; \n			padding-top: 1px;\n			margin: 0px; \n			border-width: 0px; \n			border-style: none; \n			background-color:#000;	\n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n	}\n\n\n.avada_block_white_trans{\n			position: absolute; \n			color: #fff; \n			text-shadow: none; \n			font-size: 22px; \n			line-height: 34px; \n			padding: 0px 10px; \n			padding-top: 1px;\n			margin: 0px; \n			border-width: 0px; \n			border-style: none; \n			background-color:rgba(0, 0, 0, 0.6);    		\n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n	}\n.avada_huge_white_text{\n			position: absolute; \n			color: #ffffff; \n			font-size: 130px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n            text-shadow: 0px 2px 5px rgba(0, 0, 0, 1);\n		}\n\n.avada_huge_black_text{\n			position: absolute; \n			color: #000000; \n			font-size: 130px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n		}\n\n.avada_big_black_text{\n			position: absolute; \n			color: #333333; \n			font-size: 42px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n		}\n\n.avada_big_white_text{\n			position: absolute; \n			color: #fff; \n			font-size: 42px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n		}\n\n.avada_big_black_text_center{\n			position: absolute; \n			color: #333333; \n			font-size: 38px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n                        text-align: center;\n		}\n\n\n.avada_med_green_text{\n			position: absolute; \n			color: #A0CE4E; \n			font-size: 24px; \n			line-height: 24px; \n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n		}\n\n\n.avada_small_gray_text{\n			position: absolute; \n			color: #747474; \n			font-size: 13px; 			\n            line-height: 20px; \n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n		}\n\n.avada_small_white_text{\n			position: absolute; \n			color: #fff; \n			font-size: 13px; 			\n            line-height: 20px; \n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n    		text-shadow: 0px 2px 5px rgba(0, 0, 0, 0.5);\n  			font-weight: 700; \n\n		}\n\n\n.avada_block_black{\n			position: absolute; \n			color: #A0CE4E; \n			text-shadow: none; \n			font-size: 22px; \n			line-height: 34px; \n			padding: 0px 10px; \n			padding-top: 1px;\n			margin: 0px; \n			border-width: 0px; \n			border-style: none; \n			background-color:#000;	\n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n	}\n\n.avada_block_green{\n			position: absolute; \n			color: #000; \n			text-shadow: none; \n			font-size: 22px; \n			line-height: 34px; \n			padding: 0px 10px; \n			padding-top: 1px;\n			margin: 0px; \n			border-width: 0px; \n			border-style: none; \n			background-color:#A0CE4E;	\n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n	}\n\n.avada_block_white{\n			position: absolute; \n			color: #fff; \n			text-shadow: none; \n			font-size: 22px; \n			line-height: 34px; \n			padding: 0px 10px; \n			padding-top: 1px;\n			margin: 0px; \n			border-width: 0px; \n			border-style: none; \n			background-color:#000;	\n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n	}\n\n\n.avada_block_white_trans{\n			position: absolute; \n			color: #fff; \n			text-shadow: none; \n			font-size: 22px; \n			line-height: 34px; \n			padding: 0px 10px; \n			padding-top: 1px;\n			margin: 0px; \n			border-width: 0px; \n			border-style: none; \n			background-color:rgba(0, 0, 0, 0.6);    		\n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n	}\n.avada_huge_white_text{\n			position: absolute; \n			color: #ffffff; \n			font-size: 130px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n            text-shadow: 0px 2px 5px rgba(0, 0, 0, 1);\n		}\n\n.avada_huge_black_text{\n			position: absolute; \n			color: #000000; \n			font-size: 130px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n		}\n\n.avada_big_black_text{\n			position: absolute; \n			color: #333333; \n			font-size: 42px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n		}\n\n.avada_big_white_text{\n			position: absolute; \n			color: #fff; \n			font-size: 42px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n		}\n\n.avada_big_black_text_center{\n			position: absolute; \n			color: #333333; \n			font-size: 38px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n                        text-align: center;\n		}\n\n\n.avada_med_green_text{\n			position: absolute; \n			color: #A0CE4E; \n			font-size: 24px; \n			line-height: 24px; \n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n		}\n\n\n.avada_small_gray_text{\n			position: absolute; \n			color: #747474; \n			font-size: 13px; 			\n            line-height: 20px; \n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n		}\n\n.avada_small_white_text{\n			position: absolute; \n			color: #fff; \n			font-size: 13px; 			\n            line-height: 20px; \n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n    		text-shadow: 0px 2px 5px rgba(0, 0, 0, 0.5);\n  			font-weight: 700; \n\n		}\n\n\n.avada_block_black{\n			position: absolute; \n			color: #A0CE4E; \n			text-shadow: none; \n			font-size: 22px; \n			line-height: 34px; \n			padding: 0px 10px; \n			padding-top: 1px;\n			margin: 0px; \n			border-width: 0px; \n			border-style: none; \n			background-color:#000;	\n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n	}\n\n.avada_block_green{\n			position: absolute; \n			color: #000; \n			text-shadow: none; \n			font-size: 22px; \n			line-height: 34px; \n			padding: 0px 10px; \n			padding-top: 1px;\n			margin: 0px; \n			border-width: 0px; \n			border-style: none; \n			background-color:#A0CE4E;	\n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n	}\n\n.avada_block_white{\n			position: absolute; \n			color: #fff; \n			text-shadow: none; \n			font-size: 22px; \n			line-height: 34px; \n			padding: 0px 10px; \n			padding-top: 1px;\n			margin: 0px; \n			border-width: 0px; \n			border-style: none; \n			background-color:#000;	\n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n	}\n\n\n.avada_block_white_trans{\n			position: absolute; \n			color: #fff; \n			text-shadow: none; \n			font-size: 22px; \n			line-height: 34px; \n			padding: 0px 10px; \n			padding-top: 1px;\n			margin: 0px; \n			border-width: 0px; \n			border-style: none; \n			background-color:rgba(0, 0, 0, 0.6);    		\n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n	}\n.avada_huge_white_text{\n			position: absolute; \n			color: #ffffff; \n			font-size: 130px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n            text-shadow: 0px 2px 5px rgba(0, 0, 0, 1);\n		}\n\n.avada_huge_black_text{\n			position: absolute; \n			color: #000000; \n			font-size: 130px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n		}\n\n.avada_big_black_text{\n			position: absolute; \n			color: #333333; \n			font-size: 42px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n		}\n\n.avada_big_white_text{\n			position: absolute; \n			color: #fff; \n			font-size: 42px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n		}\n\n.avada_big_black_text_center{\n			position: absolute; \n			color: #333333; \n			font-size: 38px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n                        text-align: center;\n		}\n\n\n.avada_med_green_text{\n			position: absolute; \n			color: #A0CE4E; \n			font-size: 24px; \n			line-height: 24px; \n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n		}\n\n\n.avada_small_gray_text{\n			position: absolute; \n			color: #747474; \n			font-size: 13px; 			\n            line-height: 20px; \n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n		}\n\n.avada_small_white_text{\n			position: absolute; \n			color: #fff; \n			font-size: 13px; 			\n            line-height: 20px; \n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n    		text-shadow: 0px 2px 5px rgba(0, 0, 0, 0.5);\n  			font-weight: 700; \n\n		}\n\n\n.avada_block_black{\n			position: absolute; \n			color: #A0CE4E; \n			text-shadow: none; \n			font-size: 22px; \n			line-height: 34px; \n			padding: 0px 10px; \n			padding-top: 1px;\n			margin: 0px; \n			border-width: 0px; \n			border-style: none; \n			background-color:#000;	\n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n	}\n\n.avada_block_green{\n			position: absolute; \n			color: #000; \n			text-shadow: none; \n			font-size: 22px; \n			line-height: 34px; \n			padding: 0px 10px; \n			padding-top: 1px;\n			margin: 0px; \n			border-width: 0px; \n			border-style: none; \n			background-color:#A0CE4E;	\n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n	}\n\n.avada_block_white{\n			position: absolute; \n			color: #fff; \n			text-shadow: none; \n			font-size: 22px; \n			line-height: 34px; \n			padding: 0px 10px; \n			padding-top: 1px;\n			margin: 0px; \n			border-width: 0px; \n			border-style: none; \n			background-color:#000;	\n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n	}\n\n\n.avada_block_white_trans{\n			position: absolute; \n			color: #fff; \n			text-shadow: none; \n			font-size: 22px; \n			line-height: 34px; \n			padding: 0px 10px; \n			padding-top: 1px;\n			margin: 0px; \n			border-width: 0px; \n			border-style: none; \n			background-color:rgba(0, 0, 0, 0.6);    		\n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n	}\n.avada_huge_white_text{\n			position: absolute; \n			color: #ffffff; \n			font-size: 130px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n            text-shadow: 0px 2px 5px rgba(0, 0, 0, 1);\n		}\n\n.avada_huge_black_text{\n			position: absolute; \n			color: #000000; \n			font-size: 130px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n		}\n\n.avada_big_black_text{\n			position: absolute; \n			color: #333333; \n			font-size: 42px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n		}\n\n.avada_big_white_text{\n			position: absolute; \n			color: #fff; \n			font-size: 42px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n		}\n\n.avada_big_black_text_center{\n			position: absolute; \n			color: #333333; \n			font-size: 38px; \n			line-height: 45px; \n			font-family: museoslab500regular;\n                        text-align: center;\n		}\n\n\n.avada_med_green_text{\n			position: absolute; \n			color: #A0CE4E; \n			font-size: 24px; \n			line-height: 24px; \n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n		}\n\n\n.avada_small_gray_text{\n			position: absolute; \n			color: #747474; \n			font-size: 13px; 			\n            line-height: 20px; \n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n		}\n\n.avada_small_white_text{\n			position: absolute; \n			color: #fff; \n			font-size: 13px; 			\n            line-height: 20px; \n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n    		text-shadow: 0px 2px 5px rgba(0, 0, 0, 0.5);\n  			font-weight: 700; \n\n		}\n\n\n.avada_block_black{\n			position: absolute; \n			color: #A0CE4E; \n			text-shadow: none; \n			font-size: 22px; \n			line-height: 34px; \n			padding: 0px 10px; \n			padding-top: 1px;\n			margin: 0px; \n			border-width: 0px; \n			border-style: none; \n			background-color:#000;	\n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n	}\n\n.avada_block_green{\n			position: absolute; \n			color: #000; \n			text-shadow: none; \n			font-size: 22px; \n			line-height: 34px; \n			padding: 0px 10px; \n			padding-top: 1px;\n			margin: 0px; \n			border-width: 0px; \n			border-style: none; \n			background-color:#A0CE4E;	\n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n	}\n\n.avada_block_white{\n			position: absolute; \n			color: #fff; \n			text-shadow: none; \n			font-size: 22px; \n			line-height: 34px; \n			padding: 0px 10px; \n			padding-top: 1px;\n			margin: 0px; \n			border-width: 0px; \n			border-style: none; \n			background-color:#000;	\n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n	}\n\n\n.avada_block_white_trans{\n			position: absolute; \n			color: #fff; \n			text-shadow: none; \n			font-size: 22px; \n			line-height: 34px; \n			padding: 0px 10px; \n			padding-top: 1px;\n			margin: 0px; \n			border-width: 0px; \n			border-style: none; \n			background-color:rgba(0, 0, 0, 0.6);    		\n			font-family: PTSansRegular, Arial, Helvetica, sans-serif;\n	}\n.tp-caption a {\ncolor:#ff7302;\ntext-shadow:none;\n-webkit-transition:all 0.2s ease-out;\n-moz-transition:all 0.2s ease-out;\n-o-transition:all 0.2s ease-out;\n-ms-transition:all 0.2s ease-out;\n}\n\n.tp-caption a:hover {\ncolor:#ffa902;\n}\n.tp-caption a {\ncolor:#ff7302;\ntext-shadow:none;\n-webkit-transition:all 0.2s ease-out;\n-moz-transition:all 0.2s ease-out;\n-o-transition:all 0.2s ease-out;\n-ms-transition:all 0.2s ease-out;\n}\n\n.tp-caption a:hover {\ncolor:#ffa902;\n}", "yes");
INSERT INTO `bupg_options` VALUES("157", "avada_revslider_version", "4.6.5", "yes");
INSERT INTO `bupg_options` VALUES("186", "sbg_sidebars", "a:6:{s:14:\"ContactSidebar\";s:15:\"Contact Sidebar\";s:3:\"FAQ\";s:3:\"FAQ\";s:15:\"HomepageSidebar\";s:17:\"Home Page Sidebar\";s:9:\"Portfolio\";s:9:\"Portfolio\";s:9:\"Megamenu1\";s:9:\"Megamenu1\";s:9:\"Megamenu2\";s:9:\"Megamenu2\";}", "yes");
INSERT INTO `bupg_options` VALUES("187", "widget_pyre_tabs-widget", "a:5:{i:6;a:8:{s:5:\"posts\";s:1:\"3\";s:8:\"comments\";s:1:\"3\";s:4:\"tags\";s:1:\"3\";s:18:\"show_popular_posts\";s:2:\"on\";s:17:\"show_recent_posts\";s:2:\"on\";s:13:\"show_comments\";s:2:\"on\";s:9:\"show_tags\";N;s:7:\"orderby\";s:16:\"Highest Comments\";}i:5;a:8:{s:5:\"posts\";s:1:\"3\";s:8:\"comments\";s:1:\"3\";s:4:\"tags\";s:2:\"20\";s:18:\"show_popular_posts\";s:2:\"on\";s:17:\"show_recent_posts\";s:2:\"on\";s:13:\"show_comments\";s:2:\"on\";s:9:\"show_tags\";N;s:7:\"orderby\";s:16:\"Highest Comments\";}i:4;a:7:{s:5:\"posts\";s:1:\"3\";s:8:\"comments\";s:1:\"3\";s:4:\"tags\";s:2:\"20\";s:18:\"show_popular_posts\";s:2:\"on\";s:17:\"show_recent_posts\";s:2:\"on\";s:13:\"show_comments\";s:2:\"on\";s:9:\"show_tags\";N;}i:3;a:8:{s:5:\"posts\";s:1:\"3\";s:8:\"comments\";s:1:\"3\";s:4:\"tags\";s:2:\"20\";s:18:\"show_popular_posts\";s:2:\"on\";s:17:\"show_recent_posts\";s:2:\"on\";s:13:\"show_comments\";s:2:\"on\";s:9:\"show_tags\";N;s:7:\"orderby\";s:16:\"Highest Comments\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bupg_options` VALUES("188", "widget_recent_works-widget", "a:4:{i:4;a:2:{s:5:\"title\";s:12:\"Recent Works\";s:6:\"number\";s:1:\"6\";}i:6;a:2:{s:5:\"title\";s:12:\"Recent Works\";s:6:\"number\";s:1:\"6\";}i:5;a:2:{s:5:\"title\";s:12:\"Recent Works\";s:6:\"number\";s:1:\"6\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bupg_options` VALUES("189", "widget_contact_info-widget", "a:3:{i:3;a:8:{s:5:\"title\";s:12:\"Contact Info\";s:7:\"address\";s:49:\"12345 north Street <br />New York City, NY 555555\";s:5:\"phone\";s:12:\"555-555-5555\";s:3:\"fax\";s:12:\"555-555-5555\";s:5:\"email\";s:20:\"info@yourwebsite.com\";s:8:\"emailtxt\";s:20:\"info@yourwebsite.com\";s:3:\"web\";s:22:\"http://yourwebsite.com\";s:6:\"webtxt\";s:15:\"Yourwebsite.com\";}i:2;a:9:{s:5:\"title\";s:12:\"Contact Info\";s:7:\"address\";s:47:\"12345 North Main Street,<br>New York, NY 555555\";s:5:\"phone\";s:12:\"555-555-5555\";s:3:\"fax\";s:12:\"555-555-5555\";s:5:\"email\";s:20:\"info@yourwebsite.com\";s:3:\"web\";s:22:\"http://yourwebsite.com\";s:8:\"emailtxt\";s:20:\"info@yourwebsite.com\";s:6:\"webtxt\";s:15:\"Yourwebsite.com\";s:6:\"mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bupg_options` VALUES("190", "widget_social_links-widget", "a:2:{i:3;a:32:{s:5:\"title\";s:10:\"Get Social\";s:8:\"rss_link\";s:1:\"#\";s:7:\"fb_link\";s:1:\"#\";s:12:\"twitter_link\";s:1:\"#\";s:13:\"dribbble_link\";s:1:\"#\";s:11:\"google_link\";s:1:\"#\";s:13:\"linkedin_link\";s:1:\"#\";s:12:\"blogger_link\";s:1:\"#\";s:11:\"tumblr_link\";s:1:\"#\";s:11:\"reddit_link\";s:1:\"#\";s:10:\"yahoo_link\";s:1:\"#\";s:15:\"deviantart_link\";s:1:\"#\";s:10:\"vimeo_link\";s:1:\"#\";s:12:\"youtube_link\";s:1:\"#\";s:14:\"pinterest_link\";s:1:\"#\";s:9:\"digg_link\";s:1:\"#\";s:11:\"flickr_link\";s:1:\"#\";s:11:\"forrst_link\";s:1:\"#\";s:12:\"myspace_link\";s:1:\"#\";s:10:\"skype_link\";s:1:\"#\";s:10:\"linktarget\";s:0:\"\";s:10:\"icon_color\";s:0:\"\";s:10:\"boxed_icon\";s:3:\"Yes\";s:11:\"boxed_color\";s:0:\"\";s:17:\"boxed_icon_radius\";s:3:\"4px\";s:11:\"tooltip_pos\";s:3:\"Top\";s:11:\"show_custom\";s:2:\"No\";s:14:\"instagram_link\";s:0:\"\";s:11:\"paypal_link\";s:0:\"\";s:12:\"dropbox_link\";s:0:\"\";s:15:\"soundcloud_link\";s:0:\"\";s:7:\"vk_link\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `bupg_options` VALUES("191", "category_children", "a:0:{}", "yes");
INSERT INTO `bupg_options` VALUES("192", "slide-page_children", "a:0:{}", "yes");
INSERT INTO `bupg_options` VALUES("193", "portfolio_category_children", "a:0:{}", "yes");
INSERT INTO `bupg_options` VALUES("194", "portfolio_skills_children", "a:0:{}", "yes");
INSERT INTO `bupg_options` VALUES("195", "faq_category_children", "a:0:{}", "yes");
INSERT INTO `bupg_options` VALUES("196", "taxonomy_12", "a:11:{s:12:\"slider_width\";s:6:\"1100px\";s:13:\"slider_height\";s:5:\"622px\";s:11:\"full_screen\";s:1:\"0\";s:8:\"parallax\";s:1:\"1\";s:10:\"nav_arrows\";s:1:\"1\";s:18:\"pagination_circles\";s:1:\"1\";s:8:\"autoplay\";s:1:\"1\";s:4:\"loop\";s:1:\"0\";s:9:\"animation\";s:4:\"fade\";s:15:\"slideshow_speed\";s:4:\"7000\";s:15:\"animation_speed\";s:3:\"600\";}", "yes");
INSERT INTO `bupg_options` VALUES("197", "taxonomy_13", "a:11:{s:12:\"slider_width\";s:4:\"100%\";s:13:\"slider_height\";s:5:\"500px\";s:11:\"full_screen\";s:1:\"1\";s:8:\"parallax\";s:1:\"1\";s:10:\"nav_arrows\";s:1:\"1\";s:18:\"pagination_circles\";s:1:\"1\";s:8:\"autoplay\";s:1:\"0\";s:4:\"loop\";s:1:\"0\";s:9:\"animation\";s:4:\"fade\";s:15:\"slideshow_speed\";s:4:\"7000\";s:15:\"animation_speed\";s:3:\"600\";}", "yes");
INSERT INTO `bupg_options` VALUES("198", "taxonomy_14", "a:11:{s:12:\"slider_width\";s:4:\"100%\";s:13:\"slider_height\";s:5:\"620px\";s:11:\"full_screen\";s:1:\"0\";s:8:\"parallax\";s:1:\"1\";s:10:\"nav_arrows\";s:1:\"1\";s:18:\"pagination_circles\";s:1:\"1\";s:8:\"autoplay\";s:1:\"0\";s:4:\"loop\";s:1:\"0\";s:9:\"animation\";s:4:\"fade\";s:15:\"slideshow_speed\";s:4:\"7000\";s:15:\"animation_speed\";s:3:\"600\";}", "yes");
INSERT INTO `bupg_options` VALUES("199", "taxonomy_15", "a:11:{s:12:\"slider_width\";s:4:\"100%\";s:13:\"slider_height\";s:5:\"700px\";s:11:\"full_screen\";s:1:\"0\";s:8:\"parallax\";s:1:\"1\";s:10:\"nav_arrows\";s:1:\"0\";s:18:\"pagination_circles\";s:1:\"0\";s:8:\"autoplay\";s:1:\"1\";s:4:\"loop\";s:1:\"0\";s:9:\"animation\";s:4:\"fade\";s:15:\"slideshow_speed\";s:4:\"7000\";s:15:\"animation_speed\";s:3:\"600\";}", "yes");
INSERT INTO `bupg_options` VALUES("200", "taxonomy_16", "a:11:{s:12:\"slider_width\";s:5:\"718px\";s:13:\"slider_height\";s:5:\"400px\";s:11:\"full_screen\";s:1:\"0\";s:8:\"parallax\";s:1:\"0\";s:10:\"nav_arrows\";s:1:\"1\";s:18:\"pagination_circles\";s:1:\"1\";s:8:\"autoplay\";s:1:\"1\";s:4:\"loop\";s:1:\"0\";s:9:\"animation\";s:4:\"fade\";s:15:\"slideshow_speed\";s:4:\"7000\";s:15:\"animation_speed\";s:3:\"600\";}", "yes");
INSERT INTO `bupg_options` VALUES("315", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `bupg_options` VALUES("343", "db_upgraded", "", "yes");
INSERT INTO `bupg_options` VALUES("350", "can_compress_scripts", "1", "yes");
INSERT INTO `bupg_options` VALUES("472", "wpcf7", "a:1:{s:7:\"version\";s:5:\"4.2.1\";}", "yes");
INSERT INTO `bupg_options` VALUES("476", "wpseo", "a:20:{s:14:\"blocking_files\";a:0:{}s:26:\"ignore_blog_public_warning\";b:0;s:31:\"ignore_meta_description_warning\";b:0;s:20:\"ignore_page_comments\";b:0;s:16:\"ignore_permalink\";b:0;s:15:\"ms_defaults_set\";b:0;s:23:\"theme_description_found\";s:0:\"\";s:21:\"theme_has_description\";b:0;s:7:\"version\";s:5:\"2.2.1\";s:11:\"alexaverify\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:14:\"Dunamis Studio\";s:17:\"company_or_person\";s:7:\"company\";s:20:\"disableadvanced_meta\";b:1;s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:12:\"website_name\";s:0:\"\";s:22:\"alternate_website_name\";s:17:\"Engage Birmingham\";s:12:\"yandexverify\";s:0:\"\";}", "yes");
INSERT INTO `bupg_options` VALUES("477", "wpseo_permalinks", "a:13:{s:15:\"cleanpermalinks\";b:0;s:24:\"cleanpermalink-extravars\";s:0:\"\";s:29:\"cleanpermalink-googlecampaign\";b:0;s:31:\"cleanpermalink-googlesitesearch\";b:0;s:15:\"cleanreplytocom\";b:1;s:10:\"cleanslugs\";b:1;s:14:\"hide-feedlinks\";b:1;s:12:\"hide-rsdlink\";b:1;s:14:\"hide-shortlink\";b:1;s:16:\"hide-wlwmanifest\";b:1;s:18:\"redirectattachment\";b:1;s:17:\"stripcategorybase\";b:0;s:13:\"trailingslash\";b:0;}", "yes");
INSERT INTO `bupg_options` VALUES("478", "wpseo_titles", "a:118:{s:10:\"title_test\";i:0;s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:5:\"noodp\";b:1;s:6:\"noydir\";b:1;s:15:\"usemetakeywords\";b:0;s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Author at %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:63:\"You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:35:\"Page not found %%sep%% %%sitename%%\";s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:18:\"metakey-home-wpseo\";s:0:\"\";s:20:\"metakey-author-wpseo\";s:0:\"\";s:22:\"noindex-subpages-wpseo\";b:1;s:20:\"noindex-author-wpseo\";b:0;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:10:\"title-post\";s:9:\"%%title%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"metakey-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:13:\"showdate-post\";b:0;s:16:\"hideeditbox-post\";b:0;s:10:\"title-page\";s:9:\"%%title%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"metakey-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:13:\"showdate-page\";b:0;s:16:\"hideeditbox-page\";b:0;s:16:\"title-attachment\";s:9:\"%%title%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"metakey-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:19:\"showdate-attachment\";b:0;s:22:\"hideeditbox-attachment\";b:0;s:18:\"title-tax-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:20:\"metakey-tax-category\";s:0:\"\";s:24:\"hideeditbox-tax-category\";b:0;s:20:\"noindex-tax-category\";b:1;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:20:\"metakey-tax-post_tag\";s:0:\"\";s:24:\"hideeditbox-tax-post_tag\";b:0;s:20:\"noindex-tax-post_tag\";b:1;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:23:\"metakey-tax-post_format\";s:0:\"\";s:27:\"hideeditbox-tax-post_format\";b:0;s:23:\"noindex-tax-post_format\";b:1;s:11:\"title-slide\";s:9:\"%%title%%\";s:14:\"metadesc-slide\";s:0:\"\";s:13:\"metakey-slide\";s:0:\"\";s:13:\"noindex-slide\";b:0;s:14:\"showdate-slide\";b:0;s:17:\"hideeditbox-slide\";b:0;s:21:\"title-avada_portfolio\";s:9:\"%%title%%\";s:24:\"metadesc-avada_portfolio\";s:0:\"\";s:23:\"metakey-avada_portfolio\";s:0:\"\";s:23:\"noindex-avada_portfolio\";b:0;s:24:\"showdate-avada_portfolio\";b:0;s:27:\"hideeditbox-avada_portfolio\";b:0;s:15:\"title-avada_faq\";s:9:\"%%title%%\";s:18:\"metadesc-avada_faq\";s:0:\"\";s:17:\"metakey-avada_faq\";s:0:\"\";s:17:\"noindex-avada_faq\";b:0;s:18:\"showdate-avada_faq\";b:0;s:21:\"hideeditbox-avada_faq\";b:0;s:25:\"title-themefusion_elastic\";s:9:\"%%title%%\";s:28:\"metadesc-themefusion_elastic\";s:0:\"\";s:27:\"metakey-themefusion_elastic\";s:0:\"\";s:27:\"noindex-themefusion_elastic\";b:0;s:28:\"showdate-themefusion_elastic\";b:0;s:31:\"hideeditbox-themefusion_elastic\";b:0;s:31:\"title-ptarchive-avada_portfolio\";s:51:\"%%pt_plural%% Archive %%page%% %%sep%% %%sitename%%\";s:34:\"metadesc-ptarchive-avada_portfolio\";s:0:\"\";s:33:\"metakey-ptarchive-avada_portfolio\";s:0:\"\";s:33:\"bctitle-ptarchive-avada_portfolio\";s:0:\"\";s:33:\"noindex-ptarchive-avada_portfolio\";b:0;s:25:\"title-ptarchive-avada_faq\";s:51:\"%%pt_plural%% Archive %%page%% %%sep%% %%sitename%%\";s:28:\"metadesc-ptarchive-avada_faq\";s:0:\"\";s:27:\"metakey-ptarchive-avada_faq\";s:0:\"\";s:27:\"bctitle-ptarchive-avada_faq\";s:0:\"\";s:27:\"noindex-ptarchive-avada_faq\";b:0;s:20:\"title-tax-slide-page\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:23:\"metadesc-tax-slide-page\";s:0:\"\";s:22:\"metakey-tax-slide-page\";s:0:\"\";s:26:\"hideeditbox-tax-slide-page\";b:0;s:22:\"noindex-tax-slide-page\";b:1;s:28:\"title-tax-portfolio_category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:31:\"metadesc-tax-portfolio_category\";s:0:\"\";s:30:\"metakey-tax-portfolio_category\";s:0:\"\";s:34:\"hideeditbox-tax-portfolio_category\";b:0;s:30:\"noindex-tax-portfolio_category\";b:1;s:26:\"title-tax-portfolio_skills\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:29:\"metadesc-tax-portfolio_skills\";s:0:\"\";s:28:\"metakey-tax-portfolio_skills\";s:0:\"\";s:32:\"hideeditbox-tax-portfolio_skills\";b:0;s:28:\"noindex-tax-portfolio_skills\";b:1;s:24:\"title-tax-portfolio_tags\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:27:\"metadesc-tax-portfolio_tags\";s:0:\"\";s:26:\"metakey-tax-portfolio_tags\";s:0:\"\";s:30:\"hideeditbox-tax-portfolio_tags\";b:0;s:26:\"noindex-tax-portfolio_tags\";b:1;s:22:\"title-tax-faq_category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:25:\"metadesc-tax-faq_category\";s:0:\"\";s:24:\"metakey-tax-faq_category\";s:0:\"\";s:28:\"hideeditbox-tax-faq_category\";b:0;s:24:\"noindex-tax-faq_category\";b:1;s:31:\"title-tax-themefusion_es_groups\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:34:\"metadesc-tax-themefusion_es_groups\";s:0:\"\";s:33:\"metakey-tax-themefusion_es_groups\";s:0:\"\";s:37:\"hideeditbox-tax-themefusion_es_groups\";b:0;s:33:\"noindex-tax-themefusion_es_groups\";b:1;}", "yes");
INSERT INTO `bupg_options` VALUES("479", "wpseo_social", "a:21:{s:9:\"fb_admins\";a:0:{}s:12:\"fbconnectkey\";s:32:\"38dae50bf6a3d92270fbaf197ffd569b\";s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:9:\"opengraph\";b:1;s:10:\"googleplus\";b:0;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:14:\"plus-publisher\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:7:\"summary\";s:11:\"youtube_url\";s:0:\"\";s:15:\"google_plus_url\";s:0:\"\";s:10:\"fbadminapp\";s:0:\"\";}", "yes");
INSERT INTO `bupg_options` VALUES("480", "wpseo_rss", "a:2:{s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:53:\"The post %%POSTLINK%% appeared first on %%BLOGLINK%%.\";}", "yes");
INSERT INTO `bupg_options` VALUES("481", "wpseo_internallinks", "a:20:{s:20:\"breadcrumbs-404crumb\";s:25:\"Error 404: Page not found\";s:23:\"breadcrumbs-blog-remove\";b:0;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:12:\"Archives for\";s:18:\"breadcrumbs-enable\";b:0;s:16:\"breadcrumbs-home\";s:4:\"Home\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:16:\"You searched for\";s:15:\"breadcrumbs-sep\";s:7:\"&raquo;\";s:23:\"post_types-post-maintax\";i:0;s:24:\"post_types-slide-maintax\";i:0;s:34:\"post_types-avada_portfolio-maintax\";i:0;s:28:\"post_types-avada_faq-maintax\";i:0;s:38:\"post_types-themefusion_elastic-maintax\";i:0;s:28:\"taxonomy-slide-page-ptparent\";i:0;s:36:\"taxonomy-portfolio_category-ptparent\";i:0;s:34:\"taxonomy-portfolio_skills-ptparent\";i:0;s:32:\"taxonomy-portfolio_tags-ptparent\";i:0;s:30:\"taxonomy-faq_category-ptparent\";i:0;s:39:\"taxonomy-themefusion_es_groups-ptparent\";i:0;}", "yes");
INSERT INTO `bupg_options` VALUES("482", "wpseo_xml", "a:25:{s:22:\"disable_author_sitemap\";b:1;s:22:\"disable_author_noposts\";b:1;s:16:\"enablexmlsitemap\";b:1;s:16:\"entries-per-page\";i:1000;s:38:\"user_role-administrator-not_in_sitemap\";b:0;s:31:\"user_role-editor-not_in_sitemap\";b:0;s:31:\"user_role-author-not_in_sitemap\";b:0;s:36:\"user_role-contributor-not_in_sitemap\";b:0;s:35:\"user_role-subscriber-not_in_sitemap\";b:0;s:30:\"post_types-post-not_in_sitemap\";b:0;s:30:\"post_types-page-not_in_sitemap\";b:0;s:36:\"post_types-attachment-not_in_sitemap\";b:1;s:34:\"taxonomies-category-not_in_sitemap\";b:0;s:34:\"taxonomies-post_tag-not_in_sitemap\";b:1;s:37:\"taxonomies-post_format-not_in_sitemap\";b:0;s:31:\"post_types-slide-not_in_sitemap\";b:0;s:41:\"post_types-avada_portfolio-not_in_sitemap\";b:0;s:35:\"post_types-avada_faq-not_in_sitemap\";b:0;s:45:\"post_types-themefusion_elastic-not_in_sitemap\";b:0;s:36:\"taxonomies-slide-page-not_in_sitemap\";b:0;s:44:\"taxonomies-portfolio_category-not_in_sitemap\";b:0;s:42:\"taxonomies-portfolio_skills-not_in_sitemap\";b:0;s:40:\"taxonomies-portfolio_tags-not_in_sitemap\";b:0;s:38:\"taxonomies-faq_category-not_in_sitemap\";b:0;s:47:\"taxonomies-themefusion_es_groups-not_in_sitemap\";b:0;}", "yes");
INSERT INTO `bupg_options` VALUES("558", "revslider-update-check-short", "1447732035", "yes");
INSERT INTO `bupg_options` VALUES("559", "revslider-valid-notice", "false", "yes");
INSERT INTO `bupg_options` VALUES("566", "duplicator_version_plugin", "0.5.34", "yes");
INSERT INTO `bupg_options` VALUES("569", "duplicator_settings", "a:10:{s:7:\"version\";s:6:\"0.5.34\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:0;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:20:\"storage_htaccess_off\";b:0;}", "yes");
INSERT INTO `bupg_options` VALUES("570", "_transient_random_seed", "6b88aae711c925572dcd2695fe4b71ee", "yes");
INSERT INTO `bupg_options` VALUES("576", "_site_transient_timeout_browser_52fcc5c9bb837e35bcdb6a6f0af6ef5e", "1433639249", "yes");
INSERT INTO `bupg_options` VALUES("577", "_site_transient_browser_52fcc5c9bb837e35bcdb6a6f0af6ef5e", "a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"43.0.2357.81\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO `bupg_options` VALUES("589", "duplicator_ui_view_state", "a:6:{s:27:\"dup-settings-diag-srv-panel\";s:1:\"1\";s:28:\"dup-settings-diag-opts-panel\";s:1:\"1\";s:14:\"dup-wpnotice01\";b:1;s:22:\"dup-pack-storage-panel\";s:1:\"1\";s:22:\"dup-pack-archive-panel\";s:1:\"1\";s:24:\"dup-pack-installer-panel\";s:1:\"0\";}", "yes");
INSERT INTO `bupg_options` VALUES("624", "revslider-latest-version", "5.1.3", "yes");
INSERT INTO `bupg_options` VALUES("679", "_site_transient_timeout_browser_c917cbcbdbc2b619466b4aeb270ad980", "1434474482", "yes");
INSERT INTO `bupg_options` VALUES("680", "_site_transient_browser_c917cbcbdbc2b619466b4aeb270ad980", "a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"36.0\";s:10:\"update_url\";s:23:\"http://www.firefox.com/\";s:7:\"img_src\";s:50:\"http://s.wordpress.org/images/browsers/firefox.png\";s:11:\"img_src_ssl\";s:49:\"https://wordpress.org/images/browsers/firefox.png\";s:15:\"current_version\";s:2:\"16\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO `bupg_options` VALUES("762", "WPLANG", "", "yes");
INSERT INTO `bupg_options` VALUES("771", "duplicator_package_active", "O:11:\"DUP_Package\":16:{s:2:\"ID\";N;s:4:\"Name\";s:25:\"20151117new_birminghamupg\";s:4:\"Hash\";s:29:\"564b3622dcb341940151117141354\";s:8:\"NameHash\";s:55:\"20151117new_birminghamupg_564b3622dcb341940151117141354\";s:7:\"Version\";s:6:\"0.5.34\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:70:\"/hsphere/local/home/dunamis/birminghamupg.com/bhamupg/wp-snapshots/tmp\";s:8:\"StoreURL\";s:46:\"http://birminghamupg.com/bhamupg/wp-snapshots/\";s:8:\"ScanFile\";s:65:\"20151117new_birminghamupg_564b3622dcb341940151117141354_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:53:\"/hsphere/local/home/dunamis/birminghamupg.com/bhamupg\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":16:{s:2:\"ID\";N;s:4:\"Name\";s:25:\"20151117new_birminghamupg\";s:4:\"Hash\";s:29:\"564b3622dcb341940151117141354\";s:8:\"NameHash\";s:55:\"20151117new_birminghamupg_564b3622dcb341940151117141354\";s:7:\"Version\";s:6:\"0.5.34\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:70:\"/hsphere/local/home/dunamis/birminghamupg.com/bhamupg/wp-snapshots/tmp\";s:8:\"StoreURL\";s:46:\"http://birminghamupg.com/bhamupg/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:7:\"Archive\";r:15;s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:45;}s:8:\"Database\";O:12:\"DUP_Database\":11:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"\0*\0Package\";r:45;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}}s:9:\"Installer\";r:60;s:8:\"Database\";r:73;}", "yes");
INSERT INTO `bupg_options` VALUES("812", "_site_transient_timeout_browser_d8b823361163f6c113da8d7fe620aea0", "1436140531", "yes");
INSERT INTO `bupg_options` VALUES("813", "_site_transient_browser_d8b823361163f6c113da8d7fe620aea0", "a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"43.0.2357.130\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO `bupg_options` VALUES("875", "_site_transient_timeout_browser_83271fd20a6687ffcd0d1b6f7ad13cdd", "1436374425", "yes");
INSERT INTO `bupg_options` VALUES("876", "_site_transient_browser_83271fd20a6687ffcd0d1b6f7ad13cdd", "a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"38.0\";s:10:\"update_url\";s:23:\"http://www.firefox.com/\";s:7:\"img_src\";s:50:\"http://s.wordpress.org/images/browsers/firefox.png\";s:11:\"img_src_ssl\";s:49:\"https://wordpress.org/images/browsers/firefox.png\";s:15:\"current_version\";s:2:\"16\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO `bupg_options` VALUES("933", "_site_transient_timeout_available_translations", "1435854049", "yes");
INSERT INTO `bupg_options` VALUES("934", "_site_transient_available_translations", "a:55:{s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-04-21 15:46:45\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.5/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 14:15:41\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.5/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 14:19:26\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:22:\"Продължение\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 14:22:49\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-04-22 06:13:16\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.5/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 14:30:22\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.5/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 14:32:23\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Forts&#230;t\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 14:34:24\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 14:38:25\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-04-15 12:48:44\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.5/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 14:44:26\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 14:42:35\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 14:46:15\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 14:48:12\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.5/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 14:50:12\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/es_ES.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"es\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-04-24 16:07:13\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/es_MX.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 14:56:31\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/es_PE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:3:\"4.0\";s:7:\"updated\";s:19:\"2014-09-04 19:47:01\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.0/es_CL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-27 08:55:29\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.5/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 15:03:17\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-04-21 06:21:33\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.5/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-04-29 17:21:23\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:3:\"4.0\";s:7:\"updated\";s:19:\"2014-09-05 17:37:43\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/4.0/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 15:14:57\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 15:20:27\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1.5/haz.zip\";s:3:\"iso\";a:2:{i:1;s:3:\"haz\";i:2;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-04-08 22:28:26\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"להמשיך\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 15:25:25\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.5/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 15:27:28\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Tovább\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 15:29:34\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-04-22 13:36:50\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 15:33:39\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 15:35:42\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.5/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"続ける\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-04-20 11:48:55\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 15:47:56\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 15:57:42\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ေဆာင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 15:59:41\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 16:02:30\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-04-16 06:38:46\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 16:07:08\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-29 22:19:48\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.5/ps.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ps\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"دوام\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 16:11:07\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 16:14:41\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-27 14:48:56\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 16:19:48\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 16:23:44\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 16:25:46\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Nadaljujte\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-04-20 08:33:09\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.5/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 16:30:35\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-04-23 20:21:44\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-27 00:00:51\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.5/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 16:43:10\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 16:45:38\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:9:\"Uyƣurqə\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-04-10 12:55:55\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.5/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"4.1.5\";s:7:\"updated\";s:19:\"2015-03-26 16:55:15\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.5/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"4.1.4\";s:7:\"updated\";s:19:\"2015-04-23 15:23:08\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.4/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}}", "yes");
INSERT INTO `bupg_options` VALUES("972", "_transient_wpseo_sitemap_cache_post_tag_1", "<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>http://birminghamupg.com/tag/artwork/</loc>\n		<lastmod>2012-07-31T17:25:18+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/tag/photo/</loc>\n		<lastmod>2012-07-31T17:25:18+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/tag/video/</loc>\n		<lastmod>2012-07-31T17:26:20+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/tag/videos/</loc>\n		<lastmod>2012-07-31T17:25:18+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n</urlset>", "no");
INSERT INTO `bupg_options` VALUES("1010", "rewrite_rules", "a:164:{s:19:\"sitemap_index\\.xml$\";s:19:\"index.php?sitemap=1\";s:31:\"([^/]+?)-sitemap([0-9]+)?\\.xml$\";s:51:\"index.php?sitemap=$matches[1]&sitemap_n=$matches[2]\";s:24:\"([a-z]+)?-?sitemap\\.xsl$\";s:25:\"index.php?xsl=$matches[1]\";s:18:\"portfolio-items/?$\";s:35:\"index.php?post_type=avada_portfolio\";s:48:\"portfolio-items/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?post_type=avada_portfolio&feed=$matches[1]\";s:43:\"portfolio-items/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?post_type=avada_portfolio&feed=$matches[1]\";s:35:\"portfolio-items/page/([0-9]{1,})/?$\";s:53:\"index.php?post_type=avada_portfolio&paged=$matches[1]\";s:12:\"faq-items/?$\";s:29:\"index.php?post_type=avada_faq\";s:42:\"faq-items/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=avada_faq&feed=$matches[1]\";s:37:\"faq-items/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=avada_faq&feed=$matches[1]\";s:29:\"faq-items/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=avada_faq&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:33:\"slide/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"slide/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"slide/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"slide/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"slide/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:26:\"slide/([^/]+)/trackback/?$\";s:32:\"index.php?slide=$matches[1]&tb=1\";s:34:\"slide/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?slide=$matches[1]&paged=$matches[2]\";s:41:\"slide/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?slide=$matches[1]&cpage=$matches[2]\";s:26:\"slide/([^/]+)(/[0-9]+)?/?$\";s:44:\"index.php?slide=$matches[1]&page=$matches[2]\";s:22:\"slide/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"slide/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"slide/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"slide/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"slide/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"slide-page/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?slide-page=$matches[1]&feed=$matches[2]\";s:46:\"slide-page/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?slide-page=$matches[1]&feed=$matches[2]\";s:39:\"slide-page/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?slide-page=$matches[1]&paged=$matches[2]\";s:21:\"slide-page/([^/]+)/?$\";s:32:\"index.php?slide-page=$matches[1]\";s:43:\"portfolio-items/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"portfolio-items/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"portfolio-items/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"portfolio-items/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"portfolio-items/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"portfolio-items/([^/]+)/trackback/?$\";s:42:\"index.php?avada_portfolio=$matches[1]&tb=1\";s:56:\"portfolio-items/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?avada_portfolio=$matches[1]&feed=$matches[2]\";s:51:\"portfolio-items/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?avada_portfolio=$matches[1]&feed=$matches[2]\";s:44:\"portfolio-items/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?avada_portfolio=$matches[1]&paged=$matches[2]\";s:51:\"portfolio-items/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?avada_portfolio=$matches[1]&cpage=$matches[2]\";s:36:\"portfolio-items/([^/]+)(/[0-9]+)?/?$\";s:54:\"index.php?avada_portfolio=$matches[1]&page=$matches[2]\";s:32:\"portfolio-items/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"portfolio-items/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"portfolio-items/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"portfolio-items/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"portfolio-items/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:59:\"portfolio_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:54:\"portfolio_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:47:\"portfolio_category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?portfolio_category=$matches[1]&paged=$matches[2]\";s:29:\"portfolio_category/([^/]+)/?$\";s:40:\"index.php?portfolio_category=$matches[1]\";s:57:\"portfolio_skills/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?portfolio_skills=$matches[1]&feed=$matches[2]\";s:52:\"portfolio_skills/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?portfolio_skills=$matches[1]&feed=$matches[2]\";s:45:\"portfolio_skills/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?portfolio_skills=$matches[1]&paged=$matches[2]\";s:27:\"portfolio_skills/([^/]+)/?$\";s:38:\"index.php?portfolio_skills=$matches[1]\";s:55:\"portfolio_tags/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?portfolio_tags=$matches[1]&feed=$matches[2]\";s:50:\"portfolio_tags/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?portfolio_tags=$matches[1]&feed=$matches[2]\";s:43:\"portfolio_tags/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?portfolio_tags=$matches[1]&paged=$matches[2]\";s:25:\"portfolio_tags/([^/]+)/?$\";s:36:\"index.php?portfolio_tags=$matches[1]\";s:37:\"faq-items/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"faq-items/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"faq-items/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"faq-items/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"faq-items/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"faq-items/([^/]+)/trackback/?$\";s:36:\"index.php?avada_faq=$matches[1]&tb=1\";s:50:\"faq-items/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?avada_faq=$matches[1]&feed=$matches[2]\";s:45:\"faq-items/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?avada_faq=$matches[1]&feed=$matches[2]\";s:38:\"faq-items/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?avada_faq=$matches[1]&paged=$matches[2]\";s:45:\"faq-items/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?avada_faq=$matches[1]&cpage=$matches[2]\";s:30:\"faq-items/([^/]+)(/[0-9]+)?/?$\";s:48:\"index.php?avada_faq=$matches[1]&page=$matches[2]\";s:26:\"faq-items/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"faq-items/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"faq-items/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"faq-items/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"faq-items/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"faq_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?faq_category=$matches[1]&feed=$matches[2]\";s:48:\"faq_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?faq_category=$matches[1]&feed=$matches[2]\";s:41:\"faq_category/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?faq_category=$matches[1]&paged=$matches[2]\";s:23:\"faq_category/([^/]+)/?$\";s:34:\"index.php?faq_category=$matches[1]\";s:41:\"elastic-slide/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"elastic-slide/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"elastic-slide/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"elastic-slide/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"elastic-slide/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"elastic-slide/([^/]+)/trackback/?$\";s:46:\"index.php?themefusion_elastic=$matches[1]&tb=1\";s:42:\"elastic-slide/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?themefusion_elastic=$matches[1]&paged=$matches[2]\";s:49:\"elastic-slide/([^/]+)/comment-page-([0-9]{1,})/?$\";s:59:\"index.php?themefusion_elastic=$matches[1]&cpage=$matches[2]\";s:34:\"elastic-slide/([^/]+)(/[0-9]+)?/?$\";s:58:\"index.php?themefusion_elastic=$matches[1]&page=$matches[2]\";s:30:\"elastic-slide/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"elastic-slide/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"elastic-slide/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"elastic-slide/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"elastic-slide/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:62:\"themefusion_es_groups/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:60:\"index.php?themefusion_es_groups=$matches[1]&feed=$matches[2]\";s:57:\"themefusion_es_groups/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:60:\"index.php?themefusion_es_groups=$matches[1]&feed=$matches[2]\";s:50:\"themefusion_es_groups/([^/]+)/page/?([0-9]{1,})/?$\";s:61:\"index.php?themefusion_es_groups=$matches[1]&paged=$matches[2]\";s:32:\"themefusion_es_groups/([^/]+)/?$\";s:43:\"index.php?themefusion_es_groups=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:42:\"index.php?&page_id=10995&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:20:\"(.?.+?)(/[0-9]+)?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:20:\"([^/]+)(/[0-9]+)?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";}", "yes");
INSERT INTO `bupg_options` VALUES("2922", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:3:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:7:\"upgrade\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.3.1.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.3.1.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.3.1-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.3.1-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.3.1\";s:7:\"version\";s:5:\"4.3.1\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.1\";s:15:\"partial_version\";s:0:\"\";}i:1;O:8:\"stdClass\":12:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.3.1.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.3.1.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.3.1-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.3.1-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.3.1\";s:7:\"version\";s:5:\"4.3.1\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.1\";s:15:\"partial_version\";s:0:\"\";s:13:\"support_email\";s:26:\"updatehelp42@wordpress.org\";s:9:\"new_files\";s:1:\"1\";}i:2;O:8:\"stdClass\":12:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.2.5.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.2.5.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.2.5-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.2.5-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.2.5\";s:7:\"version\";s:5:\"4.2.5\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.1\";s:15:\"partial_version\";s:0:\"\";s:13:\"support_email\";s:26:\"updatehelp42@wordpress.org\";s:9:\"new_files\";s:1:\"1\";}}s:12:\"last_checked\";i:1447769409;s:15:\"version_checked\";s:5:\"4.1.8\";s:12:\"translations\";a:0:{}}", "yes");
INSERT INTO `bupg_options` VALUES("4386", "_transient_timeout_wpseo_sitemap_cache_category_1", "1446920626", "no");
INSERT INTO `bupg_options` VALUES("4387", "_transient_wpseo_sitemap_cache_category_1", "<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>http://birminghamupg.com/category/creative/</loc>\n		<lastmod>2012-07-31T17:25:18+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/category/design/</loc>\n		<lastmod>2012-07-31T17:26:20+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.4</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/category/uncategorized/</loc>\n		<lastmod>2015-04-04T03:05:05+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/category/videos/</loc>\n		<lastmod>2012-07-31T17:24:55+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n</urlset>", "no");
INSERT INTO `bupg_options` VALUES("4465", "_transient_timeout_wpseo_sitemap_cache_portfolio_skills_1", "1447143121", "no");
INSERT INTO `bupg_options` VALUES("4466", "_transient_wpseo_sitemap_cache_portfolio_skills_1", "<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>http://birminghamupg.com/portfolio_skills/htmlcss/</loc>\n		<lastmod>2012-07-31T17:00:15+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.4</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/portfolio_skills/logo-design/</loc>\n		<lastmod>2012-07-31T16:43:55+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/portfolio_skills/web-development/</loc>\n		<lastmod>2012-07-31T16:53:51+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n</urlset>", "no");
INSERT INTO `bupg_options` VALUES("4467", "_transient_timeout_wpseo_sitemap_cache_portfolio_category_1", "1447166159", "no");
INSERT INTO `bupg_options` VALUES("4468", "_transient_wpseo_sitemap_cache_portfolio_category_1", "<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>http://birminghamupg.com/portfolio_category/cat1/</loc>\n		<lastmod>2012-07-31T17:00:15+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.4</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/portfolio_category/cat2/</loc>\n		<lastmod>2012-07-31T17:00:15+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.4</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/portfolio_category/cat3/</loc>\n		<lastmod>2012-07-31T16:54:02+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.4</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/portfolio_category/cat4/</loc>\n		<lastmod>2012-07-31T16:53:51+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/portfolio_category/cat-5/</loc>\n		<lastmod>2012-07-31T17:00:15+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n</urlset>", "no");
INSERT INTO `bupg_options` VALUES("4540", "_transient_timeout_wpseo_sitemap_cache_1_1", "1447397538", "no");
INSERT INTO `bupg_options` VALUES("4541", "_transient_wpseo_sitemap_cache_1_1", "<sitemapindex xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n<sitemap>\n<loc>http://birminghamupg.com/post-sitemap.xml</loc>\n<lastmod>2015-04-04T03:05:05+00:00</lastmod>\n</sitemap>\n<sitemap>\n<loc>http://birminghamupg.com/page-sitemap.xml</loc>\n<lastmod>2015-10-24T16:17:11+00:00</lastmod>\n</sitemap>\n<sitemap>\n<loc>http://birminghamupg.com/slide-sitemap.xml</loc>\n<lastmod>2014-11-19T15:56:43+00:00</lastmod>\n</sitemap>\n<sitemap>\n<loc>http://birminghamupg.com/avada_portfolio-sitemap.xml</loc>\n<lastmod>2012-07-31T17:00:15+00:00</lastmod>\n</sitemap>\n<sitemap>\n<loc>http://birminghamupg.com/avada_faq-sitemap.xml</loc>\n<lastmod>2012-11-27T14:44:54+00:00</lastmod>\n</sitemap>\n<sitemap>\n<loc>http://birminghamupg.com/themefusion_elastic-sitemap.xml</loc>\n<lastmod>2013-10-14T18:34:03+00:00</lastmod>\n</sitemap>\n<sitemap>\n<loc>http://birminghamupg.com/category-sitemap.xml</loc>\n<lastmod>2015-04-04T03:05:05+00:00</lastmod>\n</sitemap>\n<sitemap>\n<loc>http://birminghamupg.com/slide-page-sitemap.xml</loc>\n<lastmod>2014-11-19T15:56:43+00:00</lastmod>\n</sitemap>\n<sitemap>\n<loc>http://birminghamupg.com/portfolio_category-sitemap.xml</loc>\n<lastmod>2012-07-31T17:00:15+00:00</lastmod>\n</sitemap>\n<sitemap>\n<loc>http://birminghamupg.com/portfolio_skills-sitemap.xml</loc>\n<lastmod>2012-07-31T17:00:15+00:00</lastmod>\n</sitemap>\n<sitemap>\n<loc>http://birminghamupg.com/portfolio_tags-sitemap.xml</loc>\n<lastmod>2012-07-31T17:00:15+00:00</lastmod>\n</sitemap>\n<sitemap>\n<loc>http://birminghamupg.com/faq_category-sitemap.xml</loc>\n<lastmod>2012-11-27T14:44:54+00:00</lastmod>\n</sitemap>\n<sitemap>\n<loc>http://birminghamupg.com/themefusion_es_groups-sitemap.xml</loc>\n<lastmod>2013-10-14T18:34:03+00:00</lastmod>\n</sitemap>\n</sitemapindex>", "no");
INSERT INTO `bupg_options` VALUES("4561", "_transient_timeout_wpseo_sitemap_cache_slide-page_1", "1447453961", "no");
INSERT INTO `bupg_options` VALUES("4562", "_transient_wpseo_sitemap_cache_slide-page_1", "<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>http://birminghamupg.com/slide-page/final_fixed_width/</loc>\n		<lastmod>2014-05-29T21:15:39+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/slide-page/final_full_screen/</loc>\n		<lastmod>2014-05-29T00:44:03+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/slide-page/final_full_width/</loc>\n		<lastmod>2014-05-28T20:28:56+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/slide-page/avada-home/</loc>\n		<lastmod>2014-11-19T15:56:43+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/slide-page/avada_small/</loc>\n		<lastmod>2014-06-02T14:27:54+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n</urlset>", "no");
INSERT INTO `bupg_options` VALUES("4563", "_transient_timeout_wpseo_sitemap_cache_themefusion_elastic_1", "1447457877", "no");
INSERT INTO `bupg_options` VALUES("4564", "_transient_wpseo_sitemap_cache_themefusion_elastic_1", "<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>http://birminghamupg.com/elastic-slide/slide-1/</loc>\n		<lastmod>2013-10-14T18:33:43+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/elastic-slide/slide-2/</loc>\n		<lastmod>2013-10-14T18:34:03+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n</urlset>", "no");
INSERT INTO `bupg_options` VALUES("4565", "_transient_timeout_wpseo_sitemap_cache_avada_faq_1", "1447462424", "no");
INSERT INTO `bupg_options` VALUES("4566", "_transient_wpseo_sitemap_cache_avada_faq_1", "<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>http://birminghamupg.com/faq-items/</loc>\n		<lastmod>2012-11-27T14:44:54+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/faq-items/class-aptent-taciti-sociosqu-ad-litora-torquent-per-conubia-nostra-pers/</loc>\n		<lastmod>2012-11-27T14:42:55+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/faq-items/fusce-nisi-augue-malesuada-in-commodo-quis-euismod-quis-orci-integer-vitae-nisl-non/</loc>\n		<lastmod>2012-11-27T14:43:24+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>http://birminghamupg.com/bhamupg_base/wp-content/uploads/2012/07/blog_5-300x171.jpg</image:loc>\n			<image:caption><![CDATA[blog 5]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/faq-items/integer-vitae-nisl-non-augue-ullamcorper-blandit-donec-vitae-nibh-ipsums/</loc>\n		<lastmod>2012-11-27T14:43:43+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/faq-items/vivamus-ullamcorper-nim-sit-amet-consequat-laoreet-tortor-tortor-dictum-egestas-urna/</loc>\n		<lastmod>2012-11-27T14:44:05+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>http://birminghamupg.com/bhamupg_base/wp-content/uploads/2012/07/blog_5-300x171.jpg</image:loc>\n			<image:caption><![CDATA[blog 5]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/faq-items/fusce-nisi-malesuada-in-commodo-quis-euismod-quis-orci-onteger-vitae-nisl-non-augue-ullamcorpers/</loc>\n		<lastmod>2012-11-27T14:44:31+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/faq-items/curabitur-eget-leo-at-velit-imperdiet-varius-eu-ipsum-vitae-velit-congue-iaculis-vitaes/</loc>\n		<lastmod>2012-11-27T14:44:54+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>http://birminghamupg.com/bhamupg_base/wp-content/uploads/2012/07/blog_5-300x171.jpg</image:loc>\n			<image:caption><![CDATA[blog 5]]></image:caption>\n		</image:image>\n	</url>\n</urlset>", "no");
INSERT INTO `bupg_options` VALUES("4615", "_transient_wpseo_sitemap_cache_post_1", "<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>http://birminghamupg.com/hello-world/</loc>\n		<lastmod>2015-04-04T03:05:05+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/class-aptent-taciti-sociosqu-ad-litora/</loc>\n		<lastmod>2012-07-31T17:24:55+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/nunc-tincidunt-elit-non-cursus/</loc>\n		<lastmod>2012-07-31T17:22:22+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/proin-sodales-quam-nec-ante-sollicits/</loc>\n		<lastmod>2012-07-31T17:23:05+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/nullam-vitae-nibh-un-odio/</loc>\n		<lastmod>2012-07-31T17:23:43+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/praesent-et-urna-turpis-sadips/</loc>\n		<lastmod>2012-07-31T17:26:20+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/donec-at-mauris-enim-duis-nisi-tellus/</loc>\n		<lastmod>2012-07-31T17:25:18+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n</urlset>", "no");
INSERT INTO `bupg_options` VALUES("4623", "_transient_timeout_wpseo_sitemap_cache_page_1", "1447630926", "no");
INSERT INTO `bupg_options` VALUES("4624", "_transient_wpseo_sitemap_cache_page_1", "<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>http://birminghamupg.com/contact/</loc>\n		<lastmod>2015-05-29T02:48:10+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n		<image:image>\n			<image:loc>http://birminghamupg.com/bhamupg/wp-content/uploads/2015/05/Mexican20345046_ml-300x199.jpg</image:loc>\n			<image:caption><![CDATA[Mexican20345046 ml]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/</loc>\n		<lastmod>2015-10-24T16:17:11+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>1</priority>\n		<image:image>\n			<image:loc>http://birminghamupg.com/bhamupg/wp-content/uploads/2015/06/engage_DiscoverWelcomeEngage3v400x36.png</image:loc>\n			<image:caption><![CDATA[engage DiscoverWelcomeEngage3v400x36]]></image:caption>\n		</image:image>\n		<image:image>\n			<image:loc>http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/Guatemalan24651726_ml-300x200.jpg</image:loc>\n			<image:caption><![CDATA[PEOPLE GROUP is a ethno linguistic group with a common self identity]]></image:caption>\n		</image:image>\n		<image:image>\n			<image:loc>http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/Yemeni17378186_ml-300x201.jpg</image:loc>\n			<image:caption><![CDATA[no indigenous community of believing Christians able to engage this people group]]></image:caption>\n		</image:image>\n		<image:image>\n			<image:loc>http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/India-Telugu27371027_ml-300x203.jpg</image:loc>\n			<image:caption><![CDATA[when there is no church planting strategy, consistent with evangelical faith and practice, under way.]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/why/</loc>\n		<lastmod>2015-06-29T01:02:25+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n		<image:image>\n			<image:loc>http://birminghamupg.com/bhamupg/wp-content/uploads/2015/05/Japanese13966032_ml-300x200.jpg</image:loc>\n			<image:caption><![CDATA[Japanese13966032 ml]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/what/</loc>\n		<lastmod>2015-06-20T17:49:41+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n		<image:image>\n			<image:loc>http://birminghamupg.com/bhamupg/wp-content/uploads/2015/05/India-Gujarat13204440_ml-300x211.jpg</image:loc>\n			<image:caption><![CDATA[India Gujarat13204440 ml]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/sowhat/</loc>\n		<lastmod>2015-06-29T01:05:43+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n		<image:image>\n			<image:loc>http://birminghamupg.com/bhamupg/wp-content/uploads/2015/05/African-Ghanaian27599918_ml-300x200.jpg</image:loc>\n			<image:caption><![CDATA[African Ghanaian27599918 ml]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/resources/</loc>\n		<lastmod>2015-06-29T00:08:14+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n		<image:image>\n			<image:loc>http://birminghamupg.com/bhamupg/wp-content/uploads/2015/05/Filipino-Tagalog19179776_ml-200x300.jpg</image:loc>\n			<image:caption><![CDATA[Filipino Tagalog19179776 ml]]></image:caption>\n		</image:image>\n	</url>\n</urlset>", "no");
INSERT INTO `bupg_options` VALUES("4656", "_transient_timeout_wpseo_sitemap_cache_avada_portfolio_1", "1447730114", "no");
INSERT INTO `bupg_options` VALUES("4657", "_transient_wpseo_sitemap_cache_avada_portfolio_1", "<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>http://birminghamupg.com/portfolio-items/</loc>\n		<lastmod>2012-07-31T17:00:15+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/portfolio-items/mauris-fringilla-voluts/</loc>\n		<lastmod>2012-07-31T16:54:02+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/portfolio-items/suspendisse-pharetra-urna/</loc>\n		<lastmod>2012-07-31T16:43:55+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/portfolio-items/curabitur-malesuada-lorem/</loc>\n		<lastmod>2012-07-31T16:44:55+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/portfolio-items/proin-sodales-quam/</loc>\n		<lastmod>2012-07-31T16:53:51+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/portfolio-items/nam-viverra-euismod/</loc>\n		<lastmod>2012-07-31T16:53:09+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/portfolio-items/donec-ornare-turpis-eget/</loc>\n		<lastmod>2012-07-31T17:00:15+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n</urlset>", "no");
INSERT INTO `bupg_options` VALUES("4664", "_transient_timeout_wpseo_sitemap_cache_faq_category_1", "1447752995", "no");
INSERT INTO `bupg_options` VALUES("4665", "_transient_wpseo_sitemap_cache_faq_category_1", "<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>http://birminghamupg.com/faq_category/design-process/</loc>\n		<lastmod>2012-11-27T14:44:05+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/faq_category/misc/</loc>\n		<lastmod>2012-11-27T14:42:55+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/faq_category/pricing/</loc>\n		<lastmod>2012-11-27T14:44:54+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/faq_category/technical/</loc>\n		<lastmod>2012-11-27T14:44:31+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n</urlset>", "no");
INSERT INTO `bupg_options` VALUES("4666", "_transient_timeout_wpseo_sitemap_cache_themefusion_es_groups_1", "1447753918", "no");
INSERT INTO `bupg_options` VALUES("4667", "_transient_wpseo_sitemap_cache_themefusion_es_groups_1", "<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>http://birminghamupg.com/themefusion_es_groups/group1/</loc>\n		<lastmod>2013-10-14T18:34:03+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.2</priority>\n	</url>\n</urlset>", "no");
INSERT INTO `bupg_options` VALUES("4688", "_site_transient_timeout_browser_f17158549169c0110ce3122bf897ae75", "1448340435", "yes");
INSERT INTO `bupg_options` VALUES("4689", "_site_transient_browser_f17158549169c0110ce3122bf897ae75", "a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"41.0\";s:10:\"update_url\";s:23:\"http://www.firefox.com/\";s:7:\"img_src\";s:50:\"http://s.wordpress.org/images/browsers/firefox.png\";s:11:\"img_src_ssl\";s:49:\"https://wordpress.org/images/browsers/firefox.png\";s:15:\"current_version\";s:2:\"16\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO `bupg_options` VALUES("4690", "_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1447778840", "no");
INSERT INTO `bupg_options` VALUES("4691", "_transient_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 Nov 2015 00:04:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=4.4-beta4-35652\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.4 Beta 4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2015/11/wordpress-4-4-beta-4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 Nov 2015 00:04:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=3977\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:337:\"WordPress 4.4 Beta 4 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.4, try the WordPress Beta Tester plugin (you’ll want &#8220;bleeding edge nightlies&#8221;). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Scott Taylor\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1407:\"<p>WordPress 4.4 Beta 4 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.4, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want &#8220;bleeding edge nightlies&#8221;). Or you can <a href=\"https://wordpress.org/wordpress-4.4-beta4.zip\">download the beta here</a> (zip).</p>\n<p>For more information about what’s new in version 4.4, check out the <a href=\"https://wordpress.org/news/2015/10/wordpress-4-4-beta-1/\" target=\"_blank\">Beta 1</a> blog post. This our final planned beta. Next week will be our first Release Candidate.</p>\n<p>If you think you’ve found a bug, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. Or, if you’re comfortable writing a bug report, <a href=\"https://core.trac.wordpress.org/\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a> and <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;group=component&amp;milestone=4.4\">everything we’ve fixed</a>.</p>\n<p><em>Closer To The End</em><br />\n<em>Tickets Are Being Shuffled</em><br />\n<i>Onward to RC</i></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.4 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2015/11/wordpress-4-4-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 04 Nov 2015 22:10:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=3969\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:374:\"WordPress 4.4 Beta 3 is now available for download and testing. This is software still in development, so we don’t recommend that you run it on a production site. To get the beta, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can download the beta here (zip). For more of what’s new in version 4.4, check out [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Scott Taylor\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1245:\"<p>WordPress 4.4 Beta 3 is now available for download and testing. This is software still in development, so we don’t recommend that you run it on a production site. To get the beta, try the <a href=\"https://wordpress.org/extend/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.4-beta3.zip\">download the beta here</a> (zip).</p>\n<p>For more of what’s new in version 4.4, <a href=\"https://wordpress.org/news/2015/10/wordpress-4-4-beta-1/\" target=\"_blank\">check out the Beta 1 blog post</a>.</p>\n<p>If you think you’ve found a bug, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. Or, if you’re comfortable writing a bug report, <a href=\"https://core.trac.wordpress.org/\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a> and <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;group=component&amp;milestone=4.4\">everything we’ve fixed</a>.</p>\n<p><em>Four-four beta three<br />\nEven more activity<br />\nNary a shared term</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.4 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2015/10/wordpress-4-4-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 28 Oct 2015 20:50:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=3966\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:374:\"WordPress 4.4 Beta 2 is now available for download and testing. This is software still in development, so we don’t recommend that you run it on a production site. To get the beta, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can download the beta here (zip). For more of what’s new in version 4.4, check out [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Scott Taylor\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1246:\"<p>WordPress 4.4 Beta 2 is now available for download and testing. This is software still in development, so we don’t recommend that you run it on a production site. To get the beta, try the <a href=\"https://wordpress.org/extend/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.4-beta2.zip\">download the beta here</a> (zip).</p>\n<p>For more of what’s new in version 4.4, <a href=\"https://wordpress.org/news/2015/10/wordpress-4-4-beta-1/\" target=\"_blank\">check out the Beta 1 blog post</a>.</p>\n<p>If you think you’ve found a bug, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. Or, if you’re comfortable writing a bug report, <a href=\"https://core.trac.wordpress.org/\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a> and <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;group=component&amp;milestone=4.4\">everything we’ve fixed</a>.</p>\n<p><em>Four-four beta two<br />\nAnother week of progress<br />\nREST API lives!</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.4 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2015/10/wordpress-4-4-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 Oct 2015 23:54:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=3926\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.4 Beta 1 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.4, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Scott Taylor\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4293:\"<p>WordPress 4.4 Beta 1 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.4, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.4-beta1.zip\" target=\"_blank\">download the beta here</a> (zip).</p>\n<p>WordPress 4.4 is slated for release on <a href=\"https://make.wordpress.org/core/version-4-4-project-schedule/\" target=\"_blank\">December 8</a>, but to get there, we need your help testing what we have been working on, including:</p>\n<ul>\n<li><strong>Twenty Sixteen </strong>— The <a href=\"https://make.wordpress.org/core/2015/08/25/introducing-twenty-sixteen/\">newest</a> default theme for WordPress.</li>\n<li><strong>Responsive Images </strong>— WordPress automatically delivers a <a href=\"https://make.wordpress.org/core/2015/09/30/responsive-images-merge-proposal/\">more appropriate image</a> to users depending on a variety of conditions like screen size, viewport size, and screen resolution.</li>\n<li><strong>Embeds </strong>— WordPress can now embed rich content from nearly all sites that support the oEmbed standard — not just YouTube, Flickr, Twitter, and the like. You can even embed <a href=\"https://make.wordpress.org/core/2015/09/30/feature-plugin-merge-proposal-oembed/\">previews of posts</a> from other WordPress sites by pasting the URL on its own line.</li>\n</ul>\n<p>There have been a lot of changes for developers to play with as well:</p>\n<ul>\n<li><strong>REST API (phase 1) </strong>— The underlying infrastructure of the WordPress REST API <a href=\"https://wordpress.org/plugins/rest-api/\">plugin</a> has been <a href=\"https://make.wordpress.org/core/2015/09/21/wp-rest-api-merge-proposal/\">included in WordPress 4.4</a>. Plugin authors can take advantage of this by adding custom endpoints.</li>\n<li><strong>Term Metadata </strong>— Taxonomy term metadata is <a href=\"https://make.wordpress.org/core/2015/09/04/taxonomy-term-metadata-proposal/\">now included</a> in WordPress 4.4. If you&#8217;ve already been using a plugin to implement term metadata, you should read <a href=\"https://make.wordpress.org/core/2015/09/22/preparing-your-plugins-and-your-client-sites-for-termmeta/\">this post</a> on how to prepare. Also, the underlying <code>WP_Term</code> class improves caching when working with terms. (<a href=\"https://core.trac.wordpress.org/ticket/14162\">#14162</a>)</li>\n<li><strong>Improved <code>&lt;title&gt;</code> output</strong> — <code>wp_title()</code> is now deprecated; WordPress can <a href=\"https://make.wordpress.org/core/2015/10/20/document-title-in-4-4/\">handle the rendering</a> of the document title automatically.</li>\n<li><strong>Comments </strong>— Comment queries are now split for performance. Also, the underlying <code>WP_Comment</code> class improves caching and introduces strong-typing. (<a href=\"https://core.trac.wordpress.org/ticket/8071\">#8071</a>, <a href=\"https://core.trac.wordpress.org/ticket/32619\">#32619</a>)</li>\n</ul>\n<p>If you want a more in-depth view of what major changes have made it into 4.4, <a href=\"https://make.wordpress.org/core/tag/4-4/\" target=\"_blank\">check out all 4.4-tagged posts</a> on the main development blog, or check out a <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;group=component&amp;milestone=4.4\">list of everything</a> that&#8217;s changed.</p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\" target=\"_blank\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\" target=\"_blank\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\" target=\"_blank\">a list of known bugs</a>.</p>\n<p>Happy testing!</p>\n<p><em>Many small changes</em><br />\n<em>Some groundbreaking new features<br />\nFun times had by all<br />\n</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 4.3.1 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/news/2015/09/wordpress-4-3-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Sep 2015 15:22:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3914\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:439:\"WordPress 4.3.1 is now available. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. This release addresses three issues, including two cross-site scripting vulnerabilities and a potential privilege escalation. WordPress versions 4.3 and earlier are vulnerable to a cross-site scripting vulnerability when processing shortcode tags (CVE-2015-5714). Reported by [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Samuel Sidler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4022:\"<div class=\"storycontent\">\n<p>WordPress 4.3.1 is now available. This is a<strong> security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>This release addresses three issues, including two cross-site scripting vulnerabilities and a potential privilege escalation.</p>\n<ul>\n<li>WordPress versions 4.3 and earlier are vulnerable to a cross-site scripting vulnerability when processing shortcode tags (CVE-2015-5714). Reported by Shahar Tal and Netanel Rubin of <a href=\"http://checkpoint.com/\">Check Point</a>.</li>\n<li>A separate cross-site scripting vulnerability was found in the user list table. Reported by Ben Bidner of the WordPress security team.</li>\n<li>Finally, in certain cases, users without proper permissions could publish private posts and make them sticky (CVE-2015-5715). Reported by Shahar Tal and Netanel Rubin of <a href=\"http://checkpoint.com/\">Check Point</a>.</li>\n</ul>\n<p>Our thanks to those who have practiced <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsible disclosure</a> of security issues.</p>\n<p>WordPress 4.3.1 also fixes twenty-six bugs. For more information, see the <a href=\"https://codex.wordpress.org/Version_4.3.1\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/log/branches/4.3/?rev=34199&amp;stop_rev=33647\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.3.1</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.3.1.</p>\n</div>\n<p>Thanks to everyone who contributed to 4.3.1:</p>\n<p><a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/kraftbj\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/chriscct7\">chriscct7</a>, <a href=\"https://profiles.wordpress.org/extendwings\">Daisuke Takahashi</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/DrewAPicture\">Drew Jaynes</a>, <a href=\"https://profiles.wordpress.org/dustinbolton\">dustinbolton</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/hauvong\">hauvong</a>, <a href=\"https://profiles.wordpress.org/macmanx\">James Huff</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jobst\">jobst</a>, <a href=\"https://profiles.wordpress.org/tyxla\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/celloexpressions\">Nick Halsey</a>, <a href=\"https://profiles.wordpress.org/nikeo\">nikeo</a>, <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/figureone\">Paul Ryan</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/miqrogroove\">Robert Chapin</a>, <a href=\"https://profiles.wordpress.org/otto42\">Samuel Wood</a>, <a href=\"https://profiles.wordpress.org/wonderboymusic\">Scott Taylor</a>, <a href=\"https://profiles.wordpress.org/SergeyBiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/tmatsuur\">tmatsuur</a>, <a href=\"https://profiles.wordpress.org/liljimmi\">Tracy Levesque</a>, <a href=\"https://profiles.wordpress.org/umeshnevase\">Umesh Nevase</a>, <a href=\"https://profiles.wordpress.org/vortfu\">vortfu</a>, <a href=\"https://profiles.wordpress.org/welcher\">welcher</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"WordPress 4.3 “Billie”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"https://wordpress.org/news/2015/08/billie/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 18 Aug 2015 19:12:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"4.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3845\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:352:\"Version 4.3 of WordPress, named &#8220;Billie&#8221; in honor of jazz singer Billie Holiday, is available for download or update in your WordPress dashboard. New features in 4.3 make it even easier to format your content and customize your site. Menus in the Customizer Create your menu, update it, and assign it, all while live-previewing in [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:22531:\"<p style=\"margin: 0;height: 0\"><img src=\"https://wordpress.org/news/files/2015/08/WordPress-4-3-billie-1024x574.png\" alt=\"WordPress 4.3 - &quot;Billie&quot;\" width=\"692\" height=\"388\" class=\"alignnone size-large wp-image-3896\" style=\"height:0px;width: 0px;margin: 0\" srcset=\"https://wordpress.org/news/files/2015/08/WordPress-4-3-billie-300x168.png 300w, https://wordpress.org/news/files/2015/08/WordPress-4-3-billie-1024x574.png 1024w\" sizes=\"(max-width: 692px) 100vw, 692px\" /></p>\n<p>Version 4.3 of WordPress, named &#8220;Billie&#8221; in honor of jazz singer <a href=\"https://en.wikipedia.org/wiki/Billie_Holiday\">Billie Holiday</a>, is available for <a href=\"https://wordpress.org/download/\">download</a> or update in your WordPress dashboard. New features in 4.3 make it even easier to format your content and customize your site.</p>\n<p><iframe width=\'692\' height=\'389\' src=\'https://videopress.com/embed/T54Iy7Tw?hd=1\' frameborder=\'0\' allowfullscreen></iframe><script src=\'https://v0.wordpress.com/js/next/videopress-iframe.js?m=1435166243\'></script></p>\n<hr />\n<h2>Menus in the Customizer</h2>\n<div><img src=\"//s.w.org/images/core/4.3/menu-customizer.png\" alt=\"\" /></div>\n<p>Create your menu, update it, and assign it, all while live-previewing in the customizer. The streamlined customizer design provides a mobile-friendly and accessible interface. With every release, it becomes easier and faster to make your site just the way you want it.</p>\n<hr />\n<h2>Formatting Shortcuts</h2>\n<div style=\"margin-bottom: 0\"><div style=\"width: 640px; \" class=\"wp-video\"><!--[if lt IE 9]><script>document.createElement(\'video\');</script><![endif]-->\n<video class=\"wp-video-shortcode\" id=\"video-3845-1\" width=\"640\" height=\"360\" loop=\"1\" autoplay=\"1\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"//s.w.org/images/core/4.3/formatting.mp4?_=1\" /><source type=\"video/webm\" src=\"//s.w.org/images/core/4.3/formatting.webm?_=1\" /><source type=\"video/ogg\" src=\"//s.w.org/images/core/4.3/formatting.ogv?_=1\" /><a href=\"//s.w.org/images/core/4.3/formatting.mp4\">//s.w.org/images/core/4.3/formatting.mp4</a></video></div></div>\n<p>Your writing flow just got faster with new formatting shortcuts in WordPress 4.3. Use asterisks to create lists and number signs to make a heading. No more breaking your flow; your text looks great with a <code>*</code> and a <code>#</code>.</p>\n<hr />\n<h2>Site Icons</h2>\n<p><img src=\"//s.w.org/images/core/4.3/site-icon-customizer.png\" alt=\"\" /><br />\n&nbsp;<br />\nSite icons represent your site in browser tabs, bookmark menus, and on the home screen of mobile devices. Add your unique site icon in the customizer; it will even stay in place when you switch themes. Make your whole site reflect your brand.</p>\n<hr />\n<h2>Better Passwords</h2>\n<p><img src=\"//s.w.org/images/core/4.3/better-passwords.png\" alt=\"\" /><br />\n&nbsp;<br />\nKeep your site more secure with WordPress’ improved approach to passwords. Instead of receiving passwords via email, you’ll get a password reset link. When you add new users to your site or edit a user profile, WordPress will automatically generate a secure password.</p>\n<hr />\n<h2>Other improvements</h2>\n<ul>\n<li><strong>A smoother admin experience</strong> &#8211; Refinements to the list view across the admin make your WordPress more accessible and easier to work with on any device.</li>\n<li><strong>Comments turned off on pages</strong> &#8211; All new pages that you create will have comments turned off. Keep discussions to your blog, right where they’re supposed to happen.</li>\n<li><strong>Customize your site quickly</strong> &#8211; Wherever you are on the front-end, you can click the customize link in the toolbar to swiftly make changes to your site.</li>\n</ul>\n<hr />\n<h2>The Team</h2>\n<p><a class=\"alignleft\" href=\"https://profiles.wordpress.org/obenland\"><img src=\"https://www.gravatar.com/avatar/2370ea5912750f4cb0f3c51ae1cbca55?d=mm&amp;s=180&amp;r=G\" alt=\"Konstantin Obenland\" width=\"80\" height=\"80\" /></a>This release was led by <a href=\"http://konstantin.obenland.it/\">Konstantin Obenland</a>, with the help of these fine individuals. There are 246 contributors with props in this release. Pull up some Billie Holiday on your music service of choice, and check out some of their profiles:</p>\n<a href=\"https://profiles.wordpress.org/mercime\">@mercime</a>, <a href=\"https://profiles.wordpress.org/aaroncampbell\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/adamkheckler\">Adam Heckler</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/akibjorklund\">Aki Bjorklund</a>, <a href=\"https://profiles.wordpress.org/akirk\">Alex Kirk</a>, <a href=\"https://profiles.wordpress.org/viper007bond\">Alex Mills (Viper007Bond)</a>, <a href=\"https://profiles.wordpress.org/tellyworth\">Alex Shiels</a>, <a href=\"https://profiles.wordpress.org/deconf\">Alin Marcu</a>, <a href=\"https://profiles.wordpress.org/andfinally\">andfinally</a>, <a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/andg\">Andrea Gandino</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/afragen\">Andy Fragen</a>, <a href=\"https://profiles.wordpress.org/ankit-k-gupta\">Ankit K Gupta</a>, <a href=\"https://profiles.wordpress.org/antpb\">Anthony Burchell</a>, <a href=\"https://profiles.wordpress.org/anubisthejackle\">anubisthejackle</a>, <a href=\"https://profiles.wordpress.org/aramzs\">Aram Zucker-Scharff</a>, <a href=\"https://profiles.wordpress.org/arjunskumar\">Arjun S Kumar</a>, <a href=\"https://profiles.wordpress.org/avnarun\">avnarun</a>, <a href=\"https://profiles.wordpress.org/brad2dabone\">Bad Feather</a>, <a href=\"https://profiles.wordpress.org/bcole808\">Ben Cole</a>, <a href=\"https://profiles.wordpress.org/empireoflight\">Ben Dunkle</a>, <a href=\"https://profiles.wordpress.org/binarykitten\">BinaryKitten</a>, <a href=\"https://profiles.wordpress.org/birgire\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bjornjohansen\">Bjorn Johansen</a>, <a href=\"https://profiles.wordpress.org/bolo1988\">bolo1988</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone B. Gorges</a>, <a href=\"https://profiles.wordpress.org/bradt\">Brad Touesnard</a>, <a href=\"https://profiles.wordpress.org/bramd\">Bram Duvigneau</a>, <a href=\"https://profiles.wordpress.org/kraftbj\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/krogsgard\">Brian Krogsgard</a>, <a href=\"https://profiles.wordpress.org/brianlayman\">Brian Layman</a>, <a href=\"https://profiles.wordpress.org/icaleb\">Caleb Burks</a>, <a href=\"https://profiles.wordpress.org/calevans\">CalEvans</a>, <a href=\"https://profiles.wordpress.org/chasewiseman\">Chase Wiseman</a>, <a href=\"https://profiles.wordpress.org/chipbennett\">Chip Bennett</a>, <a href=\"https://profiles.wordpress.org/chouby\">Chouby</a>, <a href=\"https://profiles.wordpress.org/c3mdigital\">Chris Olbekson</a>, <a href=\"https://profiles.wordpress.org/chriscct7\">chriscct7</a>, <a href=\"https://profiles.wordpress.org/craig-ralston\">Craig Ralston</a>, <a href=\"https://profiles.wordpress.org/extendwings\">Daisuke Takahashi</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber\">Daniel Bachhuber</a>, <a href=\"https://profiles.wordpress.org/redsweater\">Daniel Jalkut (Red Sweater)</a>, <a href=\"https://profiles.wordpress.org/mte90\">Daniele Mte90 Scasciafratte</a>, <a href=\"https://profiles.wordpress.org/daniluk4000\">daniluk4000</a>, <a href=\"https://profiles.wordpress.org/dmchale\">Dave McHale</a>, <a href=\"https://profiles.wordpress.org/daveal\">DaveAl</a>, <a href=\"https://profiles.wordpress.org/davidakennedy\">David A. Kennedy</a>, <a href=\"https://profiles.wordpress.org/dlh\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/daxelrod\">daxelrod</a>, <a href=\"https://profiles.wordpress.org/denis-de-bernardy\">Denis de Bernardy</a>, <a href=\"https://profiles.wordpress.org/realloc\">Dennis Ploetner</a>, <a href=\"https://profiles.wordpress.org/valendesigns\">Derek Herman</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/dipeshkakadiya\">dipesh.kakadiya</a>, <a href=\"https://profiles.wordpress.org/dmsnell\">dmsnell</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/drewapicture\">Drew Jaynes</a>, <a href=\"https://profiles.wordpress.org/dustinbolton\">dustinbolton</a>, <a href=\"https://profiles.wordpress.org/kucrut\">Dzikri Aziz</a>, <a href=\"https://profiles.wordpress.org/eclev91\">eclev91</a>, <a href=\"https://profiles.wordpress.org/eligijus\">eligijus</a>, <a href=\"https://profiles.wordpress.org/eliorivero\">Elio Rivero</a>, <a href=\"https://profiles.wordpress.org/iseulde\">Ella Iseulde Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/ericlewis\">Eric Andrew Lewis</a>, <a href=\"https://profiles.wordpress.org/ebinnion\">Eric Binnion</a>, <a href=\"https://profiles.wordpress.org/ericmann\">Eric Mann</a>, <a href=\"https://profiles.wordpress.org/fab1en\">Fabien Quatravaux</a>, <a href=\"https://profiles.wordpress.org/flixos90\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/francoeurdavid\">francoeurdavid</a>, <a href=\"https://profiles.wordpress.org/frank-klein\">Frank Klein</a>, <a href=\"https://profiles.wordpress.org/gabrielperezs\">gabrielperezs</a>, <a href=\"https://profiles.wordpress.org/voldemortensen\">Garth Mortensen</a>, <a href=\"https://profiles.wordpress.org/garyj\">Gary Jones</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/georgestephanis\">George Stephanis</a>, <a href=\"https://profiles.wordpress.org/glennm\">glennm</a>, <a href=\"https://profiles.wordpress.org/gtuk\">gtuk</a>, <a href=\"https://profiles.wordpress.org/hailin\">hailin</a>, <a href=\"https://profiles.wordpress.org/hauvong\">hauvong</a>, <a href=\"https://profiles.wordpress.org/helen\">Helen Hou-Sandí</a>, <a href=\"https://profiles.wordpress.org/henrikakselsen\">henrikakselsen</a>, <a href=\"https://profiles.wordpress.org/hnle\">Hinaloe</a>, <a href=\"https://profiles.wordpress.org/hrishiv90\">Hrishikesh Vaipurkar</a>, <a href=\"https://profiles.wordpress.org/hugobaeta\">Hugo Baeta</a>, <a href=\"https://profiles.wordpress.org/polevaultweb\">Iain Poulson</a>, <a href=\"https://profiles.wordpress.org/imath\">imath</a>, <a href=\"https://profiles.wordpress.org/ipstenu\">Ipstenu (Mika Epstein)</a>, <a href=\"https://profiles.wordpress.org/isaacchapman\">isaacchapman</a>, <a href=\"https://profiles.wordpress.org/izem\">izem</a>, <a href=\"https://profiles.wordpress.org/jdgrimes\">J.D. Grimes</a>, <a href=\"https://profiles.wordpress.org/jacklenox\">Jack Lenox</a>, <a href=\"https://profiles.wordpress.org/jadpm\">jadpm</a>, <a href=\"https://profiles.wordpress.org/macmanx\">James Huff</a>, <a href=\"https://profiles.wordpress.org/jamesgol\">jamesgol</a>, <a href=\"https://profiles.wordpress.org/jancbeck\">jancbeck</a>, <a href=\"https://profiles.wordpress.org/jfarthing84\">Jeff Farthing</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jpry\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/jmichaelward\">Jeremy Ward</a>, <a href=\"https://profiles.wordpress.org/jesin\">Jesin A</a>, <a href=\"https://profiles.wordpress.org/jipmoors\">jipmoors</a>, <a href=\"https://profiles.wordpress.org/eltobiano\">jjberry</a>, <a href=\"https://profiles.wordpress.org/jobst\">Jobst Schmalenbach</a>, <a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joehoyle\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/jkudish\">Joey Kudish</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/picard102\">John Leschinski</a>, <a href=\"https://profiles.wordpress.org/joostdevalk\">Joost de Valk</a>, <a href=\"https://profiles.wordpress.org/maxxsnake\">Josh Davis</a>, <a href=\"https://profiles.wordpress.org/jpyper\">Jpyper</a>, <a href=\"https://profiles.wordpress.org/jrf\">jrf</a>, <a href=\"https://profiles.wordpress.org/juliobox\">Julio Potier</a>, <a href=\"https://profiles.wordpress.org/jtsternberg\">Justin Sternberg</a>, <a href=\"https://profiles.wordpress.org/ungestaltbar\">Kai</a>, <a href=\"https://profiles.wordpress.org/karinchristen\">karinchristen</a>, <a href=\"https://profiles.wordpress.org/karpstrucking\">karpstrucking</a>, <a href=\"https://profiles.wordpress.org/ryelle\">Kelly Dwan</a>, <a href=\"https://profiles.wordpress.org/kevkoeh\">Kevin Koehler</a>, <a href=\"https://profiles.wordpress.org/kitchin\">kitchin</a>, <a href=\"https://profiles.wordpress.org/ixkaito\">Kite</a>, <a href=\"https://profiles.wordpress.org/kovshenin\">Konstantin Kovshenin</a>, <a href=\"https://profiles.wordpress.org/lancewillett\">Lance Willett</a>, <a href=\"https://profiles.wordpress.org/leewillis77\">Lee Willis</a>, <a href=\"https://profiles.wordpress.org/leogopal\">Leo Gopal</a>, <a href=\"https://profiles.wordpress.org/loushou\">loushou</a>, <a href=\"https://profiles.wordpress.org/lumaraf\">Lumaraf</a>, <a href=\"https://profiles.wordpress.org/tyxla\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/nofearinc\">Mario Peshev</a>, <a href=\"https://profiles.wordpress.org/clorith\">Marius (Clorith)</a>, <a href=\"https://profiles.wordpress.org/markjaquith\">Mark Jaquith</a>, <a href=\"https://profiles.wordpress.org/markoheijnen\">Marko Heijnen</a>, <a href=\"https://profiles.wordpress.org/marsjaninzmarsa\">marsjaninzmarsa</a>, <a href=\"https://profiles.wordpress.org/martinsachse\">martinsachse</a>, <a href=\"https://profiles.wordpress.org/matt\">Matt Mullenweg</a>, <a href=\"https://profiles.wordpress.org/veraxus\">Matt van Andel</a>, <a href=\"https://profiles.wordpress.org/mattwiebe\">Matt Wiebe</a>, <a href=\"https://profiles.wordpress.org/mattyrob\">mattyrob</a>, <a href=\"https://profiles.wordpress.org/melchoyce\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/nikonratm\">Michael</a>, <a href=\"https://profiles.wordpress.org/mdawaffe\">Michael Adams (mdawaffe)</a>, <a href=\"https://profiles.wordpress.org/michael-arestad\">Michael Arestad</a>, <a href=\"https://profiles.wordpress.org/michaelryanmcneill\">michaelryanmcneill</a>, <a href=\"https://profiles.wordpress.org/mcguive7\">Mickey Kay</a>, <a href=\"https://profiles.wordpress.org/mihai\">mihai</a>, <a href=\"https://profiles.wordpress.org/mikehansenme\">Mike Hansen</a>, <a href=\"https://profiles.wordpress.org/mnelson4\">Mike Nelson</a>, <a href=\"https://profiles.wordpress.org/dh-shredder\">Mike Schroder</a>, <a href=\"https://profiles.wordpress.org/dimadin\">Milan Dinic</a>, <a href=\"https://profiles.wordpress.org/morganestes\">Morgan Estes</a>, <a href=\"https://profiles.wordpress.org/mrutz\">mrutz</a>, <a href=\"https://profiles.wordpress.org/nabil_kadimi\">nabil_kadimi</a>, <a href=\"https://profiles.wordpress.org/Nao\">Naoko Takano</a>, <a href=\"https://profiles.wordpress.org/nazmulhossainnihal\">Nazmul Hossain Nihal</a>, <a href=\"https://profiles.wordpress.org/nicholas_io\">nicholas_io</a>, <a href=\"https://profiles.wordpress.org/celloexpressions\">Nick Halsey</a>, <a href=\"https://profiles.wordpress.org/nickmomrik\">Nick Momrik</a>, <a href=\"https://profiles.wordpress.org/nikeo\">nikeo</a>, <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a>, <a href=\"https://profiles.wordpress.org/rabmalin\">Nilambar Sharma</a>, <a href=\"https://profiles.wordpress.org/onnimonni\">Onni Hakala</a>, <a href=\"https://profiles.wordpress.org/ozh\">Ozh</a>, <a href=\"https://profiles.wordpress.org/pareshradadiya-1\">Paresh Radadiya</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/djpaul\">Paul Gibbs</a>, <a href=\"https://profiles.wordpress.org/figureone\">Paul Ryan</a>, <a href=\"https://profiles.wordpress.org/paulwilde\">Paul Wilde</a>, <a href=\"https://profiles.wordpress.org/pavelevap\">pavelevap</a>, <a href=\"https://profiles.wordpress.org/gungeekatx\">Pete Nelson</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/peterrknight\">PeterRKnight</a>, <a href=\"https://profiles.wordpress.org/philiparthurmoore\">Philip Arthur Moore</a>, <a href=\"https://profiles.wordpress.org/mordauk\">Pippin Williamson</a>, <a href=\"https://profiles.wordpress.org/posykrat\">posykrat</a>, <a href=\"https://profiles.wordpress.org/pragunbhutani\">pragunbhutani</a>, <a href=\"https://profiles.wordpress.org/rachelbaker\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/ramiy\">Rami Yushuvaev</a>, <a href=\"https://profiles.wordpress.org/rarylson\">rarylson</a>, <a href=\"https://profiles.wordpress.org/lamosty\">Rastislav Lamos</a>, <a href=\"https://profiles.wordpress.org/rauchg\">rauchg</a>, <a href=\"https://profiles.wordpress.org/ravinderk\">Ravinder Kumar</a>, <a href=\"https://profiles.wordpress.org/rclations\">RC Lations</a>, <a href=\"https://profiles.wordpress.org/greuben\">Reuben Gunday</a>, <a href=\"https://profiles.wordpress.org/rianrietveld\">Rian Rietveld</a>, <a href=\"https://profiles.wordpress.org/ritteshpatel\">Ritesh Patel</a>, <a href=\"https://profiles.wordpress.org/miqrogroove\">Robert Chapin</a>, <a href=\"https://profiles.wordpress.org/rdall\">Robert Dall</a>, <a href=\"https://profiles.wordpress.org/rodrigosprimo\">Rodrigo Primo</a>, <a href=\"https://profiles.wordpress.org/rommelxcastro\">Rommel Castro</a>, <a href=\"https://profiles.wordpress.org/magicroundabout\">Ross Wintle</a>, <a href=\"https://profiles.wordpress.org/rhurling\">Rouven Hurling</a>, <a href=\"https://profiles.wordpress.org/ryan\">Ryan Boren</a>, <a href=\"https://profiles.wordpress.org/rmarks\">Ryan Marks</a>, <a href=\"https://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/ohryan\">Ryan Neudorf</a>, <a href=\"https://profiles.wordpress.org/welcher\">Ryan Welcher</a>, <a href=\"https://profiles.wordpress.org/sagarjadhav\">Sagar Jadhav</a>, <a href=\"https://profiles.wordpress.org/salcode\">Sal Ferrarello</a>, <a href=\"https://profiles.wordpress.org/solarissmoke\">Samir Shah</a>, <a href=\"https://profiles.wordpress.org/santagada\">santagada</a>, <a href=\"https://profiles.wordpress.org/sc0ttkclark\">Scott Kingsley Clark</a>, <a href=\"https://profiles.wordpress.org/coffee2code\">Scott Reilly</a>, <a href=\"https://profiles.wordpress.org/wonderboymusic\">Scott Taylor</a>, <a href=\"https://profiles.wordpress.org/scribu\">scribu</a>, <a href=\"https://profiles.wordpress.org/scruffian\">scruffian</a>, <a href=\"https://profiles.wordpress.org/seanchayes\">Sean Hayes</a>, <a href=\"https://profiles.wordpress.org/sebastiantiede\">Sebastian</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/shooper\">Shawn Hooper</a>, <a href=\"https://profiles.wordpress.org/designsimply\">Sheri Bigelow</a>, <a href=\"https://profiles.wordpress.org/simonwheatley\">Simon Wheatley</a>, <a href=\"https://profiles.wordpress.org/siobhan\">Siobhan</a>, <a href=\"https://profiles.wordpress.org/metodiew\">Stanko Metodiev</a>, <a href=\"https://profiles.wordpress.org/stephdau\">Stephane Daury (stephdau)</a>, <a href=\"https://profiles.wordpress.org/netweb\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/stevegrunwell\">Steve Grunwell</a>, <a href=\"https://profiles.wordpress.org/stevenkword\">Steven Word</a>, <a href=\"https://profiles.wordpress.org/stuartshields\">stuartshields</a>, <a href=\"https://profiles.wordpress.org/sudar\">Sudar Muthu</a>, <a href=\"https://profiles.wordpress.org/sunnyratilal\">Sunny Ratilal</a>, <a href=\"https://profiles.wordpress.org/taka2\">taka2</a>, <a href=\"https://profiles.wordpress.org/tharsheblows\">tharsheblows</a>, <a href=\"https://profiles.wordpress.org/thorbrink\">Thor Brink</a>, <a href=\"https://profiles.wordpress.org/creativeinfusion\">Tim Smith</a>, <a href=\"https://profiles.wordpress.org/tlexcellent\">tlexcellent</a>, <a href=\"https://profiles.wordpress.org/tmatsuur\">tmatsuur</a>, <a href=\"https://profiles.wordpress.org/tobiasbg\">TobiasBg</a>, <a href=\"https://profiles.wordpress.org/tomasm\">Tomas Mackevicius</a>, <a href=\"https://profiles.wordpress.org/tomharrigan\">TomHarrigan</a>, <a href=\"https://profiles.wordpress.org/toro_unit\">Toro_Unit (Hiroshi Urabe)</a>, <a href=\"https://profiles.wordpress.org/toru\">Toru Miki</a>, <a href=\"https://profiles.wordpress.org/liljimmi\">Tracy (LilJimmi) Levesque</a>, <a href=\"https://profiles.wordpress.org/tryon\">Tryon Eggleston</a>, <a href=\"https://profiles.wordpress.org/tywayne\">Ty Carlson</a>, <a href=\"https://profiles.wordpress.org/desaiuditd\">Udit Desai</a>, <a href=\"https://profiles.wordpress.org/umeshnevase\">Umesh Nevase</a>, <a href=\"https://profiles.wordpress.org/vivekbhusal\">vivekbhusal</a>, <a href=\"https://profiles.wordpress.org/vortfu\">vortfu</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/willnorris\">Will Norris</a>, <a href=\"https://profiles.wordpress.org/willgladstone\">willgladstone</a>, <a href=\"https://profiles.wordpress.org/earnjam\">William Earnhardt</a>, <a href=\"https://profiles.wordpress.org/willstedt\">willstedt</a>, <a href=\"https://profiles.wordpress.org/yoavf\">Yoav Farhi</a>, <a href=\"https://profiles.wordpress.org/ysalame\">Yuri Salame</a>, <a href=\"https://profiles.wordpress.org/oxymoron\">Zach Wills</a>, <a href=\"https://profiles.wordpress.org/katzwebdesign\">Zack Katz</a>, and <a href=\"https://profiles.wordpress.org/tollmanz\">Zack Tollman</a>.\n<p>&nbsp;</p>\n<p>Special thanks go to <a href=\"http://siobhanmckeown.com/\">Siobhan McKeown</a> for producing the release video, <a href=\"http://hugobaeta.com/\">Hugo Baeta</a> for the design, and <a href=\"http://jacklenox.com/\">Jack Lenox</a> for the voice-over.</p>\n<p>Finally, thanks to all of the contributors who provided subtitles for the release video, which at last count had been translated into 30 languages!</p>\n<p>If you want to follow along or help out, check out <a href=\"https://make.wordpress.org/\">Make WordPress</a> and our <a href=\"https://make.wordpress.org/core/\">core development blog</a>. Thanks for choosing WordPress. See you soon for version 4.4!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 4.2.4 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wordpress.org/news/2015/08/wordpress-4-2-4-security-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 04 Aug 2015 12:10:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3827\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:397:\"WordPress 4.2.4 is now available. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. This release addresses six issues, including three cross-site scripting vulnerabilities and a potential SQL injection that could be used to compromise a site, which were discovered by Marc-Alexandre Montpas of Sucuri, Helen Hou-Sandí [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Samuel Sidler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2011:\"<p>WordPress 4.2.4 is now available. This is a<strong> security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>This release addresses six issues, including three cross-site scripting vulnerabilities and a potential SQL injection that could be used to compromise a site, which were discovered by <a href=\"https://sucuri.net/\">Marc-Alexandre Montpas</a> of Sucuri, <a href=\"http://helenhousandi.com/\">Helen Hou-Sandí</a> of the WordPress security team, <a href=\"http://www.checkpoint.com/\">Netanel Rubin</a> of Check Point, and <a href=\"https://hackerone.com/reactors08\">Ivan Grigorov</a>. It also includes a fix for a potential timing side-channel attack, discovered by <a href=\"http://www.scrutinizer-ci.com/\">Johannes Schmitt</a> of Scrutinizer, and prevents an attacker from locking a post from being edited, discovered by <a href=\"https://www.linkedin.com/in/symbiansymoh\">Mohamed A. Baset</a>.</p>\n<p>Our thanks to those who have practiced <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsible disclosure</a> of security issues.</p>\n<p>WordPress 4.2.4 also fixes four bugs. For more information, see the <a href=\"https://codex.wordpress.org/Version_4.2.4\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/log/branches/4.2?rev=33573&amp;stop_rev=33396\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.2.4</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.2.4.</p>\n<p><em>Already testing WordPress 4.3? The second release candidate is now available (<a href=\"https://wordpress.org/wordpress-4.3-RC2.zip\">zip</a>) and it contains these fixes. For more on 4.3, see <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-release-candidate/\">the RC 1 announcement post</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"WordPress 4.3 Release Candidate\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2015/07/wordpress-4-3-release-candidate/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2015 23:50:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3817\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:340:\"The release candidate for WordPress 4.3 is now available. We&#8217;ve made more than 100 changes since releasing Beta 4 a week ago. RC means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. We hope to ship WordPress 4.3 on Tuesday, August 18, but we [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Konstantin Obenland\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2256:\"<p>The release candidate for WordPress 4.3 is now available.</p>\n<p>We&#8217;ve made more than <a href=\"https://core.trac.wordpress.org/log/trunk?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=33512&amp;stop_rev=33372&amp;limit=120\">100 changes</a> since releasing Beta 4 a week ago. RC means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. We hope to ship WordPress 4.3 on <strong>Tuesday, August 18</strong>, but we need your help to get there.</p>\n<p>If you haven’t tested 4.3 yet, now is the time!</p>\n<p><strong>Think you&#8217;ve found a bug?</strong> Please post to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta support forum</a>. If any known issues come up, you&#8217;ll be able to <a href=\"https://core.trac.wordpress.org/report/5\">find them here</a>.</p>\n<p>To test WordPress 4.3 RC1, you can use the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin or you can <a href=\"https://wordpress.org/wordpress-4.3-RC1.zip\">download the release candidate here</a> (zip).</p>\n<p>For more information about what’s new in version 4.3, check out the <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-1/\">Beta 1</a>, <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-2/\">Beta 2</a>, <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-3/\">Beta 3</a>, and <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-4/\">Beta 4</a> blog posts.</p>\n<p><strong>Developers</strong>, please test your plugins and themes against WordPress 4.3 and update your plugin&#8217;s <em>Tested up to</em> version in the readme to 4.3 before next week. If you find compatibility problems, we never want to break things, so please be sure to post to the support forums so we can figure those out before the final release.</p>\n<p>Be sure to <a href=\"https://make.wordpress.org/core/\">follow along the core development blog</a>, where we&#8217;ll continue to post <a href=\"https://make.wordpress.org/core/tag/dev-notes+4-3/\">notes for developers</a> for 4.3.</p>\n<p><em>Drei Monate Arbeit</em><br />\n<em>Endlich das Ziel vor Augen</em><br />\n<em>Bald hab ich Urlaub!</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 4.2.3 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/news/2015/07/wordpress-4-2-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 23 Jul 2015 11:21:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3807\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:380:\"WordPress 4.2.3 is now available. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. WordPress versions 4.2.2 and earlier are affected by a cross-site scripting vulnerability, which could allow users with the Contributor or Author role to compromise a site. This was initially reported by Jon Cave and [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Gary Pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2708:\"<p>WordPress 4.2.3 is now available. This is a<strong> security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>WordPress versions 4.2.2 and earlier are affected by a cross-site scripting vulnerability, which could allow users with the Contributor or Author role to compromise a site. This was initially reported by <a href=\"https://profiles.wordpress.org/duck_\">Jon Cave</a> and fixed by <a href=\"http://www.miqrogroove.com/\">Robert Chapin</a>, both of the WordPress security team, and later reported by <a href=\"http://klikki.fi/\">Jouko Pynnönen</a>.</p>\n<p>We also fixed an issue where it was possible for a user with Subscriber permissions to create a draft through Quick Draft. Reported by Netanel Rubin from <a href=\"https://www.checkpoint.com/\">Check Point Software Technologies</a>.</p>\n<p>Our thanks to those who have practiced <a href=\"https://make.wordpress.org/core/handbook/reporting-security-vulnerabilities/\">responsible disclosure</a> of security issues.</p>\n<p>WordPress 4.2.3 also contains fixes for 20 bugs from 4.2. For more information, see the <a href=\"https://codex.wordpress.org/Version_4.2.3\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/log/branches/4.2?rev=33382&amp;stop_rev=32430\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.2.3</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.2.3.</p>\n<p>Thanks to everyone who contributed to 4.2.3:</p>\n<p><a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/chriscct7\">Chris Christoff</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/iseulde\">Ella Iseulde Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/gabrielperezs\">Gabriel Pérez</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/mdawaffe\">Mike Adams</a>, <a href=\"https://profiles.wordpress.org/miqrogroove\">Robert Chapin</a>, <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a>, <a href=\"https://profiles.wordpress.org/magicroundabout\">Ross Wintle</a>, and <a href=\"https://profiles.wordpress.org/wonderboymusic\">Scott Taylor</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.3 Beta 4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Jul 2015 21:55:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=3796\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:337:\"WordPress 4.3 Beta 4 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.3, try the WordPress Beta Tester plugin (you’ll want &#8220;bleeding edge nightlies&#8221;). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Konstantin Obenland\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2212:\"<p>WordPress 4.3 Beta 4 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.3, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want &#8220;bleeding edge nightlies&#8221;). Or you can <a href=\"https://wordpress.org/wordpress-4.3-beta4.zip\">download the beta here</a> (zip).</p>\n<p>For more information about what’s new in version 4.3, check out the <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-1/\">Beta 1</a>, <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-2/\">Beta 2</a>, and <a href=\"https://wordpress.org/news/2015/07/wordpress-4-3-beta-3/\">Beta 3</a> blog posts. Some of the changes in Beta 4 include:</p>\n<ul>\n<li><span class=\"s1\">Fixed several bugs and broken flows in the </span><span class=\"s1\"><strong>publish box </strong></span><span class=\"s1\">in the edit screen.</span></li>\n<li>Addressed a number of edge cases for word count in the <strong>editor</strong>.</li>\n<li><span class=\"s1\"><strong>Site icons</strong> </span><span class=\"s1\">can now be previewed within the customizer. The feature has been removed from general settings.</span></li>\n<li><strong>Various bug fixes</strong>. We&#8217;ve made <a href=\"https://core.trac.wordpress.org/log/trunk?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=33369&amp;stop_rev=33289\">more than 60 changes</a> in the last week.</li>\n</ul>\n<p>If you think you’ve found a bug, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. Or, if you’re comfortable writing a bug report, <a href=\"https://core.trac.wordpress.org/\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a> and <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;group=component&amp;milestone=4.3\">everything we’ve fixed</a>.</p>\n<p><em>Few Tickets Remain</em><br />\n<em>Edge Cases Disappearing</em><br />\n<em>You Must Test Today</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Tue, 17 Nov 2015 04:47:20 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:13:\"last-modified\";s:29:\"Thu, 12 Nov 2015 00:04:51 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 250\";}s:5:\"build\";s:14:\"20150531010345\";}", "no");
INSERT INTO `bupg_options` VALUES("4692", "_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1447778840", "no");
INSERT INTO `bupg_options` VALUES("4693", "_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1447735640", "no");
INSERT INTO `bupg_options` VALUES("4694", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1447778841", "no");
INSERT INTO `bupg_options` VALUES("4695", "_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1447778841", "no");
INSERT INTO `bupg_options` VALUES("4696", "_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9", "1447735641", "no");
INSERT INTO `bupg_options` VALUES("4697", "_transient_timeout_feed_b9388c83948825c1edaef0d856b7b109", "1447778842", "no");
INSERT INTO `bupg_options` VALUES("4698", "_transient_feed_b9388c83948825c1edaef0d856b7b109", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n	\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:117:\"\n		\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordPress Plugins » View: Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://wordpress.org/plugins/browse/popular/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordPress Plugins » View: Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Nov 2015 04:38:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"http://bbpress.org/?v=1.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:30:{i:0;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Regenerate Thumbnails\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/regenerate-thumbnails/#post-6743\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 23 Aug 2008 14:38:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"6743@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"Allows you to regenerate your thumbnails after changing the thumbnail sizes.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Alex Mills (Viper007Bond)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Yoast SEO\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://wordpress.org/plugins/wordpress-seo/#post-8321\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Jan 2009 20:34:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"8321@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"Improve your WordPress SEO: Write better content and have a fully optimized WordPress site using Yoast SEO plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"W3 Total Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/w3-total-cache/#post-12073\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2009 18:46:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"12073@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:132:\"Easy Web Performance Optimization (WPO) using caching: browser, page, object, database, minify and content delivery network support.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Frederick Townes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Really Simple CAPTCHA\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/really-simple-captcha/#post-9542\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 Mar 2009 02:17:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"9542@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"Really Simple CAPTCHA is a CAPTCHA module intended to be called from other plugins. It is originally created for my Contact Form 7 plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Wordfence Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wordfence/#post-29832\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 04 Sep 2011 03:13:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"29832@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"The Wordfence WordPress security plugin provides free enterprise-class WordPress security, protecting your website from hacks and malware.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Wordfence\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WP Super Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/wp-super-cache/#post-2572\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Nov 2007 11:40:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2572@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"A very fast caching engine for WordPress that produces static html files.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Donncha O Caoimh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"TinyMCE Advanced\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://wordpress.org/plugins/tinymce-advanced/#post-2082\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Jun 2007 15:00:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2082@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Enables the advanced features of TinyMCE, the WordPress WYSIWYG editor.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Andrew Ozz\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"All in One SEO Pack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/all-in-one-seo-pack/#post-753\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Mar 2007 20:08:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"753@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:126:\"All in One SEO Pack is a WordPress SEO plugin to automatically optimize your WordPress blog for Search Engines such as Google.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"uberdose\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Advanced Custom Fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/advanced-custom-fields/#post-25254\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Mar 2011 04:07:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"25254@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"Customise WordPress with powerful, professional and intuitive fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"elliotcondon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Hello Dolly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/hello-dolly/#post-5790\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 May 2008 22:11:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"5790@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"This is not just a plugin, it symbolizes the hope and enthusiasm of an entire generation summed up in two words sung most famously by Louis Armstrong.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"NextGEN Gallery\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/nextgen-gallery/#post-1169\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Apr 2007 20:08:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"1169@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"The most popular WordPress gallery plugin and one of the most popular plugins of all time with over 13 million downloads.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Alex Rabe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"WP-PageNavi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wp-pagenavi/#post-363\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 23:17:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"363@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"Adds a more advanced paging navigation interface.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Lester Chan\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WooCommerce - excelling eCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/woocommerce/#post-29860\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Sep 2011 08:13:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"29860@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WooCommerce is a powerful, extendable eCommerce plugin that helps you sell anything. Beautifully.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"WooThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Google Analytics by Yoast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/plugins/google-analytics-for-wordpress/#post-2316\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Sep 2007 12:15:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2316@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:124:\"Track your WordPress site easily with the latest tracking codes and lots added data for search result pages and error pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Akismet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wordpress.org/plugins/akismet/#post-15\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:11:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"15@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"Akismet checks your comments against the Akismet Web service to see if they look like spam or not.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Google XML Sitemaps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/google-sitemap-generator/#post-132\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:31:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"132@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"This plugin will generate a special XML sitemap which will help search engines to better index your blog.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Arne Brachhold\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Contact Form 7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/contact-form-7/#post-2141\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Aug 2007 12:45:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2141@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Just another contact form plugin. Simple but flexible.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WordPress Importer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wordpress-importer/#post-18101\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 May 2010 17:42:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"18101@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"Import posts, pages, comments, custom fields, categories, tags and more from a WordPress export file.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brian Colinger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Jetpack by WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://wordpress.org/plugins/jetpack/#post-23862\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Jan 2011 02:21:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"23862@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Your WordPress, Simplified.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Tim Moore\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Duplicate Post\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/duplicate-post/#post-2646\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Dec 2007 17:40:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2646@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Clone posts and pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Lopo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Disable Comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wordpress.org/plugins/disable-comments/#post-26907\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 May 2011 04:42:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"26907@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:134:\"Allows administrators to globally disable comments on their site. Comments can be disabled according to post type. Multisite friendly.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Samir Shah\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WP Multibyte Patch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wp-multibyte-patch/#post-28395\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Jul 2011 12:22:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"28395@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Multibyte functionality enhancement for the WordPress Japanese package.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"plugin-master\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Black Studio TinyMCE Widget\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/plugins/black-studio-tinymce-widget/#post-31973\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Nov 2011 15:06:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"31973@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"The visual editor widget for Wordpress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Marco Chiesi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"iThemes Security (formerly Better WP Security)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/better-wp-security/#post-21738\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Oct 2010 22:06:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"21738@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"Protect your WordPress site by hiding vital areas of your site, protecting access to important files, preventing brute-force login attempts, detecting\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Chris Wiegman\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Page Builder by SiteOrigin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/siteorigin-panels/#post-51888\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 11 Apr 2013 10:36:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"51888@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"Build responsive page layouts using the widgets you know and love using this simple drag and drop page builder.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Greg Priday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Google Analytics Dashboard for WP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wordpress.org/plugins/google-analytics-dashboard-for-wp/#post-50539\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 10 Mar 2013 17:07:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"50539@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"Displays Google Analytics reports in your WordPress Dashboard. Inserts the latest Google Analytics tracking code in your pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Alin Marcu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Meta Slider\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/ml-slider/#post-49521\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Feb 2013 16:56:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"49521@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:145:\"Easy to use WordPress slider plugin. Create SEO optimised responsive slideshows with Nivo Slider, Flex Slider, Coin Slider and Responsive Slides.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Matcha Labs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"UpdraftPlus Backup and Restoration\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/updraftplus/#post-38058\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 May 2012 15:14:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"38058@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:148:\"Backup and restoration made easy. Complete backups; manual or scheduled (backup to S3, Dropbox, Google Drive, Rackspace, FTP, SFTP, email + others).\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"David Anderson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Clef Two-Factor Authentication\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wordpress.org/plugins/wpclef/#post-47509\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 27 Dec 2012 01:25:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"47509@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"Modern two-factor that people love to use: strong authentication without passwords or tokens; single sign on/off; magical user experience.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Dave Ross\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Duplicator\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/duplicator/#post-26607\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 May 2011 12:15:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"26607@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"Duplicate, clone, backup, move and transfer an entire site from one location to another.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Cory Lamle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:46:\"https://wordpress.org/plugins/rss/view/popular\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:12:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Tue, 17 Nov 2015 04:47:22 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:7:\"expires\";s:29:\"Tue, 17 Nov 2015 05:13:41 GMT\";s:13:\"cache-control\";s:0:\"\";s:6:\"pragma\";s:0:\"\";s:13:\"last-modified\";s:31:\"Tue, 17 Nov 2015 04:38:41 +0000\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 250\";}s:5:\"build\";s:14:\"20150531010345\";}", "no");
INSERT INTO `bupg_options` VALUES("4699", "_transient_timeout_feed_mod_b9388c83948825c1edaef0d856b7b109", "1447778842", "no");
INSERT INTO `bupg_options` VALUES("4700", "_transient_feed_mod_b9388c83948825c1edaef0d856b7b109", "1447735642", "no");
INSERT INTO `bupg_options` VALUES("4701", "_transient_timeout_plugin_slugs", "1447855822", "no");
INSERT INTO `bupg_options` VALUES("4702", "_transient_plugin_slugs", "a:6:{i:0;s:36:\"contact-form-7/wp-contact-form-7.php\";i:1;s:25:\"duplicator/duplicator.php\";i:2;s:27:\"fusion-core/fusion-core.php\";i:3;s:27:\"LayerSlider/layerslider.php\";i:4;s:23:\"revslider/revslider.php\";i:5;s:24:\"wordpress-seo/wp-seo.php\";}", "no");
INSERT INTO `bupg_options` VALUES("4703", "_transient_timeout_dash_4077549d03da2e451c8b5f002294ff51", "1447778842", "no");
INSERT INTO `bupg_options` VALUES("4704", "_transient_dash_4077549d03da2e451c8b5f002294ff51", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2015/11/wordpress-4-4-beta-4/\'>WordPress 4.4 Beta 4</a> <span class=\"rss-date\">November 12, 2015</span><div class=\"rssSummary\">WordPress 4.4 Beta 4 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.4, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&hellip;]</div></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'http://wptavern.com/impervas-web-application-attack-report-shows-spam-is-wordpress-largest-security-threat\'>WPTavern: Imperva’s Web Application Attack Report Shows Spam Is WordPress’ Largest Security Threat</a></li><li><a class=\'rsswidget\' href=\'http://wptavern.com/wordpress-freelancer-adam-soucie-on-the-dangers-of-accepting-credit-cards\'>WPTavern: WordPress Freelancer Adam Soucie on the Dangers of Accepting Credit Cards</a></li><li><a class=\'rsswidget\' href=\'http://wptavern.com/aesop-interactive-llc-acquired-by-anonymous-buyer\'>WPTavern: Aesop Interactive LLC Acquired by Anonymous Buyer</a></li></ul></div><div class=\"rss-widget\"><ul><li class=\'dashboard-news-plugin\'><span>Popular Plugin:</span> <a href=\'https://wordpress.org/plugins/ml-slider/\' class=\'dashboard-news-plugin-link\'>Meta Slider</a>&nbsp;<span>(<a href=\'plugin-install.php?tab=plugin-information&amp;plugin=ml-slider&amp;_wpnonce=5afca018e1&amp;TB_iframe=true&amp;width=600&amp;height=800\' class=\'thickbox\' title=\'Meta Slider\'>Install</a>)</span></li></ul></div>", "no");
INSERT INTO `bupg_options` VALUES("4705", "_transient_timeout_wpseo_sitemap_cache_slide_1", "1447829096", "no");
INSERT INTO `bupg_options` VALUES("4706", "_transient_wpseo_sitemap_cache_slide_1", "<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>http://birminghamupg.com/slide/demo-5/</loc>\n		<lastmod>2014-05-28T17:49:01+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/slide/demo-6-2/</loc>\n		<lastmod>2014-05-28T20:00:54+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/slide/demo-7/</loc>\n		<lastmod>2014-05-28T20:28:56+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/slide/demo-10/</loc>\n		<lastmod>2014-05-29T00:44:03+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/slide/breakfast-image/</loc>\n		<lastmod>2014-05-29T21:09:23+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/slide/youtube/</loc>\n		<lastmod>2014-05-29T21:15:39+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/slide/vimeo/</loc>\n		<lastmod>2014-05-29T14:47:55+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/slide/image-23/</loc>\n		<lastmod>2014-06-02T14:27:20+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/slide/image-23-2/</loc>\n		<lastmod>2014-06-02T14:27:54+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>http://birminghamupg.com/slide/home/</loc>\n		<lastmod>2014-11-19T15:56:43+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n</urlset>", "no");
INSERT INTO `bupg_options` VALUES("4711", "_site_transient_update_themes", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1447769410;s:7:\"checked\";a:2:{s:5:\"Avada\";s:5:\"3.7.4\";s:13:\"twentyfifteen\";s:3:\"1.2\";}s:8:\"response\";a:1:{s:13:\"twentyfifteen\";a:4:{s:5:\"theme\";s:13:\"twentyfifteen\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:43:\"https://wordpress.org/themes/twentyfifteen/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/theme/twentyfifteen.1.3.zip\";}}s:12:\"translations\";a:0:{}}", "yes");
INSERT INTO `bupg_options` VALUES("4713", "_site_transient_timeout_browser_4910e34ab899e1f04ce17d9586e216ff", "1448372361", "yes");
INSERT INTO `bupg_options` VALUES("4714", "_site_transient_browser_4910e34ab899e1f04ce17d9586e216ff", "a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"46.0.2490.86\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO `bupg_options` VALUES("4715", "_site_transient_timeout_theme_roots", "1447770603", "yes");
INSERT INTO `bupg_options` VALUES("4716", "_site_transient_theme_roots", "a:2:{s:5:\"Avada\";s:7:\"/themes\";s:13:\"twentyfifteen\";s:7:\"/themes\";}", "yes");
INSERT INTO `bupg_options` VALUES("4717", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1447780163", "yes");
INSERT INTO `bupg_options` VALUES("4718", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "a:100:{s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";s:4:\"5550\";}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"Post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";s:4:\"3478\";}s:6:\"plugin\";a:3:{s:4:\"name\";s:6:\"plugin\";s:4:\"slug\";s:6:\"plugin\";s:5:\"count\";s:4:\"3435\";}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";s:4:\"2930\";}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";s:4:\"2674\";}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";s:4:\"2131\";}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";s:4:\"2122\";}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";s:4:\"1951\";}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";s:4:\"1918\";}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";s:4:\"1901\";}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";s:4:\"1896\";}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";s:4:\"1842\";}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";s:4:\"1751\";}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"Facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";s:4:\"1552\";}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";s:4:\"1474\";}s:9:\"wordpress\";a:3:{s:4:\"name\";s:9:\"wordpress\";s:4:\"slug\";s:9:\"wordpress\";s:5:\"count\";s:4:\"1434\";}s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";s:4:\"1286\";}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";s:4:\"1264\";}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";s:4:\"1249\";}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";s:4:\"1213\";}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";s:4:\"1105\";}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";s:4:\"1044\";}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";s:4:\"1009\";}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";s:3:\"959\";}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";s:3:\"926\";}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";s:3:\"893\";}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"AJAX\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";s:3:\"861\";}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";s:3:\"852\";}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";s:3:\"844\";}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";s:3:\"841\";}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";s:3:\"821\";}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";s:3:\"786\";}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";s:3:\"752\";}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";s:3:\"719\";}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";s:3:\"713\";}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";s:3:\"712\";}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";s:3:\"710\";}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";s:3:\"709\";}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";s:3:\"692\";}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";s:3:\"689\";}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"Share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";s:3:\"687\";}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";s:3:\"667\";}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";s:3:\"665\";}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";s:3:\"660\";}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";s:3:\"636\";}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";s:3:\"624\";}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"CSS\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";s:3:\"618\";}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";s:3:\"617\";}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";s:3:\"611\";}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";s:3:\"609\";}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";s:3:\"589\";}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";s:3:\"587\";}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";s:3:\"572\";}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";s:3:\"572\";}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";s:3:\"563\";}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";s:3:\"562\";}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";s:3:\"560\";}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";s:3:\"558\";}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";s:3:\"551\";}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";s:3:\"545\";}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";s:3:\"535\";}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";s:3:\"514\";}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";s:3:\"513\";}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";s:3:\"509\";}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";s:3:\"507\";}s:7:\"picture\";a:3:{s:4:\"name\";s:7:\"picture\";s:4:\"slug\";s:7:\"picture\";s:5:\"count\";s:3:\"498\";}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";s:3:\"495\";}s:4:\"list\";a:3:{s:4:\"name\";s:4:\"list\";s:4:\"slug\";s:4:\"list\";s:5:\"count\";s:3:\"491\";}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";s:3:\"488\";}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";s:3:\"485\";}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";s:3:\"466\";}s:6:\"simple\";a:3:{s:4:\"name\";s:6:\"simple\";s:4:\"slug\";s:6:\"simple\";s:5:\"count\";s:3:\"462\";}s:8:\"pictures\";a:3:{s:4:\"name\";s:8:\"pictures\";s:4:\"slug\";s:8:\"pictures\";s:5:\"count\";s:3:\"449\";}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";s:3:\"443\";}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";s:3:\"438\";}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";s:3:\"437\";}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";s:3:\"425\";}s:5:\"flash\";a:3:{s:4:\"name\";s:5:\"flash\";s:4:\"slug\";s:5:\"flash\";s:5:\"count\";s:3:\"419\";}s:3:\"url\";a:3:{s:4:\"name\";s:3:\"url\";s:4:\"slug\";s:3:\"url\";s:5:\"count\";s:3:\"415\";}s:4:\"html\";a:3:{s:4:\"name\";s:4:\"html\";s:4:\"slug\";s:4:\"html\";s:5:\"count\";s:3:\"411\";}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";s:3:\"400\";}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";s:3:\"397\";}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"News\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";s:3:\"394\";}s:4:\"shop\";a:3:{s:4:\"name\";s:4:\"shop\";s:4:\"slug\";s:4:\"shop\";s:5:\"count\";s:3:\"393\";}s:4:\"meta\";a:3:{s:4:\"name\";s:4:\"meta\";s:4:\"slug\";s:4:\"meta\";s:5:\"count\";s:3:\"391\";}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";s:3:\"387\";}s:3:\"tag\";a:3:{s:4:\"name\";s:3:\"tag\";s:4:\"slug\";s:3:\"tag\";s:5:\"count\";s:3:\"386\";}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";s:3:\"382\";}s:9:\"thumbnail\";a:3:{s:4:\"name\";s:9:\"thumbnail\";s:4:\"slug\";s:9:\"thumbnail\";s:5:\"count\";s:3:\"379\";}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";s:3:\"375\";}s:4:\"text\";a:3:{s:4:\"name\";s:4:\"text\";s:4:\"slug\";s:4:\"text\";s:5:\"count\";s:3:\"375\";}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";s:3:\"373\";}s:11:\"advertising\";a:3:{s:4:\"name\";s:11:\"advertising\";s:4:\"slug\";s:11:\"advertising\";s:5:\"count\";s:3:\"372\";}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";s:3:\"372\";}s:6:\"upload\";a:3:{s:4:\"name\";s:6:\"upload\";s:4:\"slug\";s:6:\"upload\";s:5:\"count\";s:3:\"366\";}s:9:\"automatic\";a:3:{s:4:\"name\";s:9:\"automatic\";s:4:\"slug\";s:9:\"automatic\";s:5:\"count\";s:3:\"364\";}s:7:\"sharing\";a:3:{s:4:\"name\";s:7:\"sharing\";s:4:\"slug\";s:7:\"sharing\";s:5:\"count\";s:3:\"363\";}s:8:\"lightbox\";a:3:{s:4:\"name\";s:8:\"lightbox\";s:4:\"slug\";s:8:\"lightbox\";s:5:\"count\";s:3:\"363\";}s:7:\"profile\";a:3:{s:4:\"name\";s:7:\"profile\";s:4:\"slug\";s:7:\"profile\";s:5:\"count\";s:3:\"362\";}s:14:\"administration\";a:3:{s:4:\"name\";s:14:\"administration\";s:4:\"slug\";s:14:\"administration\";s:5:\"count\";s:3:\"360\";}}", "yes");
INSERT INTO `bupg_options` VALUES("4719", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1447769420;s:7:\"checked\";a:6:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:5:\"4.2.1\";s:25:\"duplicator/duplicator.php\";s:6:\"0.5.34\";s:27:\"fusion-core/fusion-core.php\";s:5:\"1.6.2\";s:27:\"LayerSlider/layerslider.php\";s:5:\"5.3.2\";s:23:\"revslider/revslider.php\";s:5:\"4.6.5\";s:24:\"wordpress-seo/wp-seo.php\";s:5:\"2.2.1\";}s:8:\"response\";a:1:{s:24:\"wordpress-seo/wp-seo.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"5899\";s:4:\"slug\";s:13:\"wordpress-seo\";s:6:\"plugin\";s:24:\"wordpress-seo/wp-seo.php\";s:11:\"new_version\";s:5:\"2.3.5\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wordpress-seo/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.2.3.5.zip\";}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:2:{s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:3:\"790\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:3:\"4.3\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/contact-form-7.4.3.zip\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"22600\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"0.5.34\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.0.5.34.zip\";}}}", "yes");

/* INSERT TABLE DATA: bupg_postmeta */
INSERT INTO `bupg_postmeta` VALUES("50", "4074", "_wp_attached_file", "2013/10/slide_3.jpg");
INSERT INTO `bupg_postmeta` VALUES("51", "4074", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1700;s:6:\"height\";i:400;s:4:\"file\";s:19:\"2013/10/slide_3.jpg\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:13:\"Iakov Kalinin\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `bupg_postmeta` VALUES("52", "4076", "_wp_attached_file", "2013/10/slide_4.jpg");
INSERT INTO `bupg_postmeta` VALUES("53", "4076", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:940;s:6:\"height\";i:450;s:4:\"file\";s:19:\"2013/10/slide_4.jpg\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `bupg_postmeta` VALUES("92", "4594", "_wp_attached_file", "2014/06/html5-color.png");
INSERT INTO `bupg_postmeta` VALUES("93", "4594", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:90;s:6:\"height\";i:90;s:4:\"file\";s:23:\"2014/06/html5-color.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `bupg_postmeta` VALUES("98", "4605", "_wp_attached_file", "2014/06/vimeo-color.png");
INSERT INTO `bupg_postmeta` VALUES("99", "4605", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:90;s:6:\"height\";i:90;s:4:\"file\";s:23:\"2014/06/vimeo-color.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `bupg_postmeta` VALUES("100", "4606", "_wp_attached_file", "2014/06/youtube-color.png");
INSERT INTO `bupg_postmeta` VALUES("101", "4606", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:90;s:6:\"height\";i:90;s:4:\"file\";s:25:\"2014/06/youtube-color.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `bupg_postmeta` VALUES("102", "4610", "_wp_attached_file", "2014/06/box21.png");
INSERT INTO `bupg_postmeta` VALUES("103", "4610", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:419;s:6:\"height\";i:434;s:4:\"file\";s:17:\"2014/06/box21.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `bupg_postmeta` VALUES("110", "9754", "_wp_attached_file", "2014/06/bkgd_bw2.jpg");
INSERT INTO `bupg_postmeta` VALUES("111", "9754", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:730;s:4:\"file\";s:20:\"2014/06/bkgd_bw2.jpg\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `bupg_postmeta` VALUES("125", "191", "pyre_project_url", "http://themeforest.net/user/ThemeFusion");
INSERT INTO `bupg_postmeta` VALUES("126", "191", "pyre_project_url_text", "View Project");
INSERT INTO `bupg_postmeta` VALUES("127", "191", "pyre_copy_url", "http://creattica.com");
INSERT INTO `bupg_postmeta` VALUES("128", "191", "pyre_copy_url_text", "From Creattica");
INSERT INTO `bupg_postmeta` VALUES("129", "191", "pyre_page_title_custom_subheader", "");
INSERT INTO `bupg_postmeta` VALUES("130", "191", "pyre_page_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("131", "191", "pyre_video", "");
INSERT INTO `bupg_postmeta` VALUES("132", "191", "pyre_width", "half");
INSERT INTO `bupg_postmeta` VALUES("133", "191", "pyre_video_url", "");
INSERT INTO `bupg_postmeta` VALUES("134", "191", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("135", "191", "pyre_fimg_width", "");
INSERT INTO `bupg_postmeta` VALUES("136", "191", "pyre_fimg_height", "");
INSERT INTO `bupg_postmeta` VALUES("137", "191", "avada_post_views_count", "43");
INSERT INTO `bupg_postmeta` VALUES("138", "191", "pyre_page_title_height", "");
INSERT INTO `bupg_postmeta` VALUES("139", "191", "pyre_portfolio_width_100", "no");
INSERT INTO `bupg_postmeta` VALUES("140", "191", "pyre_sidebar", "no");
INSERT INTO `bupg_postmeta` VALUES("141", "191", "pyre_sidebar_position", "default");
INSERT INTO `bupg_postmeta` VALUES("142", "191", "pyre_project_desc_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("143", "191", "pyre_project_details", "yes");
INSERT INTO `bupg_postmeta` VALUES("144", "191", "pyre_image_rollover_icons", "linkzoom");
INSERT INTO `bupg_postmeta` VALUES("145", "191", "pyre_link_icon_url", "");
INSERT INTO `bupg_postmeta` VALUES("146", "191", "pyre_related_posts", "yes");
INSERT INTO `bupg_postmeta` VALUES("147", "191", "pyre_slider_type", "no");
INSERT INTO `bupg_postmeta` VALUES("148", "191", "pyre_slider", "0");
INSERT INTO `bupg_postmeta` VALUES("149", "191", "pyre_wooslider", "0");
INSERT INTO `bupg_postmeta` VALUES("150", "191", "pyre_flexslider", "0");
INSERT INTO `bupg_postmeta` VALUES("151", "191", "pyre_revslider", "0");
INSERT INTO `bupg_postmeta` VALUES("152", "191", "pyre_elasticslider", "0");
INSERT INTO `bupg_postmeta` VALUES("153", "191", "pyre_fallback", "");
INSERT INTO `bupg_postmeta` VALUES("154", "191", "pyre_page_bg_layout", "default");
INSERT INTO `bupg_postmeta` VALUES("155", "191", "pyre_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("156", "191", "pyre_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("157", "191", "pyre_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("158", "191", "pyre_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("159", "191", "pyre_wide_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("160", "191", "pyre_wide_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("161", "191", "pyre_wide_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("162", "191", "pyre_wide_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("163", "191", "pyre_header_bg", "");
INSERT INTO `bupg_postmeta` VALUES("164", "191", "pyre_header_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("165", "191", "pyre_header_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("166", "191", "pyre_header_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("167", "191", "pyre_page_title_text", "yes");
INSERT INTO `bupg_postmeta` VALUES("168", "191", "pyre_page_title_bar_bg", "");
INSERT INTO `bupg_postmeta` VALUES("169", "191", "pyre_page_title_bar_bg_retina", "");
INSERT INTO `bupg_postmeta` VALUES("170", "191", "pyre_page_title_bar_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("171", "191", "pyre_page_title_bar_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("173", "191", "pyre_project_url", "http://themeforest.net/user/ThemeFusion");
INSERT INTO `bupg_postmeta` VALUES("174", "191", "pyre_project_url_text", "View Project");
INSERT INTO `bupg_postmeta` VALUES("175", "191", "pyre_copy_url", "http://creattica.com");
INSERT INTO `bupg_postmeta` VALUES("176", "191", "pyre_copy_url_text", "From Creattica");
INSERT INTO `bupg_postmeta` VALUES("177", "191", "pyre_page_title_custom_text", "");
INSERT INTO `bupg_postmeta` VALUES("178", "191", "pyre_page_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("179", "191", "pyre_video", "");
INSERT INTO `bupg_postmeta` VALUES("180", "191", "pyre_width", "half");
INSERT INTO `bupg_postmeta` VALUES("181", "191", "pyre_video_url", "");
INSERT INTO `bupg_postmeta` VALUES("182", "191", "pyre_fimg_width", "");
INSERT INTO `bupg_postmeta` VALUES("183", "191", "pyre_fimg_height", "");
INSERT INTO `bupg_postmeta` VALUES("184", "191", "pyre_page_title_bg_parallax", "default");
INSERT INTO `bupg_postmeta` VALUES("185", "191", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("186", "191", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("187", "191", "sbg_selected_sidebar_2_replacement", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("188", "191", "fusion_builder_status", "inactive");
INSERT INTO `bupg_postmeta` VALUES("189", "191", "pyre_slider_position", "default");
INSERT INTO `bupg_postmeta` VALUES("190", "191", "pyre_show_first_featured_image", "no");
INSERT INTO `bupg_postmeta` VALUES("191", "191", "pyre_link_icon_target", "no");
INSERT INTO `bupg_postmeta` VALUES("192", "191", "pyre_display_header", "yes");
INSERT INTO `bupg_postmeta` VALUES("193", "191", "pyre_transparent_header", "default");
INSERT INTO `bupg_postmeta` VALUES("194", "191", "pyre_displayed_menu", "default");
INSERT INTO `bupg_postmeta` VALUES("195", "191", "pyre_display_footer", "default");
INSERT INTO `bupg_postmeta` VALUES("196", "191", "pyre_display_copyright", "default");
INSERT INTO `bupg_postmeta` VALUES("197", "191", "sbg_selected_sidebar_2", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("198", "192", "pyre_project_url", "http://themeforest.net/user/ThemeFusion");
INSERT INTO `bupg_postmeta` VALUES("199", "192", "pyre_project_url_text", "View Project");
INSERT INTO `bupg_postmeta` VALUES("200", "192", "pyre_copy_url", "http://creattica.com");
INSERT INTO `bupg_postmeta` VALUES("201", "192", "pyre_copy_url_text", "From Creattica");
INSERT INTO `bupg_postmeta` VALUES("202", "192", "avada_post_views_count", "458");
INSERT INTO `bupg_postmeta` VALUES("204", "192", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:12:\"Blog Sidebar\";}");
INSERT INTO `bupg_postmeta` VALUES("205", "192", "pyre_page_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("206", "192", "pyre_video", "");
INSERT INTO `bupg_postmeta` VALUES("207", "192", "pyre_width", "full");
INSERT INTO `bupg_postmeta` VALUES("208", "192", "pyre_video_url", "");
INSERT INTO `bupg_postmeta` VALUES("209", "192", "pyre_page_title_custom_subheader", "");
INSERT INTO `bupg_postmeta` VALUES("210", "192", "pyre_fimg_width", "");
INSERT INTO `bupg_postmeta` VALUES("211", "192", "pyre_fimg_height", "");
INSERT INTO `bupg_postmeta` VALUES("212", "192", "pyre_page_title_height", "");
INSERT INTO `bupg_postmeta` VALUES("213", "192", "pyre_portfolio_width_100", "no");
INSERT INTO `bupg_postmeta` VALUES("214", "192", "pyre_sidebar", "no");
INSERT INTO `bupg_postmeta` VALUES("215", "192", "pyre_sidebar_position", "default");
INSERT INTO `bupg_postmeta` VALUES("216", "192", "pyre_project_desc_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("217", "192", "pyre_project_details", "yes");
INSERT INTO `bupg_postmeta` VALUES("218", "192", "pyre_image_rollover_icons", "linkzoom");
INSERT INTO `bupg_postmeta` VALUES("219", "192", "pyre_link_icon_url", "");
INSERT INTO `bupg_postmeta` VALUES("220", "192", "pyre_related_posts", "yes");
INSERT INTO `bupg_postmeta` VALUES("221", "192", "pyre_slider_type", "no");
INSERT INTO `bupg_postmeta` VALUES("222", "192", "pyre_slider", "0");
INSERT INTO `bupg_postmeta` VALUES("223", "192", "pyre_wooslider", "0");
INSERT INTO `bupg_postmeta` VALUES("224", "192", "pyre_flexslider", "0");
INSERT INTO `bupg_postmeta` VALUES("225", "192", "pyre_revslider", "0");
INSERT INTO `bupg_postmeta` VALUES("226", "192", "pyre_elasticslider", "0");
INSERT INTO `bupg_postmeta` VALUES("227", "192", "pyre_fallback", "");
INSERT INTO `bupg_postmeta` VALUES("228", "192", "pyre_page_bg_layout", "default");
INSERT INTO `bupg_postmeta` VALUES("229", "192", "pyre_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("230", "192", "pyre_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("231", "192", "pyre_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("232", "192", "pyre_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("233", "192", "pyre_wide_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("234", "192", "pyre_wide_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("235", "192", "pyre_wide_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("236", "192", "pyre_wide_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("237", "192", "pyre_header_bg", "");
INSERT INTO `bupg_postmeta` VALUES("238", "192", "pyre_header_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("239", "192", "pyre_header_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("240", "192", "pyre_header_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("241", "192", "pyre_page_title_text", "yes");
INSERT INTO `bupg_postmeta` VALUES("242", "192", "pyre_page_title_bar_bg", "");
INSERT INTO `bupg_postmeta` VALUES("243", "192", "pyre_page_title_bar_bg_retina", "");
INSERT INTO `bupg_postmeta` VALUES("244", "192", "pyre_page_title_bar_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("245", "192", "pyre_page_title_bar_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("246", "192", "pyre_project_url", "http://themeforest.net/user/ThemeFusion");
INSERT INTO `bupg_postmeta` VALUES("247", "192", "pyre_project_url_text", "View Project");
INSERT INTO `bupg_postmeta` VALUES("248", "192", "pyre_copy_url", "http://creattica.com");
INSERT INTO `bupg_postmeta` VALUES("249", "192", "pyre_copy_url_text", "From Creattica");
INSERT INTO `bupg_postmeta` VALUES("250", "192", "avada_post_views_count", "0");
INSERT INTO `bupg_postmeta` VALUES("251", "192", "_thumbnail_id", "3405");
INSERT INTO `bupg_postmeta` VALUES("252", "192", "pyre_page_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("253", "192", "pyre_video", "");
INSERT INTO `bupg_postmeta` VALUES("254", "192", "pyre_width", "full");
INSERT INTO `bupg_postmeta` VALUES("255", "192", "pyre_video_url", "");
INSERT INTO `bupg_postmeta` VALUES("256", "192", "pyre_page_title_custom_text", "");
INSERT INTO `bupg_postmeta` VALUES("257", "192", "pyre_fimg_width", "");
INSERT INTO `bupg_postmeta` VALUES("258", "192", "pyre_fimg_height", "");
INSERT INTO `bupg_postmeta` VALUES("259", "192", "pyre_page_title_bg_parallax", "default");
INSERT INTO `bupg_postmeta` VALUES("260", "192", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("261", "192", "sbg_selected_sidebar_2_replacement", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("262", "192", "fusion_builder_status", "inactive");
INSERT INTO `bupg_postmeta` VALUES("263", "192", "pyre_show_first_featured_image", "no");
INSERT INTO `bupg_postmeta` VALUES("264", "192", "pyre_link_icon_target", "no");
INSERT INTO `bupg_postmeta` VALUES("265", "192", "pyre_share_box", "default");
INSERT INTO `bupg_postmeta` VALUES("266", "192", "pyre_post_pagination", "default");
INSERT INTO `bupg_postmeta` VALUES("267", "192", "pyre_main_top_padding", "");
INSERT INTO `bupg_postmeta` VALUES("268", "192", "pyre_main_bottom_padding", "");
INSERT INTO `bupg_postmeta` VALUES("269", "192", "pyre_hundredp_padding", "");
INSERT INTO `bupg_postmeta` VALUES("270", "192", "pyre_slider_position", "default");
INSERT INTO `bupg_postmeta` VALUES("271", "192", "pyre_display_header", "yes");
INSERT INTO `bupg_postmeta` VALUES("272", "192", "pyre_header_100_width", "default");
INSERT INTO `bupg_postmeta` VALUES("273", "192", "pyre_header_bg_opacity", "");
INSERT INTO `bupg_postmeta` VALUES("274", "192", "pyre_displayed_menu", "default");
INSERT INTO `bupg_postmeta` VALUES("275", "192", "pyre_display_footer", "default");
INSERT INTO `bupg_postmeta` VALUES("276", "192", "pyre_display_copyright", "default");
INSERT INTO `bupg_postmeta` VALUES("277", "192", "pyre_footer_100_width", "default");
INSERT INTO `bupg_postmeta` VALUES("278", "192", "pyre_page_title_text_alignment", "default");
INSERT INTO `bupg_postmeta` VALUES("279", "192", "pyre_page_title_text_size", "");
INSERT INTO `bupg_postmeta` VALUES("280", "192", "pyre_page_title_custom_subheader_text_size", "");
INSERT INTO `bupg_postmeta` VALUES("281", "192", "pyre_page_title_font_color", "");
INSERT INTO `bupg_postmeta` VALUES("282", "192", "pyre_page_title_breadcrumbs_search_bar", "default");
INSERT INTO `bupg_postmeta` VALUES("283", "192", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("284", "192", "sbg_selected_sidebar_2", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("286", "193", "pyre_project_url", "http://themeforest.net/user/ThemeFusion");
INSERT INTO `bupg_postmeta` VALUES("287", "193", "pyre_project_url_text", "View Project");
INSERT INTO `bupg_postmeta` VALUES("288", "193", "pyre_copy_url", "http://creattica.com");
INSERT INTO `bupg_postmeta` VALUES("289", "193", "pyre_copy_url_text", "From Creattica");
INSERT INTO `bupg_postmeta` VALUES("290", "193", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("291", "193", "pyre_page_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("292", "193", "pyre_video", "");
INSERT INTO `bupg_postmeta` VALUES("293", "193", "pyre_width", "full");
INSERT INTO `bupg_postmeta` VALUES("294", "193", "pyre_video_url", "");
INSERT INTO `bupg_postmeta` VALUES("295", "193", "avada_post_views_count", "43");
INSERT INTO `bupg_postmeta` VALUES("296", "193", "pyre_page_title_custom_subheader", "");
INSERT INTO `bupg_postmeta` VALUES("297", "193", "pyre_fimg_width", "");
INSERT INTO `bupg_postmeta` VALUES("298", "193", "pyre_fimg_height", "");
INSERT INTO `bupg_postmeta` VALUES("299", "193", "pyre_page_title_height", "");
INSERT INTO `bupg_postmeta` VALUES("300", "193", "pyre_portfolio_width_100", "no");
INSERT INTO `bupg_postmeta` VALUES("301", "193", "pyre_sidebar", "no");
INSERT INTO `bupg_postmeta` VALUES("302", "193", "pyre_sidebar_position", "default");
INSERT INTO `bupg_postmeta` VALUES("303", "193", "pyre_project_desc_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("304", "193", "pyre_project_details", "yes");
INSERT INTO `bupg_postmeta` VALUES("305", "193", "pyre_image_rollover_icons", "linkzoom");
INSERT INTO `bupg_postmeta` VALUES("306", "193", "pyre_link_icon_url", "");
INSERT INTO `bupg_postmeta` VALUES("307", "193", "pyre_related_posts", "yes");
INSERT INTO `bupg_postmeta` VALUES("308", "193", "pyre_slider_type", "no");
INSERT INTO `bupg_postmeta` VALUES("309", "193", "pyre_slider", "0");
INSERT INTO `bupg_postmeta` VALUES("310", "193", "pyre_wooslider", "0");
INSERT INTO `bupg_postmeta` VALUES("311", "193", "pyre_flexslider", "0");
INSERT INTO `bupg_postmeta` VALUES("312", "193", "pyre_revslider", "0");
INSERT INTO `bupg_postmeta` VALUES("313", "193", "pyre_elasticslider", "0");
INSERT INTO `bupg_postmeta` VALUES("314", "193", "pyre_fallback", "");
INSERT INTO `bupg_postmeta` VALUES("315", "193", "pyre_page_bg_layout", "default");
INSERT INTO `bupg_postmeta` VALUES("316", "193", "pyre_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("317", "193", "pyre_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("318", "193", "pyre_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("319", "193", "pyre_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("320", "193", "pyre_wide_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("321", "193", "pyre_wide_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("322", "193", "pyre_wide_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("323", "193", "pyre_wide_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("324", "193", "pyre_header_bg", "");
INSERT INTO `bupg_postmeta` VALUES("325", "193", "pyre_header_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("326", "193", "pyre_header_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("327", "193", "pyre_header_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("328", "193", "pyre_page_title_text", "yes");
INSERT INTO `bupg_postmeta` VALUES("329", "193", "pyre_page_title_bar_bg", "");
INSERT INTO `bupg_postmeta` VALUES("330", "193", "pyre_page_title_bar_bg_retina", "");
INSERT INTO `bupg_postmeta` VALUES("331", "193", "pyre_page_title_bar_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("332", "193", "pyre_page_title_bar_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("334", "193", "pyre_project_url", "http://themeforest.net/user/ThemeFusion");
INSERT INTO `bupg_postmeta` VALUES("335", "193", "pyre_project_url_text", "View Project");
INSERT INTO `bupg_postmeta` VALUES("336", "193", "pyre_copy_url", "http://creattica.com");
INSERT INTO `bupg_postmeta` VALUES("337", "193", "pyre_copy_url_text", "From Creattica");
INSERT INTO `bupg_postmeta` VALUES("338", "193", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("339", "193", "pyre_page_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("340", "193", "pyre_video", "");
INSERT INTO `bupg_postmeta` VALUES("341", "193", "pyre_width", "full");
INSERT INTO `bupg_postmeta` VALUES("342", "193", "pyre_video_url", "");
INSERT INTO `bupg_postmeta` VALUES("343", "193", "pyre_page_title_custom_text", "");
INSERT INTO `bupg_postmeta` VALUES("344", "193", "pyre_fimg_width", "");
INSERT INTO `bupg_postmeta` VALUES("345", "193", "pyre_fimg_height", "");
INSERT INTO `bupg_postmeta` VALUES("346", "193", "pyre_page_title_bg_parallax", "default");
INSERT INTO `bupg_postmeta` VALUES("347", "193", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("348", "193", "sbg_selected_sidebar_2_replacement", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("349", "193", "fusion_builder_status", "inactive");
INSERT INTO `bupg_postmeta` VALUES("350", "193", "pyre_slider_position", "default");
INSERT INTO `bupg_postmeta` VALUES("351", "193", "pyre_show_first_featured_image", "no");
INSERT INTO `bupg_postmeta` VALUES("352", "193", "pyre_link_icon_target", "no");
INSERT INTO `bupg_postmeta` VALUES("353", "193", "pyre_display_header", "yes");
INSERT INTO `bupg_postmeta` VALUES("354", "193", "pyre_transparent_header", "default");
INSERT INTO `bupg_postmeta` VALUES("355", "193", "pyre_displayed_menu", "default");
INSERT INTO `bupg_postmeta` VALUES("356", "193", "pyre_display_footer", "default");
INSERT INTO `bupg_postmeta` VALUES("357", "193", "pyre_display_copyright", "default");
INSERT INTO `bupg_postmeta` VALUES("358", "193", "sbg_selected_sidebar_2", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("359", "193", "pyre_share_box", "default");
INSERT INTO `bupg_postmeta` VALUES("360", "193", "pyre_post_pagination", "default");
INSERT INTO `bupg_postmeta` VALUES("361", "193", "pyre_main_top_padding", "");
INSERT INTO `bupg_postmeta` VALUES("362", "193", "pyre_main_bottom_padding", "");
INSERT INTO `bupg_postmeta` VALUES("363", "193", "pyre_hundredp_padding", "");
INSERT INTO `bupg_postmeta` VALUES("364", "193", "pyre_header_100_width", "default");
INSERT INTO `bupg_postmeta` VALUES("365", "193", "pyre_header_bg_opacity", "");
INSERT INTO `bupg_postmeta` VALUES("366", "193", "pyre_footer_100_width", "default");
INSERT INTO `bupg_postmeta` VALUES("367", "193", "pyre_page_title_text_alignment", "default");
INSERT INTO `bupg_postmeta` VALUES("368", "193", "pyre_page_title_text_size", "");
INSERT INTO `bupg_postmeta` VALUES("369", "193", "pyre_page_title_custom_subheader_text_size", "");
INSERT INTO `bupg_postmeta` VALUES("370", "193", "pyre_page_title_font_color", "");
INSERT INTO `bupg_postmeta` VALUES("371", "193", "pyre_page_title_breadcrumbs_search_bar", "default");
INSERT INTO `bupg_postmeta` VALUES("372", "195", "pyre_page_title_custom_subheader", "");
INSERT INTO `bupg_postmeta` VALUES("374", "195", "pyre_project_url", "http://themeforest.net/user/ThemeFusion");
INSERT INTO `bupg_postmeta` VALUES("375", "195", "pyre_project_url_text", "View Project");
INSERT INTO `bupg_postmeta` VALUES("376", "195", "pyre_copy_url", "http://creattica.com");
INSERT INTO `bupg_postmeta` VALUES("377", "195", "pyre_copy_url_text", "From Creattica");
INSERT INTO `bupg_postmeta` VALUES("378", "195", "pyre_page_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("379", "195", "pyre_video", "");
INSERT INTO `bupg_postmeta` VALUES("380", "195", "pyre_width", "full");
INSERT INTO `bupg_postmeta` VALUES("381", "195", "pyre_video_url", "");
INSERT INTO `bupg_postmeta` VALUES("382", "195", "avada_post_views_count", "26");
INSERT INTO `bupg_postmeta` VALUES("383", "195", "pyre_fimg_width", "");
INSERT INTO `bupg_postmeta` VALUES("384", "195", "pyre_fimg_height", "");
INSERT INTO `bupg_postmeta` VALUES("385", "195", "pyre_page_title_height", "");
INSERT INTO `bupg_postmeta` VALUES("386", "195", "pyre_portfolio_width_100", "no");
INSERT INTO `bupg_postmeta` VALUES("387", "195", "pyre_sidebar", "no");
INSERT INTO `bupg_postmeta` VALUES("388", "195", "pyre_sidebar_position", "default");
INSERT INTO `bupg_postmeta` VALUES("389", "195", "pyre_project_desc_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("390", "195", "pyre_project_details", "yes");
INSERT INTO `bupg_postmeta` VALUES("391", "195", "pyre_image_rollover_icons", "linkzoom");
INSERT INTO `bupg_postmeta` VALUES("392", "195", "pyre_link_icon_url", "");
INSERT INTO `bupg_postmeta` VALUES("393", "195", "pyre_related_posts", "yes");
INSERT INTO `bupg_postmeta` VALUES("394", "195", "pyre_slider_type", "no");
INSERT INTO `bupg_postmeta` VALUES("395", "195", "pyre_slider", "0");
INSERT INTO `bupg_postmeta` VALUES("396", "195", "pyre_wooslider", "0");
INSERT INTO `bupg_postmeta` VALUES("397", "195", "pyre_flexslider", "0");
INSERT INTO `bupg_postmeta` VALUES("398", "195", "pyre_revslider", "0");
INSERT INTO `bupg_postmeta` VALUES("399", "195", "pyre_elasticslider", "0");
INSERT INTO `bupg_postmeta` VALUES("400", "195", "pyre_fallback", "");
INSERT INTO `bupg_postmeta` VALUES("401", "195", "pyre_page_bg_layout", "default");
INSERT INTO `bupg_postmeta` VALUES("402", "195", "pyre_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("403", "195", "pyre_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("404", "195", "pyre_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("405", "195", "pyre_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("406", "195", "pyre_wide_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("407", "195", "pyre_wide_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("408", "195", "pyre_wide_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("409", "195", "pyre_wide_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("410", "195", "pyre_header_bg", "");
INSERT INTO `bupg_postmeta` VALUES("411", "195", "pyre_header_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("412", "195", "pyre_header_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("413", "195", "pyre_header_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("414", "195", "pyre_page_title_text", "yes");
INSERT INTO `bupg_postmeta` VALUES("415", "195", "pyre_page_title_bar_bg", "");
INSERT INTO `bupg_postmeta` VALUES("416", "195", "pyre_page_title_bar_bg_retina", "");
INSERT INTO `bupg_postmeta` VALUES("417", "195", "pyre_page_title_bar_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("418", "195", "pyre_page_title_bar_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("419", "195", "pyre_page_title_custom_text", "");
INSERT INTO `bupg_postmeta` VALUES("421", "195", "pyre_project_url", "http://themeforest.net/user/ThemeFusion");
INSERT INTO `bupg_postmeta` VALUES("422", "195", "pyre_project_url_text", "View Project");
INSERT INTO `bupg_postmeta` VALUES("423", "195", "pyre_copy_url", "http://creattica.com");
INSERT INTO `bupg_postmeta` VALUES("424", "195", "pyre_copy_url_text", "From Creattica");
INSERT INTO `bupg_postmeta` VALUES("425", "195", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("426", "195", "pyre_page_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("427", "195", "pyre_video", "");
INSERT INTO `bupg_postmeta` VALUES("428", "195", "pyre_width", "full");
INSERT INTO `bupg_postmeta` VALUES("429", "195", "pyre_video_url", "");
INSERT INTO `bupg_postmeta` VALUES("430", "195", "pyre_fimg_width", "");
INSERT INTO `bupg_postmeta` VALUES("431", "195", "pyre_fimg_height", "");
INSERT INTO `bupg_postmeta` VALUES("432", "195", "pyre_page_title_bg_parallax", "default");
INSERT INTO `bupg_postmeta` VALUES("433", "195", "slide_template", "");
INSERT INTO `bupg_postmeta` VALUES("434", "195", "sbg_selected_sidebar_2", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("435", "195", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("436", "195", "sbg_selected_sidebar_2_replacement", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("437", "195", "fusion_builder_status", "inactive");
INSERT INTO `bupg_postmeta` VALUES("438", "195", "pyre_slider_position", "default");
INSERT INTO `bupg_postmeta` VALUES("439", "195", "pyre_show_first_featured_image", "no");
INSERT INTO `bupg_postmeta` VALUES("440", "195", "pyre_link_icon_target", "no");
INSERT INTO `bupg_postmeta` VALUES("441", "195", "pyre_display_header", "yes");
INSERT INTO `bupg_postmeta` VALUES("442", "195", "pyre_transparent_header", "default");
INSERT INTO `bupg_postmeta` VALUES("443", "195", "pyre_displayed_menu", "default");
INSERT INTO `bupg_postmeta` VALUES("444", "195", "pyre_display_footer", "default");
INSERT INTO `bupg_postmeta` VALUES("445", "195", "pyre_display_copyright", "default");
INSERT INTO `bupg_postmeta` VALUES("447", "196", "pyre_project_url", "http://themeforest.net/user/ThemeFusion");
INSERT INTO `bupg_postmeta` VALUES("448", "196", "pyre_project_url_text", "View Project");
INSERT INTO `bupg_postmeta` VALUES("449", "196", "pyre_copy_url", "http://creattica.com");
INSERT INTO `bupg_postmeta` VALUES("450", "196", "pyre_copy_url_text", "From Creattica");
INSERT INTO `bupg_postmeta` VALUES("451", "196", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("452", "196", "pyre_page_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("453", "196", "pyre_video", "");
INSERT INTO `bupg_postmeta` VALUES("454", "196", "pyre_width", "half");
INSERT INTO `bupg_postmeta` VALUES("455", "196", "pyre_video_url", "");
INSERT INTO `bupg_postmeta` VALUES("456", "196", "avada_post_views_count", "231");
INSERT INTO `bupg_postmeta` VALUES("457", "196", "pyre_page_title_custom_subheader", "");
INSERT INTO `bupg_postmeta` VALUES("458", "196", "pyre_fimg_width", "");
INSERT INTO `bupg_postmeta` VALUES("459", "196", "pyre_fimg_height", "");
INSERT INTO `bupg_postmeta` VALUES("460", "196", "pyre_page_title_height", "");
INSERT INTO `bupg_postmeta` VALUES("461", "196", "pyre_portfolio_width_100", "no");
INSERT INTO `bupg_postmeta` VALUES("462", "196", "pyre_sidebar", "no");
INSERT INTO `bupg_postmeta` VALUES("463", "196", "pyre_sidebar_position", "default");
INSERT INTO `bupg_postmeta` VALUES("464", "196", "pyre_project_desc_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("465", "196", "pyre_project_details", "yes");
INSERT INTO `bupg_postmeta` VALUES("466", "196", "pyre_image_rollover_icons", "linkzoom");
INSERT INTO `bupg_postmeta` VALUES("467", "196", "pyre_link_icon_url", "");
INSERT INTO `bupg_postmeta` VALUES("468", "196", "pyre_related_posts", "yes");
INSERT INTO `bupg_postmeta` VALUES("469", "196", "pyre_slider_type", "no");
INSERT INTO `bupg_postmeta` VALUES("470", "196", "pyre_slider", "0");
INSERT INTO `bupg_postmeta` VALUES("471", "196", "pyre_wooslider", "0");
INSERT INTO `bupg_postmeta` VALUES("472", "196", "pyre_flexslider", "0");
INSERT INTO `bupg_postmeta` VALUES("473", "196", "pyre_revslider", "0");
INSERT INTO `bupg_postmeta` VALUES("474", "196", "pyre_elasticslider", "0");
INSERT INTO `bupg_postmeta` VALUES("475", "196", "pyre_fallback", "");
INSERT INTO `bupg_postmeta` VALUES("476", "196", "pyre_page_bg_layout", "default");
INSERT INTO `bupg_postmeta` VALUES("477", "196", "pyre_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("478", "196", "pyre_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("479", "196", "pyre_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("480", "196", "pyre_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("481", "196", "pyre_wide_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("482", "196", "pyre_wide_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("483", "196", "pyre_wide_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("484", "196", "pyre_wide_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("485", "196", "pyre_header_bg", "");
INSERT INTO `bupg_postmeta` VALUES("486", "196", "pyre_header_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("487", "196", "pyre_header_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("488", "196", "pyre_header_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("489", "196", "pyre_page_title_text", "yes");
INSERT INTO `bupg_postmeta` VALUES("490", "196", "pyre_page_title_bar_bg", "");
INSERT INTO `bupg_postmeta` VALUES("491", "196", "pyre_page_title_bar_bg_retina", "");
INSERT INTO `bupg_postmeta` VALUES("492", "196", "pyre_page_title_bar_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("493", "196", "pyre_page_title_bar_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("495", "196", "pyre_project_url", "http://themeforest.net/user/ThemeFusion");
INSERT INTO `bupg_postmeta` VALUES("496", "196", "pyre_project_url_text", "View Project");
INSERT INTO `bupg_postmeta` VALUES("497", "196", "pyre_copy_url", "http://creattica.com");
INSERT INTO `bupg_postmeta` VALUES("498", "196", "pyre_copy_url_text", "From Creattica");
INSERT INTO `bupg_postmeta` VALUES("499", "196", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("500", "196", "pyre_page_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("501", "196", "pyre_video", "");
INSERT INTO `bupg_postmeta` VALUES("502", "196", "pyre_width", "half");
INSERT INTO `bupg_postmeta` VALUES("503", "196", "pyre_video_url", "");
INSERT INTO `bupg_postmeta` VALUES("504", "196", "pyre_page_title_custom_text", "");
INSERT INTO `bupg_postmeta` VALUES("505", "196", "pyre_fimg_width", "");
INSERT INTO `bupg_postmeta` VALUES("506", "196", "pyre_fimg_height", "");
INSERT INTO `bupg_postmeta` VALUES("507", "196", "pyre_page_title_bg_parallax", "default");
INSERT INTO `bupg_postmeta` VALUES("508", "196", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("509", "196", "sbg_selected_sidebar_2_replacement", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("510", "196", "fusion_builder_status", "inactive");
INSERT INTO `bupg_postmeta` VALUES("511", "196", "pyre_slider_position", "default");
INSERT INTO `bupg_postmeta` VALUES("512", "196", "pyre_show_first_featured_image", "no");
INSERT INTO `bupg_postmeta` VALUES("513", "196", "pyre_link_icon_target", "no");
INSERT INTO `bupg_postmeta` VALUES("514", "196", "pyre_display_header", "yes");
INSERT INTO `bupg_postmeta` VALUES("515", "196", "pyre_transparent_header", "default");
INSERT INTO `bupg_postmeta` VALUES("516", "196", "pyre_displayed_menu", "default");
INSERT INTO `bupg_postmeta` VALUES("517", "196", "pyre_display_footer", "default");
INSERT INTO `bupg_postmeta` VALUES("518", "196", "pyre_display_copyright", "default");
INSERT INTO `bupg_postmeta` VALUES("519", "196", "sbg_selected_sidebar_2", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("520", "1876", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("521", "1876", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("522", "1876", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("523", "1876", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("524", "1877", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("525", "1877", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("526", "1877", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("527", "1877", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("528", "1878", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("529", "1878", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("530", "1878", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("531", "1878", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("532", "1879", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("533", "1879", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("534", "1879", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("535", "1879", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("536", "1880", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("537", "1880", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("538", "1880", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("539", "1880", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("540", "1881", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("541", "1881", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("542", "1881", "avada_post_views_count", "0");
INSERT INTO `bupg_postmeta` VALUES("543", "1881", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("544", "1881", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("595", "10716", "_menu_item_type", "custom");
INSERT INTO `bupg_postmeta` VALUES("596", "10716", "_menu_item_menu_item_parent", "0");
INSERT INTO `bupg_postmeta` VALUES("597", "10716", "_menu_item_object_id", "10716");
INSERT INTO `bupg_postmeta` VALUES("598", "10716", "_menu_item_object", "custom");
INSERT INTO `bupg_postmeta` VALUES("599", "10716", "_menu_item_target", "");
INSERT INTO `bupg_postmeta` VALUES("600", "10716", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("601", "10716", "_menu_item_xfn", "");
INSERT INTO `bupg_postmeta` VALUES("602", "10716", "_menu_item_url", "#");
INSERT INTO `bupg_postmeta` VALUES("603", "10716", "_menu_item_fusion_megamenu_status", "");
INSERT INTO `bupg_postmeta` VALUES("604", "10716", "_menu_item_fusion_megamenu_width", "");
INSERT INTO `bupg_postmeta` VALUES("605", "10716", "_menu_item_fusion_megamenu_columns", "auto");
INSERT INTO `bupg_postmeta` VALUES("606", "10716", "_menu_item_fusion_megamenu_columnwidth", "");
INSERT INTO `bupg_postmeta` VALUES("607", "10716", "_menu_item_fusion_megamenu_title", "");
INSERT INTO `bupg_postmeta` VALUES("608", "10716", "_menu_item_fusion_megamenu_widgetarea", "0");
INSERT INTO `bupg_postmeta` VALUES("609", "10716", "_menu_item_fusion_megamenu_icon", "");
INSERT INTO `bupg_postmeta` VALUES("610", "10716", "_menu_item_fusion_megamenu_thumbnail", "");
INSERT INTO `bupg_postmeta` VALUES("611", "198", "pyre_project_url", "http://themeforest.net/user/ThemeFusion");
INSERT INTO `bupg_postmeta` VALUES("612", "198", "pyre_project_url_text", "View Project");
INSERT INTO `bupg_postmeta` VALUES("613", "198", "pyre_copy_url", "http://creattica.com");
INSERT INTO `bupg_postmeta` VALUES("614", "198", "pyre_copy_url_text", "From Creattica");
INSERT INTO `bupg_postmeta` VALUES("615", "198", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("616", "198", "avada_post_views_count", "64");
INSERT INTO `bupg_postmeta` VALUES("617", "198", "pyre_page_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("618", "198", "pyre_video", "");
INSERT INTO `bupg_postmeta` VALUES("619", "198", "pyre_fimg_width", "");
INSERT INTO `bupg_postmeta` VALUES("620", "198", "pyre_fimg_height", "");
INSERT INTO `bupg_postmeta` VALUES("622", "198", "pyre_width", "full");
INSERT INTO `bupg_postmeta` VALUES("623", "198", "pyre_video_url", "http://vimeo.com/8245346");
INSERT INTO `bupg_postmeta` VALUES("624", "198", "pyre_portfolio_width_100", "no");
INSERT INTO `bupg_postmeta` VALUES("625", "198", "pyre_sidebar", "no");
INSERT INTO `bupg_postmeta` VALUES("626", "198", "pyre_sidebar_position", "default");
INSERT INTO `bupg_postmeta` VALUES("627", "198", "pyre_project_desc_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("628", "198", "pyre_project_details", "yes");
INSERT INTO `bupg_postmeta` VALUES("629", "198", "pyre_image_rollover_icons", "linkzoom");
INSERT INTO `bupg_postmeta` VALUES("630", "198", "pyre_link_icon_url", "");
INSERT INTO `bupg_postmeta` VALUES("631", "198", "pyre_related_posts", "yes");
INSERT INTO `bupg_postmeta` VALUES("632", "198", "pyre_slider_type", "no");
INSERT INTO `bupg_postmeta` VALUES("633", "198", "pyre_slider", "0");
INSERT INTO `bupg_postmeta` VALUES("634", "198", "pyre_wooslider", "0");
INSERT INTO `bupg_postmeta` VALUES("635", "198", "pyre_flexslider", "0");
INSERT INTO `bupg_postmeta` VALUES("636", "198", "pyre_revslider", "0");
INSERT INTO `bupg_postmeta` VALUES("637", "198", "pyre_elasticslider", "0");
INSERT INTO `bupg_postmeta` VALUES("638", "198", "pyre_fallback", "");
INSERT INTO `bupg_postmeta` VALUES("639", "198", "pyre_page_bg_layout", "default");
INSERT INTO `bupg_postmeta` VALUES("640", "198", "pyre_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("641", "198", "pyre_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("642", "198", "pyre_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("643", "198", "pyre_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("644", "198", "pyre_wide_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("645", "198", "pyre_wide_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("646", "198", "pyre_wide_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("647", "198", "pyre_wide_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("648", "198", "pyre_header_bg", "");
INSERT INTO `bupg_postmeta` VALUES("649", "198", "pyre_header_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("650", "198", "pyre_header_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("651", "198", "pyre_header_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("652", "198", "pyre_page_title_text", "yes");
INSERT INTO `bupg_postmeta` VALUES("653", "198", "pyre_page_title_bar_bg", "");
INSERT INTO `bupg_postmeta` VALUES("654", "198", "pyre_page_title_bar_bg_retina", "");
INSERT INTO `bupg_postmeta` VALUES("655", "198", "pyre_page_title_bar_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("656", "198", "pyre_page_title_bar_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("658", "198", "pyre_project_url", "http://themeforest.net/user/ThemeFusion");
INSERT INTO `bupg_postmeta` VALUES("659", "198", "pyre_project_url_text", "View Project");
INSERT INTO `bupg_postmeta` VALUES("660", "198", "pyre_copy_url", "http://creattica.com");
INSERT INTO `bupg_postmeta` VALUES("661", "198", "pyre_copy_url_text", "From Creattica");
INSERT INTO `bupg_postmeta` VALUES("662", "198", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("663", "198", "pyre_page_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("664", "198", "pyre_video", "");
INSERT INTO `bupg_postmeta` VALUES("665", "198", "pyre_fimg_width", "");
INSERT INTO `bupg_postmeta` VALUES("666", "198", "pyre_fimg_height", "");
INSERT INTO `bupg_postmeta` VALUES("667", "198", "_thumbnail_id", "3405");
INSERT INTO `bupg_postmeta` VALUES("668", "198", "pyre_width", "full");
INSERT INTO `bupg_postmeta` VALUES("669", "198", "pyre_video_url", "http://vimeo.com/8245346");
INSERT INTO `bupg_postmeta` VALUES("670", "198", "pyre_page_title_custom_text", "");
INSERT INTO `bupg_postmeta` VALUES("671", "198", "pyre_page_title_custom_subheader", "");
INSERT INTO `bupg_postmeta` VALUES("672", "198", "pyre_page_title_height", "");
INSERT INTO `bupg_postmeta` VALUES("673", "198", "pyre_page_title_bg_parallax", "default");
INSERT INTO `bupg_postmeta` VALUES("674", "198", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("675", "198", "sbg_selected_sidebar_2_replacement", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("676", "198", "fusion_builder_status", "inactive");
INSERT INTO `bupg_postmeta` VALUES("677", "198", "pyre_slider_position", "default");
INSERT INTO `bupg_postmeta` VALUES("678", "198", "pyre_show_first_featured_image", "no");
INSERT INTO `bupg_postmeta` VALUES("679", "198", "pyre_link_icon_target", "no");
INSERT INTO `bupg_postmeta` VALUES("680", "198", "pyre_display_header", "yes");
INSERT INTO `bupg_postmeta` VALUES("681", "198", "pyre_transparent_header", "default");
INSERT INTO `bupg_postmeta` VALUES("682", "198", "pyre_displayed_menu", "default");
INSERT INTO `bupg_postmeta` VALUES("683", "198", "pyre_display_footer", "default");
INSERT INTO `bupg_postmeta` VALUES("684", "198", "pyre_display_copyright", "default");
INSERT INTO `bupg_postmeta` VALUES("685", "198", "sbg_selected_sidebar_2", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("686", "198", "pyre_share_box", "default");
INSERT INTO `bupg_postmeta` VALUES("687", "198", "pyre_post_pagination", "default");
INSERT INTO `bupg_postmeta` VALUES("688", "198", "pyre_main_top_padding", "");
INSERT INTO `bupg_postmeta` VALUES("689", "198", "pyre_main_bottom_padding", "");
INSERT INTO `bupg_postmeta` VALUES("690", "198", "pyre_hundredp_padding", "");
INSERT INTO `bupg_postmeta` VALUES("691", "198", "pyre_header_100_width", "default");
INSERT INTO `bupg_postmeta` VALUES("692", "198", "pyre_header_bg_opacity", "");
INSERT INTO `bupg_postmeta` VALUES("693", "198", "pyre_footer_100_width", "default");
INSERT INTO `bupg_postmeta` VALUES("694", "198", "pyre_page_title_text_alignment", "default");
INSERT INTO `bupg_postmeta` VALUES("695", "198", "pyre_page_title_text_size", "");
INSERT INTO `bupg_postmeta` VALUES("696", "198", "pyre_page_title_custom_subheader_text_size", "");
INSERT INTO `bupg_postmeta` VALUES("697", "198", "pyre_page_title_font_color", "");
INSERT INTO `bupg_postmeta` VALUES("698", "198", "pyre_page_title_breadcrumbs_search_bar", "default");
INSERT INTO `bupg_postmeta` VALUES("699", "10717", "_menu_item_type", "custom");
INSERT INTO `bupg_postmeta` VALUES("700", "10717", "_menu_item_menu_item_parent", "0");
INSERT INTO `bupg_postmeta` VALUES("701", "10717", "_menu_item_object_id", "10717");
INSERT INTO `bupg_postmeta` VALUES("702", "10717", "_menu_item_object", "custom");
INSERT INTO `bupg_postmeta` VALUES("703", "10717", "_menu_item_target", "");
INSERT INTO `bupg_postmeta` VALUES("704", "10717", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("705", "10717", "_menu_item_xfn", "");
INSERT INTO `bupg_postmeta` VALUES("706", "10717", "_menu_item_url", "#");
INSERT INTO `bupg_postmeta` VALUES("707", "10717", "_menu_item_fusion_megamenu_status", "");
INSERT INTO `bupg_postmeta` VALUES("708", "10717", "_menu_item_fusion_megamenu_width", "");
INSERT INTO `bupg_postmeta` VALUES("709", "10717", "_menu_item_fusion_megamenu_columns", "auto");
INSERT INTO `bupg_postmeta` VALUES("710", "10717", "_menu_item_fusion_megamenu_columnwidth", "");
INSERT INTO `bupg_postmeta` VALUES("711", "10717", "_menu_item_fusion_megamenu_title", "");
INSERT INTO `bupg_postmeta` VALUES("712", "10717", "_menu_item_fusion_megamenu_widgetarea", "0");
INSERT INTO `bupg_postmeta` VALUES("713", "10717", "_menu_item_fusion_megamenu_icon", "");
INSERT INTO `bupg_postmeta` VALUES("714", "10717", "_menu_item_fusion_megamenu_thumbnail", "");
INSERT INTO `bupg_postmeta` VALUES("1121", "10722", "_menu_item_type", "custom");
INSERT INTO `bupg_postmeta` VALUES("1122", "10722", "_menu_item_menu_item_parent", "0");
INSERT INTO `bupg_postmeta` VALUES("1123", "10722", "_menu_item_object_id", "10722");
INSERT INTO `bupg_postmeta` VALUES("1124", "10722", "_menu_item_object", "custom");
INSERT INTO `bupg_postmeta` VALUES("1125", "10722", "_menu_item_target", "");
INSERT INTO `bupg_postmeta` VALUES("1126", "10722", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("1127", "10722", "_menu_item_xfn", "");
INSERT INTO `bupg_postmeta` VALUES("1128", "10722", "_menu_item_url", "#");
INSERT INTO `bupg_postmeta` VALUES("1129", "10722", "_menu_item_fusion_megamenu_status", "");
INSERT INTO `bupg_postmeta` VALUES("1130", "10722", "_menu_item_fusion_megamenu_width", "");
INSERT INTO `bupg_postmeta` VALUES("1131", "10722", "_menu_item_fusion_megamenu_columns", "auto");
INSERT INTO `bupg_postmeta` VALUES("1132", "10722", "_menu_item_fusion_megamenu_columnwidth", "");
INSERT INTO `bupg_postmeta` VALUES("1133", "10722", "_menu_item_fusion_megamenu_title", "");
INSERT INTO `bupg_postmeta` VALUES("1134", "10722", "_menu_item_fusion_megamenu_widgetarea", "0");
INSERT INTO `bupg_postmeta` VALUES("1135", "10722", "_menu_item_fusion_megamenu_icon", "");
INSERT INTO `bupg_postmeta` VALUES("1136", "10722", "_menu_item_fusion_megamenu_thumbnail", "");
INSERT INTO `bupg_postmeta` VALUES("1137", "10723", "_menu_item_type", "custom");
INSERT INTO `bupg_postmeta` VALUES("1138", "10723", "_menu_item_menu_item_parent", "0");
INSERT INTO `bupg_postmeta` VALUES("1139", "10723", "_menu_item_object_id", "10723");
INSERT INTO `bupg_postmeta` VALUES("1140", "10723", "_menu_item_object", "custom");
INSERT INTO `bupg_postmeta` VALUES("1141", "10723", "_menu_item_target", "");
INSERT INTO `bupg_postmeta` VALUES("1142", "10723", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("1143", "10723", "_menu_item_xfn", "");
INSERT INTO `bupg_postmeta` VALUES("1144", "10723", "_menu_item_url", "#intro");
INSERT INTO `bupg_postmeta` VALUES("1145", "10723", "_menu_item_fusion_megamenu_status", "");
INSERT INTO `bupg_postmeta` VALUES("1146", "10723", "_menu_item_fusion_megamenu_width", "");
INSERT INTO `bupg_postmeta` VALUES("1147", "10723", "_menu_item_fusion_megamenu_columns", "");
INSERT INTO `bupg_postmeta` VALUES("1148", "10723", "_menu_item_fusion_megamenu_columnwidth", "");
INSERT INTO `bupg_postmeta` VALUES("1149", "10723", "_menu_item_fusion_megamenu_title", "");
INSERT INTO `bupg_postmeta` VALUES("1150", "10723", "_menu_item_fusion_megamenu_widgetarea", "");
INSERT INTO `bupg_postmeta` VALUES("1151", "10723", "_menu_item_fusion_megamenu_icon", "");
INSERT INTO `bupg_postmeta` VALUES("1152", "10723", "_menu_item_fusion_megamenu_thumbnail", "");
INSERT INTO `bupg_postmeta` VALUES("1153", "10724", "_menu_item_type", "custom");
INSERT INTO `bupg_postmeta` VALUES("1154", "10724", "_menu_item_menu_item_parent", "0");
INSERT INTO `bupg_postmeta` VALUES("1155", "10724", "_menu_item_object_id", "10724");
INSERT INTO `bupg_postmeta` VALUES("1156", "10724", "_menu_item_object", "custom");
INSERT INTO `bupg_postmeta` VALUES("1157", "10724", "_menu_item_target", "");
INSERT INTO `bupg_postmeta` VALUES("1158", "10724", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("1159", "10724", "_menu_item_xfn", "");
INSERT INTO `bupg_postmeta` VALUES("1160", "10724", "_menu_item_url", "#features");
INSERT INTO `bupg_postmeta` VALUES("1161", "10724", "_menu_item_fusion_megamenu_status", "");
INSERT INTO `bupg_postmeta` VALUES("1162", "10724", "_menu_item_fusion_megamenu_width", "");
INSERT INTO `bupg_postmeta` VALUES("1163", "10724", "_menu_item_fusion_megamenu_columns", "");
INSERT INTO `bupg_postmeta` VALUES("1164", "10724", "_menu_item_fusion_megamenu_columnwidth", "");
INSERT INTO `bupg_postmeta` VALUES("1165", "10724", "_menu_item_fusion_megamenu_title", "");
INSERT INTO `bupg_postmeta` VALUES("1166", "10724", "_menu_item_fusion_megamenu_widgetarea", "");
INSERT INTO `bupg_postmeta` VALUES("1167", "10724", "_menu_item_fusion_megamenu_icon", "");
INSERT INTO `bupg_postmeta` VALUES("1168", "10724", "_menu_item_fusion_megamenu_thumbnail", "");
INSERT INTO `bupg_postmeta` VALUES("1169", "10725", "_menu_item_type", "custom");
INSERT INTO `bupg_postmeta` VALUES("1170", "10725", "_menu_item_menu_item_parent", "0");
INSERT INTO `bupg_postmeta` VALUES("1171", "10725", "_menu_item_object_id", "10725");
INSERT INTO `bupg_postmeta` VALUES("1172", "10725", "_menu_item_object", "custom");
INSERT INTO `bupg_postmeta` VALUES("1173", "10725", "_menu_item_target", "");
INSERT INTO `bupg_postmeta` VALUES("1174", "10725", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("1175", "10725", "_menu_item_xfn", "");
INSERT INTO `bupg_postmeta` VALUES("1176", "10725", "_menu_item_url", "#pages");
INSERT INTO `bupg_postmeta` VALUES("1177", "10725", "_menu_item_fusion_megamenu_status", "");
INSERT INTO `bupg_postmeta` VALUES("1178", "10725", "_menu_item_fusion_megamenu_width", "");
INSERT INTO `bupg_postmeta` VALUES("1179", "10725", "_menu_item_fusion_megamenu_columns", "");
INSERT INTO `bupg_postmeta` VALUES("1180", "10725", "_menu_item_fusion_megamenu_columnwidth", "");
INSERT INTO `bupg_postmeta` VALUES("1181", "10725", "_menu_item_fusion_megamenu_title", "");
INSERT INTO `bupg_postmeta` VALUES("1182", "10725", "_menu_item_fusion_megamenu_widgetarea", "");
INSERT INTO `bupg_postmeta` VALUES("1183", "10725", "_menu_item_fusion_megamenu_icon", "");
INSERT INTO `bupg_postmeta` VALUES("1184", "10725", "_menu_item_fusion_megamenu_thumbnail", "");
INSERT INTO `bupg_postmeta` VALUES("1185", "10726", "_menu_item_type", "custom");
INSERT INTO `bupg_postmeta` VALUES("1186", "10726", "_menu_item_menu_item_parent", "0");
INSERT INTO `bupg_postmeta` VALUES("1187", "10726", "_menu_item_object_id", "10726");
INSERT INTO `bupg_postmeta` VALUES("1188", "10726", "_menu_item_object", "custom");
INSERT INTO `bupg_postmeta` VALUES("1189", "10726", "_menu_item_target", "");
INSERT INTO `bupg_postmeta` VALUES("1190", "10726", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("1191", "10726", "_menu_item_xfn", "");
INSERT INTO `bupg_postmeta` VALUES("1192", "10726", "_menu_item_url", "#woocommerce");
INSERT INTO `bupg_postmeta` VALUES("1193", "10726", "_menu_item_fusion_megamenu_status", "");
INSERT INTO `bupg_postmeta` VALUES("1194", "10726", "_menu_item_fusion_megamenu_width", "");
INSERT INTO `bupg_postmeta` VALUES("1195", "10726", "_menu_item_fusion_megamenu_columns", "");
INSERT INTO `bupg_postmeta` VALUES("1196", "10726", "_menu_item_fusion_megamenu_columnwidth", "");
INSERT INTO `bupg_postmeta` VALUES("1197", "10726", "_menu_item_fusion_megamenu_title", "");
INSERT INTO `bupg_postmeta` VALUES("1198", "10726", "_menu_item_fusion_megamenu_widgetarea", "");
INSERT INTO `bupg_postmeta` VALUES("1199", "10726", "_menu_item_fusion_megamenu_icon", "");
INSERT INTO `bupg_postmeta` VALUES("1200", "10726", "_menu_item_fusion_megamenu_thumbnail", "");
INSERT INTO `bupg_postmeta` VALUES("1201", "10727", "_menu_item_type", "custom");
INSERT INTO `bupg_postmeta` VALUES("1202", "10727", "_menu_item_menu_item_parent", "0");
INSERT INTO `bupg_postmeta` VALUES("1203", "10727", "_menu_item_object_id", "10727");
INSERT INTO `bupg_postmeta` VALUES("1204", "10727", "_menu_item_object", "custom");
INSERT INTO `bupg_postmeta` VALUES("1205", "10727", "_menu_item_target", "");
INSERT INTO `bupg_postmeta` VALUES("1206", "10727", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("1207", "10727", "_menu_item_xfn", "");
INSERT INTO `bupg_postmeta` VALUES("1208", "10727", "_menu_item_url", "#demo");
INSERT INTO `bupg_postmeta` VALUES("1209", "10727", "_menu_item_fusion_megamenu_status", "");
INSERT INTO `bupg_postmeta` VALUES("1210", "10727", "_menu_item_fusion_megamenu_width", "");
INSERT INTO `bupg_postmeta` VALUES("1211", "10727", "_menu_item_fusion_megamenu_columns", "");
INSERT INTO `bupg_postmeta` VALUES("1212", "10727", "_menu_item_fusion_megamenu_columnwidth", "");
INSERT INTO `bupg_postmeta` VALUES("1213", "10727", "_menu_item_fusion_megamenu_title", "");
INSERT INTO `bupg_postmeta` VALUES("1214", "10727", "_menu_item_fusion_megamenu_widgetarea", "");
INSERT INTO `bupg_postmeta` VALUES("1215", "10727", "_menu_item_fusion_megamenu_icon", "");
INSERT INTO `bupg_postmeta` VALUES("1216", "10727", "_menu_item_fusion_megamenu_thumbnail", "");
INSERT INTO `bupg_postmeta` VALUES("1217", "10728", "_menu_item_type", "custom");
INSERT INTO `bupg_postmeta` VALUES("1218", "10728", "_menu_item_menu_item_parent", "0");
INSERT INTO `bupg_postmeta` VALUES("1219", "10728", "_menu_item_object_id", "10728");
INSERT INTO `bupg_postmeta` VALUES("1220", "10728", "_menu_item_object", "custom");
INSERT INTO `bupg_postmeta` VALUES("1221", "10728", "_menu_item_target", "");
INSERT INTO `bupg_postmeta` VALUES("1222", "10728", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("1223", "10728", "_menu_item_xfn", "");
INSERT INTO `bupg_postmeta` VALUES("1224", "10728", "_menu_item_url", "#shortcodes");
INSERT INTO `bupg_postmeta` VALUES("1225", "10728", "_menu_item_fusion_megamenu_status", "");
INSERT INTO `bupg_postmeta` VALUES("1226", "10728", "_menu_item_fusion_megamenu_width", "");
INSERT INTO `bupg_postmeta` VALUES("1227", "10728", "_menu_item_fusion_megamenu_columns", "");
INSERT INTO `bupg_postmeta` VALUES("1228", "10728", "_menu_item_fusion_megamenu_columnwidth", "");
INSERT INTO `bupg_postmeta` VALUES("1229", "10728", "_menu_item_fusion_megamenu_title", "");
INSERT INTO `bupg_postmeta` VALUES("1230", "10728", "_menu_item_fusion_megamenu_widgetarea", "");
INSERT INTO `bupg_postmeta` VALUES("1231", "10728", "_menu_item_fusion_megamenu_icon", "");
INSERT INTO `bupg_postmeta` VALUES("1232", "10728", "_menu_item_fusion_megamenu_thumbnail", "");
INSERT INTO `bupg_postmeta` VALUES("1233", "10729", "_menu_item_type", "custom");
INSERT INTO `bupg_postmeta` VALUES("1234", "10729", "_menu_item_menu_item_parent", "0");
INSERT INTO `bupg_postmeta` VALUES("1235", "10729", "_menu_item_object_id", "10729");
INSERT INTO `bupg_postmeta` VALUES("1236", "10729", "_menu_item_object", "custom");
INSERT INTO `bupg_postmeta` VALUES("1237", "10729", "_menu_item_target", "");
INSERT INTO `bupg_postmeta` VALUES("1238", "10729", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("1239", "10729", "_menu_item_xfn", "");
INSERT INTO `bupg_postmeta` VALUES("1240", "10729", "_menu_item_url", "#reviews");
INSERT INTO `bupg_postmeta` VALUES("1241", "10729", "_menu_item_fusion_megamenu_status", "");
INSERT INTO `bupg_postmeta` VALUES("1242", "10729", "_menu_item_fusion_megamenu_width", "");
INSERT INTO `bupg_postmeta` VALUES("1243", "10729", "_menu_item_fusion_megamenu_columns", "");
INSERT INTO `bupg_postmeta` VALUES("1244", "10729", "_menu_item_fusion_megamenu_columnwidth", "");
INSERT INTO `bupg_postmeta` VALUES("1245", "10729", "_menu_item_fusion_megamenu_title", "");
INSERT INTO `bupg_postmeta` VALUES("1246", "10729", "_menu_item_fusion_megamenu_widgetarea", "");
INSERT INTO `bupg_postmeta` VALUES("1247", "10729", "_menu_item_fusion_megamenu_icon", "");
INSERT INTO `bupg_postmeta` VALUES("1248", "10729", "_menu_item_fusion_megamenu_thumbnail", "");
INSERT INTO `bupg_postmeta` VALUES("1249", "10730", "_menu_item_type", "custom");
INSERT INTO `bupg_postmeta` VALUES("1250", "10730", "_menu_item_menu_item_parent", "10722");
INSERT INTO `bupg_postmeta` VALUES("1251", "10730", "_menu_item_object_id", "10730");
INSERT INTO `bupg_postmeta` VALUES("1252", "10730", "_menu_item_object", "custom");
INSERT INTO `bupg_postmeta` VALUES("1253", "10730", "_menu_item_target", "");
INSERT INTO `bupg_postmeta` VALUES("1254", "10730", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("1255", "10730", "_menu_item_xfn", "");
INSERT INTO `bupg_postmeta` VALUES("1256", "10730", "_menu_item_url", "#");
INSERT INTO `bupg_postmeta` VALUES("1257", "10730", "_menu_item_fusion_megamenu_status", "enabled");
INSERT INTO `bupg_postmeta` VALUES("1258", "10730", "_menu_item_fusion_megamenu_width", "fullwidth");
INSERT INTO `bupg_postmeta` VALUES("1259", "10730", "_menu_item_fusion_megamenu_columns", "auto");
INSERT INTO `bupg_postmeta` VALUES("1260", "10730", "_menu_item_fusion_megamenu_columnwidth", "");
INSERT INTO `bupg_postmeta` VALUES("1261", "10730", "_menu_item_fusion_megamenu_title", "");
INSERT INTO `bupg_postmeta` VALUES("1262", "10730", "_menu_item_fusion_megamenu_widgetarea", "0");
INSERT INTO `bupg_postmeta` VALUES("1263", "10730", "_menu_item_fusion_megamenu_icon", "");
INSERT INTO `bupg_postmeta` VALUES("1264", "10730", "_menu_item_fusion_megamenu_thumbnail", "");
INSERT INTO `bupg_postmeta` VALUES("1265", "10731", "_menu_item_type", "custom");
INSERT INTO `bupg_postmeta` VALUES("1266", "10731", "_menu_item_menu_item_parent", "10722");
INSERT INTO `bupg_postmeta` VALUES("1267", "10731", "_menu_item_object_id", "10731");
INSERT INTO `bupg_postmeta` VALUES("1268", "10731", "_menu_item_object", "custom");
INSERT INTO `bupg_postmeta` VALUES("1269", "10731", "_menu_item_target", "");
INSERT INTO `bupg_postmeta` VALUES("1270", "10731", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("1271", "10731", "_menu_item_xfn", "");
INSERT INTO `bupg_postmeta` VALUES("1272", "10731", "_menu_item_url", "#");
INSERT INTO `bupg_postmeta` VALUES("1273", "10731", "_menu_item_fusion_megamenu_status", "enabled");
INSERT INTO `bupg_postmeta` VALUES("1274", "10731", "_menu_item_fusion_megamenu_width", "fullwidth");
INSERT INTO `bupg_postmeta` VALUES("1275", "10731", "_menu_item_fusion_megamenu_columns", "auto");
INSERT INTO `bupg_postmeta` VALUES("1276", "10731", "_menu_item_fusion_megamenu_columnwidth", "");
INSERT INTO `bupg_postmeta` VALUES("1277", "10731", "_menu_item_fusion_megamenu_title", "");
INSERT INTO `bupg_postmeta` VALUES("1278", "10731", "_menu_item_fusion_megamenu_widgetarea", "0");
INSERT INTO `bupg_postmeta` VALUES("1279", "10731", "_menu_item_fusion_megamenu_icon", "");
INSERT INTO `bupg_postmeta` VALUES("1280", "10731", "_menu_item_fusion_megamenu_thumbnail", "");
INSERT INTO `bupg_postmeta` VALUES("1281", "10732", "_menu_item_type", "custom");
INSERT INTO `bupg_postmeta` VALUES("1282", "10732", "_menu_item_menu_item_parent", "10722");
INSERT INTO `bupg_postmeta` VALUES("1283", "10732", "_menu_item_object_id", "10732");
INSERT INTO `bupg_postmeta` VALUES("1284", "10732", "_menu_item_object", "custom");
INSERT INTO `bupg_postmeta` VALUES("1285", "10732", "_menu_item_target", "");
INSERT INTO `bupg_postmeta` VALUES("1286", "10732", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("1287", "10732", "_menu_item_xfn", "");
INSERT INTO `bupg_postmeta` VALUES("1288", "10732", "_menu_item_url", "#");
INSERT INTO `bupg_postmeta` VALUES("1289", "10732", "_menu_item_fusion_megamenu_status", "enabled");
INSERT INTO `bupg_postmeta` VALUES("1290", "10732", "_menu_item_fusion_megamenu_width", "fullwidth");
INSERT INTO `bupg_postmeta` VALUES("1291", "10732", "_menu_item_fusion_megamenu_columns", "auto");
INSERT INTO `bupg_postmeta` VALUES("1292", "10732", "_menu_item_fusion_megamenu_columnwidth", "");
INSERT INTO `bupg_postmeta` VALUES("1293", "10732", "_menu_item_fusion_megamenu_title", "");
INSERT INTO `bupg_postmeta` VALUES("1294", "10732", "_menu_item_fusion_megamenu_widgetarea", "0");
INSERT INTO `bupg_postmeta` VALUES("1295", "10732", "_menu_item_fusion_megamenu_icon", "");
INSERT INTO `bupg_postmeta` VALUES("1296", "10732", "_menu_item_fusion_megamenu_thumbnail", "");
INSERT INTO `bupg_postmeta` VALUES("1297", "10733", "_menu_item_type", "custom");
INSERT INTO `bupg_postmeta` VALUES("1298", "10733", "_menu_item_menu_item_parent", "10722");
INSERT INTO `bupg_postmeta` VALUES("1299", "10733", "_menu_item_object_id", "10733");
INSERT INTO `bupg_postmeta` VALUES("1300", "10733", "_menu_item_object", "custom");
INSERT INTO `bupg_postmeta` VALUES("1301", "10733", "_menu_item_target", "");
INSERT INTO `bupg_postmeta` VALUES("1302", "10733", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("1303", "10733", "_menu_item_xfn", "");
INSERT INTO `bupg_postmeta` VALUES("1304", "10733", "_menu_item_url", "#");
INSERT INTO `bupg_postmeta` VALUES("1305", "10733", "_menu_item_fusion_megamenu_status", "enabled");
INSERT INTO `bupg_postmeta` VALUES("1306", "10733", "_menu_item_fusion_megamenu_width", "fullwidth");
INSERT INTO `bupg_postmeta` VALUES("1307", "10733", "_menu_item_fusion_megamenu_columns", "auto");
INSERT INTO `bupg_postmeta` VALUES("1308", "10733", "_menu_item_fusion_megamenu_columnwidth", "");
INSERT INTO `bupg_postmeta` VALUES("1309", "10733", "_menu_item_fusion_megamenu_title", "");
INSERT INTO `bupg_postmeta` VALUES("1310", "10733", "_menu_item_fusion_megamenu_widgetarea", "0");
INSERT INTO `bupg_postmeta` VALUES("1311", "10733", "_menu_item_fusion_megamenu_icon", "");
INSERT INTO `bupg_postmeta` VALUES("1312", "10733", "_menu_item_fusion_megamenu_thumbnail", "");
INSERT INTO `bupg_postmeta` VALUES("1313", "10734", "_menu_item_type", "custom");
INSERT INTO `bupg_postmeta` VALUES("1314", "10734", "_menu_item_menu_item_parent", "10717");
INSERT INTO `bupg_postmeta` VALUES("1315", "10734", "_menu_item_object_id", "10734");
INSERT INTO `bupg_postmeta` VALUES("1316", "10734", "_menu_item_object", "custom");
INSERT INTO `bupg_postmeta` VALUES("1317", "10734", "_menu_item_target", "");
INSERT INTO `bupg_postmeta` VALUES("1318", "10734", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("1319", "10734", "_menu_item_xfn", "");
INSERT INTO `bupg_postmeta` VALUES("1320", "10734", "_menu_item_url", "#");
INSERT INTO `bupg_postmeta` VALUES("1321", "10734", "_menu_item_fusion_megamenu_status", "enabled");
INSERT INTO `bupg_postmeta` VALUES("1322", "10734", "_menu_item_fusion_megamenu_width", "fullwidth");
INSERT INTO `bupg_postmeta` VALUES("1323", "10734", "_menu_item_fusion_megamenu_columns", "auto");
INSERT INTO `bupg_postmeta` VALUES("1324", "10734", "_menu_item_fusion_megamenu_columnwidth", "");
INSERT INTO `bupg_postmeta` VALUES("1325", "10734", "_menu_item_fusion_megamenu_title", "");
INSERT INTO `bupg_postmeta` VALUES("1326", "10734", "_menu_item_fusion_megamenu_widgetarea", "0");
INSERT INTO `bupg_postmeta` VALUES("1327", "10734", "_menu_item_fusion_megamenu_icon", "");
INSERT INTO `bupg_postmeta` VALUES("1328", "10734", "_menu_item_fusion_megamenu_thumbnail", "");
INSERT INTO `bupg_postmeta` VALUES("2085", "86", "pyre_slider", "0");
INSERT INTO `bupg_postmeta` VALUES("2086", "86", "pyre_email", "lukeabeck@gmail.com");
INSERT INTO `bupg_postmeta` VALUES("2087", "86", "pyre_address", "");
INSERT INTO `bupg_postmeta` VALUES("2088", "86", "pyre_phone", "");
INSERT INTO `bupg_postmeta` VALUES("2089", "86", "pyre_gmap", "new york city, ny");
INSERT INTO `bupg_postmeta` VALUES("2090", "86", "_wp_page_template", "default");
INSERT INTO `bupg_postmeta` VALUES("2091", "86", "pyre_main_bottom_padding", "");
INSERT INTO `bupg_postmeta` VALUES("2093", "86", "avada_post_views_count", "100");
INSERT INTO `bupg_postmeta` VALUES("2094", "86", "pyre_page_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("2095", "86", "pyre_slider_type", "no");
INSERT INTO `bupg_postmeta` VALUES("2096", "86", "pyre_wooslider", "0");
INSERT INTO `bupg_postmeta` VALUES("2097", "86", "pyre_fallback", "");
INSERT INTO `bupg_postmeta` VALUES("2098", "86", "pyre_sidebar_position", "right");
INSERT INTO `bupg_postmeta` VALUES("2099", "86", "pyre_portfolio_category", "0");
INSERT INTO `bupg_postmeta` VALUES("2100", "86", "pyre_flexslider", "0");
INSERT INTO `bupg_postmeta` VALUES("2101", "86", "pyre_revslider", "0");
INSERT INTO `bupg_postmeta` VALUES("2102", "86", "pyre_full_width", "no");
INSERT INTO `bupg_postmeta` VALUES("2103", "86", "pyre_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("2104", "86", "pyre_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("2105", "86", "pyre_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("2106", "86", "pyre_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("2107", "86", "pyre_page_title_bar_bg", "none");
INSERT INTO `bupg_postmeta` VALUES("2108", "86", "pyre_elasticslider", "0");
INSERT INTO `bupg_postmeta` VALUES("2109", "86", "pyre_page_title_bar_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("2110", "86", "pyre_portfolio_excerpt", "");
INSERT INTO `bupg_postmeta` VALUES("2111", "86", "pyre_portfolio_full_width", "yes");
INSERT INTO `bupg_postmeta` VALUES("2112", "86", "pyre_portfolio_sidebar_position", "default");
INSERT INTO `bupg_postmeta` VALUES("2113", "86", "pyre_portfolio_filters", "yes");
INSERT INTO `bupg_postmeta` VALUES("2114", "86", "pyre_page_bg_layout", "default");
INSERT INTO `bupg_postmeta` VALUES("2115", "86", "pyre_wide_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("2116", "86", "pyre_wide_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("2117", "86", "pyre_wide_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("2118", "86", "pyre_wide_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("2119", "86", "pyre_header_bg", "");
INSERT INTO `bupg_postmeta` VALUES("2120", "86", "pyre_header_bg_color", "#29292A");
INSERT INTO `bupg_postmeta` VALUES("2121", "86", "pyre_header_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("2122", "86", "pyre_header_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("2123", "86", "pyre_page_title_text", "yes");
INSERT INTO `bupg_postmeta` VALUES("2124", "86", "pyre_page_title_custom_text", "");
INSERT INTO `bupg_postmeta` VALUES("2125", "86", "pyre_page_title_custom_subheader", "");
INSERT INTO `bupg_postmeta` VALUES("2126", "86", "pyre_page_title_height", "54px");
INSERT INTO `bupg_postmeta` VALUES("2127", "86", "pyre_page_title_bar_bg_retina", "");
INSERT INTO `bupg_postmeta` VALUES("2128", "86", "pyre_page_title_bar_bg_full", "default");
INSERT INTO `bupg_postmeta` VALUES("2129", "86", "pyre_page_title_bg_parallax", "default");
INSERT INTO `bupg_postmeta` VALUES("2130", "86", "pyre_image_rollover_icons", "linkzoom");
INSERT INTO `bupg_postmeta` VALUES("2131", "86", "pyre_link_icon_url", "");
INSERT INTO `bupg_postmeta` VALUES("2132", "86", "pyre_slider", "0");
INSERT INTO `bupg_postmeta` VALUES("2133", "86", "pyre_email", "lukeabeck@gmail.com");
INSERT INTO `bupg_postmeta` VALUES("2134", "86", "pyre_address", "");
INSERT INTO `bupg_postmeta` VALUES("2135", "86", "pyre_phone", "");
INSERT INTO `bupg_postmeta` VALUES("2136", "86", "pyre_gmap", "new york city, ny");
INSERT INTO `bupg_postmeta` VALUES("2137", "86", "_wp_page_template", "default");
INSERT INTO `bupg_postmeta` VALUES("2139", "86", "avada_post_views_count", "0");
INSERT INTO `bupg_postmeta` VALUES("2140", "86", "pyre_page_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("2141", "86", "pyre_slider_type", "no");
INSERT INTO `bupg_postmeta` VALUES("2142", "86", "pyre_wooslider", "0");
INSERT INTO `bupg_postmeta` VALUES("2143", "86", "pyre_fallback", "");
INSERT INTO `bupg_postmeta` VALUES("2144", "86", "pyre_sidebar_position", "right");
INSERT INTO `bupg_postmeta` VALUES("2145", "86", "pyre_portfolio_category", "0");
INSERT INTO `bupg_postmeta` VALUES("2146", "86", "pyre_flexslider", "0");
INSERT INTO `bupg_postmeta` VALUES("2147", "86", "pyre_revslider", "0");
INSERT INTO `bupg_postmeta` VALUES("2148", "86", "pyre_full_width", "no");
INSERT INTO `bupg_postmeta` VALUES("2149", "86", "pyre_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("2150", "86", "pyre_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("2151", "86", "pyre_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("2152", "86", "pyre_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("2153", "86", "pyre_page_title_bar_bg", "none");
INSERT INTO `bupg_postmeta` VALUES("2154", "86", "pyre_elasticslider", "0");
INSERT INTO `bupg_postmeta` VALUES("2155", "86", "pyre_page_title_bar_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("2156", "86", "pyre_main_top_padding", "");
INSERT INTO `bupg_postmeta` VALUES("2157", "86", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("2158", "86", "pyre_slider_position", "default");
INSERT INTO `bupg_postmeta` VALUES("2159", "86", "pyre_display_header", "yes");
INSERT INTO `bupg_postmeta` VALUES("2160", "86", "pyre_transparent_header", "default");
INSERT INTO `bupg_postmeta` VALUES("2161", "86", "pyre_displayed_menu", "36");
INSERT INTO `bupg_postmeta` VALUES("2162", "86", "pyre_display_footer", "default");
INSERT INTO `bupg_postmeta` VALUES("2163", "86", "pyre_display_copyright", "default");
INSERT INTO `bupg_postmeta` VALUES("2164", "86", "pyre_hundredp_padding", "");
INSERT INTO `bupg_postmeta` VALUES("2166", "86", "fusion_builder_status", "active");
INSERT INTO `bupg_postmeta` VALUES("2167", "86", "pyre_portfolio_content_length", "default");
INSERT INTO `bupg_postmeta` VALUES("2168", "86", "pyre_portfolio_text_layout", "default");
INSERT INTO `bupg_postmeta` VALUES("2169", "86", "pyre_portfolio_featured_image_size", "default");
INSERT INTO `bupg_postmeta` VALUES("9758", "202", "pyre_video", "");
INSERT INTO `bupg_postmeta` VALUES("9759", "202", "pyre_overall_score", "0");
INSERT INTO `bupg_postmeta` VALUES("9760", "202", "pyre_page_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("9761", "202", "pyre_sidebar_position", "right");
INSERT INTO `bupg_postmeta` VALUES("9762", "202", "pyre_slider_type", "no");
INSERT INTO `bupg_postmeta` VALUES("9763", "202", "pyre_slider", "0");
INSERT INTO `bupg_postmeta` VALUES("9764", "202", "pyre_wooslider", "0");
INSERT INTO `bupg_postmeta` VALUES("9765", "202", "pyre_flexslider", "0");
INSERT INTO `bupg_postmeta` VALUES("9766", "202", "pyre_revslider", "0");
INSERT INTO `bupg_postmeta` VALUES("9767", "202", "pyre_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("9768", "202", "pyre_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("9769", "202", "pyre_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("9770", "202", "pyre_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("9771", "202", "pyre_page_title_bar_bg", "");
INSERT INTO `bupg_postmeta` VALUES("9772", "202", "pyre_fimg_width", "");
INSERT INTO `bupg_postmeta` VALUES("9773", "202", "pyre_fimg_height", "");
INSERT INTO `bupg_postmeta` VALUES("9774", "202", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:12:\"Blog Sidebar\";}");
INSERT INTO `bupg_postmeta` VALUES("9777", "202", "pyre_full_width", "no");
INSERT INTO `bupg_postmeta` VALUES("9778", "202", "pyre_elasticslider", "0");
INSERT INTO `bupg_postmeta` VALUES("9779", "202", "pyre_fallback", "");
INSERT INTO `bupg_postmeta` VALUES("9780", "202", "pyre_page_title_bar_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("9781", "202", "avada_post_views_count", "51");
INSERT INTO `bupg_postmeta` VALUES("9783", "202", "pyre_image_rollover_icons", "linkzoom");
INSERT INTO `bupg_postmeta` VALUES("9784", "202", "pyre_link_icon_url", "");
INSERT INTO `bupg_postmeta` VALUES("9785", "202", "pyre_related_posts", "yes");
INSERT INTO `bupg_postmeta` VALUES("9786", "202", "pyre_page_bg_layout", "default");
INSERT INTO `bupg_postmeta` VALUES("9787", "202", "pyre_wide_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("9788", "202", "pyre_wide_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("9789", "202", "pyre_wide_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("9790", "202", "pyre_wide_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("9791", "202", "pyre_header_bg", "");
INSERT INTO `bupg_postmeta` VALUES("9792", "202", "pyre_header_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("9793", "202", "pyre_header_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("9794", "202", "pyre_header_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("9795", "202", "pyre_page_title_text", "yes");
INSERT INTO `bupg_postmeta` VALUES("9796", "202", "pyre_page_title_bar_bg_retina", "");
INSERT INTO `bupg_postmeta` VALUES("9797", "202", "pyre_page_title_bar_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("9801", "202", "pyre_page_title_custom_text", "");
INSERT INTO `bupg_postmeta` VALUES("9802", "202", "pyre_page_title_custom_subheader", "");
INSERT INTO `bupg_postmeta` VALUES("9803", "202", "pyre_page_title_height", "");
INSERT INTO `bupg_postmeta` VALUES("9804", "202", "pyre_page_title_bg_parallax", "default");
INSERT INTO `bupg_postmeta` VALUES("9805", "202", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("9806", "202", "sbg_selected_sidebar_2", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("9807", "202", "sbg_selected_sidebar_2_replacement", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("9808", "202", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("9810", "202", "fusion_builder_status", "inactive");
INSERT INTO `bupg_postmeta` VALUES("9811", "202", "pyre_slider_position", "default");
INSERT INTO `bupg_postmeta` VALUES("9812", "202", "pyre_display_header", "yes");
INSERT INTO `bupg_postmeta` VALUES("9813", "202", "pyre_transparent_header", "default");
INSERT INTO `bupg_postmeta` VALUES("9814", "202", "pyre_displayed_menu", "default");
INSERT INTO `bupg_postmeta` VALUES("9815", "202", "pyre_display_footer", "default");
INSERT INTO `bupg_postmeta` VALUES("9816", "202", "pyre_display_copyright", "default");
INSERT INTO `bupg_postmeta` VALUES("9818", "207", "pyre_video", "");
INSERT INTO `bupg_postmeta` VALUES("9819", "207", "pyre_overall_score", "0");
INSERT INTO `bupg_postmeta` VALUES("9820", "207", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("9821", "207", "pyre_page_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("9822", "207", "pyre_sidebar_position", "right");
INSERT INTO `bupg_postmeta` VALUES("9823", "207", "pyre_slider_type", "no");
INSERT INTO `bupg_postmeta` VALUES("9824", "207", "pyre_slider", "0");
INSERT INTO `bupg_postmeta` VALUES("9825", "207", "pyre_wooslider", "0");
INSERT INTO `bupg_postmeta` VALUES("9826", "207", "pyre_flexslider", "0");
INSERT INTO `bupg_postmeta` VALUES("9827", "207", "pyre_revslider", "0");
INSERT INTO `bupg_postmeta` VALUES("9828", "207", "pyre_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("9829", "207", "pyre_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("9830", "207", "pyre_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("9831", "207", "pyre_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("9832", "207", "pyre_page_title_bar_bg", "");
INSERT INTO `bupg_postmeta` VALUES("9833", "207", "pyre_fimg_width", "");
INSERT INTO `bupg_postmeta` VALUES("9834", "207", "pyre_fimg_height", "");
INSERT INTO `bupg_postmeta` VALUES("9835", "207", "pyre_full_width", "no");
INSERT INTO `bupg_postmeta` VALUES("9836", "207", "pyre_fallback", "");
INSERT INTO `bupg_postmeta` VALUES("9837", "207", "pyre_page_title_bar_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("9839", "207", "pyre_elasticslider", "0");
INSERT INTO `bupg_postmeta` VALUES("9840", "207", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("9841", "207", "avada_post_views_count", "28");
INSERT INTO `bupg_postmeta` VALUES("9842", "207", "pyre_video", "");
INSERT INTO `bupg_postmeta` VALUES("9843", "207", "pyre_overall_score", "0");
INSERT INTO `bupg_postmeta` VALUES("9844", "207", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("9845", "207", "pyre_page_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("9846", "207", "pyre_sidebar_position", "right");
INSERT INTO `bupg_postmeta` VALUES("9847", "207", "pyre_slider_type", "no");
INSERT INTO `bupg_postmeta` VALUES("9848", "207", "pyre_slider", "0");
INSERT INTO `bupg_postmeta` VALUES("9849", "207", "pyre_wooslider", "0");
INSERT INTO `bupg_postmeta` VALUES("9850", "207", "pyre_flexslider", "0");
INSERT INTO `bupg_postmeta` VALUES("9851", "207", "pyre_revslider", "0");
INSERT INTO `bupg_postmeta` VALUES("9852", "207", "pyre_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("9853", "207", "pyre_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("9854", "207", "pyre_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("9855", "207", "pyre_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("9856", "207", "pyre_page_title_bar_bg", "");
INSERT INTO `bupg_postmeta` VALUES("9857", "207", "pyre_fimg_width", "");
INSERT INTO `bupg_postmeta` VALUES("9858", "207", "pyre_fimg_height", "");
INSERT INTO `bupg_postmeta` VALUES("9859", "207", "pyre_full_width", "no");
INSERT INTO `bupg_postmeta` VALUES("9860", "207", "pyre_fallback", "");
INSERT INTO `bupg_postmeta` VALUES("9861", "207", "pyre_page_title_bar_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("9862", "207", "_thumbnail_id", "3508");
INSERT INTO `bupg_postmeta` VALUES("9863", "207", "pyre_elasticslider", "0");
INSERT INTO `bupg_postmeta` VALUES("9864", "207", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("9866", "209", "avada_post_views_count", "42");
INSERT INTO `bupg_postmeta` VALUES("9867", "209", "pyre_image_rollover_icons", "linkzoom");
INSERT INTO `bupg_postmeta` VALUES("9868", "209", "pyre_link_icon_url", "");
INSERT INTO `bupg_postmeta` VALUES("9869", "209", "pyre_related_posts", "yes");
INSERT INTO `bupg_postmeta` VALUES("9870", "209", "pyre_page_bg_layout", "default");
INSERT INTO `bupg_postmeta` VALUES("9871", "209", "pyre_wide_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("9872", "209", "pyre_wide_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("9873", "209", "pyre_wide_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("9874", "209", "pyre_wide_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("9875", "209", "pyre_header_bg", "");
INSERT INTO `bupg_postmeta` VALUES("9876", "209", "pyre_header_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("9877", "209", "pyre_header_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("9878", "209", "pyre_header_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("9879", "209", "pyre_page_title_text", "yes");
INSERT INTO `bupg_postmeta` VALUES("9880", "209", "pyre_page_title_bar_bg_retina", "");
INSERT INTO `bupg_postmeta` VALUES("9881", "209", "pyre_page_title_bar_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("9883", "209", "pyre_page_title_custom_subheader", "");
INSERT INTO `bupg_postmeta` VALUES("9884", "209", "pyre_video", "");
INSERT INTO `bupg_postmeta` VALUES("9885", "209", "pyre_overall_score", "0");
INSERT INTO `bupg_postmeta` VALUES("9886", "209", "pyre_sidebar_position", "right");
INSERT INTO `bupg_postmeta` VALUES("9887", "209", "pyre_page_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("9888", "209", "pyre_slider", "0");
INSERT INTO `bupg_postmeta` VALUES("9889", "209", "pyre_slider_type", "no");
INSERT INTO `bupg_postmeta` VALUES("9890", "209", "pyre_wooslider", "0");
INSERT INTO `bupg_postmeta` VALUES("9891", "209", "pyre_fallback", "");
INSERT INTO `bupg_postmeta` VALUES("9892", "209", "pyre_flexslider", "0");
INSERT INTO `bupg_postmeta` VALUES("9893", "209", "pyre_revslider", "0");
INSERT INTO `bupg_postmeta` VALUES("9894", "209", "pyre_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("9895", "209", "pyre_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("9896", "209", "pyre_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("9897", "209", "pyre_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("9898", "209", "pyre_page_title_bar_bg", "");
INSERT INTO `bupg_postmeta` VALUES("9899", "209", "pyre_fimg_width", "");
INSERT INTO `bupg_postmeta` VALUES("9900", "209", "pyre_fimg_height", "");
INSERT INTO `bupg_postmeta` VALUES("9901", "209", "pyre_full_width", "no");
INSERT INTO `bupg_postmeta` VALUES("9902", "209", "pyre_page_title_bar_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("9903", "209", "pyre_page_title_custom_text", "");
INSERT INTO `bupg_postmeta` VALUES("9905", "209", "pyre_elasticslider", "0");
INSERT INTO `bupg_postmeta` VALUES("9907", "209", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("9908", "209", "pyre_page_title_height", "");
INSERT INTO `bupg_postmeta` VALUES("9909", "209", "pyre_page_title_bg_parallax", "default");
INSERT INTO `bupg_postmeta` VALUES("9912", "209", "avada_post_views_count", "42");
INSERT INTO `bupg_postmeta` VALUES("9913", "209", "pyre_image_rollover_icons", "linkzoom");
INSERT INTO `bupg_postmeta` VALUES("9914", "209", "pyre_link_icon_url", "");
INSERT INTO `bupg_postmeta` VALUES("9915", "209", "pyre_related_posts", "yes");
INSERT INTO `bupg_postmeta` VALUES("9916", "209", "pyre_page_bg_layout", "default");
INSERT INTO `bupg_postmeta` VALUES("9917", "209", "pyre_wide_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("9918", "209", "pyre_wide_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("9919", "209", "pyre_wide_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("9920", "209", "pyre_wide_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("9921", "209", "pyre_header_bg", "");
INSERT INTO `bupg_postmeta` VALUES("9922", "209", "pyre_header_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("9923", "209", "pyre_header_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("9924", "209", "pyre_header_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("9925", "209", "pyre_page_title_text", "yes");
INSERT INTO `bupg_postmeta` VALUES("9926", "209", "pyre_page_title_bar_bg_retina", "");
INSERT INTO `bupg_postmeta` VALUES("9927", "209", "pyre_page_title_bar_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("9928", "209", "pyre_video", "");
INSERT INTO `bupg_postmeta` VALUES("9929", "209", "pyre_overall_score", "0");
INSERT INTO `bupg_postmeta` VALUES("9930", "209", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("9931", "209", "pyre_sidebar_position", "right");
INSERT INTO `bupg_postmeta` VALUES("9932", "209", "pyre_page_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("9933", "209", "pyre_slider", "0");
INSERT INTO `bupg_postmeta` VALUES("9934", "209", "pyre_slider_type", "no");
INSERT INTO `bupg_postmeta` VALUES("9935", "209", "pyre_wooslider", "0");
INSERT INTO `bupg_postmeta` VALUES("9936", "209", "pyre_fallback", "");
INSERT INTO `bupg_postmeta` VALUES("9937", "209", "pyre_flexslider", "0");
INSERT INTO `bupg_postmeta` VALUES("9938", "209", "pyre_revslider", "0");
INSERT INTO `bupg_postmeta` VALUES("9939", "209", "pyre_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("9940", "209", "pyre_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("9941", "209", "pyre_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("9942", "209", "pyre_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("9943", "209", "pyre_page_title_bar_bg", "");
INSERT INTO `bupg_postmeta` VALUES("9944", "209", "pyre_fimg_width", "");
INSERT INTO `bupg_postmeta` VALUES("9945", "209", "pyre_fimg_height", "");
INSERT INTO `bupg_postmeta` VALUES("9946", "209", "pyre_full_width", "no");
INSERT INTO `bupg_postmeta` VALUES("9947", "209", "pyre_page_title_bar_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("9948", "209", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("9951", "209", "pyre_elasticslider", "0");
INSERT INTO `bupg_postmeta` VALUES("9953", "211", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("9955", "211", "pyre_video", "");
INSERT INTO `bupg_postmeta` VALUES("9956", "211", "pyre_overall_score", "0");
INSERT INTO `bupg_postmeta` VALUES("9957", "211", "pyre_elasticslider", "0");
INSERT INTO `bupg_postmeta` VALUES("9958", "211", "pyre_slider_type", "no");
INSERT INTO `bupg_postmeta` VALUES("9959", "211", "pyre_page_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("9960", "211", "pyre_sidebar_position", "right");
INSERT INTO `bupg_postmeta` VALUES("9961", "211", "pyre_slider", "0");
INSERT INTO `bupg_postmeta` VALUES("9962", "211", "pyre_wooslider", "0");
INSERT INTO `bupg_postmeta` VALUES("9963", "211", "pyre_flexslider", "0");
INSERT INTO `bupg_postmeta` VALUES("9964", "211", "pyre_revslider", "0");
INSERT INTO `bupg_postmeta` VALUES("9965", "211", "pyre_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("9966", "211", "pyre_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("9967", "211", "pyre_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("9968", "211", "pyre_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("9969", "211", "pyre_page_title_bar_bg", "");
INSERT INTO `bupg_postmeta` VALUES("9970", "211", "pyre_fimg_width", "");
INSERT INTO `bupg_postmeta` VALUES("9971", "211", "pyre_fimg_height", "");
INSERT INTO `bupg_postmeta` VALUES("9972", "211", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("9973", "211", "pyre_full_width", "no");
INSERT INTO `bupg_postmeta` VALUES("9974", "211", "pyre_fallback", "");
INSERT INTO `bupg_postmeta` VALUES("9975", "211", "avada_post_views_count", "59");
INSERT INTO `bupg_postmeta` VALUES("9977", "211", "pyre_page_title_bar_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("9978", "211", "pyre_transparent_header", "default");
INSERT INTO `bupg_postmeta` VALUES("9979", "211", "pyre_video", "");
INSERT INTO `bupg_postmeta` VALUES("9980", "211", "pyre_overall_score", "0");
INSERT INTO `bupg_postmeta` VALUES("9981", "211", "pyre_elasticslider", "0");
INSERT INTO `bupg_postmeta` VALUES("9982", "211", "pyre_slider_type", "no");
INSERT INTO `bupg_postmeta` VALUES("9983", "211", "pyre_page_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("9984", "211", "pyre_sidebar_position", "right");
INSERT INTO `bupg_postmeta` VALUES("9985", "211", "pyre_slider", "0");
INSERT INTO `bupg_postmeta` VALUES("9986", "211", "pyre_wooslider", "0");
INSERT INTO `bupg_postmeta` VALUES("9987", "211", "pyre_flexslider", "0");
INSERT INTO `bupg_postmeta` VALUES("9988", "211", "pyre_revslider", "0");
INSERT INTO `bupg_postmeta` VALUES("9989", "211", "pyre_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("9990", "211", "pyre_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("9991", "211", "pyre_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("9992", "211", "pyre_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("9993", "211", "pyre_page_title_bar_bg", "");
INSERT INTO `bupg_postmeta` VALUES("9994", "211", "pyre_fimg_width", "");
INSERT INTO `bupg_postmeta` VALUES("9995", "211", "pyre_fimg_height", "");
INSERT INTO `bupg_postmeta` VALUES("9996", "211", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("9997", "211", "pyre_full_width", "no");
INSERT INTO `bupg_postmeta` VALUES("9998", "211", "pyre_fallback", "");
INSERT INTO `bupg_postmeta` VALUES("9999", "211", "_thumbnail_id", "3508");
INSERT INTO `bupg_postmeta` VALUES("10000", "211", "pyre_page_title_bar_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("10001", "211", "pyre_display_header", "yes");
INSERT INTO `bupg_postmeta` VALUES("10003", "211", "pyre_displayed_menu", "default");
INSERT INTO `bupg_postmeta` VALUES("10004", "211", "pyre_display_footer", "default");
INSERT INTO `bupg_postmeta` VALUES("10005", "211", "pyre_display_copyright", "default");
INSERT INTO `bupg_postmeta` VALUES("10006", "211", "pyre_image_rollover_icons", "linkzoom");
INSERT INTO `bupg_postmeta` VALUES("10007", "211", "pyre_link_icon_url", "");
INSERT INTO `bupg_postmeta` VALUES("10008", "211", "pyre_related_posts", "default");
INSERT INTO `bupg_postmeta` VALUES("10009", "211", "pyre_slider_position", "default");
INSERT INTO `bupg_postmeta` VALUES("10010", "211", "pyre_page_bg_layout", "default");
INSERT INTO `bupg_postmeta` VALUES("10011", "211", "pyre_wide_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("10012", "211", "pyre_wide_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("10013", "211", "pyre_wide_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("10014", "211", "pyre_wide_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("10015", "211", "pyre_header_bg", "");
INSERT INTO `bupg_postmeta` VALUES("10016", "211", "pyre_header_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("10017", "211", "pyre_header_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("10018", "211", "pyre_header_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("10019", "211", "pyre_page_title_text", "yes");
INSERT INTO `bupg_postmeta` VALUES("10020", "211", "pyre_page_title_custom_text", "");
INSERT INTO `bupg_postmeta` VALUES("10021", "211", "pyre_page_title_custom_subheader", "");
INSERT INTO `bupg_postmeta` VALUES("10022", "211", "pyre_page_title_height", "");
INSERT INTO `bupg_postmeta` VALUES("10023", "211", "pyre_page_title_bar_bg_retina", "");
INSERT INTO `bupg_postmeta` VALUES("10024", "211", "pyre_page_title_bar_bg_full", "default");
INSERT INTO `bupg_postmeta` VALUES("10025", "211", "pyre_page_title_bg_parallax", "default");
INSERT INTO `bupg_postmeta` VALUES("10028", "213", "pyre_slider_position", "default");
INSERT INTO `bupg_postmeta` VALUES("10029", "213", "pyre_display_copyright", "default");
INSERT INTO `bupg_postmeta` VALUES("10030", "213", "pyre_display_footer", "default");
INSERT INTO `bupg_postmeta` VALUES("10031", "213", "pyre_displayed_menu", "default");
INSERT INTO `bupg_postmeta` VALUES("10032", "213", "pyre_transparent_header", "default");
INSERT INTO `bupg_postmeta` VALUES("10033", "213", "avada_post_views_count", "496");
INSERT INTO `bupg_postmeta` VALUES("10034", "213", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("10035", "213", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:12:\"Blog Sidebar\";}");
INSERT INTO `bupg_postmeta` VALUES("10036", "213", "pyre_video", "");
INSERT INTO `bupg_postmeta` VALUES("10037", "213", "pyre_overall_score", "0");
INSERT INTO `bupg_postmeta` VALUES("10038", "213", "pyre_page_title_bar_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("10039", "213", "pyre_page_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("10040", "213", "pyre_sidebar_position", "right");
INSERT INTO `bupg_postmeta` VALUES("10041", "213", "pyre_slider_type", "no");
INSERT INTO `bupg_postmeta` VALUES("10042", "213", "pyre_slider", "0");
INSERT INTO `bupg_postmeta` VALUES("10043", "213", "pyre_wooslider", "0");
INSERT INTO `bupg_postmeta` VALUES("10044", "213", "pyre_flexslider", "0");
INSERT INTO `bupg_postmeta` VALUES("10045", "213", "pyre_revslider", "0");
INSERT INTO `bupg_postmeta` VALUES("10046", "213", "pyre_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("10047", "213", "pyre_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("10048", "213", "pyre_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("10049", "213", "pyre_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("10050", "213", "pyre_page_title_bar_bg", "");
INSERT INTO `bupg_postmeta` VALUES("10051", "213", "pyre_fimg_width", "");
INSERT INTO `bupg_postmeta` VALUES("10052", "213", "pyre_fimg_height", "");
INSERT INTO `bupg_postmeta` VALUES("10054", "213", "pyre_full_width", "no");
INSERT INTO `bupg_postmeta` VALUES("10055", "213", "pyre_fallback", "");
INSERT INTO `bupg_postmeta` VALUES("10056", "213", "pyre_display_header", "yes");
INSERT INTO `bupg_postmeta` VALUES("10057", "213", "pyre_elasticslider", "0");
INSERT INTO `bupg_postmeta` VALUES("10061", "213", "pyre_image_rollover_icons", "linkzoom");
INSERT INTO `bupg_postmeta` VALUES("10062", "213", "pyre_link_icon_url", "");
INSERT INTO `bupg_postmeta` VALUES("10063", "213", "pyre_related_posts", "yes");
INSERT INTO `bupg_postmeta` VALUES("10064", "213", "pyre_page_bg_layout", "default");
INSERT INTO `bupg_postmeta` VALUES("10065", "213", "pyre_wide_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("10066", "213", "pyre_wide_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("10067", "213", "pyre_wide_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("10068", "213", "pyre_wide_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("10069", "213", "pyre_header_bg", "");
INSERT INTO `bupg_postmeta` VALUES("10070", "213", "pyre_header_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("10071", "213", "pyre_header_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("10072", "213", "pyre_header_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("10073", "213", "pyre_page_title_text", "yes");
INSERT INTO `bupg_postmeta` VALUES("10074", "213", "pyre_page_title_bar_bg_retina", "");
INSERT INTO `bupg_postmeta` VALUES("10075", "213", "pyre_page_title_bar_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("10079", "213", "pyre_page_title_custom_text", "");
INSERT INTO `bupg_postmeta` VALUES("10080", "213", "pyre_page_title_custom_subheader", "");
INSERT INTO `bupg_postmeta` VALUES("10081", "213", "pyre_page_title_height", "");
INSERT INTO `bupg_postmeta` VALUES("10082", "213", "pyre_page_title_bg_parallax", "default");
INSERT INTO `bupg_postmeta` VALUES("10086", "213", "avada_post_views_count", "496");
INSERT INTO `bupg_postmeta` VALUES("10087", "213", "pyre_video", "");
INSERT INTO `bupg_postmeta` VALUES("10088", "213", "pyre_overall_score", "0");
INSERT INTO `bupg_postmeta` VALUES("10089", "213", "pyre_page_title_bar_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("10090", "213", "pyre_page_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("10091", "213", "pyre_sidebar_position", "right");
INSERT INTO `bupg_postmeta` VALUES("10092", "213", "pyre_slider_type", "no");
INSERT INTO `bupg_postmeta` VALUES("10093", "213", "pyre_slider", "0");
INSERT INTO `bupg_postmeta` VALUES("10094", "213", "pyre_wooslider", "0");
INSERT INTO `bupg_postmeta` VALUES("10095", "213", "pyre_flexslider", "0");
INSERT INTO `bupg_postmeta` VALUES("10096", "213", "pyre_revslider", "0");
INSERT INTO `bupg_postmeta` VALUES("10097", "213", "pyre_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("10098", "213", "pyre_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("10099", "213", "pyre_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("10100", "213", "pyre_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("10101", "213", "pyre_page_title_bar_bg", "");
INSERT INTO `bupg_postmeta` VALUES("10102", "213", "pyre_fimg_width", "");
INSERT INTO `bupg_postmeta` VALUES("10103", "213", "pyre_fimg_height", "");
INSERT INTO `bupg_postmeta` VALUES("10104", "213", "pyre_full_width", "no");
INSERT INTO `bupg_postmeta` VALUES("10105", "213", "pyre_fallback", "");
INSERT INTO `bupg_postmeta` VALUES("10106", "213", "pyre_elasticslider", "0");
INSERT INTO `bupg_postmeta` VALUES("10107", "213", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("10108", "213", "_thumbnail_id", "3508");
INSERT INTO `bupg_postmeta` VALUES("10109", "213", "kd_featured-image-2_post_id", "3508");
INSERT INTO `bupg_postmeta` VALUES("10112", "215", "pyre_page_title_custom_subheader", "");
INSERT INTO `bupg_postmeta` VALUES("10114", "215", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("10115", "215", "pyre_video", "");
INSERT INTO `bupg_postmeta` VALUES("10116", "215", "pyre_page_title_bar_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("10117", "215", "pyre_slider_type", "no");
INSERT INTO `bupg_postmeta` VALUES("10118", "215", "pyre_overall_score", "0");
INSERT INTO `bupg_postmeta` VALUES("10119", "215", "pyre_page_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("10120", "215", "pyre_sidebar_position", "right");
INSERT INTO `bupg_postmeta` VALUES("10121", "215", "pyre_fallback", "");
INSERT INTO `bupg_postmeta` VALUES("10122", "215", "pyre_wooslider", "0");
INSERT INTO `bupg_postmeta` VALUES("10123", "215", "pyre_slider", "0");
INSERT INTO `bupg_postmeta` VALUES("10124", "215", "pyre_flexslider", "0");
INSERT INTO `bupg_postmeta` VALUES("10125", "215", "pyre_revslider", "0");
INSERT INTO `bupg_postmeta` VALUES("10126", "215", "pyre_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("10127", "215", "pyre_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("10128", "215", "pyre_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("10129", "215", "pyre_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("10130", "215", "pyre_page_title_bar_bg", "");
INSERT INTO `bupg_postmeta` VALUES("10131", "215", "pyre_fimg_width", "");
INSERT INTO `bupg_postmeta` VALUES("10132", "215", "pyre_fimg_height", "");
INSERT INTO `bupg_postmeta` VALUES("10133", "215", "pyre_full_width", "no");
INSERT INTO `bupg_postmeta` VALUES("10134", "215", "avada_post_views_count", "91");
INSERT INTO `bupg_postmeta` VALUES("10135", "215", "pyre_elasticslider", "0");
INSERT INTO `bupg_postmeta` VALUES("10138", "215", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:12:\"Blog Sidebar\";}");
INSERT INTO `bupg_postmeta` VALUES("10139", "215", "pyre_image_rollover_icons", "linkzoom");
INSERT INTO `bupg_postmeta` VALUES("10140", "215", "pyre_link_icon_url", "");
INSERT INTO `bupg_postmeta` VALUES("10141", "215", "pyre_related_posts", "yes");
INSERT INTO `bupg_postmeta` VALUES("10142", "215", "pyre_page_bg_layout", "default");
INSERT INTO `bupg_postmeta` VALUES("10143", "215", "pyre_wide_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("10144", "215", "pyre_wide_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("10145", "215", "pyre_wide_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("10146", "215", "pyre_wide_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("10147", "215", "pyre_header_bg", "");
INSERT INTO `bupg_postmeta` VALUES("10148", "215", "pyre_header_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("10149", "215", "pyre_header_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("10150", "215", "pyre_header_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("10151", "215", "pyre_page_title_text", "yes");
INSERT INTO `bupg_postmeta` VALUES("10152", "215", "pyre_page_title_bar_bg_retina", "");
INSERT INTO `bupg_postmeta` VALUES("10153", "215", "pyre_page_title_bar_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("10155", "215", "pyre_page_title_height", "");
INSERT INTO `bupg_postmeta` VALUES("10156", "215", "pyre_page_title_bg_parallax", "default");
INSERT INTO `bupg_postmeta` VALUES("10157", "215", "pyre_video", "");
INSERT INTO `bupg_postmeta` VALUES("10158", "215", "pyre_page_title_custom_text", "");
INSERT INTO `bupg_postmeta` VALUES("10159", "215", "pyre_page_title_bar_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("10160", "215", "pyre_slider_type", "no");
INSERT INTO `bupg_postmeta` VALUES("10161", "215", "pyre_overall_score", "0");
INSERT INTO `bupg_postmeta` VALUES("10162", "215", "pyre_page_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("10163", "215", "pyre_sidebar_position", "right");
INSERT INTO `bupg_postmeta` VALUES("10164", "215", "pyre_fallback", "");
INSERT INTO `bupg_postmeta` VALUES("10165", "215", "pyre_wooslider", "0");
INSERT INTO `bupg_postmeta` VALUES("10166", "215", "pyre_slider", "0");
INSERT INTO `bupg_postmeta` VALUES("10167", "215", "pyre_flexslider", "0");
INSERT INTO `bupg_postmeta` VALUES("10168", "215", "pyre_revslider", "0");
INSERT INTO `bupg_postmeta` VALUES("10169", "215", "pyre_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("10170", "215", "pyre_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("10171", "215", "pyre_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("10172", "215", "pyre_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("10173", "215", "pyre_page_title_bar_bg", "");
INSERT INTO `bupg_postmeta` VALUES("10174", "215", "pyre_fimg_width", "");
INSERT INTO `bupg_postmeta` VALUES("10175", "215", "pyre_fimg_height", "");
INSERT INTO `bupg_postmeta` VALUES("10176", "215", "pyre_full_width", "no");
INSERT INTO `bupg_postmeta` VALUES("10177", "215", "avada_post_views_count", "91");
INSERT INTO `bupg_postmeta` VALUES("10178", "215", "pyre_elasticslider", "0");
INSERT INTO `bupg_postmeta` VALUES("10179", "215", "_thumbnail_id", "3508");
INSERT INTO `bupg_postmeta` VALUES("10181", "215", "pyre_display_copyright", "default");
INSERT INTO `bupg_postmeta` VALUES("10182", "215", "pyre_display_footer", "default");
INSERT INTO `bupg_postmeta` VALUES("10183", "215", "pyre_displayed_menu", "default");
INSERT INTO `bupg_postmeta` VALUES("10184", "215", "pyre_transparent_header", "default");
INSERT INTO `bupg_postmeta` VALUES("10185", "215", "pyre_display_header", "yes");
INSERT INTO `bupg_postmeta` VALUES("10186", "215", "pyre_slider_position", "default");
INSERT INTO `bupg_postmeta` VALUES("10187", "215", "fusion_builder_status", "inactive");
INSERT INTO `bupg_postmeta` VALUES("10188", "215", "sbg_selected_sidebar_2", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("10189", "215", "sbg_selected_sidebar_2_replacement", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("10190", "215", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("11017", "4052", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("11018", "4052", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("11019", "4052", "pyre_caption_1", "Elastic Slider");
INSERT INTO `bupg_postmeta` VALUES("11020", "4052", "pyre_caption_2", "Simple. Elegant. Beautiful.");
INSERT INTO `bupg_postmeta` VALUES("11022", "4055", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("11023", "4055", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("11024", "4055", "pyre_caption_1", "Elastic Slider");
INSERT INTO `bupg_postmeta` VALUES("11025", "4055", "pyre_caption_2", "Simple. Elegant. Beautiful.");
INSERT INTO `bupg_postmeta` VALUES("11026", "9548", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("11027", "9548", "pyre_type", "self-hosted-video");
INSERT INTO `bupg_postmeta` VALUES("11028", "9548", "pyre_youtube_id", "");
INSERT INTO `bupg_postmeta` VALUES("11029", "9548", "pyre_vimeo_id", "");
INSERT INTO `bupg_postmeta` VALUES("11030", "9548", "pyre_webm", "http://theme-fusion.com/avadaxml/wp-content/uploads/2014/11/171328.webm");
INSERT INTO `bupg_postmeta` VALUES("11031", "9548", "pyre_mp4", "http://theme-fusion.com/avadaxml/wp-content/uploads/2014/11/171328.mp4");
INSERT INTO `bupg_postmeta` VALUES("11032", "9548", "pyre_ogv", "");
INSERT INTO `bupg_postmeta` VALUES("11033", "9548", "pyre_preview_image", "http://theme-fusion.com/avadaxml/wp-content/uploads/2014/11/171328_preview.jpg");
INSERT INTO `bupg_postmeta` VALUES("11034", "9548", "pyre_video_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("11035", "9548", "pyre_mute_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("11036", "9548", "pyre_autoplay_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("11037", "9548", "pyre_loop_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("11038", "9548", "pyre_hide_video_controls", "yes");
INSERT INTO `bupg_postmeta` VALUES("11039", "9548", "pyre_content_alignment", "right");
INSERT INTO `bupg_postmeta` VALUES("11040", "9548", "pyre_heading", "Fusion Slider");
INSERT INTO `bupg_postmeta` VALUES("11041", "9548", "pyre_heading_font_size", "85");
INSERT INTO `bupg_postmeta` VALUES("11042", "9548", "pyre_heading_color", "");
INSERT INTO `bupg_postmeta` VALUES("11043", "9548", "pyre_heading_bg", "yes");
INSERT INTO `bupg_postmeta` VALUES("11044", "9548", "pyre_caption", "Responsive, Parallax Effect, Custom Options,<br /> Video Support, Full Screen & More");
INSERT INTO `bupg_postmeta` VALUES("11045", "9548", "pyre_caption_font_size", "");
INSERT INTO `bupg_postmeta` VALUES("11046", "9548", "pyre_caption_color", "#fff");
INSERT INTO `bupg_postmeta` VALUES("11047", "9548", "pyre_caption_bg", "no");
INSERT INTO `bupg_postmeta` VALUES("11048", "9548", "pyre_link_type", "button");
INSERT INTO `bupg_postmeta` VALUES("11049", "9548", "pyre_slide_link", "");
INSERT INTO `bupg_postmeta` VALUES("11050", "9548", "pyre_button_1", "[button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"custom\" size=\"xlarge\" type=\"flat\" shape=\"round\" target=\"_self\" title=\"\" gradient_colors=\"transparent\" gradient_hover_colors=\"rgba(255,255,255,.1)\" accent_color=\"rgba(255,255,255,.7)\" accent_hover_color=\"#fff\" bevel_color=\"\" border_width=\"1px\" shadow=\"no\" icon=\"\" icon_divider=\"no\" icon_position=\"\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Learn More[/button]");
INSERT INTO `bupg_postmeta` VALUES("11051", "9548", "pyre_button_2", "[button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"custom\" size=\"xlarge\" type=\"flat\" shape=\"round\" target=\"_self\" title=\"\" gradient_colors=\"#a0ce4e\" gradient_hover_colors=\"#87be22\" accent_color=\"rgba(255,255,255,.8)\" accent_hover_color=\"rgba(255,255,255,.9)\" bevel_color=\"\" border_width=\"0px\" shadow=\"no\" icon=\"\" icon_divider=\"no\" icon_position=\"\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Buy Avada Now[/button]");
INSERT INTO `bupg_postmeta` VALUES("11052", "9552", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("11053", "9552", "pyre_type", "image");
INSERT INTO `bupg_postmeta` VALUES("11054", "9552", "pyre_youtube_id", "");
INSERT INTO `bupg_postmeta` VALUES("11055", "9552", "pyre_vimeo_id", "");
INSERT INTO `bupg_postmeta` VALUES("11056", "9552", "pyre_webm", "");
INSERT INTO `bupg_postmeta` VALUES("11057", "9552", "pyre_mp4", "");
INSERT INTO `bupg_postmeta` VALUES("11058", "9552", "pyre_ogv", "");
INSERT INTO `bupg_postmeta` VALUES("11059", "9552", "pyre_preview_image", "");
INSERT INTO `bupg_postmeta` VALUES("11060", "9552", "pyre_video_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("11061", "9552", "pyre_mute_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("11062", "9552", "pyre_autoplay_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("11063", "9552", "pyre_loop_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("11064", "9552", "pyre_hide_video_controls", "yes");
INSERT INTO `bupg_postmeta` VALUES("11065", "9552", "pyre_content_alignment", "left");
INSERT INTO `bupg_postmeta` VALUES("11066", "9552", "pyre_heading", "Beauty & Brains");
INSERT INTO `bupg_postmeta` VALUES("11067", "9552", "pyre_heading_font_size", "");
INSERT INTO `bupg_postmeta` VALUES("11068", "9552", "pyre_heading_color", "");
INSERT INTO `bupg_postmeta` VALUES("11069", "9552", "pyre_heading_bg", "yes");
INSERT INTO `bupg_postmeta` VALUES("11070", "9552", "pyre_caption", "Beautiful parallax scrolling effect & intelligent options.");
INSERT INTO `bupg_postmeta` VALUES("11071", "9552", "pyre_caption_font_size", "");
INSERT INTO `bupg_postmeta` VALUES("11072", "9552", "pyre_caption_color", "");
INSERT INTO `bupg_postmeta` VALUES("11073", "9552", "pyre_caption_bg", "yes");
INSERT INTO `bupg_postmeta` VALUES("11074", "9552", "pyre_link_type", "button");
INSERT INTO `bupg_postmeta` VALUES("11075", "9552", "pyre_slide_link", "");
INSERT INTO `bupg_postmeta` VALUES("11076", "9552", "pyre_button_1", "[button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"custom\" size=\"xlarge\" type=\"flat\" shape=\"round\" target=\"_self\" title=\"\" gradient_colors=\"transparent\" gradient_hover_colors=\"rgba(255,255,255,.1)\" accent_color=\"rgba(255,255,255,.8)\" accent_hover_color=\"#fff\" bevel_color=\"\" border_width=\"1px\" shadow=\"no\" icon=\"\" icon_divider=\"no\" icon_position=\"\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Button Text[/button]");
INSERT INTO `bupg_postmeta` VALUES("11077", "9552", "pyre_button_2", "[button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"custom\" size=\"xlarge\" type=\"flat\" shape=\"round\" target=\"_self\" title=\"\" gradient_colors=\"#a0ce4e\" gradient_hover_colors=\"#87be22\" accent_color=\"rgba(255,255,255,.8)\" accent_hover_color=\"rgba(255,255,255,.9)\" bevel_color=\"\" border_width=\"0px\" shadow=\"no\" icon=\"\" icon_divider=\"no\" icon_position=\"\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Buy Avada Now[/button]");
INSERT INTO `bupg_postmeta` VALUES("11079", "9564", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("11080", "9564", "pyre_type", "self-hosted-video");
INSERT INTO `bupg_postmeta` VALUES("11081", "9564", "pyre_youtube_id", "");
INSERT INTO `bupg_postmeta` VALUES("11082", "9564", "pyre_vimeo_id", "");
INSERT INTO `bupg_postmeta` VALUES("11083", "9564", "pyre_webm", "http://theme-fusion.com/avadaxml/wp-content/uploads/2014/11/Hand-With-Wedding-Ring.webm");
INSERT INTO `bupg_postmeta` VALUES("11084", "9564", "pyre_mp4", "http://theme-fusion.com/avadaxml/wp-content/uploads/2014/11/Hand-With-Wedding-Ring.mp4");
INSERT INTO `bupg_postmeta` VALUES("11085", "9564", "pyre_ogv", "");
INSERT INTO `bupg_postmeta` VALUES("11086", "9564", "pyre_preview_image", "http://theme-fusion.com/avadaxml/wp-content/uploads/2014/11/Hand-With-Wedding-Ring_preview.jpg");
INSERT INTO `bupg_postmeta` VALUES("11087", "9564", "pyre_video_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("11088", "9564", "pyre_mute_video", "no");
INSERT INTO `bupg_postmeta` VALUES("11089", "9564", "pyre_autoplay_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("11090", "9564", "pyre_loop_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("11091", "9564", "pyre_hide_video_controls", "yes");
INSERT INTO `bupg_postmeta` VALUES("11092", "9564", "pyre_content_alignment", "center");
INSERT INTO `bupg_postmeta` VALUES("11093", "9564", "pyre_heading", "Fusion Slider Is Here");
INSERT INTO `bupg_postmeta` VALUES("11094", "9564", "pyre_heading_font_size", "");
INSERT INTO `bupg_postmeta` VALUES("11095", "9564", "pyre_heading_color", "#000");
INSERT INTO `bupg_postmeta` VALUES("11096", "9564", "pyre_heading_bg", "no");
INSERT INTO `bupg_postmeta` VALUES("11097", "9564", "pyre_caption", "Simply amazing and fun to use. It\'s bold, beautiful & brilliant.");
INSERT INTO `bupg_postmeta` VALUES("11098", "9564", "pyre_caption_font_size", "");
INSERT INTO `bupg_postmeta` VALUES("11099", "9564", "pyre_caption_color", "#000");
INSERT INTO `bupg_postmeta` VALUES("11100", "9564", "pyre_caption_bg", "no");
INSERT INTO `bupg_postmeta` VALUES("11101", "9564", "pyre_link_type", "button");
INSERT INTO `bupg_postmeta` VALUES("11102", "9564", "pyre_slide_link", "");
INSERT INTO `bupg_postmeta` VALUES("11103", "9564", "pyre_button_1", "[button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"custom\" size=\"xlarge\" type=\"flat\" shape=\"round\" target=\"_self\" title=\"\" gradient_colors=\"transparent\" gradient_hover_colors=\"rgba(0,0,0,.1)\" accent_color=\"rgba(0,0,0,.7)\" accent_hover_color=\"#000\" bevel_color=\"\" border_width=\"1px\" shadow=\"no\" icon=\"\" icon_divider=\"no\" icon_position=\"\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Learn More[/button]");
INSERT INTO `bupg_postmeta` VALUES("11104", "9564", "pyre_button_2", "[button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"custom\" size=\"xlarge\" type=\"flat\" shape=\"round\" target=\"_self\" title=\"\" gradient_colors=\"#a0ce4e\" gradient_hover_colors=\"#87be22\" accent_color=\"rgba(255,255,255,.8)\" accent_hover_color=\"rgba(255,255,255,.9)\" bevel_color=\"\" border_width=\"0px\" shadow=\"no\" icon=\"\" icon_divider=\"no\" icon_position=\"\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Buy Avada Now[/button]");
INSERT INTO `bupg_postmeta` VALUES("11161", "9578", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("11162", "9578", "pyre_type", "self-hosted-video");
INSERT INTO `bupg_postmeta` VALUES("11163", "9578", "pyre_youtube_id", "");
INSERT INTO `bupg_postmeta` VALUES("11164", "9578", "pyre_vimeo_id", "");
INSERT INTO `bupg_postmeta` VALUES("11165", "9578", "pyre_webm", "http://theme-fusion.com/avadaxml/wp-content/uploads/2014/11/shutterstock_3743237.webm");
INSERT INTO `bupg_postmeta` VALUES("11166", "9578", "pyre_mp4", "http://theme-fusion.com/avadaxml/wp-content/uploads/2014/11/shutterstock_3743237.mp4");
INSERT INTO `bupg_postmeta` VALUES("11167", "9578", "pyre_ogv", "");
INSERT INTO `bupg_postmeta` VALUES("11168", "9578", "pyre_preview_image", "http://theme-fusion.com/avadaxml/wp-content/uploads/2014/11/shutterstock_3743237_preview.jpg");
INSERT INTO `bupg_postmeta` VALUES("11169", "9578", "pyre_video_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("11170", "9578", "pyre_mute_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("11171", "9578", "pyre_autoplay_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("11172", "9578", "pyre_loop_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("11173", "9578", "pyre_hide_video_controls", "yes");
INSERT INTO `bupg_postmeta` VALUES("11174", "9578", "pyre_content_alignment", "center");
INSERT INTO `bupg_postmeta` VALUES("11175", "9578", "pyre_heading", "Fusion Slider Is Here.<br /> Beauty & Brains.");
INSERT INTO `bupg_postmeta` VALUES("11176", "9578", "pyre_heading_font_size", "85");
INSERT INTO `bupg_postmeta` VALUES("11177", "9578", "pyre_heading_color", "#333333");
INSERT INTO `bupg_postmeta` VALUES("11178", "9578", "pyre_heading_bg", "no");
INSERT INTO `bupg_postmeta` VALUES("11179", "9578", "pyre_caption", "");
INSERT INTO `bupg_postmeta` VALUES("11180", "9578", "pyre_caption_font_size", "");
INSERT INTO `bupg_postmeta` VALUES("11181", "9578", "pyre_caption_color", "");
INSERT INTO `bupg_postmeta` VALUES("11182", "9578", "pyre_caption_bg", "yes");
INSERT INTO `bupg_postmeta` VALUES("11183", "9578", "pyre_link_type", "button");
INSERT INTO `bupg_postmeta` VALUES("11184", "9578", "pyre_slide_link", "");
INSERT INTO `bupg_postmeta` VALUES("11185", "9578", "pyre_button_1", "[button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"custom\" size=\"xlarge\" type=\"flat\" shape=\"round\" target=\"_self\" title=\"\" gradient_colors=\"transparent\" gradient_hover_colors=\"rgba(0,0,0,.1)\" accent_color=\"rgba(0,0,0,.7)\" accent_hover_color=\"#000\" bevel_color=\"\" border_width=\"1px\" shadow=\"no\" icon=\"\" icon_divider=\"no\" icon_position=\"\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Learn More[/button]");
INSERT INTO `bupg_postmeta` VALUES("11186", "9578", "pyre_button_2", "[button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"custom\" size=\"xlarge\" type=\"flat\" shape=\"round\" target=\"_self\" title=\"\" gradient_colors=\"#a0ce4e\" gradient_hover_colors=\"#87be22\" accent_color=\"rgba(255,255,255,.8)\" accent_hover_color=\"rgba(255,255,255,.9)\" bevel_color=\"\" border_width=\"0px\" shadow=\"no\" icon=\"\" icon_divider=\"no\" icon_position=\"\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Buy Avada Now[/button]");
INSERT INTO `bupg_postmeta` VALUES("11188", "9611", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("11189", "9611", "pyre_type", "image");
INSERT INTO `bupg_postmeta` VALUES("11190", "9611", "pyre_youtube_id", "");
INSERT INTO `bupg_postmeta` VALUES("11191", "9611", "pyre_vimeo_id", "");
INSERT INTO `bupg_postmeta` VALUES("11192", "9611", "pyre_webm", "");
INSERT INTO `bupg_postmeta` VALUES("11193", "9611", "pyre_mp4", "");
INSERT INTO `bupg_postmeta` VALUES("11194", "9611", "pyre_ogv", "");
INSERT INTO `bupg_postmeta` VALUES("11195", "9611", "pyre_preview_image", "");
INSERT INTO `bupg_postmeta` VALUES("11196", "9611", "pyre_video_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("11197", "9611", "pyre_mute_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("11198", "9611", "pyre_autoplay_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("11199", "9611", "pyre_loop_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("11200", "9611", "pyre_hide_video_controls", "yes");
INSERT INTO `bupg_postmeta` VALUES("11201", "9611", "pyre_content_alignment", "left");
INSERT INTO `bupg_postmeta` VALUES("11202", "9611", "pyre_heading", "Create Beauty");
INSERT INTO `bupg_postmeta` VALUES("11203", "9611", "pyre_heading_font_size", "");
INSERT INTO `bupg_postmeta` VALUES("11204", "9611", "pyre_heading_color", "#333333");
INSERT INTO `bupg_postmeta` VALUES("11205", "9611", "pyre_heading_bg", "no");
INSERT INTO `bupg_postmeta` VALUES("11206", "9611", "pyre_caption", "With Your Creativity");
INSERT INTO `bupg_postmeta` VALUES("11207", "9611", "pyre_caption_font_size", "");
INSERT INTO `bupg_postmeta` VALUES("11208", "9611", "pyre_caption_color", "");
INSERT INTO `bupg_postmeta` VALUES("11209", "9611", "pyre_caption_bg", "yes");
INSERT INTO `bupg_postmeta` VALUES("11210", "9611", "pyre_link_type", "full");
INSERT INTO `bupg_postmeta` VALUES("11211", "9611", "pyre_slide_link", "http://enva.to/154eBMk");
INSERT INTO `bupg_postmeta` VALUES("11212", "9611", "pyre_button_1", "[button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"custom\" size=\"large\" type=\"flat\" shape=\"round\" target=\"_self\" title=\"\" gradient_colors=\"transparent\" gradient_hover_colors=\"rgba(0,0,0,.1)\" accent_color=\"rgba(0,0,0,.7)\" accent_hover_color=\"#000\" bevel_color=\"\" border_width=\"1px\" shadow=\"no\" icon=\"\" icon_divider=\"no\" icon_position=\"\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Learn More[/button]");
INSERT INTO `bupg_postmeta` VALUES("11213", "9611", "pyre_button_2", "[button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"custom\" size=\"large\" type=\"flat\" shape=\"round\" target=\"_self\" title=\"\" gradient_colors=\"#a0ce4e\" gradient_hover_colors=\"#7db21d\" accent_color=\"rgba(255,255,255,.9)\" accent_hover_color=\"#fff\" bevel_color=\"\" border_width=\"0px\" shadow=\"no\" icon=\"\" icon_divider=\"no\" icon_position=\"\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Buy Avada Now[/button]");
INSERT INTO `bupg_postmeta` VALUES("11214", "9613", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("11215", "9613", "pyre_type", "youtube");
INSERT INTO `bupg_postmeta` VALUES("11216", "9613", "pyre_youtube_id", "nACpDR1twKU");
INSERT INTO `bupg_postmeta` VALUES("11217", "9613", "pyre_vimeo_id", "");
INSERT INTO `bupg_postmeta` VALUES("11218", "9613", "pyre_webm", "");
INSERT INTO `bupg_postmeta` VALUES("11219", "9613", "pyre_mp4", "");
INSERT INTO `bupg_postmeta` VALUES("11220", "9613", "pyre_ogv", "");
INSERT INTO `bupg_postmeta` VALUES("11221", "9613", "pyre_preview_image", "");
INSERT INTO `bupg_postmeta` VALUES("11222", "9613", "pyre_video_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("11223", "9613", "pyre_mute_video", "no");
INSERT INTO `bupg_postmeta` VALUES("11224", "9613", "pyre_autoplay_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("11225", "9613", "pyre_loop_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("11226", "9613", "pyre_hide_video_controls", "no");
INSERT INTO `bupg_postmeta` VALUES("11227", "9613", "pyre_content_alignment", "left");
INSERT INTO `bupg_postmeta` VALUES("11228", "9613", "pyre_heading", "");
INSERT INTO `bupg_postmeta` VALUES("11229", "9613", "pyre_heading_font_size", "");
INSERT INTO `bupg_postmeta` VALUES("11230", "9613", "pyre_heading_color", "");
INSERT INTO `bupg_postmeta` VALUES("11231", "9613", "pyre_heading_bg", "yes");
INSERT INTO `bupg_postmeta` VALUES("11232", "9613", "pyre_caption", "");
INSERT INTO `bupg_postmeta` VALUES("11233", "9613", "pyre_caption_font_size", "");
INSERT INTO `bupg_postmeta` VALUES("11234", "9613", "pyre_caption_color", "");
INSERT INTO `bupg_postmeta` VALUES("11235", "9613", "pyre_caption_bg", "yes");
INSERT INTO `bupg_postmeta` VALUES("11236", "9613", "pyre_link_type", "full");
INSERT INTO `bupg_postmeta` VALUES("11237", "9613", "pyre_slide_link", "");
INSERT INTO `bupg_postmeta` VALUES("11238", "9613", "pyre_button_1", "[button link=\"\" color=\"default\" size=\"\" type=\"\" shape=\"\" target=\"_self\" title=\"\" gradient_colors=\"|\" gradient_hover_colors=\"|\" accent_color=\"\" accent_hover_color=\"\" bevel_color=\"\" border_width=\"1px\" shadow=\"\" icon=\"\" icon_divider=\"yes\" icon_position=\"left\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Button Text[/button]");
INSERT INTO `bupg_postmeta` VALUES("11239", "9613", "pyre_button_2", "[button link=\"\" color=\"default\" size=\"\" type=\"\" shape=\"\" target=\"_self\" title=\"\" gradient_colors=\"|\" gradient_hover_colors=\"|\" accent_color=\"\" accent_hover_color=\"\" bevel_color=\"\" border_width=\"1px\" shadow=\"\" icon=\"\" icon_divider=\"yes\" icon_position=\"left\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Button Text[/button]");
INSERT INTO `bupg_postmeta` VALUES("11240", "9688", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("11241", "9688", "pyre_type", "vimeo");
INSERT INTO `bupg_postmeta` VALUES("11242", "9688", "pyre_youtube_id", "");
INSERT INTO `bupg_postmeta` VALUES("11243", "9688", "pyre_vimeo_id", "64038952");
INSERT INTO `bupg_postmeta` VALUES("11244", "9688", "pyre_webm", "");
INSERT INTO `bupg_postmeta` VALUES("11245", "9688", "pyre_mp4", "");
INSERT INTO `bupg_postmeta` VALUES("11246", "9688", "pyre_ogv", "");
INSERT INTO `bupg_postmeta` VALUES("11247", "9688", "pyre_preview_image", "");
INSERT INTO `bupg_postmeta` VALUES("11248", "9688", "pyre_video_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("11249", "9688", "pyre_mute_video", "no");
INSERT INTO `bupg_postmeta` VALUES("11250", "9688", "pyre_autoplay_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("11251", "9688", "pyre_loop_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("11252", "9688", "pyre_hide_video_controls", "yes");
INSERT INTO `bupg_postmeta` VALUES("11253", "9688", "pyre_content_alignment", "left");
INSERT INTO `bupg_postmeta` VALUES("11254", "9688", "pyre_heading", "");
INSERT INTO `bupg_postmeta` VALUES("11255", "9688", "pyre_heading_font_size", "");
INSERT INTO `bupg_postmeta` VALUES("11256", "9688", "pyre_heading_color", "");
INSERT INTO `bupg_postmeta` VALUES("11257", "9688", "pyre_heading_bg", "yes");
INSERT INTO `bupg_postmeta` VALUES("11258", "9688", "pyre_caption", "");
INSERT INTO `bupg_postmeta` VALUES("11259", "9688", "pyre_caption_font_size", "");
INSERT INTO `bupg_postmeta` VALUES("11260", "9688", "pyre_caption_color", "");
INSERT INTO `bupg_postmeta` VALUES("11261", "9688", "pyre_caption_bg", "yes");
INSERT INTO `bupg_postmeta` VALUES("11262", "9688", "pyre_link_type", "full");
INSERT INTO `bupg_postmeta` VALUES("11263", "9688", "pyre_slide_link", "");
INSERT INTO `bupg_postmeta` VALUES("11264", "9688", "pyre_button_1", "[button link=\"\" color=\"default\" size=\"\" type=\"\" shape=\"\" target=\"_self\" title=\"\" gradient_colors=\"|\" gradient_hover_colors=\"|\" accent_color=\"\" accent_hover_color=\"\" bevel_color=\"\" border_width=\"1px\" shadow=\"\" icon=\"\" icon_divider=\"yes\" icon_position=\"left\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Button Text[/button]");
INSERT INTO `bupg_postmeta` VALUES("11265", "9688", "pyre_button_2", "[button link=\"\" color=\"default\" size=\"\" type=\"\" shape=\"\" target=\"_self\" title=\"\" gradient_colors=\"|\" gradient_hover_colors=\"|\" accent_color=\"\" accent_hover_color=\"\" bevel_color=\"\" border_width=\"1px\" shadow=\"\" icon=\"\" icon_divider=\"yes\" icon_position=\"left\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Button Text[/button]");
INSERT INTO `bupg_postmeta` VALUES("11266", "9719", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("11267", "9719", "pyre_type", "image");
INSERT INTO `bupg_postmeta` VALUES("11268", "9719", "pyre_youtube_id", "");
INSERT INTO `bupg_postmeta` VALUES("11269", "9719", "pyre_vimeo_id", "");
INSERT INTO `bupg_postmeta` VALUES("11270", "9719", "pyre_webm", "");
INSERT INTO `bupg_postmeta` VALUES("11271", "9719", "pyre_mp4", "");
INSERT INTO `bupg_postmeta` VALUES("11272", "9719", "pyre_ogv", "");
INSERT INTO `bupg_postmeta` VALUES("11273", "9719", "pyre_preview_image", "");
INSERT INTO `bupg_postmeta` VALUES("11274", "9719", "pyre_video_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("11275", "9719", "pyre_mute_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("11276", "9719", "pyre_autoplay_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("11277", "9719", "pyre_loop_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("11278", "9719", "pyre_hide_video_controls", "yes");
INSERT INTO `bupg_postmeta` VALUES("11279", "9719", "pyre_content_alignment", "left");
INSERT INTO `bupg_postmeta` VALUES("11280", "9719", "pyre_heading", "Slice of Paradise");
INSERT INTO `bupg_postmeta` VALUES("11281", "9719", "pyre_heading_font_size", "40");
INSERT INTO `bupg_postmeta` VALUES("11282", "9719", "pyre_heading_color", "");
INSERT INTO `bupg_postmeta` VALUES("11283", "9719", "pyre_heading_bg", "yes");
INSERT INTO `bupg_postmeta` VALUES("11284", "9719", "pyre_caption", "by Nautilus in 2010");
INSERT INTO `bupg_postmeta` VALUES("11285", "9719", "pyre_caption_font_size", "18");
INSERT INTO `bupg_postmeta` VALUES("11286", "9719", "pyre_caption_color", "");
INSERT INTO `bupg_postmeta` VALUES("11287", "9719", "pyre_caption_bg", "yes");
INSERT INTO `bupg_postmeta` VALUES("11288", "9719", "pyre_link_type", "button");
INSERT INTO `bupg_postmeta` VALUES("11289", "9719", "pyre_slide_link", "");
INSERT INTO `bupg_postmeta` VALUES("11290", "9719", "pyre_button_1", "[button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"custom\" size=\"medium\" type=\"flat\" shape=\"round\" target=\"_self\" title=\"\" gradient_colors=\"transparent\" gradient_hover_colors=\"rgba(0,0,0,.1)\" accent_color=\"rgba(0,0,0,.7)\" accent_hover_color=\"#000\" bevel_color=\"\" border_width=\"1px\" shadow=\"no\" icon=\"\" icon_divider=\"no\" icon_position=\"\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Learn More[/button]");
INSERT INTO `bupg_postmeta` VALUES("11291", "9719", "pyre_button_2", "[button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"custom\" size=\"medium\" type=\"flat\" shape=\"round\" target=\"_self\" title=\"\" gradient_colors=\"#a0ce4e\" gradient_hover_colors=\"#87be22\" accent_color=\"rgba(255,255,255,.8)\" accent_hover_color=\"rgba(255,255,255,.9)\" bevel_color=\"\" border_width=\"0px\" shadow=\"no\" icon=\"\" icon_divider=\"no\" icon_position=\"\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Buy Avada Now[/button]");
INSERT INTO `bupg_postmeta` VALUES("11294", "9722", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("11295", "9722", "pyre_type", "image");
INSERT INTO `bupg_postmeta` VALUES("11296", "9722", "pyre_youtube_id", "");
INSERT INTO `bupg_postmeta` VALUES("11297", "9722", "pyre_vimeo_id", "");
INSERT INTO `bupg_postmeta` VALUES("11298", "9722", "pyre_webm", "");
INSERT INTO `bupg_postmeta` VALUES("11299", "9722", "pyre_mp4", "");
INSERT INTO `bupg_postmeta` VALUES("11300", "9722", "pyre_ogv", "");
INSERT INTO `bupg_postmeta` VALUES("11301", "9722", "pyre_preview_image", "");
INSERT INTO `bupg_postmeta` VALUES("11302", "9722", "pyre_video_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("11303", "9722", "pyre_mute_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("11304", "9722", "pyre_autoplay_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("11305", "9722", "pyre_loop_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("11306", "9722", "pyre_hide_video_controls", "yes");
INSERT INTO `bupg_postmeta` VALUES("11307", "9722", "pyre_content_alignment", "left");
INSERT INTO `bupg_postmeta` VALUES("11308", "9722", "pyre_heading", "Create Beauty");
INSERT INTO `bupg_postmeta` VALUES("11309", "9722", "pyre_heading_font_size", "40");
INSERT INTO `bupg_postmeta` VALUES("11310", "9722", "pyre_heading_color", "");
INSERT INTO `bupg_postmeta` VALUES("11311", "9722", "pyre_heading_bg", "yes");
INSERT INTO `bupg_postmeta` VALUES("11312", "9722", "pyre_caption", "Like Martin Grohs Has Done");
INSERT INTO `bupg_postmeta` VALUES("11313", "9722", "pyre_caption_font_size", "18");
INSERT INTO `bupg_postmeta` VALUES("11314", "9722", "pyre_caption_color", "");
INSERT INTO `bupg_postmeta` VALUES("11315", "9722", "pyre_caption_bg", "yes");
INSERT INTO `bupg_postmeta` VALUES("11316", "9722", "pyre_link_type", "button");
INSERT INTO `bupg_postmeta` VALUES("11317", "9722", "pyre_slide_link", "");
INSERT INTO `bupg_postmeta` VALUES("11318", "9722", "pyre_button_1", "[button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"custom\" size=\"medium\" type=\"flat\" shape=\"round\" target=\"_self\" title=\"\" gradient_colors=\"transparent\" gradient_hover_colors=\"rgba(0,0,0,.1)\" accent_color=\"rgba(0,0,0,.7)\" accent_hover_color=\"#000\" bevel_color=\"\" border_width=\"1px\" shadow=\"no\" icon=\"\" icon_divider=\"no\" icon_position=\"\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Learn More[/button]");
INSERT INTO `bupg_postmeta` VALUES("11319", "9722", "pyre_button_2", "[button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"custom\" size=\"medium\" type=\"flat\" shape=\"round\" target=\"_self\" title=\"\" gradient_colors=\"#a0ce4e\" gradient_hover_colors=\"#87be22\" accent_color=\"rgba(255,255,255,.8)\" accent_hover_color=\"rgba(255,255,255,.9)\" bevel_color=\"\" border_width=\"0px\" shadow=\"no\" icon=\"\" icon_divider=\"no\" icon_position=\"\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Buy Avada Now[/button]");
INSERT INTO `bupg_postmeta` VALUES("11320", "10712", "pyre_ogv", "");
INSERT INTO `bupg_postmeta` VALUES("11321", "10712", "pyre_mp4", "");
INSERT INTO `bupg_postmeta` VALUES("11322", "10712", "pyre_webm", "");
INSERT INTO `bupg_postmeta` VALUES("11323", "10712", "pyre_vimeo_id", "");
INSERT INTO `bupg_postmeta` VALUES("11324", "10712", "pyre_youtube_id", "");
INSERT INTO `bupg_postmeta` VALUES("11325", "10712", "pyre_type", "image");
INSERT INTO `bupg_postmeta` VALUES("11326", "10712", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("11328", "10712", "pyre_caption_bg", "no");
INSERT INTO `bupg_postmeta` VALUES("11329", "10712", "pyre_caption_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("11330", "10712", "pyre_link_type", "button");
INSERT INTO `bupg_postmeta` VALUES("11331", "10712", "pyre_button_2", "");
INSERT INTO `bupg_postmeta` VALUES("11332", "10712", "pyre_button_1", "[button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"custom\" size=\"xlarge\" type=\"flat\" shape=\"round\" target=\"_blank\" title=\"\" gradient_colors=\"#a0ce4e\" gradient_hover_colors=\"#87be22\" accent_color=\"rgba(255,255,255,.8)\" accent_hover_color=\"rgba(255,255,255,.9)\" bevel_color=\"\" border_width=\"0px\" shadow=\"no\" icon=\"\" icon_divider=\"no\" icon_position=\"\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Purchase Avada![/button]");
INSERT INTO `bupg_postmeta` VALUES("11333", "10712", "pyre_slide_target", "yes");
INSERT INTO `bupg_postmeta` VALUES("11334", "10712", "pyre_slide_link", "");
INSERT INTO `bupg_postmeta` VALUES("11335", "10712", "pyre_caption_color", "#fff");
INSERT INTO `bupg_postmeta` VALUES("11336", "10712", "pyre_caption_font_size", "42");
INSERT INTO `bupg_postmeta` VALUES("11337", "10712", "pyre_caption", "Join The Avada Community");
INSERT INTO `bupg_postmeta` VALUES("11338", "10712", "pyre_heading_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("11339", "10712", "pyre_heading_bg", "no");
INSERT INTO `bupg_postmeta` VALUES("11340", "10712", "pyre_heading_color", "#fff");
INSERT INTO `bupg_postmeta` VALUES("11341", "10712", "pyre_heading_font_size", "74");
INSERT INTO `bupg_postmeta` VALUES("11342", "10712", "pyre_heading", "#1 Selling WordPress Theme");
INSERT INTO `bupg_postmeta` VALUES("11343", "10712", "pyre_content_alignment", "center");
INSERT INTO `bupg_postmeta` VALUES("11344", "10712", "pyre_hide_video_controls", "yes");
INSERT INTO `bupg_postmeta` VALUES("11345", "10712", "pyre_loop_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("11346", "10712", "pyre_autoplay_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("11347", "10712", "pyre_preview_image", "");
INSERT INTO `bupg_postmeta` VALUES("11348", "10712", "pyre_video_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("11349", "10712", "pyre_mute_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("11734", "10838", "_menu_item_type", "post_type");
INSERT INTO `bupg_postmeta` VALUES("11735", "10838", "_menu_item_menu_item_parent", "0");
INSERT INTO `bupg_postmeta` VALUES("11736", "10838", "_menu_item_object_id", "86");
INSERT INTO `bupg_postmeta` VALUES("11737", "10838", "_menu_item_object", "page");
INSERT INTO `bupg_postmeta` VALUES("11738", "10838", "_menu_item_target", "");
INSERT INTO `bupg_postmeta` VALUES("11739", "10838", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("11740", "10838", "_menu_item_xfn", "");
INSERT INTO `bupg_postmeta` VALUES("11741", "10838", "_menu_item_url", "");
INSERT INTO `bupg_postmeta` VALUES("11742", "10838", "_menu_item_fusion_megamenu_status", "");
INSERT INTO `bupg_postmeta` VALUES("11743", "10838", "_menu_item_fusion_megamenu_width", "");
INSERT INTO `bupg_postmeta` VALUES("11744", "10838", "_menu_item_fusion_megamenu_columns", "");
INSERT INTO `bupg_postmeta` VALUES("11745", "10838", "_menu_item_fusion_megamenu_columnwidth", "");
INSERT INTO `bupg_postmeta` VALUES("11746", "10838", "_menu_item_fusion_megamenu_title", "");
INSERT INTO `bupg_postmeta` VALUES("11747", "10838", "_menu_item_fusion_megamenu_widgetarea", "");
INSERT INTO `bupg_postmeta` VALUES("11748", "10838", "_menu_item_fusion_megamenu_icon", "");
INSERT INTO `bupg_postmeta` VALUES("11749", "10838", "_menu_item_fusion_megamenu_thumbnail", "");
INSERT INTO `bupg_postmeta` VALUES("13522", "10955", "_wp_attached_file", "layerslider/Avada-Full-Width/slide_3.jpg");
INSERT INTO `bupg_postmeta` VALUES("13523", "10955", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1700;s:6:\"height\";i:400;s:4:\"file\";s:40:\"layerslider/Avada-Full-Width/slide_3.jpg\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:13:\"Iakov Kalinin\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `bupg_postmeta` VALUES("13524", "10956", "_wp_attached_file", "layerslider/Avada-Full-Width/slide_4.jpg");
INSERT INTO `bupg_postmeta` VALUES("13525", "10956", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:940;s:6:\"height\";i:450;s:4:\"file\";s:40:\"layerslider/Avada-Full-Width/slide_4.jpg\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `bupg_postmeta` VALUES("13550", "10969", "_wp_attached_file", "layerslider/Avada-Transparent-Header/html5-color.png");
INSERT INTO `bupg_postmeta` VALUES("13551", "10969", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:90;s:6:\"height\";i:90;s:4:\"file\";s:52:\"layerslider/Avada-Transparent-Header/html5-color.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `bupg_postmeta` VALUES("13556", "10972", "_wp_attached_file", "layerslider/Avada-Transparent-Header/vimeo-color.png");
INSERT INTO `bupg_postmeta` VALUES("13557", "10972", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:90;s:6:\"height\";i:90;s:4:\"file\";s:52:\"layerslider/Avada-Transparent-Header/vimeo-color.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `bupg_postmeta` VALUES("13558", "10973", "_wp_attached_file", "layerslider/Avada-Transparent-Header/youtube-color.png");
INSERT INTO `bupg_postmeta` VALUES("13559", "10973", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:90;s:6:\"height\";i:90;s:4:\"file\";s:54:\"layerslider/Avada-Transparent-Header/youtube-color.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `bupg_postmeta` VALUES("13560", "10974", "_wp_attached_file", "revslider/Avada_Full_Width/slide_3.jpg");
INSERT INTO `bupg_postmeta` VALUES("13561", "10974", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1700;s:6:\"height\";i:400;s:4:\"file\";s:38:\"revslider/Avada_Full_Width/slide_3.jpg\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:13:\"Iakov Kalinin\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `bupg_postmeta` VALUES("13562", "10975", "_wp_attached_file", "revslider/Avada_Full_Width/slide_4.jpg");
INSERT INTO `bupg_postmeta` VALUES("13563", "10975", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:940;s:6:\"height\";i:450;s:4:\"file\";s:38:\"revslider/Avada_Full_Width/slide_4.jpg\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `bupg_postmeta` VALUES("13578", "10983", "_wp_attached_file", "revslider/Avada_Small_Slider/slide_4.jpg");
INSERT INTO `bupg_postmeta` VALUES("13579", "10983", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:940;s:6:\"height\";i:450;s:4:\"file\";s:40:\"revslider/Avada_Small_Slider/slide_4.jpg\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `bupg_postmeta` VALUES("13588", "10988", "_wp_attached_file", "revslider/captions_tall/box21.png");
INSERT INTO `bupg_postmeta` VALUES("13589", "10988", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:419;s:6:\"height\";i:434;s:4:\"file\";s:33:\"revslider/captions_tall/box21.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `bupg_postmeta` VALUES("13604", "9548", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("13605", "9548", "pyre_type", "self-hosted-video");
INSERT INTO `bupg_postmeta` VALUES("13606", "9548", "pyre_youtube_id", "");
INSERT INTO `bupg_postmeta` VALUES("13607", "9548", "pyre_vimeo_id", "");
INSERT INTO `bupg_postmeta` VALUES("13608", "9548", "pyre_webm", "http://theme-fusion.com/avadaxml/wp-content/uploads/2014/11/171328.webm");
INSERT INTO `bupg_postmeta` VALUES("13609", "9548", "pyre_mp4", "http://theme-fusion.com/avadaxml/wp-content/uploads/2014/11/171328.mp4");
INSERT INTO `bupg_postmeta` VALUES("13610", "9548", "pyre_ogv", "");
INSERT INTO `bupg_postmeta` VALUES("13611", "9548", "pyre_preview_image", "http://theme-fusion.com/avadaxml/wp-content/uploads/2014/11/171328_preview.jpg");
INSERT INTO `bupg_postmeta` VALUES("13612", "9548", "pyre_video_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("13613", "9548", "pyre_mute_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("13614", "9548", "pyre_autoplay_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("13615", "9548", "pyre_loop_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("13616", "9548", "pyre_hide_video_controls", "yes");
INSERT INTO `bupg_postmeta` VALUES("13617", "9548", "pyre_content_alignment", "right");
INSERT INTO `bupg_postmeta` VALUES("13618", "9548", "pyre_heading", "Fusion Slider");
INSERT INTO `bupg_postmeta` VALUES("13619", "9548", "pyre_heading_font_size", "85");
INSERT INTO `bupg_postmeta` VALUES("13620", "9548", "pyre_heading_color", "");
INSERT INTO `bupg_postmeta` VALUES("13621", "9548", "pyre_heading_bg", "yes");
INSERT INTO `bupg_postmeta` VALUES("13622", "9548", "pyre_caption", "Responsive, Parallax Effect, Custom Options,<br /> Video Support, Full Screen & More");
INSERT INTO `bupg_postmeta` VALUES("13623", "9548", "pyre_caption_font_size", "");
INSERT INTO `bupg_postmeta` VALUES("13624", "9548", "pyre_caption_color", "#fff");
INSERT INTO `bupg_postmeta` VALUES("13625", "9548", "pyre_caption_bg", "no");
INSERT INTO `bupg_postmeta` VALUES("13626", "9548", "pyre_link_type", "button");
INSERT INTO `bupg_postmeta` VALUES("13627", "9548", "pyre_slide_link", "");
INSERT INTO `bupg_postmeta` VALUES("13628", "9548", "pyre_button_1", "[button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"custom\" size=\"xlarge\" type=\"flat\" shape=\"round\" target=\"_self\" title=\"\" gradient_colors=\"transparent\" gradient_hover_colors=\"rgba(255,255,255,.1)\" accent_color=\"rgba(255,255,255,.7)\" accent_hover_color=\"#fff\" bevel_color=\"\" border_width=\"1px\" shadow=\"no\" icon=\"\" icon_divider=\"no\" icon_position=\"\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Learn More[/button]");
INSERT INTO `bupg_postmeta` VALUES("13629", "9548", "pyre_button_2", "[button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"custom\" size=\"xlarge\" type=\"flat\" shape=\"round\" target=\"_self\" title=\"\" gradient_colors=\"#a0ce4e\" gradient_hover_colors=\"#87be22\" accent_color=\"rgba(255,255,255,.8)\" accent_hover_color=\"rgba(255,255,255,.9)\" bevel_color=\"\" border_width=\"0px\" shadow=\"no\" icon=\"\" icon_divider=\"no\" icon_position=\"\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Buy Avada Now[/button]");
INSERT INTO `bupg_postmeta` VALUES("13630", "9552", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("13631", "9552", "pyre_type", "image");
INSERT INTO `bupg_postmeta` VALUES("13632", "9552", "pyre_youtube_id", "");
INSERT INTO `bupg_postmeta` VALUES("13633", "9552", "pyre_vimeo_id", "");
INSERT INTO `bupg_postmeta` VALUES("13634", "9552", "pyre_webm", "");
INSERT INTO `bupg_postmeta` VALUES("13635", "9552", "pyre_mp4", "");
INSERT INTO `bupg_postmeta` VALUES("13636", "9552", "pyre_ogv", "");
INSERT INTO `bupg_postmeta` VALUES("13637", "9552", "pyre_preview_image", "");
INSERT INTO `bupg_postmeta` VALUES("13638", "9552", "pyre_video_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("13639", "9552", "pyre_mute_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("13640", "9552", "pyre_autoplay_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("13641", "9552", "pyre_loop_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("13642", "9552", "pyre_hide_video_controls", "yes");
INSERT INTO `bupg_postmeta` VALUES("13643", "9552", "pyre_content_alignment", "left");
INSERT INTO `bupg_postmeta` VALUES("13644", "9552", "pyre_heading", "Beauty & Brains");
INSERT INTO `bupg_postmeta` VALUES("13645", "9552", "pyre_heading_font_size", "");
INSERT INTO `bupg_postmeta` VALUES("13646", "9552", "pyre_heading_color", "");
INSERT INTO `bupg_postmeta` VALUES("13647", "9552", "pyre_heading_bg", "yes");
INSERT INTO `bupg_postmeta` VALUES("13648", "9552", "pyre_caption", "Beautiful parallax scrolling effect & intelligent options.");
INSERT INTO `bupg_postmeta` VALUES("13649", "9552", "pyre_caption_font_size", "");
INSERT INTO `bupg_postmeta` VALUES("13650", "9552", "pyre_caption_color", "");
INSERT INTO `bupg_postmeta` VALUES("13651", "9552", "pyre_caption_bg", "yes");
INSERT INTO `bupg_postmeta` VALUES("13652", "9552", "pyre_link_type", "button");
INSERT INTO `bupg_postmeta` VALUES("13653", "9552", "pyre_slide_link", "");
INSERT INTO `bupg_postmeta` VALUES("13654", "9552", "pyre_button_1", "[button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"custom\" size=\"xlarge\" type=\"flat\" shape=\"round\" target=\"_self\" title=\"\" gradient_colors=\"transparent\" gradient_hover_colors=\"rgba(255,255,255,.1)\" accent_color=\"rgba(255,255,255,.8)\" accent_hover_color=\"#fff\" bevel_color=\"\" border_width=\"1px\" shadow=\"no\" icon=\"\" icon_divider=\"no\" icon_position=\"\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Button Text[/button]");
INSERT INTO `bupg_postmeta` VALUES("13655", "9552", "pyre_button_2", "[button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"custom\" size=\"xlarge\" type=\"flat\" shape=\"round\" target=\"_self\" title=\"\" gradient_colors=\"#a0ce4e\" gradient_hover_colors=\"#87be22\" accent_color=\"rgba(255,255,255,.8)\" accent_hover_color=\"rgba(255,255,255,.9)\" bevel_color=\"\" border_width=\"0px\" shadow=\"no\" icon=\"\" icon_divider=\"no\" icon_position=\"\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Buy Avada Now[/button]");
INSERT INTO `bupg_postmeta` VALUES("13657", "9564", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("13658", "9564", "pyre_type", "self-hosted-video");
INSERT INTO `bupg_postmeta` VALUES("13659", "9564", "pyre_youtube_id", "");
INSERT INTO `bupg_postmeta` VALUES("13660", "9564", "pyre_vimeo_id", "");
INSERT INTO `bupg_postmeta` VALUES("13661", "9564", "pyre_webm", "http://theme-fusion.com/avadaxml/wp-content/uploads/2014/11/Hand-With-Wedding-Ring.webm");
INSERT INTO `bupg_postmeta` VALUES("13662", "9564", "pyre_mp4", "http://theme-fusion.com/avadaxml/wp-content/uploads/2014/11/Hand-With-Wedding-Ring.mp4");
INSERT INTO `bupg_postmeta` VALUES("13663", "9564", "pyre_ogv", "");
INSERT INTO `bupg_postmeta` VALUES("13664", "9564", "pyre_preview_image", "http://theme-fusion.com/avadaxml/wp-content/uploads/2014/11/Hand-With-Wedding-Ring_preview.jpg");
INSERT INTO `bupg_postmeta` VALUES("13665", "9564", "pyre_video_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("13666", "9564", "pyre_mute_video", "no");
INSERT INTO `bupg_postmeta` VALUES("13667", "9564", "pyre_autoplay_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("13668", "9564", "pyre_loop_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("13669", "9564", "pyre_hide_video_controls", "yes");
INSERT INTO `bupg_postmeta` VALUES("13670", "9564", "pyre_content_alignment", "center");
INSERT INTO `bupg_postmeta` VALUES("13671", "9564", "pyre_heading", "Fusion Slider Is Here");
INSERT INTO `bupg_postmeta` VALUES("13672", "9564", "pyre_heading_font_size", "");
INSERT INTO `bupg_postmeta` VALUES("13673", "9564", "pyre_heading_color", "#000");
INSERT INTO `bupg_postmeta` VALUES("13674", "9564", "pyre_heading_bg", "no");
INSERT INTO `bupg_postmeta` VALUES("13675", "9564", "pyre_caption", "Simply amazing and fun to use. It\'s bold, beautiful & brilliant.");
INSERT INTO `bupg_postmeta` VALUES("13676", "9564", "pyre_caption_font_size", "");
INSERT INTO `bupg_postmeta` VALUES("13677", "9564", "pyre_caption_color", "#000");
INSERT INTO `bupg_postmeta` VALUES("13678", "9564", "pyre_caption_bg", "no");
INSERT INTO `bupg_postmeta` VALUES("13679", "9564", "pyre_link_type", "button");
INSERT INTO `bupg_postmeta` VALUES("13680", "9564", "pyre_slide_link", "");
INSERT INTO `bupg_postmeta` VALUES("13681", "9564", "pyre_button_1", "[button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"custom\" size=\"xlarge\" type=\"flat\" shape=\"round\" target=\"_self\" title=\"\" gradient_colors=\"transparent\" gradient_hover_colors=\"rgba(0,0,0,.1)\" accent_color=\"rgba(0,0,0,.7)\" accent_hover_color=\"#000\" bevel_color=\"\" border_width=\"1px\" shadow=\"no\" icon=\"\" icon_divider=\"no\" icon_position=\"\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Learn More[/button]");
INSERT INTO `bupg_postmeta` VALUES("13682", "9564", "pyre_button_2", "[button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"custom\" size=\"xlarge\" type=\"flat\" shape=\"round\" target=\"_self\" title=\"\" gradient_colors=\"#a0ce4e\" gradient_hover_colors=\"#87be22\" accent_color=\"rgba(255,255,255,.8)\" accent_hover_color=\"rgba(255,255,255,.9)\" bevel_color=\"\" border_width=\"0px\" shadow=\"no\" icon=\"\" icon_divider=\"no\" icon_position=\"\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Buy Avada Now[/button]");
INSERT INTO `bupg_postmeta` VALUES("13739", "9578", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("13740", "9578", "pyre_type", "self-hosted-video");
INSERT INTO `bupg_postmeta` VALUES("13741", "9578", "pyre_youtube_id", "");
INSERT INTO `bupg_postmeta` VALUES("13742", "9578", "pyre_vimeo_id", "");
INSERT INTO `bupg_postmeta` VALUES("13743", "9578", "pyre_webm", "http://theme-fusion.com/avadaxml/wp-content/uploads/2014/11/shutterstock_3743237.webm");
INSERT INTO `bupg_postmeta` VALUES("13744", "9578", "pyre_mp4", "http://theme-fusion.com/avadaxml/wp-content/uploads/2014/11/shutterstock_3743237.mp4");
INSERT INTO `bupg_postmeta` VALUES("13745", "9578", "pyre_ogv", "");
INSERT INTO `bupg_postmeta` VALUES("13746", "9578", "pyre_preview_image", "http://theme-fusion.com/avadaxml/wp-content/uploads/2014/11/shutterstock_3743237_preview.jpg");
INSERT INTO `bupg_postmeta` VALUES("13747", "9578", "pyre_video_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("13748", "9578", "pyre_mute_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("13749", "9578", "pyre_autoplay_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("13750", "9578", "pyre_loop_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("13751", "9578", "pyre_hide_video_controls", "yes");
INSERT INTO `bupg_postmeta` VALUES("13752", "9578", "pyre_content_alignment", "center");
INSERT INTO `bupg_postmeta` VALUES("13753", "9578", "pyre_heading", "Fusion Slider Is Here.<br /> Beauty & Brains.");
INSERT INTO `bupg_postmeta` VALUES("13754", "9578", "pyre_heading_font_size", "85");
INSERT INTO `bupg_postmeta` VALUES("13755", "9578", "pyre_heading_color", "#333333");
INSERT INTO `bupg_postmeta` VALUES("13756", "9578", "pyre_heading_bg", "no");
INSERT INTO `bupg_postmeta` VALUES("13757", "9578", "pyre_caption", "");
INSERT INTO `bupg_postmeta` VALUES("13758", "9578", "pyre_caption_font_size", "");
INSERT INTO `bupg_postmeta` VALUES("13759", "9578", "pyre_caption_color", "");
INSERT INTO `bupg_postmeta` VALUES("13760", "9578", "pyre_caption_bg", "yes");
INSERT INTO `bupg_postmeta` VALUES("13761", "9578", "pyre_link_type", "button");
INSERT INTO `bupg_postmeta` VALUES("13762", "9578", "pyre_slide_link", "");
INSERT INTO `bupg_postmeta` VALUES("13763", "9578", "pyre_button_1", "[button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"custom\" size=\"xlarge\" type=\"flat\" shape=\"round\" target=\"_self\" title=\"\" gradient_colors=\"transparent\" gradient_hover_colors=\"rgba(0,0,0,.1)\" accent_color=\"rgba(0,0,0,.7)\" accent_hover_color=\"#000\" bevel_color=\"\" border_width=\"1px\" shadow=\"no\" icon=\"\" icon_divider=\"no\" icon_position=\"\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Learn More[/button]");
INSERT INTO `bupg_postmeta` VALUES("13764", "9578", "pyre_button_2", "[button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"custom\" size=\"xlarge\" type=\"flat\" shape=\"round\" target=\"_self\" title=\"\" gradient_colors=\"#a0ce4e\" gradient_hover_colors=\"#87be22\" accent_color=\"rgba(255,255,255,.8)\" accent_hover_color=\"rgba(255,255,255,.9)\" bevel_color=\"\" border_width=\"0px\" shadow=\"no\" icon=\"\" icon_divider=\"no\" icon_position=\"\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Buy Avada Now[/button]");
INSERT INTO `bupg_postmeta` VALUES("13766", "9611", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("13767", "9611", "pyre_type", "image");
INSERT INTO `bupg_postmeta` VALUES("13768", "9611", "pyre_youtube_id", "");
INSERT INTO `bupg_postmeta` VALUES("13769", "9611", "pyre_vimeo_id", "");
INSERT INTO `bupg_postmeta` VALUES("13770", "9611", "pyre_webm", "");
INSERT INTO `bupg_postmeta` VALUES("13771", "9611", "pyre_mp4", "");
INSERT INTO `bupg_postmeta` VALUES("13772", "9611", "pyre_ogv", "");
INSERT INTO `bupg_postmeta` VALUES("13773", "9611", "pyre_preview_image", "");
INSERT INTO `bupg_postmeta` VALUES("13774", "9611", "pyre_video_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("13775", "9611", "pyre_mute_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("13776", "9611", "pyre_autoplay_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("13777", "9611", "pyre_loop_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("13778", "9611", "pyre_hide_video_controls", "yes");
INSERT INTO `bupg_postmeta` VALUES("13779", "9611", "pyre_content_alignment", "left");
INSERT INTO `bupg_postmeta` VALUES("13780", "9611", "pyre_heading", "Create Beauty");
INSERT INTO `bupg_postmeta` VALUES("13781", "9611", "pyre_heading_font_size", "");
INSERT INTO `bupg_postmeta` VALUES("13782", "9611", "pyre_heading_color", "#333333");
INSERT INTO `bupg_postmeta` VALUES("13783", "9611", "pyre_heading_bg", "no");
INSERT INTO `bupg_postmeta` VALUES("13784", "9611", "pyre_caption", "With Your Creativity");
INSERT INTO `bupg_postmeta` VALUES("13785", "9611", "pyre_caption_font_size", "");
INSERT INTO `bupg_postmeta` VALUES("13786", "9611", "pyre_caption_color", "");
INSERT INTO `bupg_postmeta` VALUES("13787", "9611", "pyre_caption_bg", "yes");
INSERT INTO `bupg_postmeta` VALUES("13788", "9611", "pyre_link_type", "full");
INSERT INTO `bupg_postmeta` VALUES("13789", "9611", "pyre_slide_link", "http://enva.to/154eBMk");
INSERT INTO `bupg_postmeta` VALUES("13790", "9611", "pyre_button_1", "[button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"custom\" size=\"large\" type=\"flat\" shape=\"round\" target=\"_self\" title=\"\" gradient_colors=\"transparent\" gradient_hover_colors=\"rgba(0,0,0,.1)\" accent_color=\"rgba(0,0,0,.7)\" accent_hover_color=\"#000\" bevel_color=\"\" border_width=\"1px\" shadow=\"no\" icon=\"\" icon_divider=\"no\" icon_position=\"\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Learn More[/button]");
INSERT INTO `bupg_postmeta` VALUES("13791", "9611", "pyre_button_2", "[button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"custom\" size=\"large\" type=\"flat\" shape=\"round\" target=\"_self\" title=\"\" gradient_colors=\"#a0ce4e\" gradient_hover_colors=\"#7db21d\" accent_color=\"rgba(255,255,255,.9)\" accent_hover_color=\"#fff\" bevel_color=\"\" border_width=\"0px\" shadow=\"no\" icon=\"\" icon_divider=\"no\" icon_position=\"\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Buy Avada Now[/button]");
INSERT INTO `bupg_postmeta` VALUES("13792", "9613", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("13793", "9613", "pyre_type", "youtube");
INSERT INTO `bupg_postmeta` VALUES("13794", "9613", "pyre_youtube_id", "nACpDR1twKU");
INSERT INTO `bupg_postmeta` VALUES("13795", "9613", "pyre_vimeo_id", "");
INSERT INTO `bupg_postmeta` VALUES("13796", "9613", "pyre_webm", "");
INSERT INTO `bupg_postmeta` VALUES("13797", "9613", "pyre_mp4", "");
INSERT INTO `bupg_postmeta` VALUES("13798", "9613", "pyre_ogv", "");
INSERT INTO `bupg_postmeta` VALUES("13799", "9613", "pyre_preview_image", "");
INSERT INTO `bupg_postmeta` VALUES("13800", "9613", "pyre_video_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("13801", "9613", "pyre_mute_video", "no");
INSERT INTO `bupg_postmeta` VALUES("13802", "9613", "pyre_autoplay_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("13803", "9613", "pyre_loop_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("13804", "9613", "pyre_hide_video_controls", "no");
INSERT INTO `bupg_postmeta` VALUES("13805", "9613", "pyre_content_alignment", "left");
INSERT INTO `bupg_postmeta` VALUES("13806", "9613", "pyre_heading", "");
INSERT INTO `bupg_postmeta` VALUES("13807", "9613", "pyre_heading_font_size", "");
INSERT INTO `bupg_postmeta` VALUES("13808", "9613", "pyre_heading_color", "");
INSERT INTO `bupg_postmeta` VALUES("13809", "9613", "pyre_heading_bg", "yes");
INSERT INTO `bupg_postmeta` VALUES("13810", "9613", "pyre_caption", "");
INSERT INTO `bupg_postmeta` VALUES("13811", "9613", "pyre_caption_font_size", "");
INSERT INTO `bupg_postmeta` VALUES("13812", "9613", "pyre_caption_color", "");
INSERT INTO `bupg_postmeta` VALUES("13813", "9613", "pyre_caption_bg", "yes");
INSERT INTO `bupg_postmeta` VALUES("13814", "9613", "pyre_link_type", "full");
INSERT INTO `bupg_postmeta` VALUES("13815", "9613", "pyre_slide_link", "");
INSERT INTO `bupg_postmeta` VALUES("13816", "9613", "pyre_button_1", "[button link=\"\" color=\"default\" size=\"\" type=\"\" shape=\"\" target=\"_self\" title=\"\" gradient_colors=\"|\" gradient_hover_colors=\"|\" accent_color=\"\" accent_hover_color=\"\" bevel_color=\"\" border_width=\"1px\" shadow=\"\" icon=\"\" icon_divider=\"yes\" icon_position=\"left\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Button Text[/button]");
INSERT INTO `bupg_postmeta` VALUES("13817", "9613", "pyre_button_2", "[button link=\"\" color=\"default\" size=\"\" type=\"\" shape=\"\" target=\"_self\" title=\"\" gradient_colors=\"|\" gradient_hover_colors=\"|\" accent_color=\"\" accent_hover_color=\"\" bevel_color=\"\" border_width=\"1px\" shadow=\"\" icon=\"\" icon_divider=\"yes\" icon_position=\"left\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Button Text[/button]");
INSERT INTO `bupg_postmeta` VALUES("13818", "9688", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("13819", "9688", "pyre_type", "vimeo");
INSERT INTO `bupg_postmeta` VALUES("13820", "9688", "pyre_youtube_id", "");
INSERT INTO `bupg_postmeta` VALUES("13821", "9688", "pyre_vimeo_id", "64038952");
INSERT INTO `bupg_postmeta` VALUES("13822", "9688", "pyre_webm", "");
INSERT INTO `bupg_postmeta` VALUES("13823", "9688", "pyre_mp4", "");
INSERT INTO `bupg_postmeta` VALUES("13824", "9688", "pyre_ogv", "");
INSERT INTO `bupg_postmeta` VALUES("13825", "9688", "pyre_preview_image", "");
INSERT INTO `bupg_postmeta` VALUES("13826", "9688", "pyre_video_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("13827", "9688", "pyre_mute_video", "no");
INSERT INTO `bupg_postmeta` VALUES("13828", "9688", "pyre_autoplay_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("13829", "9688", "pyre_loop_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("13830", "9688", "pyre_hide_video_controls", "yes");
INSERT INTO `bupg_postmeta` VALUES("13831", "9688", "pyre_content_alignment", "left");
INSERT INTO `bupg_postmeta` VALUES("13832", "9688", "pyre_heading", "");
INSERT INTO `bupg_postmeta` VALUES("13833", "9688", "pyre_heading_font_size", "");
INSERT INTO `bupg_postmeta` VALUES("13834", "9688", "pyre_heading_color", "");
INSERT INTO `bupg_postmeta` VALUES("13835", "9688", "pyre_heading_bg", "yes");
INSERT INTO `bupg_postmeta` VALUES("13836", "9688", "pyre_caption", "");
INSERT INTO `bupg_postmeta` VALUES("13837", "9688", "pyre_caption_font_size", "");
INSERT INTO `bupg_postmeta` VALUES("13838", "9688", "pyre_caption_color", "");
INSERT INTO `bupg_postmeta` VALUES("13839", "9688", "pyre_caption_bg", "yes");
INSERT INTO `bupg_postmeta` VALUES("13840", "9688", "pyre_link_type", "full");
INSERT INTO `bupg_postmeta` VALUES("13841", "9688", "pyre_slide_link", "");
INSERT INTO `bupg_postmeta` VALUES("13842", "9688", "pyre_button_1", "[button link=\"\" color=\"default\" size=\"\" type=\"\" shape=\"\" target=\"_self\" title=\"\" gradient_colors=\"|\" gradient_hover_colors=\"|\" accent_color=\"\" accent_hover_color=\"\" bevel_color=\"\" border_width=\"1px\" shadow=\"\" icon=\"\" icon_divider=\"yes\" icon_position=\"left\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Button Text[/button]");
INSERT INTO `bupg_postmeta` VALUES("13843", "9688", "pyre_button_2", "[button link=\"\" color=\"default\" size=\"\" type=\"\" shape=\"\" target=\"_self\" title=\"\" gradient_colors=\"|\" gradient_hover_colors=\"|\" accent_color=\"\" accent_hover_color=\"\" bevel_color=\"\" border_width=\"1px\" shadow=\"\" icon=\"\" icon_divider=\"yes\" icon_position=\"left\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Button Text[/button]");
INSERT INTO `bupg_postmeta` VALUES("13844", "9719", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("13845", "9719", "pyre_type", "image");
INSERT INTO `bupg_postmeta` VALUES("13846", "9719", "pyre_youtube_id", "");
INSERT INTO `bupg_postmeta` VALUES("13847", "9719", "pyre_vimeo_id", "");
INSERT INTO `bupg_postmeta` VALUES("13848", "9719", "pyre_webm", "");
INSERT INTO `bupg_postmeta` VALUES("13849", "9719", "pyre_mp4", "");
INSERT INTO `bupg_postmeta` VALUES("13850", "9719", "pyre_ogv", "");
INSERT INTO `bupg_postmeta` VALUES("13851", "9719", "pyre_preview_image", "");
INSERT INTO `bupg_postmeta` VALUES("13852", "9719", "pyre_video_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("13853", "9719", "pyre_mute_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("13854", "9719", "pyre_autoplay_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("13855", "9719", "pyre_loop_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("13856", "9719", "pyre_hide_video_controls", "yes");
INSERT INTO `bupg_postmeta` VALUES("13857", "9719", "pyre_content_alignment", "left");
INSERT INTO `bupg_postmeta` VALUES("13858", "9719", "pyre_heading", "Slice of Paradise");
INSERT INTO `bupg_postmeta` VALUES("13859", "9719", "pyre_heading_font_size", "40");
INSERT INTO `bupg_postmeta` VALUES("13860", "9719", "pyre_heading_color", "");
INSERT INTO `bupg_postmeta` VALUES("13861", "9719", "pyre_heading_bg", "yes");
INSERT INTO `bupg_postmeta` VALUES("13862", "9719", "pyre_caption", "by Nautilus in 2010");
INSERT INTO `bupg_postmeta` VALUES("13863", "9719", "pyre_caption_font_size", "18");
INSERT INTO `bupg_postmeta` VALUES("13864", "9719", "pyre_caption_color", "");
INSERT INTO `bupg_postmeta` VALUES("13865", "9719", "pyre_caption_bg", "yes");
INSERT INTO `bupg_postmeta` VALUES("13866", "9719", "pyre_link_type", "button");
INSERT INTO `bupg_postmeta` VALUES("13867", "9719", "pyre_slide_link", "");
INSERT INTO `bupg_postmeta` VALUES("13868", "9719", "pyre_button_1", "[button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"custom\" size=\"medium\" type=\"flat\" shape=\"round\" target=\"_self\" title=\"\" gradient_colors=\"transparent\" gradient_hover_colors=\"rgba(0,0,0,.1)\" accent_color=\"rgba(0,0,0,.7)\" accent_hover_color=\"#000\" bevel_color=\"\" border_width=\"1px\" shadow=\"no\" icon=\"\" icon_divider=\"no\" icon_position=\"\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Learn More[/button]");
INSERT INTO `bupg_postmeta` VALUES("13869", "9719", "pyre_button_2", "[button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"custom\" size=\"medium\" type=\"flat\" shape=\"round\" target=\"_self\" title=\"\" gradient_colors=\"#a0ce4e\" gradient_hover_colors=\"#87be22\" accent_color=\"rgba(255,255,255,.8)\" accent_hover_color=\"rgba(255,255,255,.9)\" bevel_color=\"\" border_width=\"0px\" shadow=\"no\" icon=\"\" icon_divider=\"no\" icon_position=\"\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Buy Avada Now[/button]");
INSERT INTO `bupg_postmeta` VALUES("13872", "9722", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("13873", "9722", "pyre_type", "image");
INSERT INTO `bupg_postmeta` VALUES("13874", "9722", "pyre_youtube_id", "");
INSERT INTO `bupg_postmeta` VALUES("13875", "9722", "pyre_vimeo_id", "");
INSERT INTO `bupg_postmeta` VALUES("13876", "9722", "pyre_webm", "");
INSERT INTO `bupg_postmeta` VALUES("13877", "9722", "pyre_mp4", "");
INSERT INTO `bupg_postmeta` VALUES("13878", "9722", "pyre_ogv", "");
INSERT INTO `bupg_postmeta` VALUES("13879", "9722", "pyre_preview_image", "");
INSERT INTO `bupg_postmeta` VALUES("13880", "9722", "pyre_video_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("13881", "9722", "pyre_mute_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("13882", "9722", "pyre_autoplay_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("13883", "9722", "pyre_loop_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("13884", "9722", "pyre_hide_video_controls", "yes");
INSERT INTO `bupg_postmeta` VALUES("13885", "9722", "pyre_content_alignment", "left");
INSERT INTO `bupg_postmeta` VALUES("13886", "9722", "pyre_heading", "Create Beauty");
INSERT INTO `bupg_postmeta` VALUES("13887", "9722", "pyre_heading_font_size", "40");
INSERT INTO `bupg_postmeta` VALUES("13888", "9722", "pyre_heading_color", "");
INSERT INTO `bupg_postmeta` VALUES("13889", "9722", "pyre_heading_bg", "yes");
INSERT INTO `bupg_postmeta` VALUES("13890", "9722", "pyre_caption", "Like Martin Grohs Has Done");
INSERT INTO `bupg_postmeta` VALUES("13891", "9722", "pyre_caption_font_size", "18");
INSERT INTO `bupg_postmeta` VALUES("13892", "9722", "pyre_caption_color", "");
INSERT INTO `bupg_postmeta` VALUES("13893", "9722", "pyre_caption_bg", "yes");
INSERT INTO `bupg_postmeta` VALUES("13894", "9722", "pyre_link_type", "button");
INSERT INTO `bupg_postmeta` VALUES("13895", "9722", "pyre_slide_link", "");
INSERT INTO `bupg_postmeta` VALUES("13896", "9722", "pyre_button_1", "[button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"custom\" size=\"medium\" type=\"flat\" shape=\"round\" target=\"_self\" title=\"\" gradient_colors=\"transparent\" gradient_hover_colors=\"rgba(0,0,0,.1)\" accent_color=\"rgba(0,0,0,.7)\" accent_hover_color=\"#000\" bevel_color=\"\" border_width=\"1px\" shadow=\"no\" icon=\"\" icon_divider=\"no\" icon_position=\"\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Learn More[/button]");
INSERT INTO `bupg_postmeta` VALUES("13897", "9722", "pyre_button_2", "[button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"custom\" size=\"medium\" type=\"flat\" shape=\"round\" target=\"_self\" title=\"\" gradient_colors=\"#a0ce4e\" gradient_hover_colors=\"#87be22\" accent_color=\"rgba(255,255,255,.8)\" accent_hover_color=\"rgba(255,255,255,.9)\" bevel_color=\"\" border_width=\"0px\" shadow=\"no\" icon=\"\" icon_divider=\"no\" icon_position=\"\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Buy Avada Now[/button]");
INSERT INTO `bupg_postmeta` VALUES("13898", "10712", "pyre_ogv", "");
INSERT INTO `bupg_postmeta` VALUES("13899", "10712", "pyre_mp4", "");
INSERT INTO `bupg_postmeta` VALUES("13900", "10712", "pyre_webm", "");
INSERT INTO `bupg_postmeta` VALUES("13901", "10712", "pyre_vimeo_id", "");
INSERT INTO `bupg_postmeta` VALUES("13902", "10712", "pyre_youtube_id", "");
INSERT INTO `bupg_postmeta` VALUES("13903", "10712", "pyre_type", "image");
INSERT INTO `bupg_postmeta` VALUES("13904", "10712", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("13906", "10712", "pyre_caption_bg", "no");
INSERT INTO `bupg_postmeta` VALUES("13907", "10712", "pyre_caption_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("13908", "10712", "pyre_link_type", "button");
INSERT INTO `bupg_postmeta` VALUES("13909", "10712", "pyre_button_2", "");
INSERT INTO `bupg_postmeta` VALUES("13910", "10712", "pyre_button_1", "[button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"custom\" size=\"xlarge\" type=\"flat\" shape=\"round\" target=\"_blank\" title=\"\" gradient_colors=\"#a0ce4e\" gradient_hover_colors=\"#87be22\" accent_color=\"rgba(255,255,255,.8)\" accent_hover_color=\"rgba(255,255,255,.9)\" bevel_color=\"\" border_width=\"0px\" shadow=\"no\" icon=\"\" icon_divider=\"no\" icon_position=\"\" modal=\"\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]Purchase Avada![/button]");
INSERT INTO `bupg_postmeta` VALUES("13911", "10712", "pyre_slide_target", "yes");
INSERT INTO `bupg_postmeta` VALUES("13912", "10712", "pyre_slide_link", "");
INSERT INTO `bupg_postmeta` VALUES("13913", "10712", "pyre_caption_color", "#fff");
INSERT INTO `bupg_postmeta` VALUES("13914", "10712", "pyre_caption_font_size", "42");
INSERT INTO `bupg_postmeta` VALUES("13915", "10712", "pyre_caption", "Join The Avada Community");
INSERT INTO `bupg_postmeta` VALUES("13916", "10712", "pyre_heading_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("13917", "10712", "pyre_heading_bg", "no");
INSERT INTO `bupg_postmeta` VALUES("13918", "10712", "pyre_heading_color", "#fff");
INSERT INTO `bupg_postmeta` VALUES("13919", "10712", "pyre_heading_font_size", "74");
INSERT INTO `bupg_postmeta` VALUES("13920", "10712", "pyre_heading", "#1 Selling WordPress Theme");
INSERT INTO `bupg_postmeta` VALUES("13921", "10712", "pyre_content_alignment", "center");
INSERT INTO `bupg_postmeta` VALUES("13922", "10712", "pyre_hide_video_controls", "yes");
INSERT INTO `bupg_postmeta` VALUES("13923", "10712", "pyre_loop_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("13924", "10712", "pyre_autoplay_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("13925", "10712", "pyre_preview_image", "");
INSERT INTO `bupg_postmeta` VALUES("13926", "10712", "pyre_video_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("13927", "10712", "pyre_mute_video", "yes");
INSERT INTO `bupg_postmeta` VALUES("13938", "10995", "_edit_last", "1");
INSERT INTO `bupg_postmeta` VALUES("13939", "10995", "_edit_lock", "1445713331:1");
INSERT INTO `bupg_postmeta` VALUES("13940", "10995", "_wp_page_template", "100-width.php");
INSERT INTO `bupg_postmeta` VALUES("13945", "10995", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("13946", "10995", "fusion_builder_status", "active");
INSERT INTO `bupg_postmeta` VALUES("13947", "10996", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("13948", "10995", "pyre_slider_position", "default");
INSERT INTO `bupg_postmeta` VALUES("13949", "10995", "pyre_slider_type", "no");
INSERT INTO `bupg_postmeta` VALUES("13950", "10995", "pyre_slider", "0");
INSERT INTO `bupg_postmeta` VALUES("13951", "10995", "pyre_wooslider", "0");
INSERT INTO `bupg_postmeta` VALUES("13952", "10995", "pyre_revslider", "0");
INSERT INTO `bupg_postmeta` VALUES("13953", "10995", "pyre_elasticslider", "0");
INSERT INTO `bupg_postmeta` VALUES("13954", "10995", "pyre_fallback", "");
INSERT INTO `bupg_postmeta` VALUES("13955", "10995", "pyre_avada_rev_styles", "default");
INSERT INTO `bupg_postmeta` VALUES("13956", "10995", "pyre_main_top_padding", "0px");
INSERT INTO `bupg_postmeta` VALUES("13957", "10995", "pyre_main_bottom_padding", "0px");
INSERT INTO `bupg_postmeta` VALUES("13958", "10995", "pyre_hundredp_padding", "0px");
INSERT INTO `bupg_postmeta` VALUES("13959", "10995", "pyre_show_first_featured_image", "no");
INSERT INTO `bupg_postmeta` VALUES("13960", "10995", "pyre_display_header", "yes");
INSERT INTO `bupg_postmeta` VALUES("13961", "10995", "pyre_header_100_width", "default");
INSERT INTO `bupg_postmeta` VALUES("13962", "10995", "pyre_header_bg", "");
INSERT INTO `bupg_postmeta` VALUES("13963", "10995", "pyre_header_bg_color", "#29292A");
INSERT INTO `bupg_postmeta` VALUES("13964", "10995", "pyre_header_bg_opacity", "");
INSERT INTO `bupg_postmeta` VALUES("13965", "10995", "pyre_header_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("13966", "10995", "pyre_header_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("13967", "10995", "pyre_displayed_menu", "default");
INSERT INTO `bupg_postmeta` VALUES("13968", "10995", "pyre_display_footer", "default");
INSERT INTO `bupg_postmeta` VALUES("13969", "10995", "pyre_display_copyright", "default");
INSERT INTO `bupg_postmeta` VALUES("13970", "10995", "pyre_footer_100_width", "default");
INSERT INTO `bupg_postmeta` VALUES("13971", "10995", "pyre_sidebar_position", "default");
INSERT INTO `bupg_postmeta` VALUES("13972", "10995", "pyre_page_bg_layout", "default");
INSERT INTO `bupg_postmeta` VALUES("13973", "10995", "pyre_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("13974", "10995", "pyre_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("13975", "10995", "pyre_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("13976", "10995", "pyre_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("13977", "10995", "pyre_wide_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("13978", "10995", "pyre_wide_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("13979", "10995", "pyre_wide_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("13980", "10995", "pyre_wide_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("13981", "10995", "pyre_portfolio_width_100", "no");
INSERT INTO `bupg_postmeta` VALUES("13982", "10995", "pyre_portfolio_content_length", "default");
INSERT INTO `bupg_postmeta` VALUES("13983", "10995", "pyre_portfolio_excerpt", "");
INSERT INTO `bupg_postmeta` VALUES("13984", "10995", "pyre_portfolio_filters", "yes");
INSERT INTO `bupg_postmeta` VALUES("13985", "10995", "pyre_portfolio_text_layout", "default");
INSERT INTO `bupg_postmeta` VALUES("13986", "10995", "pyre_portfolio_featured_image_size", "default");
INSERT INTO `bupg_postmeta` VALUES("13987", "10995", "pyre_portfolio_column_spacing", "");
INSERT INTO `bupg_postmeta` VALUES("13988", "10995", "pyre_page_title", "no");
INSERT INTO `bupg_postmeta` VALUES("13989", "10995", "pyre_page_title_text", "no");
INSERT INTO `bupg_postmeta` VALUES("13990", "10995", "pyre_page_title_text_alignment", "default");
INSERT INTO `bupg_postmeta` VALUES("13991", "10995", "pyre_page_title_custom_text", "");
INSERT INTO `bupg_postmeta` VALUES("13992", "10995", "pyre_page_title_100_width", "default");
INSERT INTO `bupg_postmeta` VALUES("13993", "10995", "pyre_page_title_text_size", "");
INSERT INTO `bupg_postmeta` VALUES("13994", "10995", "pyre_page_title_custom_subheader", "");
INSERT INTO `bupg_postmeta` VALUES("13995", "10995", "pyre_page_title_custom_subheader_text_size", "");
INSERT INTO `bupg_postmeta` VALUES("13996", "10995", "pyre_page_title_font_color", "");
INSERT INTO `bupg_postmeta` VALUES("13997", "10995", "pyre_page_title_height", "");
INSERT INTO `bupg_postmeta` VALUES("13998", "10995", "pyre_page_title_bar_bg", "");
INSERT INTO `bupg_postmeta` VALUES("13999", "10995", "pyre_page_title_bar_bg_retina", "");
INSERT INTO `bupg_postmeta` VALUES("14000", "10995", "pyre_page_title_bar_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("14001", "10995", "pyre_page_title_bar_bg_full", "default");
INSERT INTO `bupg_postmeta` VALUES("14002", "10995", "pyre_page_title_bg_parallax", "default");
INSERT INTO `bupg_postmeta` VALUES("14003", "10995", "pyre_page_title_breadcrumbs_search_bar", "default");
INSERT INTO `bupg_postmeta` VALUES("14016", "10997", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14025", "10998", "_wp_attached_file", "2015/04/downtown1.jpg");
INSERT INTO `bupg_postmeta` VALUES("14026", "10998", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:5760;s:6:\"height\";i:3840;s:4:\"file\";s:21:\"2015/04/downtown1.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"downtown1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"downtown1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:22:\"downtown1-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:21:\"downtown1-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:21:\"downtown1-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"tabs-img\";a:4:{s:4:\"file\";s:19:\"downtown1-52x50.jpg\";s:5:\"width\";i:52;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"related-img\";a:4:{s:4:\"file\";s:21:\"downtown1-180x138.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:138;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:21:\"downtown1-940x400.jpg\";s:5:\"width\";i:940;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:21:\"downtown1-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:21:\"downtown1-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:21:\"downtown1-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-four\";a:4:{s:4:\"file\";s:21:\"downtown1-220x161.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:161;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:21:\"downtown1-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-six\";a:4:{s:4:\"file\";s:21:\"downtown1-147x118.jpg\";s:5:\"width\";i:147;s:6:\"height\";i:118;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:21:\"downtown1-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:19:\"downtown1-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";d:4;s:6:\"credit\";s:14:\"dunamis studio\";s:6:\"camera\";s:21:\"Canon EOS 5D Mark III\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1421426543;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"140\";s:3:\"iso\";s:3:\"320\";s:13:\"shutter_speed\";s:8:\"0.003125\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `bupg_postmeta` VALUES("14031", "10999", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14044", "11000", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14057", "11001", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14071", "11002", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14084", "11003", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14097", "11004", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14110", "11005", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14123", "11006", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14136", "11007", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14149", "11008", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14162", "11009", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14175", "11010", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14188", "11011", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14201", "11012", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14214", "11013", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14227", "11014", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14240", "11015", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14254", "11016", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14267", "11017", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14280", "11018", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14293", "11019", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14306", "11020", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14319", "11021", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14332", "11022", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14345", "11023", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14360", "11025", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14373", "11026", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14386", "11027", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14399", "11028", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14412", "11029", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14425", "11030", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14438", "11031", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14451", "11032", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14464", "11033", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14477", "11034", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14490", "11035", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14503", "11036", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14516", "11037", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14529", "11038", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14542", "11039", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14551", "11041", "_wp_attached_file", "2015/04/India-Telugu27371027_ml.jpg");
INSERT INTO `bupg_postmeta` VALUES("14552", "11041", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1668;s:6:\"height\";i:1126;s:4:\"file\";s:35:\"2015/04/India-Telugu27371027_ml.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:35:\"India-Telugu27371027_ml-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:35:\"India-Telugu27371027_ml-300x203.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:203;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:36:\"India-Telugu27371027_ml-1024x691.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:691;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:35:\"India-Telugu27371027_ml-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:35:\"India-Telugu27371027_ml-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"tabs-img\";a:4:{s:4:\"file\";s:33:\"India-Telugu27371027_ml-52x50.jpg\";s:5:\"width\";i:52;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"related-img\";a:4:{s:4:\"file\";s:35:\"India-Telugu27371027_ml-180x138.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:138;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:35:\"India-Telugu27371027_ml-940x400.jpg\";s:5:\"width\";i:940;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:35:\"India-Telugu27371027_ml-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:35:\"India-Telugu27371027_ml-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:35:\"India-Telugu27371027_ml-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-four\";a:4:{s:4:\"file\";s:35:\"India-Telugu27371027_ml-220x161.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:161;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:35:\"India-Telugu27371027_ml-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-six\";a:4:{s:4:\"file\";s:35:\"India-Telugu27371027_ml-147x118.jpg\";s:5:\"width\";i:147;s:6:\"height\";i:118;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:35:\"India-Telugu27371027_ml-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:33:\"India-Telugu27371027_ml-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `bupg_postmeta` VALUES("14553", "11042", "_wp_attached_file", "2015/04/Yemeni17378186_ml.jpg");
INSERT INTO `bupg_postmeta` VALUES("14554", "11042", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1674;s:6:\"height\";i:1121;s:4:\"file\";s:29:\"2015/04/Yemeni17378186_ml.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:29:\"Yemeni17378186_ml-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:29:\"Yemeni17378186_ml-300x201.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:201;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:30:\"Yemeni17378186_ml-1024x686.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:686;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:29:\"Yemeni17378186_ml-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:29:\"Yemeni17378186_ml-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"tabs-img\";a:4:{s:4:\"file\";s:27:\"Yemeni17378186_ml-52x50.jpg\";s:5:\"width\";i:52;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"related-img\";a:4:{s:4:\"file\";s:29:\"Yemeni17378186_ml-180x138.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:138;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:29:\"Yemeni17378186_ml-940x400.jpg\";s:5:\"width\";i:940;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:29:\"Yemeni17378186_ml-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:29:\"Yemeni17378186_ml-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:29:\"Yemeni17378186_ml-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-four\";a:4:{s:4:\"file\";s:29:\"Yemeni17378186_ml-220x161.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:161;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:29:\"Yemeni17378186_ml-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-six\";a:4:{s:4:\"file\";s:29:\"Yemeni17378186_ml-147x118.jpg\";s:5:\"width\";i:147;s:6:\"height\";i:118;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:29:\"Yemeni17378186_ml-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:27:\"Yemeni17378186_ml-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `bupg_postmeta` VALUES("14555", "11043", "_wp_attached_file", "2015/04/Guatemalan24651726_ml.jpg");
INSERT INTO `bupg_postmeta` VALUES("14556", "11043", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1679;s:6:\"height\";i:1118;s:4:\"file\";s:33:\"2015/04/Guatemalan24651726_ml.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:33:\"Guatemalan24651726_ml-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:33:\"Guatemalan24651726_ml-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:34:\"Guatemalan24651726_ml-1024x682.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:682;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:33:\"Guatemalan24651726_ml-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:33:\"Guatemalan24651726_ml-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"tabs-img\";a:4:{s:4:\"file\";s:31:\"Guatemalan24651726_ml-52x50.jpg\";s:5:\"width\";i:52;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"related-img\";a:4:{s:4:\"file\";s:33:\"Guatemalan24651726_ml-180x138.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:138;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:33:\"Guatemalan24651726_ml-940x400.jpg\";s:5:\"width\";i:940;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:33:\"Guatemalan24651726_ml-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:33:\"Guatemalan24651726_ml-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:33:\"Guatemalan24651726_ml-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-four\";a:4:{s:4:\"file\";s:33:\"Guatemalan24651726_ml-220x161.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:161;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:33:\"Guatemalan24651726_ml-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-six\";a:4:{s:4:\"file\";s:33:\"Guatemalan24651726_ml-147x118.jpg\";s:5:\"width\";i:147;s:6:\"height\";i:118;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:33:\"Guatemalan24651726_ml-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:31:\"Guatemalan24651726_ml-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `bupg_postmeta` VALUES("14561", "11044", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14574", "11045", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14587", "11046", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14600", "11047", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14613", "11048", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14626", "11049", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14639", "11050", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14652", "11051", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14665", "11052", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14678", "11053", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14691", "11054", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14704", "11055", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14717", "11056", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14730", "11057", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14743", "11058", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14756", "11059", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14769", "11060", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14782", "11061", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14799", "11063", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14812", "11064", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14833", "11065", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14846", "11066", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14859", "11067", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14872", "11068", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14881", "10998", "_edit_lock", "1429043274:1");
INSERT INTO `bupg_postmeta` VALUES("14884", "11070", "_wp_attached_file", "2015/04/downtown_opa1.jpg");
INSERT INTO `bupg_postmeta` VALUES("14885", "11070", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:5760;s:6:\"height\";i:3840;s:4:\"file\";s:25:\"2015/04/downtown_opa1.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"downtown_opa1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"downtown_opa1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"downtown_opa1-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:25:\"downtown_opa1-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:25:\"downtown_opa1-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"tabs-img\";a:4:{s:4:\"file\";s:23:\"downtown_opa1-52x50.jpg\";s:5:\"width\";i:52;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"related-img\";a:4:{s:4:\"file\";s:25:\"downtown_opa1-180x138.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:138;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:25:\"downtown_opa1-940x400.jpg\";s:5:\"width\";i:940;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:25:\"downtown_opa1-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:25:\"downtown_opa1-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:25:\"downtown_opa1-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-four\";a:4:{s:4:\"file\";s:25:\"downtown_opa1-220x161.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:161;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:25:\"downtown_opa1-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-six\";a:4:{s:4:\"file\";s:25:\"downtown_opa1-147x118.jpg\";s:5:\"width\";i:147;s:6:\"height\";i:118;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:25:\"downtown_opa1-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:23:\"downtown_opa1-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";d:4;s:6:\"credit\";s:14:\"dunamis studio\";s:6:\"camera\";s:21:\"Canon EOS 5D Mark III\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:1421426543;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:3:\"140\";s:3:\"iso\";s:3:\"320\";s:13:\"shutter_speed\";s:8:\"0.003125\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:1;}}");
INSERT INTO `bupg_postmeta` VALUES("14890", "11071", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14903", "11072", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14918", "11074", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14931", "11075", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14944", "11076", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14957", "11077", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14970", "11078", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14983", "11079", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("14996", "11080", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15009", "11081", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15022", "11082", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15035", "11083", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15048", "11084", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15061", "11085", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15074", "11086", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15087", "11087", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15100", "11088", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15113", "11089", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15126", "11090", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15139", "11091", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15152", "11092", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15165", "11093", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15178", "11094", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15191", "11095", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15204", "11096", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15217", "11097", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15230", "11098", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15243", "11099", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15256", "11100", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15269", "11101", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15282", "11102", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15295", "11103", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15308", "11104", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15321", "11105", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15334", "11106", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15347", "11107", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15360", "11108", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15373", "11109", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15386", "11110", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15399", "11111", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15412", "11112", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15425", "11114", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15434", "11115", "_menu_item_type", "post_type");
INSERT INTO `bupg_postmeta` VALUES("15435", "11115", "_menu_item_menu_item_parent", "0");
INSERT INTO `bupg_postmeta` VALUES("15436", "11115", "_menu_item_object_id", "10995");
INSERT INTO `bupg_postmeta` VALUES("15437", "11115", "_menu_item_object", "page");
INSERT INTO `bupg_postmeta` VALUES("15438", "11115", "_menu_item_target", "");
INSERT INTO `bupg_postmeta` VALUES("15439", "11115", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("15440", "11115", "_menu_item_xfn", "");
INSERT INTO `bupg_postmeta` VALUES("15441", "11115", "_menu_item_url", "");
INSERT INTO `bupg_postmeta` VALUES("15443", "11115", "_menu_item_fusion_megamenu_status", "");
INSERT INTO `bupg_postmeta` VALUES("15444", "11115", "_menu_item_fusion_megamenu_width", "");
INSERT INTO `bupg_postmeta` VALUES("15445", "11115", "_menu_item_fusion_megamenu_columns", "auto");
INSERT INTO `bupg_postmeta` VALUES("15446", "11115", "_menu_item_fusion_megamenu_columnwidth", "");
INSERT INTO `bupg_postmeta` VALUES("15447", "11115", "_menu_item_fusion_megamenu_title", "");
INSERT INTO `bupg_postmeta` VALUES("15448", "11115", "_menu_item_fusion_megamenu_widgetarea", "0");
INSERT INTO `bupg_postmeta` VALUES("15449", "11115", "_menu_item_fusion_megamenu_icon", "");
INSERT INTO `bupg_postmeta` VALUES("15450", "11115", "_menu_item_fusion_megamenu_thumbnail", "");
INSERT INTO `bupg_postmeta` VALUES("15451", "11116", "_edit_last", "1");
INSERT INTO `bupg_postmeta` VALUES("15452", "11116", "_edit_lock", "1435861137:1");
INSERT INTO `bupg_postmeta` VALUES("15453", "11116", "_wp_page_template", "default");
INSERT INTO `bupg_postmeta` VALUES("15458", "11116", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("15459", "11116", "fusion_builder_status", "active");
INSERT INTO `bupg_postmeta` VALUES("15460", "11117", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15461", "11116", "pyre_slider_position", "default");
INSERT INTO `bupg_postmeta` VALUES("15462", "11116", "pyre_slider_type", "no");
INSERT INTO `bupg_postmeta` VALUES("15463", "11116", "pyre_slider", "0");
INSERT INTO `bupg_postmeta` VALUES("15464", "11116", "pyre_wooslider", "0");
INSERT INTO `bupg_postmeta` VALUES("15465", "11116", "pyre_revslider", "0");
INSERT INTO `bupg_postmeta` VALUES("15466", "11116", "pyre_elasticslider", "0");
INSERT INTO `bupg_postmeta` VALUES("15467", "11116", "pyre_fallback", "");
INSERT INTO `bupg_postmeta` VALUES("15468", "11116", "pyre_avada_rev_styles", "default");
INSERT INTO `bupg_postmeta` VALUES("15469", "11116", "pyre_main_top_padding", "");
INSERT INTO `bupg_postmeta` VALUES("15470", "11116", "pyre_main_bottom_padding", "");
INSERT INTO `bupg_postmeta` VALUES("15471", "11116", "pyre_hundredp_padding", "");
INSERT INTO `bupg_postmeta` VALUES("15472", "11116", "pyre_show_first_featured_image", "no");
INSERT INTO `bupg_postmeta` VALUES("15473", "11116", "pyre_display_header", "yes");
INSERT INTO `bupg_postmeta` VALUES("15474", "11116", "pyre_header_100_width", "default");
INSERT INTO `bupg_postmeta` VALUES("15475", "11116", "pyre_header_bg", "");
INSERT INTO `bupg_postmeta` VALUES("15476", "11116", "pyre_header_bg_color", "#29292A");
INSERT INTO `bupg_postmeta` VALUES("15477", "11116", "pyre_header_bg_opacity", "");
INSERT INTO `bupg_postmeta` VALUES("15478", "11116", "pyre_header_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("15479", "11116", "pyre_header_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("15480", "11116", "pyre_displayed_menu", "36");
INSERT INTO `bupg_postmeta` VALUES("15481", "11116", "pyre_display_footer", "default");
INSERT INTO `bupg_postmeta` VALUES("15482", "11116", "pyre_display_copyright", "default");
INSERT INTO `bupg_postmeta` VALUES("15483", "11116", "pyre_footer_100_width", "default");
INSERT INTO `bupg_postmeta` VALUES("15484", "11116", "pyre_sidebar_position", "right");
INSERT INTO `bupg_postmeta` VALUES("15485", "11116", "pyre_page_bg_layout", "default");
INSERT INTO `bupg_postmeta` VALUES("15486", "11116", "pyre_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("15487", "11116", "pyre_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("15488", "11116", "pyre_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("15489", "11116", "pyre_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("15490", "11116", "pyre_wide_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("15491", "11116", "pyre_wide_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("15492", "11116", "pyre_wide_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("15493", "11116", "pyre_wide_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("15494", "11116", "pyre_portfolio_width_100", "no");
INSERT INTO `bupg_postmeta` VALUES("15495", "11116", "pyre_portfolio_content_length", "default");
INSERT INTO `bupg_postmeta` VALUES("15496", "11116", "pyre_portfolio_excerpt", "");
INSERT INTO `bupg_postmeta` VALUES("15497", "11116", "pyre_portfolio_filters", "yes");
INSERT INTO `bupg_postmeta` VALUES("15498", "11116", "pyre_portfolio_text_layout", "default");
INSERT INTO `bupg_postmeta` VALUES("15499", "11116", "pyre_portfolio_featured_image_size", "default");
INSERT INTO `bupg_postmeta` VALUES("15500", "11116", "pyre_portfolio_column_spacing", "");
INSERT INTO `bupg_postmeta` VALUES("15501", "11116", "pyre_page_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("15502", "11116", "pyre_page_title_text", "yes");
INSERT INTO `bupg_postmeta` VALUES("15503", "11116", "pyre_page_title_text_alignment", "default");
INSERT INTO `bupg_postmeta` VALUES("15504", "11116", "pyre_page_title_custom_text", "");
INSERT INTO `bupg_postmeta` VALUES("15505", "11116", "pyre_page_title_100_width", "default");
INSERT INTO `bupg_postmeta` VALUES("15506", "11116", "pyre_page_title_text_size", "24px");
INSERT INTO `bupg_postmeta` VALUES("15507", "11116", "pyre_page_title_custom_subheader", "");
INSERT INTO `bupg_postmeta` VALUES("15508", "11116", "pyre_page_title_custom_subheader_text_size", "");
INSERT INTO `bupg_postmeta` VALUES("15509", "11116", "pyre_page_title_font_color", "");
INSERT INTO `bupg_postmeta` VALUES("15510", "11116", "pyre_page_title_height", "54px");
INSERT INTO `bupg_postmeta` VALUES("15511", "11116", "pyre_page_title_bar_bg", "none");
INSERT INTO `bupg_postmeta` VALUES("15512", "11116", "pyre_page_title_bar_bg_retina", "");
INSERT INTO `bupg_postmeta` VALUES("15513", "11116", "pyre_page_title_bar_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("15514", "11116", "pyre_page_title_bar_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("15515", "11116", "pyre_page_title_bg_parallax", "no");
INSERT INTO `bupg_postmeta` VALUES("15516", "11116", "pyre_page_title_breadcrumbs_search_bar", "none");
INSERT INTO `bupg_postmeta` VALUES("15566", "11121", "_wp_attached_file", "2015/05/EngageLogoRGB250.png");
INSERT INTO `bupg_postmeta` VALUES("15567", "11121", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:250;s:6:\"height\";i:45;s:4:\"file\";s:28:\"2015/05/EngageLogoRGB250.png\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"EngageLogoRGB250-150x45.png\";s:5:\"width\";i:150;s:6:\"height\";i:45;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"tabs-img\";a:4:{s:4:\"file\";s:26:\"EngageLogoRGB250-52x45.png\";s:5:\"width\";i:52;s:6:\"height\";i:45;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"related-img\";a:4:{s:4:\"file\";s:27:\"EngageLogoRGB250-180x45.png\";s:5:\"width\";i:180;s:6:\"height\";i:45;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"portfolio-four\";a:4:{s:4:\"file\";s:27:\"EngageLogoRGB250-220x45.png\";s:5:\"width\";i:220;s:6:\"height\";i:45;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:27:\"EngageLogoRGB250-177x45.png\";s:5:\"width\";i:177;s:6:\"height\";i:45;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"portfolio-six\";a:4:{s:4:\"file\";s:27:\"EngageLogoRGB250-147x45.png\";s:5:\"width\";i:147;s:6:\"height\";i:45;s:9:\"mime-type\";s:9:\"image/png\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:26:\"EngageLogoRGB250-66x45.png\";s:5:\"width\";i:66;s:6:\"height\";i:45;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `bupg_postmeta` VALUES("15572", "11122", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15664", "11150", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15963", "11247", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15976", "11248", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("15989", "11249", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16002", "11250", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16015", "11251", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16028", "11252", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16041", "11253", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16054", "11254", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16067", "11255", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16080", "11256", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16093", "11257", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16106", "11258", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16119", "11259", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16132", "11260", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16145", "11261", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16158", "11262", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16171", "11263", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16184", "11264", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16197", "11265", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16210", "11266", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16219", "86", "_edit_lock", "1432867569:1");
INSERT INTO `bupg_postmeta` VALUES("16222", "11267", "_wp_attached_file", "2015/05/UnreachedPeoplesLeastReachedAreas230.jpg");
INSERT INTO `bupg_postmeta` VALUES("16223", "11267", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:230;s:6:\"height\";i:298;s:4:\"file\";s:48:\"2015/05/UnreachedPeoplesLeastReachedAreas230.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:48:\"UnreachedPeoplesLeastReachedAreas230-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:48:\"UnreachedPeoplesLeastReachedAreas230-230x272.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:48:\"UnreachedPeoplesLeastReachedAreas230-230x202.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"tabs-img\";a:4:{s:4:\"file\";s:46:\"UnreachedPeoplesLeastReachedAreas230-52x50.jpg\";s:5:\"width\";i:52;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"related-img\";a:4:{s:4:\"file\";s:48:\"UnreachedPeoplesLeastReachedAreas230-180x138.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:138;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:48:\"UnreachedPeoplesLeastReachedAreas230-230x272.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:48:\"UnreachedPeoplesLeastReachedAreas230-230x295.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:48:\"UnreachedPeoplesLeastReachedAreas230-230x214.jpg\";s:5:\"width\";i:230;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-four\";a:4:{s:4:\"file\";s:48:\"UnreachedPeoplesLeastReachedAreas230-220x161.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:161;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:48:\"UnreachedPeoplesLeastReachedAreas230-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-six\";a:4:{s:4:\"file\";s:48:\"UnreachedPeoplesLeastReachedAreas230-147x118.jpg\";s:5:\"width\";i:147;s:6:\"height\";i:118;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:46:\"UnreachedPeoplesLeastReachedAreas230-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:1;}}");
INSERT INTO `bupg_postmeta` VALUES("16224", "11267", "_wp_attachment_image_alt", "Unreached Peoples, Least Reached Places Downloaded eBook by J. D. Payne");
INSERT INTO `bupg_postmeta` VALUES("16225", "11268", "_wp_attached_file", "2015/05/UnreachedPeoplesLeastReachedAreas280.jpg");
INSERT INTO `bupg_postmeta` VALUES("16226", "11268", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:280;s:6:\"height\";i:362;s:4:\"file\";s:48:\"2015/05/UnreachedPeoplesLeastReachedAreas280.jpg\";s:5:\"sizes\";a:13:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:48:\"UnreachedPeoplesLeastReachedAreas280-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:48:\"UnreachedPeoplesLeastReachedAreas280-232x300.jpg\";s:5:\"width\";i:232;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:48:\"UnreachedPeoplesLeastReachedAreas280-280x272.jpg\";s:5:\"width\";i:280;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:48:\"UnreachedPeoplesLeastReachedAreas280-280x202.jpg\";s:5:\"width\";i:280;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"tabs-img\";a:4:{s:4:\"file\";s:46:\"UnreachedPeoplesLeastReachedAreas280-52x50.jpg\";s:5:\"width\";i:52;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"related-img\";a:4:{s:4:\"file\";s:48:\"UnreachedPeoplesLeastReachedAreas280-180x138.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:138;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:48:\"UnreachedPeoplesLeastReachedAreas280-280x272.jpg\";s:5:\"width\";i:280;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:48:\"UnreachedPeoplesLeastReachedAreas280-280x295.jpg\";s:5:\"width\";i:280;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:48:\"UnreachedPeoplesLeastReachedAreas280-280x214.jpg\";s:5:\"width\";i:280;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-four\";a:4:{s:4:\"file\";s:48:\"UnreachedPeoplesLeastReachedAreas280-220x161.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:161;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:48:\"UnreachedPeoplesLeastReachedAreas280-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-six\";a:4:{s:4:\"file\";s:48:\"UnreachedPeoplesLeastReachedAreas280-147x118.jpg\";s:5:\"width\";i:147;s:6:\"height\";i:118;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:46:\"UnreachedPeoplesLeastReachedAreas280-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:1;}}");
INSERT INTO `bupg_postmeta` VALUES("16250", "11270", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16401", "11271", "_wp_attached_file", "2015/05/Japanese13966032_ml.jpg");
INSERT INTO `bupg_postmeta` VALUES("16402", "11271", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1678;s:6:\"height\";i:1119;s:4:\"file\";s:31:\"2015/05/Japanese13966032_ml.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"Japanese13966032_ml-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"Japanese13966032_ml-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:32:\"Japanese13966032_ml-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:31:\"Japanese13966032_ml-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:31:\"Japanese13966032_ml-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"tabs-img\";a:4:{s:4:\"file\";s:29:\"Japanese13966032_ml-52x50.jpg\";s:5:\"width\";i:52;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"related-img\";a:4:{s:4:\"file\";s:31:\"Japanese13966032_ml-180x138.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:138;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:31:\"Japanese13966032_ml-940x400.jpg\";s:5:\"width\";i:940;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:31:\"Japanese13966032_ml-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:31:\"Japanese13966032_ml-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:31:\"Japanese13966032_ml-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-four\";a:4:{s:4:\"file\";s:31:\"Japanese13966032_ml-220x161.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:161;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:31:\"Japanese13966032_ml-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-six\";a:4:{s:4:\"file\";s:31:\"Japanese13966032_ml-147x118.jpg\";s:5:\"width\";i:147;s:6:\"height\";i:118;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:31:\"Japanese13966032_ml-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:29:\"Japanese13966032_ml-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `bupg_postmeta` VALUES("16407", "11272", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16420", "11273", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16441", "11274", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16454", "11275", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16467", "11276", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16480", "11277", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16493", "11278", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16506", "11279", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16515", "11280", "_edit_last", "1");
INSERT INTO `bupg_postmeta` VALUES("16516", "11280", "_edit_lock", "1434822529:1");
INSERT INTO `bupg_postmeta` VALUES("16517", "11280", "_wp_page_template", "default");
INSERT INTO `bupg_postmeta` VALUES("16522", "11280", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("16523", "11280", "fusion_builder_status", "active");
INSERT INTO `bupg_postmeta` VALUES("16524", "11281", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16525", "11280", "pyre_slider_position", "default");
INSERT INTO `bupg_postmeta` VALUES("16526", "11280", "pyre_slider_type", "no");
INSERT INTO `bupg_postmeta` VALUES("16527", "11280", "pyre_slider", "0");
INSERT INTO `bupg_postmeta` VALUES("16528", "11280", "pyre_wooslider", "0");
INSERT INTO `bupg_postmeta` VALUES("16529", "11280", "pyre_revslider", "0");
INSERT INTO `bupg_postmeta` VALUES("16530", "11280", "pyre_elasticslider", "0");
INSERT INTO `bupg_postmeta` VALUES("16531", "11280", "pyre_fallback", "");
INSERT INTO `bupg_postmeta` VALUES("16532", "11280", "pyre_avada_rev_styles", "default");
INSERT INTO `bupg_postmeta` VALUES("16533", "11280", "pyre_main_top_padding", "");
INSERT INTO `bupg_postmeta` VALUES("16534", "11280", "pyre_main_bottom_padding", "");
INSERT INTO `bupg_postmeta` VALUES("16535", "11280", "pyre_hundredp_padding", "");
INSERT INTO `bupg_postmeta` VALUES("16536", "11280", "pyre_show_first_featured_image", "no");
INSERT INTO `bupg_postmeta` VALUES("16537", "11280", "pyre_display_header", "yes");
INSERT INTO `bupg_postmeta` VALUES("16538", "11280", "pyre_header_100_width", "default");
INSERT INTO `bupg_postmeta` VALUES("16539", "11280", "pyre_header_bg", "");
INSERT INTO `bupg_postmeta` VALUES("16540", "11280", "pyre_header_bg_color", "#29292A");
INSERT INTO `bupg_postmeta` VALUES("16541", "11280", "pyre_header_bg_opacity", "");
INSERT INTO `bupg_postmeta` VALUES("16542", "11280", "pyre_header_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("16543", "11280", "pyre_header_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("16544", "11280", "pyre_displayed_menu", "36");
INSERT INTO `bupg_postmeta` VALUES("16545", "11280", "pyre_display_footer", "default");
INSERT INTO `bupg_postmeta` VALUES("16546", "11280", "pyre_display_copyright", "default");
INSERT INTO `bupg_postmeta` VALUES("16547", "11280", "pyre_footer_100_width", "default");
INSERT INTO `bupg_postmeta` VALUES("16548", "11280", "pyre_sidebar_position", "right");
INSERT INTO `bupg_postmeta` VALUES("16549", "11280", "pyre_page_bg_layout", "default");
INSERT INTO `bupg_postmeta` VALUES("16550", "11280", "pyre_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("16551", "11280", "pyre_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("16552", "11280", "pyre_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("16553", "11280", "pyre_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("16554", "11280", "pyre_wide_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("16555", "11280", "pyre_wide_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("16556", "11280", "pyre_wide_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("16557", "11280", "pyre_wide_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("16558", "11280", "pyre_portfolio_width_100", "no");
INSERT INTO `bupg_postmeta` VALUES("16559", "11280", "pyre_portfolio_content_length", "default");
INSERT INTO `bupg_postmeta` VALUES("16560", "11280", "pyre_portfolio_excerpt", "");
INSERT INTO `bupg_postmeta` VALUES("16561", "11280", "pyre_portfolio_filters", "yes");
INSERT INTO `bupg_postmeta` VALUES("16562", "11280", "pyre_portfolio_text_layout", "default");
INSERT INTO `bupg_postmeta` VALUES("16563", "11280", "pyre_portfolio_featured_image_size", "default");
INSERT INTO `bupg_postmeta` VALUES("16564", "11280", "pyre_portfolio_column_spacing", "");
INSERT INTO `bupg_postmeta` VALUES("16565", "11280", "pyre_page_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("16566", "11280", "pyre_page_title_text", "yes");
INSERT INTO `bupg_postmeta` VALUES("16567", "11280", "pyre_page_title_text_alignment", "default");
INSERT INTO `bupg_postmeta` VALUES("16568", "11280", "pyre_page_title_custom_text", "");
INSERT INTO `bupg_postmeta` VALUES("16569", "11280", "pyre_page_title_100_width", "default");
INSERT INTO `bupg_postmeta` VALUES("16570", "11280", "pyre_page_title_text_size", "24px");
INSERT INTO `bupg_postmeta` VALUES("16571", "11280", "pyre_page_title_custom_subheader", "");
INSERT INTO `bupg_postmeta` VALUES("16572", "11280", "pyre_page_title_custom_subheader_text_size", "");
INSERT INTO `bupg_postmeta` VALUES("16573", "11280", "pyre_page_title_font_color", "");
INSERT INTO `bupg_postmeta` VALUES("16574", "11280", "pyre_page_title_height", "54px");
INSERT INTO `bupg_postmeta` VALUES("16575", "11280", "pyre_page_title_bar_bg", "none");
INSERT INTO `bupg_postmeta` VALUES("16576", "11280", "pyre_page_title_bar_bg_retina", "");
INSERT INTO `bupg_postmeta` VALUES("16577", "11280", "pyre_page_title_bar_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("16578", "11280", "pyre_page_title_bar_bg_full", "default");
INSERT INTO `bupg_postmeta` VALUES("16579", "11280", "pyre_page_title_bg_parallax", "default");
INSERT INTO `bupg_postmeta` VALUES("16580", "11280", "pyre_page_title_breadcrumbs_search_bar", "none");
INSERT INTO `bupg_postmeta` VALUES("16593", "11282", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16606", "11283", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16635", "11284", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16648", "11285", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16669", "11286", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16692", "11287", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16741", "11289", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16746", "11290", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16755", "11291", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16760", "11292", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16793", "11293", "_edit_last", "1");
INSERT INTO `bupg_postmeta` VALUES("16794", "11293", "_edit_lock", "1435539944:1");
INSERT INTO `bupg_postmeta` VALUES("16795", "11293", "_wp_page_template", "default");
INSERT INTO `bupg_postmeta` VALUES("16800", "11293", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("16801", "11293", "fusion_builder_status", "active");
INSERT INTO `bupg_postmeta` VALUES("16802", "11294", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16803", "11293", "pyre_slider_position", "default");
INSERT INTO `bupg_postmeta` VALUES("16804", "11293", "pyre_slider_type", "no");
INSERT INTO `bupg_postmeta` VALUES("16805", "11293", "pyre_slider", "0");
INSERT INTO `bupg_postmeta` VALUES("16806", "11293", "pyre_wooslider", "0");
INSERT INTO `bupg_postmeta` VALUES("16807", "11293", "pyre_revslider", "0");
INSERT INTO `bupg_postmeta` VALUES("16808", "11293", "pyre_elasticslider", "0");
INSERT INTO `bupg_postmeta` VALUES("16809", "11293", "pyre_fallback", "");
INSERT INTO `bupg_postmeta` VALUES("16810", "11293", "pyre_avada_rev_styles", "default");
INSERT INTO `bupg_postmeta` VALUES("16811", "11293", "pyre_main_top_padding", "");
INSERT INTO `bupg_postmeta` VALUES("16812", "11293", "pyre_main_bottom_padding", "");
INSERT INTO `bupg_postmeta` VALUES("16813", "11293", "pyre_hundredp_padding", "");
INSERT INTO `bupg_postmeta` VALUES("16814", "11293", "pyre_show_first_featured_image", "no");
INSERT INTO `bupg_postmeta` VALUES("16815", "11293", "pyre_display_header", "yes");
INSERT INTO `bupg_postmeta` VALUES("16816", "11293", "pyre_header_100_width", "default");
INSERT INTO `bupg_postmeta` VALUES("16817", "11293", "pyre_header_bg", "");
INSERT INTO `bupg_postmeta` VALUES("16818", "11293", "pyre_header_bg_color", "#29292A");
INSERT INTO `bupg_postmeta` VALUES("16819", "11293", "pyre_header_bg_opacity", "");
INSERT INTO `bupg_postmeta` VALUES("16820", "11293", "pyre_header_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("16821", "11293", "pyre_header_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("16822", "11293", "pyre_displayed_menu", "36");
INSERT INTO `bupg_postmeta` VALUES("16823", "11293", "pyre_display_footer", "default");
INSERT INTO `bupg_postmeta` VALUES("16824", "11293", "pyre_display_copyright", "default");
INSERT INTO `bupg_postmeta` VALUES("16825", "11293", "pyre_footer_100_width", "default");
INSERT INTO `bupg_postmeta` VALUES("16826", "11293", "pyre_sidebar_position", "default");
INSERT INTO `bupg_postmeta` VALUES("16827", "11293", "pyre_page_bg_layout", "default");
INSERT INTO `bupg_postmeta` VALUES("16828", "11293", "pyre_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("16829", "11293", "pyre_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("16830", "11293", "pyre_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("16831", "11293", "pyre_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("16832", "11293", "pyre_wide_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("16833", "11293", "pyre_wide_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("16834", "11293", "pyre_wide_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("16835", "11293", "pyre_wide_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("16836", "11293", "pyre_portfolio_width_100", "no");
INSERT INTO `bupg_postmeta` VALUES("16837", "11293", "pyre_portfolio_content_length", "default");
INSERT INTO `bupg_postmeta` VALUES("16838", "11293", "pyre_portfolio_excerpt", "");
INSERT INTO `bupg_postmeta` VALUES("16839", "11293", "pyre_portfolio_filters", "yes");
INSERT INTO `bupg_postmeta` VALUES("16840", "11293", "pyre_portfolio_text_layout", "default");
INSERT INTO `bupg_postmeta` VALUES("16841", "11293", "pyre_portfolio_featured_image_size", "default");
INSERT INTO `bupg_postmeta` VALUES("16842", "11293", "pyre_portfolio_column_spacing", "");
INSERT INTO `bupg_postmeta` VALUES("16843", "11293", "pyre_page_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("16844", "11293", "pyre_page_title_text", "yes");
INSERT INTO `bupg_postmeta` VALUES("16845", "11293", "pyre_page_title_text_alignment", "default");
INSERT INTO `bupg_postmeta` VALUES("16846", "11293", "pyre_page_title_custom_text", "");
INSERT INTO `bupg_postmeta` VALUES("16847", "11293", "pyre_page_title_100_width", "default");
INSERT INTO `bupg_postmeta` VALUES("16848", "11293", "pyre_page_title_text_size", "24px");
INSERT INTO `bupg_postmeta` VALUES("16849", "11293", "pyre_page_title_custom_subheader", "");
INSERT INTO `bupg_postmeta` VALUES("16850", "11293", "pyre_page_title_custom_subheader_text_size", "");
INSERT INTO `bupg_postmeta` VALUES("16851", "11293", "pyre_page_title_font_color", "");
INSERT INTO `bupg_postmeta` VALUES("16852", "11293", "pyre_page_title_height", "54px");
INSERT INTO `bupg_postmeta` VALUES("16853", "11293", "pyre_page_title_bar_bg", "none");
INSERT INTO `bupg_postmeta` VALUES("16854", "11293", "pyre_page_title_bar_bg_retina", "");
INSERT INTO `bupg_postmeta` VALUES("16855", "11293", "pyre_page_title_bar_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("16856", "11293", "pyre_page_title_bar_bg_full", "default");
INSERT INTO `bupg_postmeta` VALUES("16857", "11293", "pyre_page_title_bg_parallax", "default");
INSERT INTO `bupg_postmeta` VALUES("16858", "11293", "pyre_page_title_breadcrumbs_search_bar", "none");
INSERT INTO `bupg_postmeta` VALUES("16871", "11295", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16884", "11296", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16897", "11297", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16906", "11289", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16911", "11298", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16924", "11299", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16937", "11300", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16950", "11301", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16963", "11302", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16976", "11303", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16989", "11304", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("16998", "11305", "_menu_item_type", "post_type");
INSERT INTO `bupg_postmeta` VALUES("16999", "11305", "_menu_item_menu_item_parent", "0");
INSERT INTO `bupg_postmeta` VALUES("17000", "11305", "_menu_item_object_id", "11116");
INSERT INTO `bupg_postmeta` VALUES("17001", "11305", "_menu_item_object", "page");
INSERT INTO `bupg_postmeta` VALUES("17002", "11305", "_menu_item_target", "");
INSERT INTO `bupg_postmeta` VALUES("17003", "11305", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("17004", "11305", "_menu_item_xfn", "");
INSERT INTO `bupg_postmeta` VALUES("17005", "11305", "_menu_item_url", "");
INSERT INTO `bupg_postmeta` VALUES("17007", "11305", "_menu_item_fusion_megamenu_status", "");
INSERT INTO `bupg_postmeta` VALUES("17008", "11305", "_menu_item_fusion_megamenu_width", "");
INSERT INTO `bupg_postmeta` VALUES("17009", "11305", "_menu_item_fusion_megamenu_columns", "auto");
INSERT INTO `bupg_postmeta` VALUES("17010", "11305", "_menu_item_fusion_megamenu_columnwidth", "");
INSERT INTO `bupg_postmeta` VALUES("17011", "11305", "_menu_item_fusion_megamenu_title", "");
INSERT INTO `bupg_postmeta` VALUES("17012", "11305", "_menu_item_fusion_megamenu_widgetarea", "0");
INSERT INTO `bupg_postmeta` VALUES("17013", "11305", "_menu_item_fusion_megamenu_icon", "");
INSERT INTO `bupg_postmeta` VALUES("17014", "11305", "_menu_item_fusion_megamenu_thumbnail", "");
INSERT INTO `bupg_postmeta` VALUES("17015", "11306", "_menu_item_type", "post_type");
INSERT INTO `bupg_postmeta` VALUES("17016", "11306", "_menu_item_menu_item_parent", "0");
INSERT INTO `bupg_postmeta` VALUES("17017", "11306", "_menu_item_object_id", "11280");
INSERT INTO `bupg_postmeta` VALUES("17018", "11306", "_menu_item_object", "page");
INSERT INTO `bupg_postmeta` VALUES("17019", "11306", "_menu_item_target", "");
INSERT INTO `bupg_postmeta` VALUES("17020", "11306", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("17021", "11306", "_menu_item_xfn", "");
INSERT INTO `bupg_postmeta` VALUES("17022", "11306", "_menu_item_url", "");
INSERT INTO `bupg_postmeta` VALUES("17024", "11306", "_menu_item_fusion_megamenu_status", "");
INSERT INTO `bupg_postmeta` VALUES("17025", "11306", "_menu_item_fusion_megamenu_width", "");
INSERT INTO `bupg_postmeta` VALUES("17026", "11306", "_menu_item_fusion_megamenu_columns", "auto");
INSERT INTO `bupg_postmeta` VALUES("17027", "11306", "_menu_item_fusion_megamenu_columnwidth", "");
INSERT INTO `bupg_postmeta` VALUES("17028", "11306", "_menu_item_fusion_megamenu_title", "");
INSERT INTO `bupg_postmeta` VALUES("17029", "11306", "_menu_item_fusion_megamenu_widgetarea", "0");
INSERT INTO `bupg_postmeta` VALUES("17030", "11306", "_menu_item_fusion_megamenu_icon", "");
INSERT INTO `bupg_postmeta` VALUES("17031", "11306", "_menu_item_fusion_megamenu_thumbnail", "");
INSERT INTO `bupg_postmeta` VALUES("17032", "11307", "_menu_item_type", "post_type");
INSERT INTO `bupg_postmeta` VALUES("17033", "11307", "_menu_item_menu_item_parent", "0");
INSERT INTO `bupg_postmeta` VALUES("17034", "11307", "_menu_item_object_id", "11293");
INSERT INTO `bupg_postmeta` VALUES("17035", "11307", "_menu_item_object", "page");
INSERT INTO `bupg_postmeta` VALUES("17036", "11307", "_menu_item_target", "");
INSERT INTO `bupg_postmeta` VALUES("17037", "11307", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("17038", "11307", "_menu_item_xfn", "");
INSERT INTO `bupg_postmeta` VALUES("17039", "11307", "_menu_item_url", "");
INSERT INTO `bupg_postmeta` VALUES("17041", "11307", "_menu_item_fusion_megamenu_status", "");
INSERT INTO `bupg_postmeta` VALUES("17042", "11307", "_menu_item_fusion_megamenu_width", "");
INSERT INTO `bupg_postmeta` VALUES("17043", "11307", "_menu_item_fusion_megamenu_columns", "auto");
INSERT INTO `bupg_postmeta` VALUES("17044", "11307", "_menu_item_fusion_megamenu_columnwidth", "");
INSERT INTO `bupg_postmeta` VALUES("17045", "11307", "_menu_item_fusion_megamenu_title", "");
INSERT INTO `bupg_postmeta` VALUES("17046", "11307", "_menu_item_fusion_megamenu_widgetarea", "0");
INSERT INTO `bupg_postmeta` VALUES("17047", "11307", "_menu_item_fusion_megamenu_icon", "");
INSERT INTO `bupg_postmeta` VALUES("17048", "11307", "_menu_item_fusion_megamenu_thumbnail", "");
INSERT INTO `bupg_postmeta` VALUES("17053", "11308", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17074", "11309", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17087", "11310", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17100", "11311", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17109", "86", "_edit_last", "1");
INSERT INTO `bupg_postmeta` VALUES("17114", "86", "pyre_avada_rev_styles", "default");
INSERT INTO `bupg_postmeta` VALUES("17115", "86", "pyre_show_first_featured_image", "no");
INSERT INTO `bupg_postmeta` VALUES("17116", "86", "pyre_header_100_width", "default");
INSERT INTO `bupg_postmeta` VALUES("17117", "86", "pyre_header_bg_opacity", "");
INSERT INTO `bupg_postmeta` VALUES("17118", "86", "pyre_footer_100_width", "default");
INSERT INTO `bupg_postmeta` VALUES("17119", "86", "pyre_portfolio_width_100", "no");
INSERT INTO `bupg_postmeta` VALUES("17120", "86", "pyre_portfolio_column_spacing", "");
INSERT INTO `bupg_postmeta` VALUES("17121", "86", "pyre_page_title_text_alignment", "default");
INSERT INTO `bupg_postmeta` VALUES("17122", "86", "pyre_page_title_100_width", "default");
INSERT INTO `bupg_postmeta` VALUES("17123", "86", "pyre_page_title_text_size", "24px");
INSERT INTO `bupg_postmeta` VALUES("17124", "86", "pyre_page_title_custom_subheader_text_size", "");
INSERT INTO `bupg_postmeta` VALUES("17125", "86", "pyre_page_title_font_color", "");
INSERT INTO `bupg_postmeta` VALUES("17126", "86", "pyre_page_title_breadcrumbs_search_bar", "none");
INSERT INTO `bupg_postmeta` VALUES("17143", "11312", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17176", "11313", "_edit_last", "1");
INSERT INTO `bupg_postmeta` VALUES("17177", "11313", "_edit_lock", "1435536809:1");
INSERT INTO `bupg_postmeta` VALUES("17178", "11313", "_wp_page_template", "default");
INSERT INTO `bupg_postmeta` VALUES("17183", "11313", "slide_template", "default");
INSERT INTO `bupg_postmeta` VALUES("17184", "11313", "fusion_builder_status", "active");
INSERT INTO `bupg_postmeta` VALUES("17185", "11314", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17186", "11313", "pyre_slider_position", "default");
INSERT INTO `bupg_postmeta` VALUES("17187", "11313", "pyre_slider_type", "no");
INSERT INTO `bupg_postmeta` VALUES("17188", "11313", "pyre_slider", "0");
INSERT INTO `bupg_postmeta` VALUES("17189", "11313", "pyre_wooslider", "0");
INSERT INTO `bupg_postmeta` VALUES("17190", "11313", "pyre_revslider", "0");
INSERT INTO `bupg_postmeta` VALUES("17191", "11313", "pyre_elasticslider", "0");
INSERT INTO `bupg_postmeta` VALUES("17192", "11313", "pyre_fallback", "");
INSERT INTO `bupg_postmeta` VALUES("17193", "11313", "pyre_avada_rev_styles", "default");
INSERT INTO `bupg_postmeta` VALUES("17194", "11313", "pyre_main_top_padding", "");
INSERT INTO `bupg_postmeta` VALUES("17195", "11313", "pyre_main_bottom_padding", "");
INSERT INTO `bupg_postmeta` VALUES("17196", "11313", "pyre_hundredp_padding", "");
INSERT INTO `bupg_postmeta` VALUES("17197", "11313", "pyre_show_first_featured_image", "no");
INSERT INTO `bupg_postmeta` VALUES("17198", "11313", "pyre_display_header", "yes");
INSERT INTO `bupg_postmeta` VALUES("17199", "11313", "pyre_header_100_width", "default");
INSERT INTO `bupg_postmeta` VALUES("17200", "11313", "pyre_header_bg", "");
INSERT INTO `bupg_postmeta` VALUES("17201", "11313", "pyre_header_bg_color", "#29292A");
INSERT INTO `bupg_postmeta` VALUES("17202", "11313", "pyre_header_bg_opacity", "");
INSERT INTO `bupg_postmeta` VALUES("17203", "11313", "pyre_header_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("17204", "11313", "pyre_header_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("17205", "11313", "pyre_displayed_menu", "36");
INSERT INTO `bupg_postmeta` VALUES("17206", "11313", "pyre_display_footer", "default");
INSERT INTO `bupg_postmeta` VALUES("17207", "11313", "pyre_display_copyright", "default");
INSERT INTO `bupg_postmeta` VALUES("17208", "11313", "pyre_footer_100_width", "default");
INSERT INTO `bupg_postmeta` VALUES("17209", "11313", "pyre_sidebar_position", "right");
INSERT INTO `bupg_postmeta` VALUES("17210", "11313", "pyre_page_bg_layout", "default");
INSERT INTO `bupg_postmeta` VALUES("17211", "11313", "pyre_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("17212", "11313", "pyre_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("17213", "11313", "pyre_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("17214", "11313", "pyre_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("17215", "11313", "pyre_wide_page_bg", "");
INSERT INTO `bupg_postmeta` VALUES("17216", "11313", "pyre_wide_page_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("17217", "11313", "pyre_wide_page_bg_full", "no");
INSERT INTO `bupg_postmeta` VALUES("17218", "11313", "pyre_wide_page_bg_repeat", "repeat");
INSERT INTO `bupg_postmeta` VALUES("17219", "11313", "pyre_portfolio_width_100", "no");
INSERT INTO `bupg_postmeta` VALUES("17220", "11313", "pyre_portfolio_content_length", "default");
INSERT INTO `bupg_postmeta` VALUES("17221", "11313", "pyre_portfolio_excerpt", "");
INSERT INTO `bupg_postmeta` VALUES("17222", "11313", "pyre_portfolio_filters", "yes");
INSERT INTO `bupg_postmeta` VALUES("17223", "11313", "pyre_portfolio_text_layout", "default");
INSERT INTO `bupg_postmeta` VALUES("17224", "11313", "pyre_portfolio_featured_image_size", "default");
INSERT INTO `bupg_postmeta` VALUES("17225", "11313", "pyre_portfolio_column_spacing", "");
INSERT INTO `bupg_postmeta` VALUES("17226", "11313", "pyre_page_title", "yes");
INSERT INTO `bupg_postmeta` VALUES("17227", "11313", "pyre_page_title_text", "yes");
INSERT INTO `bupg_postmeta` VALUES("17228", "11313", "pyre_page_title_text_alignment", "default");
INSERT INTO `bupg_postmeta` VALUES("17229", "11313", "pyre_page_title_custom_text", "");
INSERT INTO `bupg_postmeta` VALUES("17230", "11313", "pyre_page_title_100_width", "default");
INSERT INTO `bupg_postmeta` VALUES("17231", "11313", "pyre_page_title_text_size", "24px");
INSERT INTO `bupg_postmeta` VALUES("17232", "11313", "pyre_page_title_custom_subheader", "");
INSERT INTO `bupg_postmeta` VALUES("17233", "11313", "pyre_page_title_custom_subheader_text_size", "");
INSERT INTO `bupg_postmeta` VALUES("17234", "11313", "pyre_page_title_font_color", "");
INSERT INTO `bupg_postmeta` VALUES("17235", "11313", "pyre_page_title_height", "54px");
INSERT INTO `bupg_postmeta` VALUES("17236", "11313", "pyre_page_title_bar_bg", "none");
INSERT INTO `bupg_postmeta` VALUES("17237", "11313", "pyre_page_title_bar_bg_retina", "");
INSERT INTO `bupg_postmeta` VALUES("17238", "11313", "pyre_page_title_bar_bg_color", "");
INSERT INTO `bupg_postmeta` VALUES("17239", "11313", "pyre_page_title_bar_bg_full", "default");
INSERT INTO `bupg_postmeta` VALUES("17240", "11313", "pyre_page_title_bg_parallax", "default");
INSERT INTO `bupg_postmeta` VALUES("17241", "11313", "pyre_page_title_breadcrumbs_search_bar", "none");
INSERT INTO `bupg_postmeta` VALUES("17270", "11316", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17279", "11317", "_menu_item_type", "post_type");
INSERT INTO `bupg_postmeta` VALUES("17280", "11317", "_menu_item_menu_item_parent", "0");
INSERT INTO `bupg_postmeta` VALUES("17281", "11317", "_menu_item_object_id", "11313");
INSERT INTO `bupg_postmeta` VALUES("17282", "11317", "_menu_item_object", "page");
INSERT INTO `bupg_postmeta` VALUES("17283", "11317", "_menu_item_target", "");
INSERT INTO `bupg_postmeta` VALUES("17284", "11317", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("17285", "11317", "_menu_item_xfn", "");
INSERT INTO `bupg_postmeta` VALUES("17286", "11317", "_menu_item_url", "");
INSERT INTO `bupg_postmeta` VALUES("17288", "11317", "_menu_item_fusion_megamenu_status", "");
INSERT INTO `bupg_postmeta` VALUES("17289", "11317", "_menu_item_fusion_megamenu_width", "");
INSERT INTO `bupg_postmeta` VALUES("17290", "11317", "_menu_item_fusion_megamenu_columns", "auto");
INSERT INTO `bupg_postmeta` VALUES("17291", "11317", "_menu_item_fusion_megamenu_columnwidth", "");
INSERT INTO `bupg_postmeta` VALUES("17292", "11317", "_menu_item_fusion_megamenu_title", "");
INSERT INTO `bupg_postmeta` VALUES("17293", "11317", "_menu_item_fusion_megamenu_widgetarea", "0");
INSERT INTO `bupg_postmeta` VALUES("17294", "11317", "_menu_item_fusion_megamenu_icon", "");
INSERT INTO `bupg_postmeta` VALUES("17295", "11317", "_menu_item_fusion_megamenu_thumbnail", "");
INSERT INTO `bupg_postmeta` VALUES("17296", "11318", "_menu_item_type", "post_type");
INSERT INTO `bupg_postmeta` VALUES("17297", "11318", "_menu_item_menu_item_parent", "0");
INSERT INTO `bupg_postmeta` VALUES("17298", "11318", "_menu_item_object_id", "86");
INSERT INTO `bupg_postmeta` VALUES("17299", "11318", "_menu_item_object", "page");
INSERT INTO `bupg_postmeta` VALUES("17300", "11318", "_menu_item_target", "");
INSERT INTO `bupg_postmeta` VALUES("17301", "11318", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("17302", "11318", "_menu_item_xfn", "");
INSERT INTO `bupg_postmeta` VALUES("17303", "11318", "_menu_item_url", "");
INSERT INTO `bupg_postmeta` VALUES("17305", "11318", "_menu_item_fusion_megamenu_status", "");
INSERT INTO `bupg_postmeta` VALUES("17306", "11318", "_menu_item_fusion_megamenu_width", "");
INSERT INTO `bupg_postmeta` VALUES("17307", "11318", "_menu_item_fusion_megamenu_columns", "auto");
INSERT INTO `bupg_postmeta` VALUES("17308", "11318", "_menu_item_fusion_megamenu_columnwidth", "");
INSERT INTO `bupg_postmeta` VALUES("17309", "11318", "_menu_item_fusion_megamenu_title", "");
INSERT INTO `bupg_postmeta` VALUES("17310", "11318", "_menu_item_fusion_megamenu_widgetarea", "0");
INSERT INTO `bupg_postmeta` VALUES("17311", "11318", "_menu_item_fusion_megamenu_icon", "");
INSERT INTO `bupg_postmeta` VALUES("17312", "11318", "_menu_item_fusion_megamenu_thumbnail", "");
INSERT INTO `bupg_postmeta` VALUES("17317", "11319", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17330", "11320", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17343", "11321", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17360", "11322", "_wp_attached_file", "2015/05/African-Ghanaian27599918_ml.jpg");
INSERT INTO `bupg_postmeta` VALUES("17361", "11322", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1678;s:6:\"height\";i:1119;s:4:\"file\";s:39:\"2015/05/African-Ghanaian27599918_ml.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:39:\"African-Ghanaian27599918_ml-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:39:\"African-Ghanaian27599918_ml-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:40:\"African-Ghanaian27599918_ml-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:39:\"African-Ghanaian27599918_ml-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:39:\"African-Ghanaian27599918_ml-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"tabs-img\";a:4:{s:4:\"file\";s:37:\"African-Ghanaian27599918_ml-52x50.jpg\";s:5:\"width\";i:52;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"related-img\";a:4:{s:4:\"file\";s:39:\"African-Ghanaian27599918_ml-180x138.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:138;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:39:\"African-Ghanaian27599918_ml-940x400.jpg\";s:5:\"width\";i:940;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:39:\"African-Ghanaian27599918_ml-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:39:\"African-Ghanaian27599918_ml-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:39:\"African-Ghanaian27599918_ml-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-four\";a:4:{s:4:\"file\";s:39:\"African-Ghanaian27599918_ml-220x161.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:161;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:39:\"African-Ghanaian27599918_ml-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-six\";a:4:{s:4:\"file\";s:39:\"African-Ghanaian27599918_ml-147x118.jpg\";s:5:\"width\";i:147;s:6:\"height\";i:118;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:39:\"African-Ghanaian27599918_ml-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:37:\"African-Ghanaian27599918_ml-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `bupg_postmeta` VALUES("17362", "11323", "_wp_attached_file", "2015/05/Filipino-Tagalog19179776_ml.jpg");
INSERT INTO `bupg_postmeta` VALUES("17363", "11323", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1119;s:6:\"height\";i:1678;s:4:\"file\";s:39:\"2015/05/Filipino-Tagalog19179776_ml.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:39:\"Filipino-Tagalog19179776_ml-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:39:\"Filipino-Tagalog19179776_ml-200x300.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:40:\"Filipino-Tagalog19179776_ml-683x1024.jpg\";s:5:\"width\";i:683;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:39:\"Filipino-Tagalog19179776_ml-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:39:\"Filipino-Tagalog19179776_ml-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"tabs-img\";a:4:{s:4:\"file\";s:37:\"Filipino-Tagalog19179776_ml-52x50.jpg\";s:5:\"width\";i:52;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"related-img\";a:4:{s:4:\"file\";s:39:\"Filipino-Tagalog19179776_ml-180x138.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:138;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:39:\"Filipino-Tagalog19179776_ml-940x400.jpg\";s:5:\"width\";i:940;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:39:\"Filipino-Tagalog19179776_ml-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:39:\"Filipino-Tagalog19179776_ml-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:39:\"Filipino-Tagalog19179776_ml-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-four\";a:4:{s:4:\"file\";s:39:\"Filipino-Tagalog19179776_ml-220x161.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:161;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:39:\"Filipino-Tagalog19179776_ml-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-six\";a:4:{s:4:\"file\";s:39:\"Filipino-Tagalog19179776_ml-147x118.jpg\";s:5:\"width\";i:147;s:6:\"height\";i:118;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:39:\"Filipino-Tagalog19179776_ml-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:37:\"Filipino-Tagalog19179776_ml-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `bupg_postmeta` VALUES("17364", "11324", "_wp_attached_file", "2015/05/India-Gujarat13204440_ml.jpg");
INSERT INTO `bupg_postmeta` VALUES("17365", "11324", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1633;s:6:\"height\";i:1150;s:4:\"file\";s:36:\"2015/05/India-Gujarat13204440_ml.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"India-Gujarat13204440_ml-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"India-Gujarat13204440_ml-300x211.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:211;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:37:\"India-Gujarat13204440_ml-1024x721.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:721;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:36:\"India-Gujarat13204440_ml-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:36:\"India-Gujarat13204440_ml-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"tabs-img\";a:4:{s:4:\"file\";s:34:\"India-Gujarat13204440_ml-52x50.jpg\";s:5:\"width\";i:52;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"related-img\";a:4:{s:4:\"file\";s:36:\"India-Gujarat13204440_ml-180x138.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:138;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:36:\"India-Gujarat13204440_ml-940x400.jpg\";s:5:\"width\";i:940;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:36:\"India-Gujarat13204440_ml-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:36:\"India-Gujarat13204440_ml-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:36:\"India-Gujarat13204440_ml-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-four\";a:4:{s:4:\"file\";s:36:\"India-Gujarat13204440_ml-220x161.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:161;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:36:\"India-Gujarat13204440_ml-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-six\";a:4:{s:4:\"file\";s:36:\"India-Gujarat13204440_ml-147x118.jpg\";s:5:\"width\";i:147;s:6:\"height\";i:118;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:36:\"India-Gujarat13204440_ml-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:34:\"India-Gujarat13204440_ml-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `bupg_postmeta` VALUES("17370", "11325", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17383", "11326", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17396", "11327", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17405", "11328", "_wp_attached_file", "2015/05/Mexican20345046_ml.jpg");
INSERT INTO `bupg_postmeta` VALUES("17406", "11328", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1681;s:6:\"height\";i:1117;s:4:\"file\";s:30:\"2015/05/Mexican20345046_ml.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"Mexican20345046_ml-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"Mexican20345046_ml-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:31:\"Mexican20345046_ml-1024x680.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:680;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:30:\"Mexican20345046_ml-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:30:\"Mexican20345046_ml-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"tabs-img\";a:4:{s:4:\"file\";s:28:\"Mexican20345046_ml-52x50.jpg\";s:5:\"width\";i:52;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"related-img\";a:4:{s:4:\"file\";s:30:\"Mexican20345046_ml-180x138.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:138;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:30:\"Mexican20345046_ml-940x400.jpg\";s:5:\"width\";i:940;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:30:\"Mexican20345046_ml-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:30:\"Mexican20345046_ml-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:30:\"Mexican20345046_ml-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-four\";a:4:{s:4:\"file\";s:30:\"Mexican20345046_ml-220x161.jpg\";s:5:\"width\";i:220;s:6:\"height\";i:161;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:30:\"Mexican20345046_ml-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-six\";a:4:{s:4:\"file\";s:30:\"Mexican20345046_ml-147x118.jpg\";s:5:\"width\";i:147;s:6:\"height\";i:118;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:30:\"Mexican20345046_ml-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:28:\"Mexican20345046_ml-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `bupg_postmeta` VALUES("17411", "11329", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17424", "11330", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17437", "11331", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17450", "11332", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17463", "11333", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17472", "11334", "_form", "<p>Your Name (required)<br />\n    [text* your-name] </p>\n\n<p>Your Email (required)<br />\n    [email* your-email] </p>\n\n<p>Subject<br />\n    [text your-subject] </p>\n\n<p>Your Message<br />\n    [textarea your-message] </p>\n\n<p>[submit \"Send\"]</p>");
INSERT INTO `bupg_postmeta` VALUES("17473", "11334", "_mail", "a:8:{s:7:\"subject\";s:14:\"[your-subject]\";s:6:\"sender\";s:33:\"[your-name] <kencook75@gmail.com>\";s:4:\"body\";s:176:\"From: [your-name] <[your-email]>\nSubject: [your-subject]\n\nMessage Body:\n[your-message]\n\n--\nThis e-mail was sent from a contact form on Birmingham UPG (http://birminghamupg.com)\";s:9:\"recipient\";s:19:\"kencook75@gmail.com\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `bupg_postmeta` VALUES("17474", "11334", "_mail_2", "a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:14:\"[your-subject]\";s:6:\"sender\";s:36:\"Birmingham UPG <kencook75@gmail.com>\";s:4:\"body\";s:126:\"Message Body:\n[your-message]\n\n--\nThis e-mail was sent from a contact form on Birmingham UPG (http://birminghamupg.com/bhamupg)\";s:9:\"recipient\";s:12:\"[your-email]\";s:18:\"additional_headers\";s:29:\"Reply-To: kencook75@gmail.com\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO `bupg_postmeta` VALUES("17475", "11334", "_messages", "a:23:{s:12:\"mail_sent_ok\";s:43:\"Your message was sent successfully. Thanks.\";s:12:\"mail_sent_ng\";s:93:\"Failed to send your message. Please try later or contact the administrator by another method.\";s:16:\"validation_error\";s:74:\"Validation errors occurred. Please confirm the fields and submit it again.\";s:4:\"spam\";s:93:\"Failed to send your message. Please try later or contact the administrator by another method.\";s:12:\"accept_terms\";s:35:\"Please accept the terms to proceed.\";s:16:\"invalid_required\";s:34:\"Please fill in the required field.\";s:16:\"invalid_too_long\";s:23:\"This input is too long.\";s:17:\"invalid_too_short\";s:24:\"This input is too short.\";s:17:\"captcha_not_match\";s:31:\"Your entered code is incorrect.\";s:14:\"invalid_number\";s:28:\"Number format seems invalid.\";s:16:\"number_too_small\";s:25:\"This number is too small.\";s:16:\"number_too_large\";s:25:\"This number is too large.\";s:13:\"invalid_email\";s:28:\"Email address seems invalid.\";s:11:\"invalid_url\";s:18:\"URL seems invalid.\";s:11:\"invalid_tel\";s:31:\"Telephone number seems invalid.\";s:23:\"quiz_answer_not_correct\";s:27:\"Your answer is not correct.\";s:12:\"invalid_date\";s:26:\"Date format seems invalid.\";s:14:\"date_too_early\";s:23:\"This date is too early.\";s:13:\"date_too_late\";s:22:\"This date is too late.\";s:13:\"upload_failed\";s:22:\"Failed to upload file.\";s:24:\"upload_file_type_invalid\";s:30:\"This file type is not allowed.\";s:21:\"upload_file_too_large\";s:23:\"This file is too large.\";s:23:\"upload_failed_php_error\";s:38:\"Failed to upload file. Error occurred.\";}");
INSERT INTO `bupg_postmeta` VALUES("17476", "11334", "_additional_settings", "");
INSERT INTO `bupg_postmeta` VALUES("17477", "11334", "_locale", "en_US");
INSERT INTO `bupg_postmeta` VALUES("17482", "11335", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17511", "86", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("17512", "86", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:15:\"Contact Sidebar\";}");
INSERT INTO `bupg_postmeta` VALUES("17513", "86", "sbg_selected_sidebar_2", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("17514", "86", "sbg_selected_sidebar_2_replacement", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("17519", "11336", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17540", "11338", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17553", "11339", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17566", "11340", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17579", "11341", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17592", "11342", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17613", "11343", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17626", "11344", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17639", "11345", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17652", "11346", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17665", "11347", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17678", "11348", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17691", "11349", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17704", "11350", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17717", "11351", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17730", "11352", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17743", "11353", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17764", "11354", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17777", "11355", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17790", "11356", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17803", "11357", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17816", "11358", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17829", "11359", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17850", "11360", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17863", "11361", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17876", "11362", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17889", "11363", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17902", "11364", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17915", "11365", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17928", "11366", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17941", "11367", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17954", "11368", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17967", "11369", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17980", "11370", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("17993", "11371", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18006", "11372", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18015", "11373", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18016", "11293", "_post_restored_from", "a:3:{s:20:\"restored_revision_id\";i:11371;s:16:\"restored_by_user\";i:1;s:13:\"restored_time\";i:1433870463;}");
INSERT INTO `bupg_postmeta` VALUES("18017", "11293", "fusion_builder_content", "");
INSERT INTO `bupg_postmeta` VALUES("18022", "11374", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18035", "11375", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18048", "11376", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18061", "11377", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18074", "11378", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18087", "11379", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18100", "11380", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18113", "11381", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18126", "11383", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18139", "11384", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18152", "11385", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18165", "11386", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18178", "11387", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18199", "11388", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18212", "11389", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18225", "11390", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18238", "11280", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("18239", "11280", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:15:\"Contact Sidebar\";}");
INSERT INTO `bupg_postmeta` VALUES("18240", "11280", "sbg_selected_sidebar_2", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("18241", "11280", "sbg_selected_sidebar_2_replacement", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("18246", "11391", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18261", "11393", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18276", "11395", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18291", "11398", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18306", "11400", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18321", "11402", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18334", "11403", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18347", "11404", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18364", "11406", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18377", "11407", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18392", "11409", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18401", "11410", "_wp_attached_file", "2015/06/engage_DiscoverWelcomeEngage3v400x36.png");
INSERT INTO `bupg_postmeta` VALUES("18402", "11410", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:400;s:6:\"height\";i:36;s:4:\"file\";s:48:\"2015/06/engage_DiscoverWelcomeEngage3v400x36.png\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:47:\"engage_DiscoverWelcomeEngage3v400x36-150x36.png\";s:5:\"width\";i:150;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:47:\"engage_DiscoverWelcomeEngage3v400x36-300x27.png\";s:5:\"width\";i:300;s:6:\"height\";i:27;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:47:\"engage_DiscoverWelcomeEngage3v400x36-320x36.png\";s:5:\"width\";i:320;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"tabs-img\";a:4:{s:4:\"file\";s:46:\"engage_DiscoverWelcomeEngage3v400x36-52x36.png\";s:5:\"width\";i:52;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"related-img\";a:4:{s:4:\"file\";s:47:\"engage_DiscoverWelcomeEngage3v400x36-180x36.png\";s:5:\"width\";i:180;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:47:\"engage_DiscoverWelcomeEngage3v400x36-300x36.png\";s:5:\"width\";i:300;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"portfolio-four\";a:4:{s:4:\"file\";s:47:\"engage_DiscoverWelcomeEngage3v400x36-220x36.png\";s:5:\"width\";i:220;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:47:\"engage_DiscoverWelcomeEngage3v400x36-177x36.png\";s:5:\"width\";i:177;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"portfolio-six\";a:4:{s:4:\"file\";s:47:\"engage_DiscoverWelcomeEngage3v400x36-147x36.png\";s:5:\"width\";i:147;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:46:\"engage_DiscoverWelcomeEngage3v400x36-66x36.png\";s:5:\"width\";i:66;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `bupg_postmeta` VALUES("18407", "11411", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18420", "11412", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18433", "11413", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18446", "11414", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18458", "11417", "_wp_attached_file", "2015/06/favicon.ico");
INSERT INTO `bupg_postmeta` VALUES("18463", "11419", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18476", "11420", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18489", "11313", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("18490", "11313", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:15:\"Contact Sidebar\";}");
INSERT INTO `bupg_postmeta` VALUES("18491", "11313", "sbg_selected_sidebar_2", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("18492", "11313", "sbg_selected_sidebar_2_replacement", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("18497", "11421", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18510", "11422", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18523", "11423", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18536", "11116", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("18537", "11116", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:15:\"Contact Sidebar\";}");
INSERT INTO `bupg_postmeta` VALUES("18538", "11116", "sbg_selected_sidebar_2", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("18539", "11116", "sbg_selected_sidebar_2_replacement", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("18544", "11424", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18557", "11425", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18570", "11426", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18575", "11293", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("18576", "11293", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:15:\"Contact Sidebar\";}");
INSERT INTO `bupg_postmeta` VALUES("18577", "11293", "sbg_selected_sidebar_2", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("18578", "11293", "sbg_selected_sidebar_2_replacement", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("18579", "11417", "_edit_lock", "1435771193:1");
INSERT INTO `bupg_postmeta` VALUES("18580", "11417", "_edit_last", "1");
INSERT INTO `bupg_postmeta` VALUES("18581", "11417", "_yoast_wpseo_focuskw", "#birminghamupg");
INSERT INTO `bupg_postmeta` VALUES("18582", "11417", "_yoast_wpseo_linkdex", "29");
INSERT INTO `bupg_postmeta` VALUES("18583", "11410", "_edit_lock", "1435771305:1");
INSERT INTO `bupg_postmeta` VALUES("18584", "11410", "_edit_last", "1");
INSERT INTO `bupg_postmeta` VALUES("18585", "11410", "_yoast_wpseo_focuskw", "#birminghamupg");
INSERT INTO `bupg_postmeta` VALUES("18586", "11410", "_yoast_wpseo_linkdex", "26");
INSERT INTO `bupg_postmeta` VALUES("18595", "10995", "_yoast_wpseo_focuskw", "birmingham");
INSERT INTO `bupg_postmeta` VALUES("18596", "10995", "_yoast_wpseo_metadesc", "Highlights the human journey of peoples from all over the globe that have migrated to Birmingham Alabama, the Magic City.");
INSERT INTO `bupg_postmeta` VALUES("18597", "10995", "_yoast_wpseo_linkdex", "85");
INSERT INTO `bupg_postmeta` VALUES("18602", "11427", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18607", "10995", "_yoast_wpseo_title", "Birmingham Unreached People Groups");
INSERT INTO `bupg_postmeta` VALUES("18620", "1", "avada_post_views_count", "31");
INSERT INTO `bupg_postmeta` VALUES("18625", "11429", "FB_content", "");
INSERT INTO `bupg_postmeta` VALUES("18630", "10995", "sbg_selected_sidebar", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("18631", "10995", "sbg_selected_sidebar_replacement", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `bupg_postmeta` VALUES("18632", "10995", "sbg_selected_sidebar_2", "a:1:{i:0;s:1:\"0\";}");
INSERT INTO `bupg_postmeta` VALUES("18633", "10995", "sbg_selected_sidebar_2_replacement", "a:1:{i:0;s:0:\"\";}");

/* INSERT TABLE DATA: bupg_posts */
INSERT INTO `bupg_posts` VALUES("1", "1", "2015-04-04 03:05:05", "2015-04-04 03:05:05", "Welcome to WordPress. This is your first post. Edit or delete it, then start blogging!", "Hello world!", "", "publish", "open", "open", "", "hello-world", "", "", "2015-04-04 03:05:05", "2015-04-04 03:05:05", "", "0", "http://birminghamupg.com/bhamupg_base/?p=1", "0", "post", "", "1");
INSERT INTO `bupg_posts` VALUES("86", "1", "2012-07-31 02:17:58", "2012-07-31 02:17:58", "[fusion_text]<a href=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/05/Mexican20345046_ml.jpg\"><img class=\" size-medium wp-image-11328 aligncenter\" src=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/05/Mexican20345046_ml-300x199.jpg\" alt=\"Mexican20345046_ml\" width=\"300\" height=\"199\" /></a>[/fusion_text][separator style_type=\"single\" top_margin=\"40\" bottom_margin=\"20\" sep_color=\"#cecece\" icon=\"fa-chevron-circle-down\" width=\"\" class=\"\" id=\"\"][fusion_text]\r\n<h2 class=\"title-heading-left\" data-fontsize=\"28\" data-lineheight=\"34\">Have questions? Comments? Contact Us!</h2>\r\n<div class=\"title-sep-container\"></div>\r\n[/fusion_text][fusion_text][contact-form-7 id=\"11334\" title=\"Contact form 1\"][/fusion_text][separator style_type=\"none\" top_margin=\"20\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"]", "Contact Us", "", "publish", "open", "open", "", "contact", "", "", "2015-05-29 02:48:10", "2015-05-29 02:48:10", "", "0", "http://theme-fusion.com/avada/?page_id=86", "6", "page", "", "0");
INSERT INTO `bupg_posts` VALUES("191", "1", "2012-07-31 16:54:02", "2012-07-31 16:54:02", "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam viverra euismod odio, gravida pellentesque urna varius vitae. Sed dui lorem, adipiscing in adipiscing et, interdum nec metus. Mauris ultricie est justos.", "Mauris Fringilla Voluts", "", "publish", "open", "closed", "", "mauris-fringilla-voluts", "", "", "2012-07-31 16:54:02", "2012-07-31 16:54:02", "", "0", "http://theme-fusion.com/avada/?post_type=avada_portfolio&#038;p=191", "0", "avada_portfolio", "", "0");
INSERT INTO `bupg_posts` VALUES("192", "1", "2012-07-31 16:43:55", "2012-07-31 16:43:55", "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam viverra euismod odio, gravida pellentesque urna varius vitae. Sed dui lorem, adipiscing in adipiscing et, interdum nec metus. Mauris ultricies, justo eu convallis placerat, felis enim ornare nisi, vitae mattis nulla ante id dui. Ut lectus purus, commodo et tincidunt vel, interdum sed lectus. Vestibulum adipiscing tempor nisi id elementu sadips ipsums dolores uns fugiats gravida nam elit vols nulla dolores amet untras sitsers.\n\nUt porttitor euismod cursus. Mauris suscipit, turpis ut dapibus rhoncus, odio erat egestas orci, in sollicitudin enim erat id est. Sed auctor gravida arcu, nec fringilla orci aliquet ut. Nullam eu pretium purus. Maecenas fermentum posuere sem vel posuere. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi ornare convallis lectus a faucibus. Praesent et urna turpis. Fusce tincidunt augue in velit tincidunt sed tempor felis porta. Nunc sodales, metus ut vestibulum ornare, est magna laoreet lectus, ut adipiscing massa odio sed turpis. In nec lorem porttitor urna consequat sagittis. Nullam eget elit ante. Pellentesque justo urna, semper nec faucibus sit amet, aliquam at mi. Maecenas eget diam nec mi dignissim pharetra.", "Suspende Phara Urna", "", "publish", "open", "closed", "", "suspendisse-pharetra-urna", "", "", "2012-07-31 16:43:55", "2012-07-31 16:43:55", "", "0", "http://theme-fusion.com/avada/?post_type=avada_portfolio&#038;p=192", "0", "avada_portfolio", "", "0");
INSERT INTO `bupg_posts` VALUES("193", "1", "2012-07-31 16:44:55", "2012-07-31 16:44:55", "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam viverra euismod odio, gravida pellentesque urna varius vitae. Sed dui lorem, adipiscing in adipiscing et, interdum nec metus. Mauris ultricies, justo eu convallis placerat, felis enim ornare nisi, vitae mattis nulla ante id dui. Ut lectus purus, commodo et tincidunt vel, interdum sed lectus. Vestibulum adipiscing tempor nisi id elementu sadips ipsums dolores uns fugiats gravida nam elit vols nulla dolores amet untras sitsers.\n\nDonec volutpat nibh sit amet libero ornare non laoreet arcu luctus. Donec id arcu quis mauris euismod placerat sit amet ut metus. Sed imperdiet fringilla sem eget euismod. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Pellentesque adipiscing, neque ut pulvinar tincidunt, est sem euismod odio, eu ullamcorper turpis nisl sit amet velit. Nullam vitae nibh odio, non scelerisque nibh. Vestibulum ut est augue, in varius purus.\n\nProin dictum lobortis justo at pretium. Nunc malesuada ante sit amet purus ornare pulvinar. Donec suscipit dignissim ipsum at euismod. Curabitur malesuada lorem sed metus adipiscing in vehicula quam commodo. Sed porttitor elementum elementum. Proin eu ligula eget leo consectetur sodales et non mauris. Lorem ipsum dolor sit amet, consectetur adipiscing elit.", "Curabitur Malada Lorem", "", "publish", "open", "closed", "", "curabitur-malesuada-lorem", "", "", "2012-07-31 16:44:55", "2012-07-31 16:44:55", "", "0", "http://theme-fusion.com/avada/?post_type=avada_portfolio&#038;p=193", "0", "avada_portfolio", "", "0");
INSERT INTO `bupg_posts` VALUES("195", "1", "2012-07-31 16:53:51", "2012-07-31 16:53:51", "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam viverra euismod odio, gravida pellentesque urna varius vitae. Sed dui lorem, adipiscing in adipiscing et, interdum nec metus. Mauris ultricies, justo eu convallis placerat, felis enim ornare nisi, vitae mattis nulla ante id dui. Ut lectus purus, commodo et tincidunt vel, interdum sed lectus. Vestibulum adipiscing tempor nisi id elementu sadips ipsums dolores uns fugiats gravida nam elit vols nulla dolores amet untras sitsers.\n\nDonec volutpat nibh sit amet libero ornare non laoreet arcu luctus. Donec id arcu quis mauris euismod placerat sit amet ut metus. Sed imperdiet fringilla sem eget euismod. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Pellentesque adipiscing, neque ut pulvinar tincidunt, est sem euismod odio, eu ullamcorper turpis nisl sit amet velit. Nullam vitae nibh odio, non scelerisque nibh. Vestibulum ut est augue, in varius purus. Proin dictum lobortis justo at pretium. Nunc malesuada ante sit amet purus ornare pulvinar. Donec suscipit dignissim ipsum at euismod. Curabitur malesuada lorems metus adipiscing in vehicula quam commodo. Sed porttitor elementum elementum.", "Proin Sodales Quam", "", "publish", "open", "closed", "", "proin-sodales-quam", "", "", "2012-07-31 16:53:51", "2012-07-31 16:53:51", "", "0", "http://theme-fusion.com/avada/?post_type=avada_portfolio&#038;p=195", "0", "avada_portfolio", "", "0");
INSERT INTO `bupg_posts` VALUES("196", "1", "2012-07-31 16:53:09", "2012-07-31 16:53:09", "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam viverra euismod odio, gravida pellentesque urna varius vitae. Sed dui lorem, adipiscing in adipiscing et, interdum nec metus. Mauris ultricies, justo eu convallis placerat, felis enim ornare nisi, vitae mattis nulla ante id dui. Ut lectus purus, commodo et tincidunt vel, interdum sed lectus.", "Nam Viverra Euismod", "", "publish", "open", "closed", "", "nam-viverra-euismod", "", "", "2012-07-31 16:53:09", "2012-07-31 16:53:09", "", "0", "http://theme-fusion.com/avada/?post_type=avada_portfolio&#038;p=196", "0", "avada_portfolio", "", "0");
INSERT INTO `bupg_posts` VALUES("198", "1", "2012-07-31 17:00:15", "2012-07-31 17:00:15", "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam viverra euismod odio, gravida pellentesque urna varius vitae. Sed dui lorem, adipiscing in adipiscing et, interdum nec metus. Mauris ultricies, justo eu convallis placerat, felis enim ornare nisi, vitae mattis nulla ante id dui. Ut lectus purus, commodo et tincidunt vel, interdum sed lectus. Vestibulum adipiscing tempor nisi id elementu sadips ipsums dolores uns fugiats gravida nam elit vols nulla dolores amet untras sitsers.\n\nCras id erat arcu. Suspendisse nec lacinia eros. Morbi in nisl ut quam vulputate elementum. Donec ornare, turpis eget rhoncus pharetra, nunc augue porta orci, eu volutpat enim nisi ac risus. Proin a tortor id orci fermentum sollicitudin tincidunt in magna. Quisque semper, leo a malesuada dictum, orci massa blandit diam, nec porttitor quam nunc laoreet odio. Maecenas sed felis ante, non cursus justo. Vivamus semper euismod vulputate. Praesent a hendrerit sapien. Sed dapibus leo rutrum lorem convallis et commodo urna tempus. Quisque hendrerit imperdiet erat id fringilla. Vivamus vitae odio nisi, sit amet pellentesque justo. Pellentesque enim enim, ultricies sit amet blandit a, sagittis vel dolor. Cras lorem purus, posuere sed hendrerit ac, varius vel eros. Quisque nisl ante, posuere pulvinar bibendum a, malesuada sed mi.", "Donec Ore Turis Eget", "", "publish", "open", "closed", "", "donec-ornare-turpis-eget", "", "", "2012-07-31 17:00:15", "2012-07-31 17:00:15", "", "0", "http://theme-fusion.com/avada/?post_type=avada_portfolio&#038;p=198", "0", "avada_portfolio", "", "0");
INSERT INTO `bupg_posts` VALUES("202", "1", "2012-07-31 17:24:55", "2012-07-31 17:24:55", "Quisque ligulas ipsum, euismod atras vulputate iltricies etri elit. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Nulla nunc dui, tristique in semper vel, congue sed ligula. Nam dolor ligula, faucibus id sodales in, auctor fringilla libero. Pellentesque pellentesque tempor tellus eget hendrerit. Morbi id aliquam ligula. Aliquam id dui sem. Proin rhoncus consequat nisl, eu ornare mauris tincidunt vitae.\n\nVestibulum sodales ante a purus volutpat euismod. Proin sodales quam nec ante sollicitudin lacinia. Ut egestas bibendum tempor. Morbi non nibh sit amet ligula blandit ullamcorper in nec risus. Pellentesque fringilla diam faucibus tortor bibendum vulputate. Etiam turpis urna, rhoncus et mattis ut, dapibus eu nunc. Nunc sed aliquet nisi. Nullam ut magna non lacus adipiscing volutpat. Aenean odio mauris, consectetur quis consequat quis, blandit a nunc. Sed orci erat, placerat ac interdum ut, suscipit eu augue. Nunc vitae mi tortor. Ut vel justo quis lectus elementum ullamcorper volutpat vel libero.\n<blockquote>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exercitation.</blockquote>\nDonec volutpat nibh sit amet libero ornare non laoreet arcu luctus. Donec id arcu quis mauris euismod placerat sit amet ut metus. Sed imperdiet fringilla sem eget euismod. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Pellentesque adipiscing, neque ut pulvinar tincidunt, est sem euismod odio, eu ullamcorper turpis nisl sit amet velit. Nullam vitae nibh odio, non scelerisque nibh. Vestibulum ut est augue, in varius purus.\n\nProin dictum lobortis justo at pretium. Nunc malesuada ante sit amet purus ornare pulvinar. Donec suscipit dignissim ipsum at euismod. Curabitur malesuada lorem sed metus adipiscing in vehicula quam commodo. Sed porttitor elementum elementum. Proin eu ligula eget leo consectetur sodales et non mauris. Lorem ipsum dolor sit amet, consectetur adipiscing elit.\n\nNunc tincidunt, elit non cursus euismod, lacus augue ornare metus, egestas imperdiet nulla nisl quis mauris. Suspendisse a pharetra urna. Morbi dui lectus, pharetra nec elementum eget, vulputate ut nisi. Aliquam accumsan, nulla sed feugiat vehicula, lacus justo semper libero, quis porttitor turpis odio sit amet ligula. Duis dapibus fermentum orci, nec malesuada libero vehicula ut. Integer sodales, urna eget interdum eleifend, nulla nibh laoreet nisl, quis dignissim mauris dolor eget mi. Donec at mauris enim. Duis nisi tellus, adipiscing a convallis quis, tristique vitae risus. Nullam molestie gravida lobortis. Proin ut nibh quis felis auctor ornare. Cras ultricies, nibh at mollis faucibus, justo eros porttitor mi, quis auctor lectus arcu sit amet nunc. Vivamus gravida vehicula arcu, vitae vulputate augue lacinia faucibus.\n\nUt porttitor euismod cursus. Mauris suscipit, turpis ut dapibus rhoncus, odio erat egestas orci, in sollicitudin enim erat id est. Sed auctor gravida arcu, nec fringilla orci aliquet ut. Nullam eu pretium purus. Maecenas fermentum posuere sem vel posuere. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi ornare convallis lectus a faucibus. Praesent et urna turpis. Fusce tincidunt augue in velit tincidunt sed tempor felis porta. Nunc sodales, metus ut vestibulum ornare, est magna laoreet lectus, ut adipiscing massa odio sed turpis. In nec lorem porttitor urna consequat sagittis. Nullam eget elit ante. Pellentesque justo urna, semper nec faucibus sit amet, aliquam at mi. Maecenas eget diam nec mi dignissim pharetra.\n", "Class Aptent Taciti Soci Ad Litora", "", "publish", "open", "open", "", "class-aptent-taciti-sociosqu-ad-litora", "", "", "2012-07-31 17:24:55", "2012-07-31 17:24:55", "", "0", "http://theme-fusion.com/avada/?p=202", "5", "post", "", "0");
INSERT INTO `bupg_posts` VALUES("207", "1", "2012-07-31 17:22:22", "2012-07-31 17:22:22", "Quisque ligula ipsum, euismod a vulputate a, ultricies et elit. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Nulla nunc dui, tristique in semper vel, congue sed ligula. Nam dolor ligula, faucibus id sodales in, auctor fringilla libero. Pellentesque pellentesque tempor tellus eget hendrerit. Morbi id aliquam ligula. Aliquam id dui sem. Proin rhoncus consequat nisl, eu ornare mauris tincidunt vitae.\n\nVestibulum sodales ante a purus volutpat euismod. Proin sodales quam nec ante sollicitudin lacinia. Ut egestas bibendum tempor. Morbi non nibh sit amet ligula blandit ullamcorper in nec risus. Pellentesque fringilla diam faucibus tortor bibendum vulputate. Etiam turpis urna, rhoncus et mattis ut, dapibus eu nunc. Nunc sed aliquet nisi. Nullam ut magna non lacus adipiscing volutpat. Aenean odio mauris, consectetur quis consequat quis, blandit a nunc. Sed orci erat, placerat ac interdum ut, suscipit eu augue. Nunc vitae mi tortor. Ut vel justo quis lectus elementum ullamcorper volutpat vel libero.\n\nDonec volutpat nibh sit amet libero ornare non laoreet arcu luctus. Donec id arcu quis mauris euismod placerat sit amet ut metus. Sed imperdiet fringilla sem eget euismod. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Pellentesque adipiscing, neque ut pulvinar tincidunt, est sem euismod odio, eu ullamcorper turpis nisl sit amet velit. Nullam vitae nibh odio, non scelerisque nibh. Vestibulum ut est augue, in varius purus.\n\nProin dictum lobortis justo at pretium. Nunc malesuada ante sit amet purus ornare pulvinar. Donec suscipit dignissim ipsum at euismod. Curabitur malesuada lorem sed metus adipiscing in vehicula quam commodo. Sed porttitor elementum elementum. Proin eu ligula eget leo consectetur sodales et non mauris. Lorem ipsum dolor sit amet, consectetur adipiscing elit.\n\nNunc tincidunt, elit non cursus euismod, lacus augue ornare metus, egestas imperdiet nulla nisl quis mauris. Suspendisse a pharetra urna. Morbi dui lectus, pharetra nec elementum eget, vulputate ut nisi. Aliquam accumsan, nulla sed feugiat vehicula, lacus justo semper libero, quis porttitor turpis odio sit amet ligula. Duis dapibus fermentum orci, nec malesuada libero vehicula ut. Integer sodales, urna eget interdum eleifend, nulla nibh laoreet nisl, quis dignissim mauris dolor eget mi. Donec at mauris enim. Duis nisi tellus, adipiscing a convallis quis, tristique vitae risus. Nullam molestie gravida lobortis. Proin ut nibh quis felis auctor ornare. Cras ultricies, nibh at mollis faucibus, justo eros porttitor mi, quis auctor lectus arcu sit amet nunc. Vivamus gravida vehicula arcu, vitae vulputate augue lacinia faucibus.\n\nUt porttitor euismod cursus. Mauris suscipit, turpis ut dapibus rhoncus, odio erat egestas orci, in sollicitudin enim erat id est. Sed auctor gravida arcu, nec fringilla orci aliquet ut. Nullam eu pretium purus. Maecenas fermentum posuere sem vel posuere. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi ornare convallis lectus a faucibus. Praesent et urna turpis. Fusce tincidunt augue in velit tincidunt sed tempor felis porta. Nunc sodales, metus ut vestibulum ornare, est magna laoreet lectus, ut adipiscing massa odio sed turpis. In nec lorem porttitor urna consequat sagittis. Nullam eget elit ante. Pellentesque justo urna, semper nec faucibus sit amet, aliquam at mi. Maecenas eget diam nec mi dignissim pharetra.", "Nunc Tincidunt Elit Cursus", "", "publish", "open", "open", "", "nunc-tincidunt-elit-non-cursus", "", "", "2012-07-31 17:22:22", "2012-07-31 17:22:22", "", "0", "http://theme-fusion.com/avada/?p=207", "4", "post", "", "0");
INSERT INTO `bupg_posts` VALUES("209", "1", "2012-07-31 17:23:05", "2012-07-31 17:23:05", "Quisque ligula ipsum, euismod aturesit vulputate a, ultricies et elit. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Nulla nunc dui, tristique in semper vel, congue sed ligula. Nam dolor ligula, faucibus id sodales in, auctor fringilla libero. Pellentesque pellentesque tempor tellus eget hendrerit. Morbi id aliquam ligula. Aliquam id dui sem. Proin rhoncus consequat nisl, eu ornare mauris tincidunt vitae.\n\nVestibulum sodales ante a purus volutpat euismod. Proin sodales quam nec ante sollicitudin lacinia. Ut egestas bibendum tempor. Morbi non nibh sit amet ligula blandit ullamcorper in nec risus. Pellentesque fringilla diam faucibus tortor bibendum vulputate. Etiam turpis urna, rhoncus et mattis ut, dapibus eu nunc. Nunc sed aliquet nisi. Nullam ut magna non lacus adipiscing volutpat. Aenean odio mauris, consectetur quis consequat quis, blandit a nunc. Sed orci erat, placerat ac interdum ut, suscipit eu augue. Nunc vitae mi tortor. Ut vel justo quis lectus elementum ullamcorper volutpat vel libero.\n\nDonec volutpat nibh sit amet libero ornare non laoreet arcu luctus. Donec id arcu quis mauris euismod placerat sit amet ut metus. Sed imperdiet fringilla sem eget euismod. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Pellentesque adipiscing, neque ut pulvinar tincidunt, est sem euismod odio, eu ullamcorper turpis nisl sit amet velit. Nullam vitae nibh odio, non scelerisque nibh. Vestibulum ut est augue, in varius purus.\n\nProin dictum lobortis justo at pretium. Nunc malesuada ante sit amet purus ornare pulvinar. Donec suscipit dignissim ipsum at euismod. Curabitur malesuada lorem sed metus adipiscing in vehicula quam commodo. Sed porttitor elementum elementum. Proin eu ligula eget leo consectetur sodales et non mauris. Lorem ipsum dolor sit amet, consectetur adipiscing elit.\n\nNunc tincidunt, elit non cursus euismod, lacus augue ornare metus, egestas imperdiet nulla nisl quis mauris. Suspendisse a pharetra urna. Morbi dui lectus, pharetra nec elementum eget, vulputate ut nisi. Aliquam accumsan, nulla sed feugiat vehicula, lacus justo semper libero, quis porttitor turpis odio sit amet ligula. Duis dapibus fermentum orci, nec malesuada libero vehicula ut. Integer sodales, urna eget interdum eleifend, nulla nibh laoreet nisl, quis dignissim mauris dolor eget mi. Donec at mauris enim. Duis nisi tellus, adipiscing a convallis quis, tristique vitae risus. Nullam molestie gravida lobortis. Proin ut nibh quis felis auctor ornare. Cras ultricies, nibh at mollis faucibus, justo eros porttitor mi, quis auctor lectus arcu sit amet nunc. Vivamus gravida vehicula arcu, vitae vulputate augue lacinia faucibus.\n\nUt porttitor euismod cursus. Mauris suscipit, turpis ut dapibus rhoncus, odio erat egestas orci, in sollicitudin enim erat id est. Sed auctor gravida arcu, nec fringilla orci aliquet ut. Nullam eu pretium purus. Maecenas fermentum posuere sem vel posuere. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi ornare convallis lectus a faucibus. Praesent et urna turpis. Fusce tincidunt augue in velit tincidunt sed tempor felis porta. Nunc sodales, metus ut vestibulum ornare, est magna laoreet lectus, ut adipiscing massa odio sed turpis. In nec lorem porttitor urna consequat sagittis. Nullam eget elit ante. Pellentesque justo urna, semper nec faucibus sit amet, aliquam at mi. Maecenas eget diam nec mi dignissim pharetra.", "Proin Sodales Quam Nec Sollicit", "", "publish", "open", "open", "", "proin-sodales-quam-nec-ante-sollicits", "", "", "2012-07-31 17:23:05", "2012-07-31 17:23:05", "", "0", "http://theme-fusion.com/avada/?p=209", "3", "post", "", "0");
INSERT INTO `bupg_posts` VALUES("211", "1", "2012-07-31 17:23:43", "2012-07-31 17:23:43", "Quisque ligulas ipsum, euismod atras vulputate iltricies etri elit. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Nulla nunc dui, tristique in semper vel, congue sed ligula. Nam dolor ligula, faucibus id sodales in, auctor fringilla libero. Pellentesque pellentesque tempor tellus eget hendrerit. Morbi id aliquam ligula. Aliquam id dui sem. Proin rhoncus consequat nisl, eu ornare mauris tincidunt vitae.\n\nVestibulum sodales ante a purus volutpat euismod. Proin sodales quam nec ante sollicitudin lacinia. Ut egestas bibendum tempor. Morbi non nibh sit amet ligula blandit ullamcorper in nec risus. Pellentesque fringilla diam faucibus tortor bibendum vulputate. Etiam turpis urna, rhoncus et mattis ut, dapibus eu nunc. Nunc sed aliquet nisi. Nullam ut magna non lacus adipiscing volutpat. Aenean odio mauris, consectetur quis consequat quis, blandit a nunc. Sed orci erat, placerat ac interdum ut, suscipit eu augue. Nunc vitae mi tortor. Ut vel justo quis lectus elementum ullamcorper volutpat vel libero.\n\nDonec volutpat nibh sit amet libero ornare non laoreet arcu luctus. Donec id arcu quis mauris euismod placerat sit amet ut metus. Sed imperdiet fringilla sem eget euismod. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Pellentesque adipiscing, neque ut pulvinar tincidunt, est sem euismod odio, eu ullamcorper turpis nisl sit amet velit. Nullam vitae nibh odio, non scelerisque nibh. Vestibulum ut est augue, in varius purus.\n\nProin dictum lobortis justo at pretium. Nunc malesuada ante sit amet purus ornare pulvinar. Donec suscipit dignissim ipsum at euismod. Curabitur malesuada lorem sed metus adipiscing in vehicula quam commodo. Sed porttitor elementum elementum. Proin eu ligula eget leo consectetur sodales et non mauris. Lorem ipsum dolor sit amet, consectetur adipiscing elit.\n\nNunc tincidunt, elit non cursus euismod, lacus augue ornare metus, egestas imperdiet nulla nisl quis mauris. Suspendisse a pharetra urna. Morbi dui lectus, pharetra nec elementum eget, vulputate ut nisi. Aliquam accumsan, nulla sed feugiat vehicula, lacus justo semper libero, quis porttitor turpis odio sit amet ligula. Duis dapibus fermentum orci, nec malesuada libero vehicula ut. Integer sodales, urna eget interdum eleifend, nulla nibh laoreet nisl, quis dignissim mauris dolor eget mi. Donec at mauris enim. Duis nisi tellus, adipiscing a convallis quis, tristique vitae risus. Nullam molestie gravida lobortis. Proin ut nibh quis felis auctor ornare. Cras ultricies, nibh at mollis faucibus, justo eros porttitor mi, quis auctor lectus arcu sit amet nunc. Vivamus gravida vehicula arcu, vitae vulputate augue lacinia faucibus.\n\nUt porttitor euismod cursus. Mauris suscipit, turpis ut dapibus rhoncus, odio erat egestas orci, in sollicitudin enim erat id est. Sed auctor gravida arcu, nec fringilla orci aliquet ut. Nullam eu pretium purus. Maecenas fermentum posuere sem vel posuere. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi ornare convallis lectus a faucibus. Praesent et urna turpis. Fusce tincidunt augue in velit tincidunt sed tempor felis porta. Nunc sodales, metus ut vestibulum ornare, est magna laoreet lectus, ut adipiscing massa odio sed turpis. In nec lorem porttitor urna consequat sagittis. Nullam eget elit ante. Pellentesque justo urna, semper nec faucibus sit amet, aliquam at mi. Maecenas eget diam nec mi dignissim pharetra.", "Nullam Vitae Nibh Un Odiosters", "", "publish", "open", "open", "", "nullam-vitae-nibh-un-odio", "", "", "2012-07-31 17:23:43", "2012-07-31 17:23:43", "", "0", "http://theme-fusion.com/avada/?p=211", "2", "post", "", "0");
INSERT INTO `bupg_posts` VALUES("213", "1", "2012-07-31 17:26:20", "2012-07-31 17:26:20", "Quisque ligulas ipsum, euismod atras vulputate iltricies etri elit. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Nulla nunc dui, tristique in semper vel, congue sed ligula. Nam dolor ligula, faucibus id sodales in, auctor fringilla libero. Pellentesque pellentesque tempor tellus eget hendrerit. Morbi id aliquam ligula. Aliquam id dui sem. Proin rhoncus consequat nisl, eu ornare mauris tincidunt vitae.\n\nVestibulum sodales ante a purus volutpat euismod. Proin sodales quam nec ante sollicitudin lacinia. Ut egestas bibendum tempor. Morbi non nibh sit amet ligula blandit ullamcorper in nec risus. Pellentesque fringilla diam faucibus tortor bibendum vulputate. Etiam turpis urna, rhoncus et mattis ut, dapibus eu nunc. Nunc sed aliquet nisi. Nullam ut magna non lacus adipiscing volutpat. Aenean odio mauris, consectetur quis consequat quis, blandit a nunc. Sed orci erat, placerat ac interdum ut, suscipit eu augue. Nunc vitae mi tortor. Ut vel justo quis lectus elementum ullamcorper volutpat vel libero.\n\nDonec volutpat nibh sit amet libero ornare non laoreet arcu luctus. Donec id arcu quis mauris euismod placerat sit amet ut metus. Sed imperdiet fringilla sem eget euismod. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Pellentesque adipiscing, neque ut pulvinar tincidunt, est sem euismod odio, eu ullamcorper turpis nisl sit amet velit. Nullam vitae nibh odio, non scelerisque nibh. Vestibulum ut est augue, in varius purus.\n\nProin dictum lobortis justo at pretium. Nunc malesuada ante sit amet purus ornare pulvinar. Donec suscipit dignissim ipsum at euismod. Curabitur malesuada lorem sed metus adipiscing in vehicula quam commodo. Sed porttitor elementum elementum. Proin eu ligula eget leo consectetur sodales et non mauris. Lorem ipsum dolor sit amet, consectetur adipiscing elit.\n\nNunc tincidunt, elit non cursus euismod, lacus augue ornare metus, egestas imperdiet nulla nisl quis mauris. Suspendisse a pharetra urna. Morbi dui lectus, pharetra nec elementum eget, vulputate ut nisi. Aliquam accumsan, nulla sed feugiat vehicula, lacus justo semper libero, quis porttitor turpis odio sit amet ligula. Duis dapibus fermentum orci, nec malesuada libero vehicula ut. Integer sodales, urna eget interdum eleifend, nulla nibh laoreet nisl, quis dignissim mauris dolor eget mi. Donec at mauris enim. Duis nisi tellus, adipiscing a convallis quis, tristique vitae risus. Nullam molestie gravida lobortis. Proin ut nibh quis felis auctor ornare. Cras ultricies, nibh at mollis faucibus, justo eros porttitor mi, quis auctor lectus arcu sit amet nunc. Vivamus gravida vehicula arcu, vitae vulputate augue lacinia faucibus.\n\nUt porttitor euismod cursus. Mauris suscipit, turpis ut dapibus rhoncus, odio erat egestas orci, in sollicitudin enim erat id est. Sed auctor gravida arcu, nec fringilla orci aliquet ut. Nullam eu pretium purus. Maecenas fermentum posuere sem vel posuere. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi ornare convallis lectus a faucibus. Praesent et urna turpis. Fusce tincidunt augue in velit tincidunt sed tempor felis porta. Nunc sodales, metus ut vestibulum ornare, est magna laoreet lectus, ut adipiscing massa odio sed turpis. In nec lorem porttitor urna consequat sagittis. Nullam eget elit ante. Pellentesque justo urna, semper nec faucibus sit amet, aliquam at mi. Maecenas eget diam nec mi dignissim pharetra.", "Praesent Et Urna Turpis", "", "publish", "open", "open", "", "praesent-et-urna-turpis-sadips", "", "", "2012-07-31 17:26:20", "2012-07-31 17:26:20", "", "0", "http://theme-fusion.com/avada/?p=213", "0", "post", "", "0");
INSERT INTO `bupg_posts` VALUES("215", "1", "2012-07-31 17:25:18", "2012-07-31 17:25:18", "Quisque ligulas ipsum, euismod atras vulputate iltricies etri elit. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Nulla nunc dui, tristique in semper vel, congue sed ligula. Nam dolor ligula, faucibus id sodales in, auctor fringilla libero. Pellentesque pellentesque tempor tellus eget hendrerit. Morbi id aliquam ligula. Aliquam id dui sem. Proin rhoncus consequat nisl, eu ornare mauris tincidunt vitae.\n\nVestibulum sodales ante a purus volutpat euismod. Proin sodales quam nec ante sollicitudin lacinia. Ut egestas bibendum tempor. Morbi non nibh sit amet ligula blandit ullamcorper in nec risus. Pellentesque fringilla diam faucibus tortor bibendum vulputate. Etiam turpis urna, rhoncus et mattis ut, dapibus eu nunc. Nunc sed aliquet nisi. Nullam ut magna non lacus adipiscing volutpat. Aenean odio mauris, consectetur quis consequat quis, blandit a nunc. Sed orci erat, placerat ac interdum ut, suscipit eu augue. Nunc vitae mi tortor. Ut vel justo quis lectus elementum ullamcorper volutpat vel libero.\n<blockquote>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exercitation.</blockquote>\nDonec volutpat nibh sit amet libero ornare non laoreet arcu luctus. Donec id arcu quis mauris euismod placerat sit amet ut metus. Sed imperdiet fringilla sem eget euismod. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Pellentesque adipiscing, neque ut pulvinar tincidunt, est sem euismod odio, eu ullamcorper turpis nisl sit amet velit. Nullam vitae nibh odio, non scelerisque nibh. Vestibulum ut est augue, in varius purus.\n\nProin dictum lobortis justo at pretium. Nunc malesuada ante sit amet purus ornare pulvinar. Donec suscipit dignissim ipsum at euismod. Curabitur malesuada lorem sed metus adipiscing in vehicula quam commodo. Sed porttitor elementum elementum. Proin eu ligula eget leo consectetur sodales et non mauris. Lorem ipsum dolor sit amet, consectetur adipiscing elit.\n\nNunc tincidunt, elit non cursus euismod, lacus augue ornare metus, egestas imperdiet nulla nisl quis mauris. Suspendisse a pharetra urna. Morbi dui lectus, pharetra nec elementum eget, vulputate ut nisi. Aliquam accumsan, nulla sed feugiat vehicula, lacus justo semper libero, quis porttitor turpis odio sit amet ligula. Duis dapibus fermentum orci, nec malesuada libero vehicula ut. Integer sodales, urna eget interdum eleifend, nulla nibh laoreet nisl, quis dignissim mauris dolor eget mi. Donec at mauris enim. Duis nisi tellus, adipiscing a convallis quis, tristique vitae risus. Nullam molestie gravida lobortis. Proin ut nibh quis felis auctor ornare. Cras ultricies, nibh at mollis faucibus, justo eros porttitor mi, quis auctor lectus arcu sit amet nunc. Vivamus gravida vehicula arcu, vitae vulputate augue lacinia faucibus.\n\nUt porttitor euismod cursus. Mauris suscipit, turpis ut dapibus rhoncus, odio erat egestas orci, in sollicitudin enim erat id est. Sed auctor gravida arcu, nec fringilla orci aliquet ut. Nullam eu pretium purus. Maecenas fermentum posuere sem vel posuere. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi ornare convallis lectus a faucibus. Praesent et urna turpis. Fusce tincidunt augue in velit tincidunt sed tempor felis porta. Nunc sodales, metus ut vestibulum ornare, est magna laoreet lectus, ut adipiscing massa odio sed turpis. In nec lorem porttitor urna consequat sagittis. Nullam eget elit ante. Pellentesque justo urna, semper nec faucibus sit amet, aliquam at mi. Maecenas eget diam nec mi dignissim pharetra.\n", "Donec At Mauris Enims", "", "publish", "open", "open", "", "donec-at-mauris-enim-duis-nisi-tellus", "", "", "2012-07-31 17:25:18", "2012-07-31 17:25:18", "", "0", "http://theme-fusion.com/avada/?p=215", "1", "post", "", "0");
INSERT INTO `bupg_posts` VALUES("1876", "1", "2012-11-27 14:42:55", "2012-11-27 14:42:55", "Vestibulum egestas pharetra felis. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Suspendisse dignissim bibendum lectus, quis ornare tortor elementum quis. Aenean semper vehicula elementum. Nulla massa est, faucibus non semper quis, laoreet et sapien. Suspendisse massa odio, aliquet nec commodo et, venenatis ut velit. Pellentesque mauris lorem, dictum vitae feugiat quis, placerat vitae eros. Vestibulum quis purus vel urna convallis faucibus. Etiam vel mauris nisi, non vehicula est. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aliquam leo lorem, tincidunt sed molestie id, egestas feugiat quam. Aliquam sed ipsum non nulla tempus mollis elementum ac dolor. Curabitur ac metus et enim pellentesque pellentesque. Nunc ultrices, felis elementum iaculis semper, libero turpis semper erat, in dapibus nisi urna vel mi. Nulla sed nibh libero. Maecenas a libero mauris, sed malesuada dui.\n\nNunc euismod lobortis massa, id sollicitudin augue auctor vel. Integer ornare sollicitudin turpis vitae vestibulum. Curabitur faucibus ullamcorper lorem sed egestas. Pellentesque laoreet auctor eros, et consectetur eros auctor eget. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum tortor nisi, egestas eget molestie tincidunt, tempus sed justo. Vestibulum ultricies auctor varius. Fusce consequat tincidunt dui, ac adipiscing turpis adipiscing pulvinar. Aliquam erat volutpat. Vivamus eleifend rhoncus nulla in laoreet.", "Class aptent taciti sociosqu ad litora torquent per conubia nostra pers.", "", "publish", "open", "closed", "", "class-aptent-taciti-sociosqu-ad-litora-torquent-per-conubia-nostra-pers", "", "", "2012-11-27 14:42:55", "2012-11-27 14:42:55", "", "0", "http://theme-fusion.com/avadatest/?post_type=avada_faq&#038;p=1876", "0", "avada_faq", "", "0");
INSERT INTO `bupg_posts` VALUES("1877", "1", "2012-11-27 14:43:24", "2012-11-27 14:43:24", "<a href=\"http://birminghamupg.com/bhamupg_base/wp-content/uploads/2012/07/blog_5.jpg\"><img class=\"alignleft size-medium wp-image-3889\" style=\"padding-bottom: 10px;\" alt=\"blog_5\" src=\"http://birminghamupg.com/bhamupg_base/wp-content/uploads/2012/07/blog_5-300x171.jpg\" width=\"300\" height=\"171\" class=\"alignleft size-full wp-image-1662\" style=\"padding-bottom: 10px;\" /></a>Nunc euismod lobortis massa, id sollicitudin augue auctor vel. Integer ornare sollicitudin turpis vitae vestibulum. Curabitur faucibus ullamcorper lorem sed egestas. Pellentesque laoreet auctor eros, et consectetur eros auctor eget. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum tortor nisi, egestas eget molestie tincidunt, tempus sed justo. Vestibulum ultricies auctor varius. Fusce consequat tincidunt dui, ac adipiscing turpis adipiscing pulvinar. Aliquam erat volutpat. Vivamus eleifend rhoncus nulla in laoreet.\n\nAliquam commodo gravida magna eget tincidunt. Fusce nisi augue, malesuada in commodo quis, euismod quis orci. Integer vitae nisl non augue ullamcorper blandit. Donec vitae nibh ipsum, vitae semper orci. Nunc sed elit in nulla auctor imperdiet. Ut a nisl sit amet odio accumsan laoreet. Sed pharetra lectus in arcu pellentesque et iaculis justo pellentesque. Etiam laoreet sodales sapien, id congue magna malesuada ut. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.Vestibulum tortor nisi, egestas eget molestie tincidunt, tempus sed justo. Vestibulum ultricies auctor varius. Fusce consequat tincidunt dui, ac adipiscing turpis adipiscing pulvinar. Aliquam erat volutpat. Vivamus eleifend rhoncus nulla in laoreet.", "Fusce nisi augue, malesuada in commodo quis, euismod quis orci integer vitae nisl non.", "", "publish", "open", "closed", "", "fusce-nisi-augue-malesuada-in-commodo-quis-euismod-quis-orci-integer-vitae-nisl-non", "", "", "2012-11-27 14:43:24", "2012-11-27 14:43:24", "", "0", "http://theme-fusion.com/avadatest/?post_type=avada_faq&#038;p=1877", "0", "avada_faq", "", "0");
INSERT INTO `bupg_posts` VALUES("1878", "1", "2012-11-27 14:43:43", "2012-11-27 14:43:43", "Nunc euismod lobortis massa, id sollicitudin augue auctor vel. Integer ornare sollicitudin turpis vitae vestibulum. Curabitur faucibus ullamcorper lorem sed egestas. Pellentesque laoreet auctor eros, et consectetur eros auctor eget. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum tortor nisi, egestas eget molestie tincidunt, tempus sed justo. Vestibulum ultricies auctor varius. Fusce consequat tincidunt dui, ac adipiscing turpis adipiscing pulvinar. Aliquam erat volutpat. Vivamus eleifend rhoncus nulla in laoreet.\n\nAliquam commodo gravida magna eget tincidunt. Fusce nisi augue, malesuada in commodo quis, euismod quis orci. Integer vitae nisl non augue ullamcorper blandit. Donec vitae nibh ipsum, vitae semper orci. Nunc sed elit in nulla auctor imperdiet. Ut a nisl sit amet odio accumsan laoreet. Sed pharetra lectus in arcu pellentesque et iaculis justo pellentesque. Etiam laoreet sodales sapien, id congue magna malesuada ut. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.\n", "Integer vitae nisl non augue ullamcorper blandit donec vitae nibh ipsums.", "", "publish", "open", "closed", "", "integer-vitae-nisl-non-augue-ullamcorper-blandit-donec-vitae-nibh-ipsums", "", "", "2012-11-27 14:43:43", "2012-11-27 14:43:43", "", "0", "http://theme-fusion.com/avadatest/?post_type=avada_faq&#038;p=1878", "0", "avada_faq", "", "0");
INSERT INTO `bupg_posts` VALUES("1879", "1", "2012-11-27 14:44:05", "2012-11-27 14:44:05", "<a href=\"http://birminghamupg.com/bhamupg_base/wp-content/uploads/2012/07/blog_5.jpg\"><img class=\"alignleft size-medium wp-image-3889\" style=\"padding-bottom: 10px;\" alt=\"blog_5\" src=\"http://birminghamupg.com/bhamupg_base/wp-content/uploads/2012/07/blog_5-300x171.jpg\" width=\"300\" height=\"171\" class=\"alignleft size-full wp-image-1662\" style=\"padding-bottom: 10px;\" /></a>Nunc euismod lobortis massa, id sollicitudin augue auctor vel. Integer ornare sollicitudin turpis vitae vestibulum. Curabitur faucibus ullamcorper lorem sed egestas. Pellentesque laoreet auctor eros, et consectetur eros auctor eget. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum tortor nisi, egestas eget molestie tincidunt, tempus sed justo. Vestibulum ultricies auctor varius. Fusce consequat tincidunt dui, ac adipiscing turpis adipiscing pulvinar. Aliquam erat volutpat. Vivamus eleifend rhoncus nulla in laoreet.\n\nAliquam commodo gravida magna eget tincidunt. Fusce nisi augue, malesuada in commodo quis, euismod quis orci. Integer vitae nisl non augue ullamcorper blandit. Donec vitae nibh ipsum, vitae semper orci. Nunc sed elit in nulla auctor imperdiet. Ut a nisl sit amet odio accumsan laoreet. Sed pharetra lectus in arcu pellentesque et iaculis justo pellentesque. Etiam laoreet sodales sapien, id congue magna malesuada ut. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.Vestibulum tortor nisi, egestas eget molestie tincidunt, tempus sed justo. Vestibulum ultricies auctor varius. Fusce consequat tincidunt dui, ac adipiscing turpis adipiscing pulvinar. Aliquam erat volutpat. Vivamus eleifend rhoncus nulla in laoreet.", "Vivamus ullamcorper nim sit amet consequat laoreet tortor tortor dictum egestas urna.", "", "publish", "open", "closed", "", "vivamus-ullamcorper-nim-sit-amet-consequat-laoreet-tortor-tortor-dictum-egestas-urna", "", "", "2012-11-27 14:44:05", "2012-11-27 14:44:05", "", "0", "http://theme-fusion.com/avadatest/?post_type=avada_faq&#038;p=1879", "0", "avada_faq", "", "0");
INSERT INTO `bupg_posts` VALUES("1880", "1", "2012-11-27 14:44:31", "2012-11-27 14:44:31", "Nunc euismod lobortis massa, id sollicitudin augue auctor vel. Integer ornare sollicitudin turpis vitae vestibulum. Curabitur faucibus ullamcorper lorem sed egestas. Pellentesque laoreet auctor eros, et consectetur eros auctor eget. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum tortor nisi, egestas eget molestie tincidunt, tempus sed justo. Vestibulum ultricies auctor varius. Fusce consequat tincidunt dui, ac adipiscing turpis adipiscing pulvinar. Aliquam erat volutpat. Vivamus eleifend rhoncus nulla in laoreet.\n\nAliquam commodo gravida magna eget tincidunt. Fusce nisi augue, malesuada in commodo quis, euismod quis orci. Integer vitae nisl non augue ullamcorper blandit. Donec vitae nibh ipsum, vitae semper orci. Nunc sed elit in nulla auctor imperdiet. Ut a nisl sit amet odio accumsan laoreet. Sed pharetra lectus in arcu pellentesque et iaculis justo pellentesque. Etiam laoreet sodales sapien, id congue magna malesuada ut. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.", "Fusce nisi malesuada in commodo quis, euismod quis orci on augue ullamcorpers.", "", "publish", "open", "closed", "", "fusce-nisi-malesuada-in-commodo-quis-euismod-quis-orci-onteger-vitae-nisl-non-augue-ullamcorpers", "", "", "2012-11-27 14:44:31", "2012-11-27 14:44:31", "", "0", "http://theme-fusion.com/avadatest/?post_type=avada_faq&#038;p=1880", "0", "avada_faq", "", "0");
INSERT INTO `bupg_posts` VALUES("1881", "1", "2012-11-27 14:44:54", "2012-11-27 14:44:54", "<a href=\"http://birminghamupg.com/bhamupg_base/wp-content/uploads/2012/07/blog_5.jpg\"><img class=\"alignleft size-medium wp-image-3889\" style=\"padding-bottom: 10px;\" alt=\"blog_5\" src=\"http://birminghamupg.com/bhamupg_base/wp-content/uploads/2012/07/blog_5-300x171.jpg\" width=\"300\" height=\"171\" class=\"alignleft size-full wp-image-1662\" style=\"padding-bottom: 10px;\" /></a>Nunc euismod lobortis massa, id sollicitudin augue auctor vel. Integer ornare sollicitudin turpis vitae vestibulum. Curabitur faucibus ullamcorper lorem sed egestas. Pellentesque laoreet auctor eros, et consectetur eros auctor eget. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum tortor nisi, egestas eget molestie tincidunt, tempus sed justo. Vestibulum ultricies auctor varius. Fusce consequat tincidunt dui, ac adipiscing turpis adipiscing pulvinar. Aliquam erat volutpat. Vivamus eleifend rhoncus nulla in laoreet.\n\nAliquam commodo gravida magna eget tincidunt. Fusce nisi augue, malesuada in commodo quis, euismod quis orci. Integer vitae nisl non augue ullamcorper blandit. Donec vitae nibh ipsum, vitae semper orci. Nunc sed elit in nulla auctor imperdiet. Ut a nisl sit amet odio accumsan laoreet. Sed pharetra lectus in arcu pellentesque et iaculis justo pellentesque. Etiam laoreet sodales sapien, id congue magna malesuada ut. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.Vestibulum tortor nisi, egestas eget molestie tincidunt, tempus sed justo. Vestibulum ultricies auctor varius. Fusce consequat tincidunt dui, ac adipiscing turpis adipiscing pulvinar. Aliquam erat volutpat. Vivamus eleifend rhoncus nulla in laoreet.", "Curabitur eget leo at velit imperdiet varius eu ipsum vitae velit congue iaculis vitaes.", "", "publish", "open", "closed", "", "curabitur-eget-leo-at-velit-imperdiet-varius-eu-ipsum-vitae-velit-congue-iaculis-vitaes", "", "", "2012-11-27 14:44:54", "2012-11-27 14:44:54", "", "0", "http://theme-fusion.com/avadatest/?post_type=avada_faq&#038;p=1881", "0", "avada_faq", "", "0");
INSERT INTO `bupg_posts` VALUES("4052", "1", "2013-10-14 18:33:43", "2013-10-14 18:33:43", "", "Slide 1", "", "publish", "closed", "closed", "", "slide-1", "", "", "2013-10-14 18:33:43", "2013-10-14 18:33:43", "", "0", "http://theme-fusion.com/avadaxml/?post_type=themefusion_elastic&#038;p=4052", "0", "themefusion_elastic", "", "0");
INSERT INTO `bupg_posts` VALUES("4055", "1", "2013-10-14 18:34:03", "2013-10-14 18:34:03", "", "Slide 2", "", "publish", "closed", "closed", "", "slide-2", "", "", "2013-10-14 18:34:03", "2013-10-14 18:34:03", "", "0", "http://theme-fusion.com/avadaxml/?post_type=themefusion_elastic&#038;p=4055", "0", "themefusion_elastic", "", "0");
INSERT INTO `bupg_posts` VALUES("4074", "1", "2013-10-15 15:07:22", "2013-10-15 15:07:22", "", "slide_3", "", "inherit", "closed", "closed", "", "slide_3", "", "", "2013-10-15 15:07:22", "2013-10-15 15:07:22", "", "0", "http://birminghamupg.com/bhamupg_base/wp-content/uploads/2013/10/slide_3.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `bupg_posts` VALUES("4076", "1", "2013-10-15 15:37:30", "2013-10-15 15:37:30", "", "slide_4", "", "inherit", "closed", "closed", "", "slide_4", "", "", "2013-10-15 15:37:30", "2013-10-15 15:37:30", "", "0", "http://birminghamupg.com/bhamupg_base/wp-content/uploads/2013/10/slide_4.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `bupg_posts` VALUES("4594", "1", "2014-06-16 17:24:31", "2014-06-16 17:24:31", "", "html5-color", "", "inherit", "closed", "closed", "", "html5-color", "", "", "2014-06-16 17:24:31", "2014-06-16 17:24:31", "", "0", "http://birminghamupg.com/bhamupg_base/wp-content/uploads/2014/06/html5-color.png", "0", "attachment", "image/png", "0");
INSERT INTO `bupg_posts` VALUES("4605", "1", "2014-06-16 17:24:41", "2014-06-16 17:24:41", "", "vimeo-color", "", "inherit", "closed", "closed", "", "vimeo-color", "", "", "2014-06-16 17:24:41", "2014-06-16 17:24:41", "", "0", "http://birminghamupg.com/bhamupg_base/wp-content/uploads/2014/06/vimeo-color.png", "0", "attachment", "image/png", "0");
INSERT INTO `bupg_posts` VALUES("4606", "1", "2014-06-16 17:24:41", "2014-06-16 17:24:41", "", "youtube-color", "", "inherit", "closed", "closed", "", "youtube-color", "", "", "2014-06-16 17:24:41", "2014-06-16 17:24:41", "", "0", "http://birminghamupg.com/bhamupg_base/wp-content/uploads/2014/06/youtube-color.png", "0", "attachment", "image/png", "0");
INSERT INTO `bupg_posts` VALUES("4610", "1", "2014-06-16 17:25:18", "2014-06-16 17:25:18", "", "box21.png", "", "inherit", "closed", "closed", "", "box21-png", "", "", "2014-06-16 17:25:18", "2014-06-16 17:25:18", "", "0", "http://birminghamupg.com/bhamupg_base/wp-content/uploads/2014/06/box21.png", "0", "attachment", "image/png", "0");
INSERT INTO `bupg_posts` VALUES("9548", "1", "2014-05-28 17:49:01", "2014-05-28 17:49:01", "", "Paint Drop", "", "publish", "closed", "closed", "", "demo-5", "", "", "2014-05-28 17:49:01", "2014-05-28 17:49:01", "", "0", "http://avadatest.theme-fusion.com/?post_type=slide&#038;p=9548", "0", "slide", "", "0");
INSERT INTO `bupg_posts` VALUES("9552", "1", "2014-05-28 20:00:54", "2014-05-28 20:00:54", "", "Flower", "", "publish", "closed", "closed", "", "demo-6-2", "", "", "2014-05-28 20:00:54", "2014-05-28 20:00:54", "", "0", "http://avadatest.theme-fusion.com/?post_type=slide&#038;p=9552", "0", "slide", "", "0");
INSERT INTO `bupg_posts` VALUES("9564", "1", "2014-05-28 20:28:56", "2014-05-28 20:28:56", "", "Hand With Ring", "", "publish", "closed", "closed", "", "demo-7", "", "", "2014-05-28 20:28:56", "2014-05-28 20:28:56", "", "0", "http://avadatest.theme-fusion.com/?post_type=slide&#038;p=9564", "0", "slide", "", "0");
INSERT INTO `bupg_posts` VALUES("9578", "1", "2014-05-29 00:44:03", "2014-05-29 00:44:03", "", "Green Paint", "", "publish", "closed", "closed", "", "demo-10", "", "", "2014-05-29 00:44:03", "2014-05-29 00:44:03", "", "0", "http://avadatest.theme-fusion.com/?post_type=slide&#038;p=9578", "0", "slide", "", "0");
INSERT INTO `bupg_posts` VALUES("9611", "1", "2014-05-29 21:09:23", "2014-05-29 21:09:23", "", "Fixed Image", "", "publish", "closed", "closed", "", "breakfast-image", "", "", "2014-05-29 21:09:23", "2014-05-29 21:09:23", "", "0", "http://avadatest.theme-fusion.com/?post_type=slide&#038;p=9611", "0", "slide", "", "0");
INSERT INTO `bupg_posts` VALUES("9613", "1", "2014-05-29 21:15:39", "2014-05-29 21:15:39", "", "Youtube", "", "publish", "closed", "closed", "", "youtube", "", "", "2014-05-29 21:15:39", "2014-05-29 21:15:39", "", "0", "http://avadatest.theme-fusion.com/?post_type=slide&#038;p=9613", "0", "slide", "", "0");
INSERT INTO `bupg_posts` VALUES("9688", "1", "2014-05-29 14:47:55", "2014-05-29 14:47:55", "", "Vimeo", "", "publish", "closed", "closed", "", "vimeo", "", "", "2014-05-29 14:47:55", "2014-05-29 14:47:55", "", "0", "http://avadatest.theme-fusion.com/?post_type=slide&#038;p=9688", "0", "slide", "", "0");
INSERT INTO `bupg_posts` VALUES("9719", "1", "2014-06-02 14:27:20", "2014-06-02 14:27:20", "", "Image two_third 1", "", "publish", "closed", "closed", "", "image-23", "", "", "2014-06-02 14:27:20", "2014-06-02 14:27:20", "", "0", "http://avadatest.theme-fusion.com/?post_type=slide&#038;p=9719", "0", "slide", "", "0");
INSERT INTO `bupg_posts` VALUES("9722", "1", "2014-06-02 14:27:54", "2014-06-02 14:27:54", "", "Image two_third 2", "", "publish", "closed", "closed", "", "image-23-2", "", "", "2014-06-02 14:27:54", "2014-06-02 14:27:54", "", "0", "http://avadatest.theme-fusion.com/?post_type=slide&#038;p=9722", "0", "slide", "", "0");
INSERT INTO `bupg_posts` VALUES("9754", "1", "2014-06-16 18:13:47", "2014-06-16 18:13:47", "", "bkgd_bw2", "", "inherit", "closed", "closed", "", "bkgd_bw2", "", "", "2014-06-16 18:13:47", "2014-06-16 18:13:47", "", "0", "http://birminghamupg.com/bhamupg_base/wp-content/uploads/2014/06/bkgd_bw2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `bupg_posts` VALUES("10712", "1", "2014-11-19 15:56:43", "2014-11-19 15:56:43", "", "Home", "", "publish", "closed", "closed", "", "home", "", "", "2014-11-19 15:56:43", "2014-11-19 15:56:43", "", "0", "http://theme-fusion.com/avadaxml/?post_type=slide&#038;p=10712", "0", "slide", "", "0");
INSERT INTO `bupg_posts` VALUES("10716", "1", "2015-04-04 03:09:10", "2015-04-04 03:09:10", "", "Pages", "", "publish", "open", "open", "", "pages", "", "", "2015-04-18 22:12:37", "2015-04-18 22:12:37", "", "0", "http://birminghamupg.com/bhamupg_base/?p=10716", "45", "nav_menu_item", "", "0");
INSERT INTO `bupg_posts` VALUES("10717", "1", "2015-04-04 03:09:11", "2015-04-04 03:09:11", "", "Sliders", "", "publish", "open", "open", "", "sliders", "", "", "2015-04-18 22:12:37", "2015-04-18 22:12:37", "", "0", "http://birminghamupg.com/bhamupg_base/?p=10717", "34", "nav_menu_item", "", "0");
INSERT INTO `bupg_posts` VALUES("10722", "1", "2015-04-04 03:09:11", "2015-04-04 03:09:11", "", "Home", "", "publish", "open", "open", "", "home", "", "", "2015-04-18 22:12:37", "2015-04-18 22:12:37", "", "0", "http://birminghamupg.com/bhamupg_base/?p=10722", "1", "nav_menu_item", "", "0");
INSERT INTO `bupg_posts` VALUES("10723", "1", "2015-04-04 03:09:11", "2015-04-04 03:09:11", "", "Intro", "", "publish", "open", "open", "", "intro", "", "", "2015-04-04 03:09:11", "2015-04-04 03:09:11", "", "0", "http://birminghamupg.com/bhamupg_base/?p=10723", "1", "nav_menu_item", "", "0");
INSERT INTO `bupg_posts` VALUES("10724", "1", "2015-04-04 03:09:11", "2015-04-04 03:09:11", "", "Features", "", "publish", "open", "open", "", "features-2", "", "", "2015-04-04 03:09:11", "2015-04-04 03:09:11", "", "0", "http://birminghamupg.com/bhamupg_base/?p=10724", "2", "nav_menu_item", "", "0");
INSERT INTO `bupg_posts` VALUES("10725", "1", "2015-04-04 03:09:11", "2015-04-04 03:09:11", "", "Pages", "", "publish", "open", "open", "", "pages-2", "", "", "2015-04-04 03:09:11", "2015-04-04 03:09:11", "", "0", "http://birminghamupg.com/bhamupg_base/?p=10725", "3", "nav_menu_item", "", "0");
INSERT INTO `bupg_posts` VALUES("10726", "1", "2015-04-04 03:09:11", "2015-04-04 03:09:11", "", "WooCommerce", "", "publish", "open", "open", "", "woocommerce", "", "", "2015-04-04 03:09:11", "2015-04-04 03:09:11", "", "0", "http://birminghamupg.com/bhamupg_base/?p=10726", "4", "nav_menu_item", "", "0");
INSERT INTO `bupg_posts` VALUES("10727", "1", "2015-04-04 03:09:11", "2015-04-04 03:09:11", "", "Demo", "", "publish", "open", "open", "", "demo", "", "", "2015-04-04 03:09:11", "2015-04-04 03:09:11", "", "0", "http://birminghamupg.com/bhamupg_base/?p=10727", "5", "nav_menu_item", "", "0");
INSERT INTO `bupg_posts` VALUES("10728", "1", "2015-04-04 03:09:11", "2015-04-04 03:09:11", "", "Shortcodes", "", "publish", "open", "open", "", "shortcodes-2", "", "", "2015-04-04 03:09:11", "2015-04-04 03:09:11", "", "0", "http://birminghamupg.com/bhamupg_base/?p=10728", "6", "nav_menu_item", "", "0");
INSERT INTO `bupg_posts` VALUES("10729", "1", "2015-04-04 03:09:11", "2015-04-04 03:09:11", "", "Reviews", "", "publish", "open", "open", "", "reviews", "", "", "2015-04-04 03:09:11", "2015-04-04 03:09:11", "", "0", "http://birminghamupg.com/bhamupg_base/?p=10729", "7", "nav_menu_item", "", "0");
INSERT INTO `bupg_posts` VALUES("10730", "1", "2015-04-04 03:09:12", "2015-04-04 03:09:12", "", "Home Samples 1", "", "publish", "open", "open", "", "home-samples-1", "", "", "2015-04-18 22:12:37", "2015-04-18 22:12:37", "", "0", "http://birminghamupg.com/bhamupg_base/?p=10730", "2", "nav_menu_item", "", "0");
INSERT INTO `bupg_posts` VALUES("10731", "1", "2015-04-04 03:09:12", "2015-04-04 03:09:12", "", "Home Samples 2", "", "publish", "open", "open", "", "home-samples-2", "", "", "2015-04-18 22:12:37", "2015-04-18 22:12:37", "", "0", "http://birminghamupg.com/bhamupg_base/?p=10731", "10", "nav_menu_item", "", "0");
INSERT INTO `bupg_posts` VALUES("10732", "1", "2015-04-04 03:09:12", "2015-04-04 03:09:12", "", "Home Samples 3", "", "publish", "open", "open", "", "home-samples-3", "", "", "2015-04-18 22:12:37", "2015-04-18 22:12:37", "", "0", "http://birminghamupg.com/bhamupg_base/?p=10732", "18", "nav_menu_item", "", "0");
INSERT INTO `bupg_posts` VALUES("10733", "1", "2015-04-04 03:09:12", "2015-04-04 03:09:12", "", "Home Samples 4", "", "publish", "open", "open", "", "home-samples-4", "", "", "2015-04-18 22:12:37", "2015-04-18 22:12:37", "", "0", "http://birminghamupg.com/bhamupg_base/?p=10733", "26", "nav_menu_item", "", "0");
INSERT INTO `bupg_posts` VALUES("10734", "1", "2015-04-04 03:09:12", "2015-04-04 03:09:12", "", "Fusion Slider", "", "publish", "open", "open", "", "fusion-slider", "", "", "2015-04-18 22:12:37", "2015-04-18 22:12:37", "", "0", "http://birminghamupg.com/bhamupg_base/?p=10734", "38", "nav_menu_item", "", "0");
INSERT INTO `bupg_posts` VALUES("10838", "1", "2015-04-04 03:09:26", "2015-04-04 03:09:26", "", "Contact", "", "publish", "open", "open", "", "contact", "", "", "2015-04-04 03:09:26", "2015-04-04 03:09:26", "", "0", "http://birminghamupg.com/bhamupg_base/?p=10838", "5", "nav_menu_item", "", "0");
INSERT INTO `bupg_posts` VALUES("10955", "1", "2015-04-04 03:09:40", "2015-04-04 03:09:40", "", "slide_3", "", "inherit", "open", "open", "", "slide_3-2", "", "", "2015-04-04 03:09:40", "2015-04-04 03:09:40", "", "37", "http://birminghamupg.com/bhamupg_base/?attachment_id=10955", "0", "attachment", "image/jpeg", "0");
INSERT INTO `bupg_posts` VALUES("10956", "1", "2015-04-04 03:09:40", "2015-04-04 03:09:40", "", "slide_4", "", "inherit", "open", "open", "", "slide_4-2", "", "", "2015-04-04 03:09:40", "2015-04-04 03:09:40", "", "37", "http://birminghamupg.com/bhamupg_base/?attachment_id=10956", "0", "attachment", "image/jpeg", "0");
INSERT INTO `bupg_posts` VALUES("10969", "1", "2015-04-04 03:09:40", "2015-04-04 03:09:40", "", "html5-color", "", "inherit", "open", "open", "", "html5-color-2", "", "", "2015-04-04 03:09:40", "2015-04-04 03:09:40", "", "37", "http://birminghamupg.com/bhamupg_base/?attachment_id=10969", "0", "attachment", "image/png", "0");
INSERT INTO `bupg_posts` VALUES("10972", "1", "2015-04-04 03:09:40", "2015-04-04 03:09:40", "", "vimeo-color", "", "inherit", "open", "open", "", "vimeo-color-2", "", "", "2015-04-04 03:09:40", "2015-04-04 03:09:40", "", "37", "http://birminghamupg.com/bhamupg_base/?attachment_id=10972", "0", "attachment", "image/png", "0");
INSERT INTO `bupg_posts` VALUES("10973", "1", "2015-04-04 03:09:40", "2015-04-04 03:09:40", "", "youtube-color", "", "inherit", "open", "open", "", "youtube-color-2", "", "", "2015-04-04 03:09:40", "2015-04-04 03:09:40", "", "37", "http://birminghamupg.com/bhamupg_base/?attachment_id=10973", "0", "attachment", "image/png", "0");
INSERT INTO `bupg_posts` VALUES("10974", "1", "2015-04-04 03:09:40", "2015-04-04 03:09:40", "", "slide_3.jpg", "", "inherit", "closed", "closed", "", "slide-3-jpg", "", "", "2015-04-04 03:09:40", "2015-04-04 03:09:40", "", "0", "http://birminghamupg.com/bhamupg_base/wp-content/uploads/revslider/Avada_Full_Width/slide_3.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `bupg_posts` VALUES("10975", "1", "2015-04-04 03:09:40", "2015-04-04 03:09:40", "", "slide_4.jpg", "", "inherit", "closed", "closed", "", "slide-4-jpg", "", "", "2015-04-04 03:09:40", "2015-04-04 03:09:40", "", "0", "http://birminghamupg.com/bhamupg_base/wp-content/uploads/revslider/Avada_Full_Width/slide_4.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `bupg_posts` VALUES("10983", "1", "2015-04-04 03:09:41", "2015-04-04 03:09:41", "", "slide_4.jpg", "", "inherit", "closed", "closed", "", "slide-4-jpg-2", "", "", "2015-04-04 03:09:41", "2015-04-04 03:09:41", "", "0", "http://birminghamupg.com/bhamupg_base/wp-content/uploads/revslider/Avada_Small_Slider/slide_4.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `bupg_posts` VALUES("10988", "1", "2015-04-04 03:09:41", "2015-04-04 03:09:41", "", "box21.png", "", "inherit", "closed", "closed", "", "box21-png-2", "", "", "2015-04-04 03:09:41", "2015-04-04 03:09:41", "", "0", "http://birminghamupg.com/bhamupg_base/wp-content/uploads/revslider/captions_tall/box21.png", "0", "attachment", "image/png", "0");
INSERT INTO `bupg_posts` VALUES("10995", "1", "2015-04-18 22:15:40", "2015-04-18 22:15:40", "[fullwidth backgroundcolor=\"#f9f9f9\" backgroundimage=\"\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"0px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"none\" top_margin=\"\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]\r\n<h1 style=\"text-align: center; font-size: 32px; line-height: 38px; color: #000;\"><strong>Birmingham Unreached People Groups</strong></h1>\r\n<p style=\"text-align: center; margin-top: -20px; font-size: 28px; color: #ed7c31;\"> <a href=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/06/engage_DiscoverWelcomeEngage3v400x36.png\"><img class=\"alignnone size-medium wp-image-11410\" src=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/06/engage_DiscoverWelcomeEngage3v400x36.png\" alt=\"engage_DiscoverWelcomeEngage3v400x36\" width=\"400\" height=\"36\" /></a></p>\r\n[/fusion_text][youtube id=\"HxeilZgGWBg\" width=\"1280\" height=\"720\" autoplay=\"yes\" api_params=\"&amp;rel=0\" class=\"\"][/fullwidth][fullwidth backgroundcolor=\"\" backgroundimage=\"\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"scroll\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"1px\" bordercolor=\"#00bbd6\" borderstyle=\"solid\" paddingtop=\"8px\" paddingbottom=\"8px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][fusion_text]\r\n<blockquote>All <span style=\"color: #172d78; font-weight: bold;\">nations</span> whom You have made shall come and worship before You, O Lord, And they shall glorify Your name.  Psalm 86:9</blockquote>\r\n[/fusion_text][/fullwidth][fullwidth backgroundcolor=\"\" backgroundimage=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/downtown1-300x200.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"20px\" paddingbottom=\"20px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][one_third last=\"no\" spacing=\"yes\" background_color=\"#172d78\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"solid\" padding=\"10px\" class=\"transparent\" id=\"\"][imageframe lightbox=\"yes\" style_type=\"none\" bordercolor=\"\" bordersize=\"\" borderradius=\"\" stylecolor=\"\" align=\"center\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img src=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/Guatemalan24651726_ml-300x200.jpg\" alt=\"PEOPLE GROUP is a ethno-linguistic group with a common self-identity\" />[/imageframe][separator style_type=\"none\" top_margin=\"\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]\r\n<h2 style=\"color: #fff;\">WHAT IS A PEOPLE GROUP?</h2>\r\n<span style=\"color: #f4f4f4;\">\r\n\"An ethno-linguistic group with a common self-identity that is shared by the various members. For strategic purposes it is the largest group within which the Gospel can spread without encountering barriers of understanding or acceptance.\" </span>\r\n\r\n<span style=\"color: #f4f4f4;\">Quote Source: The International Mission Board, PeopleGroups.org</span>\r\n\r\n[/fusion_text][/one_third][one_third last=\"no\" spacing=\"yes\" background_color=\"#009900\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"solid\" padding=\"10px\" class=\"transparent\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"\" borderradius=\"\" stylecolor=\"\" align=\"center\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img src=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/Yemeni17378186_ml-300x201.jpg\" alt=\"no indigenous community of believing Christians able to engage this people group\" />[/imageframe][separator style_type=\"none\" top_margin=\"\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]\r\n<h2 style=\"color: #fff;\">WHY ARE THEY UNREACHED?</h2>\r\n<span style=\"color: #f4f4f4;\">\r\n\"A people group is considered unreached (UPG) when there is no indigenous community of believing Christians able to engage this people group with church planting. Technically speaking, the percentage of evangelical Christians in this people group is less than 2 percent.\" </span>\r\n\r\n<span style=\"color: #f4f4f4;\">Quote Source: The International Mission Board, PeopleGroups.org</span>\r\n\r\n[/fusion_text][/one_third][one_third last=\"yes\" spacing=\"yes\" background_color=\"#da2222\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"solid\" padding=\"10px\" class=\"transparent\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"\" borderradius=\"\" stylecolor=\"\" align=\"center\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img src=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/India-Telugu27371027_ml-300x203.jpg\" alt=\"when there is no church planting strategy, consistent with evangelical faith and practice, under way.\" />[/imageframe][separator style_type=\"none\" top_margin=\"\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]\r\n<h2 style=\"color: #fff;\">WHO ARE THE UNENGAGED?</h2>\r\n<span style=\"color: #f4f4f4;\">\r\n\"Unreached people groups are unengaged (UUPG) when there is no church planting strategy, consistent with evangelical faith and practice, under way. Gathering believers and planting churches are the keys to establishing an effective and multiplying presence among these people groups.\" </span>\r\n\r\n<span style=\"color: #f4f4f4;\">Quote Source: The International Mission Board, PeopleGroups.org\r\n</span>[/fusion_text][/one_third][/fullwidth][fullwidth backgroundcolor=\"\" backgroundimage=\"\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"1px\" bordercolor=\"#e5e4e4\" borderstyle=\"solid\" paddingtop=\"8px\" paddingbottom=\"8px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][fusion_text]\r\n<blockquote>This gospel of the kingdom shall be preached in the whole world as a testimony to all the <span style=\"color: #172d78; font-weight: bold;\">nations</span>, and then the end will come. — Matthew 24:14</blockquote>\r\n[/fusion_text][/fullwidth][fullwidth backgroundcolor=\"\" backgroundimage=\"\" backgroundrepeat=\"no-repeat\" backgroundposition=\"top left\" backgroundattachment=\"scroll\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"#f6f6f6\" borderstyle=\"\" paddingtop=\"0px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][content_boxes layout=\"icon-with-title\" icon_circle_size=\"medium\" icon_align=\"left\" columns=\"3\" class=\"\" id=\"\"][content_box title=\"Why Are the Nations Coming?\" icon=\"fa-road\" backgroundcolor=\"\" iconcolor=\"\" circlecolor=\"#db2532\" circlebordercolor=\"#000000\" iconflip=\"\" iconrotate=\"\" iconspin=\"no\" image=\"\" image_width=\"\" image_height=\"\" link=\"why\" linktext=\"READ MORE\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"1\"] We should not be surprised that God is moving the people groups to where they can hear the Gospel.[/content_box][content_box title=\"What is Our Response?\" icon=\"fa-comment\" backgroundcolor=\"\" iconcolor=\"\" circlecolor=\"#1ed9ac\" circlebordercolor=\"#000000\" iconflip=\"\" iconrotate=\"\" iconspin=\"no\" image=\"\" image_width=\"\" image_height=\"\" link=\"what\" linktext=\"READ MORE\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"1\"] The people groups that God is bringing to Birmingham bring with them a wealth of cultural traditions and different ideas about who God is and how He might be known.[/content_box][content_box title=\"So What Can I Do?\" icon=\"fa-bicycle\" backgroundcolor=\"\" iconcolor=\"\" circlecolor=\"#704efc\" circlebordercolor=\"#000000\" iconflip=\"\" iconrotate=\"\" iconspin=\"no\" image=\"\" image_width=\"\" image_height=\"\" link=\"sowhat\" linktext=\"READ MORE\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"1\"] Unreached people groups will not be found in your local church on Sunday morning.[/content_box][/content_boxes][separator style_type=\"none\" top_margin=\"-20\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth]", "Birmingham Unreached People Groups", "", "publish", "open", "open", "", "home-2", "", "", "2015-10-24 16:17:11", "2015-10-24 16:17:11", "", "0", "http://birminghamupg.com/bhamupg/?page_id=10995", "1", "page", "", "0");
INSERT INTO `bupg_posts` VALUES("10996", "1", "2015-04-12 21:57:56", "2015-04-12 21:57:56", "[fullwidth backgroundcolor=\"\" backgroundimage=\"http://theme-fusion.com/avadaxml/wp-content/uploads/2013/10/bkgd1.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"100px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][youtube id=\"HxeilZgGWBg\" width=\"1280\" height=\"720\" autoplay=\"yes\" api_params=\"&amp;rel=0\" class=\"\"][separator style_type=\"single\" top_margin=\"-10\" bottom_margin=\"70\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]\r\n<h1 style=\"text-align: center; font-size: 57px; line-height: 75px;\">Avada Is The #1 Selling WP Theme</h1>\r\n<p style=\"text-align: center; margin-top: -20px; font-size: 18px;\">With over [tooltip title=\"Join The Avada Community!\"]<strong>95,000+ Users and counting</strong>[/tooltip], Avada is the most complete and trusted wordpress theme on the market.</p>\r\n[/fusion_text][separator style_type=\"none\" top_margin=\"20\" bottom_margin=\"20\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img src=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/browsers.png\" alt=\"\" />[/imageframe][/fullwidth][fullwidth backgroundcolor=\"#fff\" backgroundimage=\"\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"1px\" bordercolor=\"#e5e4e4\" borderstyle=\"solid\" paddingtop=\"55px\" paddingbottom=\"45px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][flip_boxes columns=\"3\" class=\"\" id=\"\"][flip_box title_front=\"Fully Responsive\" title_back=\"Perfect For All Sizes\" text_front=\"Avada\'s responsive framework ensures your content looks great on all screen sizes.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-compress\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]No matter the size of your screen or device, your site will look fantastic.[/flip_box][flip_box title_front=\"Premium Sliders\" title_back=\"Make Your Content Stand Out\" text_front=\"Avada includes four premium sliders that make your content stand out!\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-rocket\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]Avada includes the Layer Slider, Revolution Slider, Fusion Slider and Elastic Slider.[/flip_box][flip_box title_front=\"Fusion Builder\" title_back=\"Build Something Beautiful\" text_front=\"Fusion Builder is an intuitive visual page builder that is a pleasure to use.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-trophy\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]Fusion Builder includes dozens of shortcodes loaded with options, giving you perfect freedom.[/flip_box][/flip_boxes][flip_boxes columns=\"3\" class=\"\" id=\"\"][flip_box title_front=\"Dedicated Support\" title_back=\"You Can Count On Us\" text_front=\"We care about your site as much as you do, you can count on us for theme support.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-thumbs-o-up\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]We thrive on our users, and want to see everyone happy when using Avada.[/flip_box][flip_box title_front=\"Powerful Options\" title_back=\"Unleash The Power of Avada\" text_front=\"Avada\'s theme options and page options allow you to take control of your website.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-cog\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]We build intuitive, user-friendly options so you can quickly and easily build your site.[/flip_box][flip_box title_front=\"Free Updates With Value\" title_back=\"Its Like Getting A New Theme\" text_front=\"We issue updates that matter; rich with amazing new features and improvements.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-gift\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]Avada just keeps getting better and better, each update is like getting a brand new theme all for free.[/flip_box][/flip_boxes][separator style_type=\"single\" top_margin=\"22\" bottom_margin=\"70\" sep_color=\"rgba(000,000,000,.1)\" icon=\"fa-chevron-down\" width=\"\" class=\"\" id=\"\"][one_half last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][postslider layout=\"posts\" excerpt=\"35\" category=\"design\" limit=\"2\" lightbox=\"yes\" class=\"\" id=\"\"][/postslider][/one_half][one_half last=\"yes\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][fusion_text]\r\n<h2>What Else? We Have The Best Support Around</h2>\r\n[/fusion_text][separator style_type=\"single\" top_margin=\"5\" bottom_margin=\"25\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]Avada is [tooltip title=\"Everting You Need To Create!\"]<strong>loaded with useful, functional options</strong>[/tooltip] that allow users to quickly and easily create stunning websites. But that\'s not all, when you purchase a copy of Avada you will also get the [tooltip title=\"Support Forum, Docs &amp; Videos!\"]<strong>most amazing customer support around!</strong>[/tooltip][/fusion_text][separator style_type=\"none\" top_margin=\"15\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][checklist icon=\"fa-star\" iconcolor=\"dark\" circle=\"no\" circlecolor=\"\" size=\"small\" class=\"\" id=\"\"][li_item icon=\"\"]Fully responsive so your content will always look good on any screen size[/li_item][li_item icon=\"\"]Awesome sliders give you the opportunity to showcase your content[/li_item][li_item icon=\"\"]Advanced theme options panel to easily customize your website[/li_item][/checklist][separator style_type=\"single\" top_margin=\"10\" bottom_margin=\"30\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"default\" size=\"large\" type=\"\" shape=\"\" target=\"_blank\" title=\"\" gradient_colors=\"|\" gradient_hover_colors=\"|\" accent_color=\"\" accent_hover_color=\"\" bevel_color=\"\" border_width=\"1px\" shadow=\"\" icon=\"\" icon_position=\"left\" icon_divider=\"yes\" modal=\"\" animation_type=\"fade\" animation_direction=\"down\" animation_speed=\"1\" alignment=\"\" class=\"\" id=\"\"]Buy Avada Now![/button][/one_half][/fullwidth][fullwidth backgroundcolor=\"\" backgroundimage=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/forest3.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"65px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][tagline_box backgroundcolor=\"rgba(255,255,255,.2)\" shadow=\"no\" shadowopacity=\"0.1\" border=\"1px\" bordercolor=\"rgba(255,255,255,.4)\" highlightposition=\"top\" content_alignment=\"left\" link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" linktarget=\"_blank\" modal=\"\" button_size=\"large\" button_shape=\"square\" button_type=\"flat\" buttoncolor=\"\" button=\"Purchase Now\" title=\"<span style=\"color: #ffffff;\">Avada Is The Ultimate Wordpress Multi-Purpose Wordpress Theme!</span>\" description=\" <span style=\"color: #ffffff;\">Loaded with awesome features like Fusion Builder, premium sliders, unlimited colors, advanced theme options &amp; more!</span>\" animation_type=\"fade\" animation_direction=\"up\" animation_speed=\"1\" class=\"\" id=\"\"][/tagline_box][separator style_type=\"none\" top_margin=\"-20\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth]", "UPGhome", "", "inherit", "open", "open", "", "10995-revision-v1", "", "", "2015-04-12 21:57:56", "2015-04-12 21:57:56", "", "10995", "http://birminghamupg.com/bhamupg/?p=10996", "0", "revision", "", "0");
INSERT INTO `bupg_posts` VALUES("10997", "1", "2015-04-12 22:00:06", "2015-04-12 22:00:06", "[fullwidth backgroundcolor=\"\" backgroundimage=\"http://theme-fusion.com/avadaxml/wp-content/uploads/2013/10/bkgd1.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"100px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][youtube id=\"HxeilZgGWBg\" width=\"1280\" height=\"720\" autoplay=\"yes\" api_params=\"&amp;rel=0\" class=\"\"][separator style_type=\"single\" top_margin=\"-10\" bottom_margin=\"70\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]\r\n<h1 style=\"text-align: center; font-size: 57px; line-height: 75px;\">Avada Is The #1 Selling WP Theme</h1>\r\n<p style=\"text-align: center; margin-top: -20px; font-size: 18px;\">With over [tooltip title=\"Join The Avada Community!\"]<strong>95,000+ Users and counting</strong>[/tooltip], Avada is the most complete and trusted wordpress theme on the market.</p>\r\n[/fusion_text][separator style_type=\"none\" top_margin=\"20\" bottom_margin=\"20\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img src=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/browsers.png\" alt=\"\" />[/imageframe][/fullwidth][fullwidth backgroundcolor=\"#fff\" backgroundimage=\"\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"1px\" bordercolor=\"#e5e4e4\" borderstyle=\"solid\" paddingtop=\"55px\" paddingbottom=\"45px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][flip_boxes columns=\"3\" class=\"\" id=\"\"][flip_box title_front=\"Fully Responsive\" title_back=\"Perfect For All Sizes\" text_front=\"Avada\'s responsive framework ensures your content looks great on all screen sizes.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-compress\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]No matter the size of your screen or device, your site will look fantastic.[/flip_box][flip_box title_front=\"Premium Sliders\" title_back=\"Make Your Content Stand Out\" text_front=\"Avada includes four premium sliders that make your content stand out!\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-rocket\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]Avada includes the Layer Slider, Revolution Slider, Fusion Slider and Elastic Slider.[/flip_box][flip_box title_front=\"Fusion Builder\" title_back=\"Build Something Beautiful\" text_front=\"Fusion Builder is an intuitive visual page builder that is a pleasure to use.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-trophy\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]Fusion Builder includes dozens of shortcodes loaded with options, giving you perfect freedom.[/flip_box][/flip_boxes][flip_boxes columns=\"3\" class=\"\" id=\"\"][flip_box title_front=\"Dedicated Support\" title_back=\"You Can Count On Us\" text_front=\"We care about your site as much as you do, you can count on us for theme support.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-thumbs-o-up\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]We thrive on our users, and want to see everyone happy when using Avada.[/flip_box][flip_box title_front=\"Powerful Options\" title_back=\"Unleash The Power of Avada\" text_front=\"Avada\'s theme options and page options allow you to take control of your website.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-cog\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]We build intuitive, user-friendly options so you can quickly and easily build your site.[/flip_box][flip_box title_front=\"Free Updates With Value\" title_back=\"Its Like Getting A New Theme\" text_front=\"We issue updates that matter; rich with amazing new features and improvements.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-gift\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]Avada just keeps getting better and better, each update is like getting a brand new theme all for free.[/flip_box][/flip_boxes][separator style_type=\"single\" top_margin=\"22\" bottom_margin=\"70\" sep_color=\"rgba(000,000,000,.1)\" icon=\"fa-chevron-down\" width=\"\" class=\"\" id=\"\"][one_half last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][postslider layout=\"posts\" excerpt=\"35\" category=\"design\" limit=\"2\" lightbox=\"yes\" class=\"\" id=\"\"][/postslider][/one_half][one_half last=\"yes\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][fusion_text]\r\n<h2>What Else? We Have The Best Support Around</h2>\r\n[/fusion_text][separator style_type=\"single\" top_margin=\"5\" bottom_margin=\"25\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]Avada is [tooltip title=\"Everting You Need To Create!\"]<strong>loaded with useful, functional options</strong>[/tooltip] that allow users to quickly and easily create stunning websites. But that\'s not all, when you purchase a copy of Avada you will also get the [tooltip title=\"Support Forum, Docs &amp; Videos!\"]<strong>most amazing customer support around!</strong>[/tooltip][/fusion_text][separator style_type=\"none\" top_margin=\"15\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][checklist icon=\"fa-star\" iconcolor=\"dark\" circle=\"no\" circlecolor=\"\" size=\"small\" class=\"\" id=\"\"][li_item icon=\"\"]Fully responsive so your content will always look good on any screen size[/li_item][li_item icon=\"\"]Awesome sliders give you the opportunity to showcase your content[/li_item][li_item icon=\"\"]Advanced theme options panel to easily customize your website[/li_item][/checklist][separator style_type=\"single\" top_margin=\"10\" bottom_margin=\"30\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"default\" size=\"large\" type=\"\" shape=\"\" target=\"_blank\" title=\"\" gradient_colors=\"|\" gradient_hover_colors=\"|\" accent_color=\"\" accent_hover_color=\"\" bevel_color=\"\" border_width=\"1px\" shadow=\"\" icon=\"\" icon_position=\"left\" icon_divider=\"yes\" modal=\"\" animation_type=\"fade\" animation_direction=\"down\" animation_speed=\"1\" alignment=\"\" class=\"\" id=\"\"]Buy Avada Now![/button][/one_half][/fullwidth][fullwidth backgroundcolor=\"\" backgroundimage=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/forest3.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"65px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][tagline_box backgroundcolor=\"title=\"&lt;span\" shadow=\"no\" shadowopacity=\"0.1\" border=\"1px\" bordercolor=\"rgba(255,255,255,.4)\" highlightposition=\"top\" content_alignment=\"left\" link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" linktarget=\"_blank\" modal=\"\" button_size=\"large\" button_shape=\"square\" button_type=\"flat\" buttoncolor=\"\" button=\"Purchase Now\" title=\"\" description=\"\" animation_type=\"fade\" animation_direction=\"up\" animation_speed=\"1\" class=\"\" id=\"\"][/tagline_box][separator style_type=\"none\" top_margin=\"-20\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth]", "UPGhome", "", "inherit", "open", "open", "", "10995-revision-v1", "", "", "2015-04-12 22:00:06", "2015-04-12 22:00:06", "", "10995", "http://birminghamupg.com/bhamupg/?p=10997", "0", "revision", "", "0");
INSERT INTO `bupg_posts` VALUES("10998", "1", "2015-04-12 22:11:44", "2015-04-12 22:11:44", "", "downtown", "", "inherit", "open", "open", "", "downtown", "", "", "2015-04-12 22:11:44", "2015-04-12 22:11:44", "", "10995", "http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/downtown1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `bupg_posts` VALUES("10999", "1", "2015-04-12 22:13:13", "2015-04-12 22:13:13", "[fullwidth backgroundcolor=\"\" backgroundimage=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/downtown1-300x200.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"100px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][youtube id=\"HxeilZgGWBg\" width=\"1280\" height=\"720\" autoplay=\"yes\" api_params=\"&amp;rel=0\" class=\"\"][separator style_type=\"single\" top_margin=\"-10\" bottom_margin=\"70\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]\r\n<h1 style=\"text-align: center; font-size: 57px; line-height: 75px;\">Avada Is The #1 Selling WP Theme</h1>\r\n<p style=\"text-align: center; margin-top: -20px; font-size: 18px;\">With over [tooltip title=\"Join The Avada Community!\"]<strong>95,000+ Users and counting</strong>[/tooltip], Avada is the most complete and trusted wordpress theme on the market.</p>\r\n[/fusion_text][separator style_type=\"none\" top_margin=\"20\" bottom_margin=\"20\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img src=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/browsers.png\" alt=\"\" />[/imageframe][/fullwidth][fullwidth backgroundcolor=\"#fff\" backgroundimage=\"\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"1px\" bordercolor=\"#e5e4e4\" borderstyle=\"solid\" paddingtop=\"55px\" paddingbottom=\"45px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][flip_boxes columns=\"3\" class=\"\" id=\"\"][flip_box title_front=\"Fully Responsive\" title_back=\"Perfect For All Sizes\" text_front=\"Avada\'s responsive framework ensures your content looks great on all screen sizes.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-compress\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]No matter the size of your screen or device, your site will look fantastic.[/flip_box][flip_box title_front=\"Premium Sliders\" title_back=\"Make Your Content Stand Out\" text_front=\"Avada includes four premium sliders that make your content stand out!\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-rocket\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]Avada includes the Layer Slider, Revolution Slider, Fusion Slider and Elastic Slider.[/flip_box][flip_box title_front=\"Fusion Builder\" title_back=\"Build Something Beautiful\" text_front=\"Fusion Builder is an intuitive visual page builder that is a pleasure to use.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-trophy\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]Fusion Builder includes dozens of shortcodes loaded with options, giving you perfect freedom.[/flip_box][/flip_boxes][flip_boxes columns=\"3\" class=\"\" id=\"\"][flip_box title_front=\"Dedicated Support\" title_back=\"You Can Count On Us\" text_front=\"We care about your site as much as you do, you can count on us for theme support.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-thumbs-o-up\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]We thrive on our users, and want to see everyone happy when using Avada.[/flip_box][flip_box title_front=\"Powerful Options\" title_back=\"Unleash The Power of Avada\" text_front=\"Avada\'s theme options and page options allow you to take control of your website.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-cog\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]We build intuitive, user-friendly options so you can quickly and easily build your site.[/flip_box][flip_box title_front=\"Free Updates With Value\" title_back=\"Its Like Getting A New Theme\" text_front=\"We issue updates that matter; rich with amazing new features and improvements.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-gift\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]Avada just keeps getting better and better, each update is like getting a brand new theme all for free.[/flip_box][/flip_boxes][separator style_type=\"single\" top_margin=\"22\" bottom_margin=\"70\" sep_color=\"rgba(000,000,000,.1)\" icon=\"fa-chevron-down\" width=\"\" class=\"\" id=\"\"][one_half last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][postslider layout=\"posts\" excerpt=\"35\" category=\"design\" limit=\"2\" lightbox=\"yes\" class=\"\" id=\"\"][/postslider][/one_half][one_half last=\"yes\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][fusion_text]\r\n<h2>What Else? We Have The Best Support Around</h2>\r\n[/fusion_text][separator style_type=\"single\" top_margin=\"5\" bottom_margin=\"25\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]Avada is [tooltip title=\"Everting You Need To Create!\"]<strong>loaded with useful, functional options</strong>[/tooltip] that allow users to quickly and easily create stunning websites. But that\'s not all, when you purchase a copy of Avada you will also get the [tooltip title=\"Support Forum, Docs &amp; Videos!\"]<strong>most amazing customer support around!</strong>[/tooltip][/fusion_text][separator style_type=\"none\" top_margin=\"15\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][checklist icon=\"fa-star\" iconcolor=\"dark\" circle=\"no\" circlecolor=\"\" size=\"small\" class=\"\" id=\"\"][li_item icon=\"\"]Fully responsive so your content will always look good on any screen size[/li_item][li_item icon=\"\"]Awesome sliders give you the opportunity to showcase your content[/li_item][li_item icon=\"\"]Advanced theme options panel to easily customize your website[/li_item][/checklist][separator style_type=\"single\" top_margin=\"10\" bottom_margin=\"30\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"default\" size=\"large\" type=\"\" shape=\"\" target=\"_blank\" title=\"\" gradient_colors=\"|\" gradient_hover_colors=\"|\" accent_color=\"\" accent_hover_color=\"\" bevel_color=\"\" border_width=\"1px\" shadow=\"\" icon=\"\" icon_position=\"left\" icon_divider=\"yes\" modal=\"\" animation_type=\"fade\" animation_direction=\"down\" animation_speed=\"1\" alignment=\"\" class=\"\" id=\"\"]Buy Avada Now![/button][/one_half][/fullwidth][fullwidth backgroundcolor=\"\" backgroundimage=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/forest3.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"65px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][tagline_box backgroundcolor=\"backgroundcolor=\"title=\"&lt;span\"\" shadow=\"no\" shadowopacity=\"0.1\" border=\"1px\" bordercolor=\"rgba(255,255,255,.4)\" highlightposition=\"top\" content_alignment=\"left\" link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" linktarget=\"_blank\" modal=\"\" button_size=\"large\" button_shape=\"square\" button_type=\"flat\" buttoncolor=\"\" button=\"Purchase Now\" title=\"\" description=\"\" animation_type=\"fade\" animation_direction=\"up\" animation_speed=\"1\" class=\"\" id=\"\"][/tagline_box][separator style_type=\"none\" top_margin=\"-20\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth]", "UPGhome", "", "inherit", "open", "open", "", "10995-revision-v1", "", "", "2015-04-12 22:13:13", "2015-04-12 22:13:13", "", "10995", "http://birminghamupg.com/bhamupg/?p=10999", "0", "revision", "", "0");
INSERT INTO `bupg_posts` VALUES("11000", "1", "2015-04-12 22:14:04", "2015-04-12 22:14:04", "[fullwidth backgroundcolor=\"\" backgroundimage=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/downtown1-300x200.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"100px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"single\" top_margin=\"-10\" bottom_margin=\"70\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][youtube id=\"HxeilZgGWBg\" width=\"1280\" height=\"720\" autoplay=\"yes\" api_params=\"&amp;rel=0\" class=\"\"][fusion_text]\r\n<h1 style=\"text-align: center; font-size: 57px; line-height: 75px;\">Avada Is The #1 Selling WP Theme</h1>\r\n<p style=\"text-align: center; margin-top: -20px; font-size: 18px;\">With over [tooltip title=\"Join The Avada Community!\"]<strong>95,000+ Users and counting</strong>[/tooltip], Avada is the most complete and trusted wordpress theme on the market.</p>\r\n[/fusion_text][separator style_type=\"none\" top_margin=\"20\" bottom_margin=\"20\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img src=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/browsers.png\" alt=\"\" />[/imageframe][/fullwidth][fullwidth backgroundcolor=\"#fff\" backgroundimage=\"\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"1px\" bordercolor=\"#e5e4e4\" borderstyle=\"solid\" paddingtop=\"55px\" paddingbottom=\"45px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][flip_boxes columns=\"3\" class=\"\" id=\"\"][flip_box title_front=\"Fully Responsive\" title_back=\"Perfect For All Sizes\" text_front=\"Avada\'s responsive framework ensures your content looks great on all screen sizes.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-compress\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]No matter the size of your screen or device, your site will look fantastic.[/flip_box][flip_box title_front=\"Premium Sliders\" title_back=\"Make Your Content Stand Out\" text_front=\"Avada includes four premium sliders that make your content stand out!\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-rocket\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]Avada includes the Layer Slider, Revolution Slider, Fusion Slider and Elastic Slider.[/flip_box][flip_box title_front=\"Fusion Builder\" title_back=\"Build Something Beautiful\" text_front=\"Fusion Builder is an intuitive visual page builder that is a pleasure to use.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-trophy\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]Fusion Builder includes dozens of shortcodes loaded with options, giving you perfect freedom.[/flip_box][/flip_boxes][flip_boxes columns=\"3\" class=\"\" id=\"\"][flip_box title_front=\"Dedicated Support\" title_back=\"You Can Count On Us\" text_front=\"We care about your site as much as you do, you can count on us for theme support.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-thumbs-o-up\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]We thrive on our users, and want to see everyone happy when using Avada.[/flip_box][flip_box title_front=\"Powerful Options\" title_back=\"Unleash The Power of Avada\" text_front=\"Avada\'s theme options and page options allow you to take control of your website.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-cog\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]We build intuitive, user-friendly options so you can quickly and easily build your site.[/flip_box][flip_box title_front=\"Free Updates With Value\" title_back=\"Its Like Getting A New Theme\" text_front=\"We issue updates that matter; rich with amazing new features and improvements.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-gift\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]Avada just keeps getting better and better, each update is like getting a brand new theme all for free.[/flip_box][/flip_boxes][separator style_type=\"single\" top_margin=\"22\" bottom_margin=\"70\" sep_color=\"rgba(000,000,000,.1)\" icon=\"fa-chevron-down\" width=\"\" class=\"\" id=\"\"][one_half last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][postslider layout=\"posts\" excerpt=\"35\" category=\"design\" limit=\"2\" lightbox=\"yes\" class=\"\" id=\"\"][/postslider][/one_half][one_half last=\"yes\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][fusion_text]\r\n<h2>What Else? We Have The Best Support Around</h2>\r\n[/fusion_text][separator style_type=\"single\" top_margin=\"5\" bottom_margin=\"25\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]Avada is [tooltip title=\"Everting You Need To Create!\"]<strong>loaded with useful, functional options</strong>[/tooltip] that allow users to quickly and easily create stunning websites. But that\'s not all, when you purchase a copy of Avada you will also get the [tooltip title=\"Support Forum, Docs &amp; Videos!\"]<strong>most amazing customer support around!</strong>[/tooltip][/fusion_text][separator style_type=\"none\" top_margin=\"15\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][checklist icon=\"fa-star\" iconcolor=\"dark\" circle=\"no\" circlecolor=\"\" size=\"small\" class=\"\" id=\"\"][li_item icon=\"\"]Fully responsive so your content will always look good on any screen size[/li_item][li_item icon=\"\"]Awesome sliders give you the opportunity to showcase your content[/li_item][li_item icon=\"\"]Advanced theme options panel to easily customize your website[/li_item][/checklist][separator style_type=\"single\" top_margin=\"10\" bottom_margin=\"30\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"default\" size=\"large\" type=\"\" shape=\"\" target=\"_blank\" title=\"\" gradient_colors=\"|\" gradient_hover_colors=\"|\" accent_color=\"\" accent_hover_color=\"\" bevel_color=\"\" border_width=\"1px\" shadow=\"\" icon=\"\" icon_position=\"left\" icon_divider=\"yes\" modal=\"\" animation_type=\"fade\" animation_direction=\"down\" animation_speed=\"1\" alignment=\"\" class=\"\" id=\"\"]Buy Avada Now![/button][/one_half][/fullwidth][fullwidth backgroundcolor=\"\" backgroundimage=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/forest3.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"65px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][tagline_box backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"title=\"&lt;span\"\"\" shadow=\"no\" shadowopacity=\"0.1\" border=\"1px\" bordercolor=\"rgba(255,255,255,.4)\" highlightposition=\"top\" content_alignment=\"left\" link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" linktarget=\"_blank\" modal=\"\" button_size=\"large\" button_shape=\"square\" button_type=\"flat\" buttoncolor=\"\" button=\"Purchase Now\" title=\"\" description=\"\" animation_type=\"fade\" animation_direction=\"up\" animation_speed=\"1\" class=\"\" id=\"\"][/tagline_box][separator style_type=\"none\" top_margin=\"-20\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth]", "UPGhome", "", "inherit", "open", "open", "", "10995-revision-v1", "", "", "2015-04-12 22:14:04", "2015-04-12 22:14:04", "", "10995", "http://birminghamupg.com/bhamupg/?p=11000", "0", "revision", "", "0");
INSERT INTO `bupg_posts` VALUES("11001", "1", "2015-04-12 22:15:26", "2015-04-12 22:15:26", "[fullwidth backgroundcolor=\"\" backgroundimage=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/downtown1-300x200.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"100px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][youtube id=\"HxeilZgGWBg\" width=\"1280\" height=\"720\" autoplay=\"yes\" api_params=\"&amp;rel=0\" class=\"\"][separator style_type=\"single\" top_margin=\"-10\" bottom_margin=\"70\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]\r\n<h1 style=\"text-align: center; font-size: 57px; line-height: 75px;\">Avada Is The #1 Selling WP Theme</h1>\r\n<p style=\"text-align: center; margin-top: -20px; font-size: 18px;\">With over [tooltip title=\"Join The Avada Community!\"]<strong>95,000+ Users and counting</strong>[/tooltip], Avada is the most complete and trusted wordpress theme on the market.</p>\r\n[/fusion_text][separator style_type=\"none\" top_margin=\"20\" bottom_margin=\"20\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img src=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/browsers.png\" alt=\"\" />[/imageframe][/fullwidth][fullwidth backgroundcolor=\"#fff\" backgroundimage=\"\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"1px\" bordercolor=\"#e5e4e4\" borderstyle=\"solid\" paddingtop=\"55px\" paddingbottom=\"45px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][flip_boxes columns=\"3\" class=\"\" id=\"\"][flip_box title_front=\"Fully Responsive\" title_back=\"Perfect For All Sizes\" text_front=\"Avada\'s responsive framework ensures your content looks great on all screen sizes.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-compress\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]No matter the size of your screen or device, your site will look fantastic.[/flip_box][flip_box title_front=\"Premium Sliders\" title_back=\"Make Your Content Stand Out\" text_front=\"Avada includes four premium sliders that make your content stand out!\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-rocket\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]Avada includes the Layer Slider, Revolution Slider, Fusion Slider and Elastic Slider.[/flip_box][flip_box title_front=\"Fusion Builder\" title_back=\"Build Something Beautiful\" text_front=\"Fusion Builder is an intuitive visual page builder that is a pleasure to use.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-trophy\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]Fusion Builder includes dozens of shortcodes loaded with options, giving you perfect freedom.[/flip_box][/flip_boxes][flip_boxes columns=\"3\" class=\"\" id=\"\"][flip_box title_front=\"Dedicated Support\" title_back=\"You Can Count On Us\" text_front=\"We care about your site as much as you do, you can count on us for theme support.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-thumbs-o-up\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]We thrive on our users, and want to see everyone happy when using Avada.[/flip_box][flip_box title_front=\"Powerful Options\" title_back=\"Unleash The Power of Avada\" text_front=\"Avada\'s theme options and page options allow you to take control of your website.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-cog\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]We build intuitive, user-friendly options so you can quickly and easily build your site.[/flip_box][flip_box title_front=\"Free Updates With Value\" title_back=\"Its Like Getting A New Theme\" text_front=\"We issue updates that matter; rich with amazing new features and improvements.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-gift\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]Avada just keeps getting better and better, each update is like getting a brand new theme all for free.[/flip_box][/flip_boxes][separator style_type=\"single\" top_margin=\"22\" bottom_margin=\"70\" sep_color=\"rgba(000,000,000,.1)\" icon=\"fa-chevron-down\" width=\"\" class=\"\" id=\"\"][one_half last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][postslider layout=\"posts\" excerpt=\"35\" category=\"design\" limit=\"2\" lightbox=\"yes\" class=\"\" id=\"\"][/postslider][/one_half][one_half last=\"yes\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][fusion_text]\r\n<h2>What Else? We Have The Best Support Around</h2>\r\n[/fusion_text][separator style_type=\"single\" top_margin=\"5\" bottom_margin=\"25\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]Avada is [tooltip title=\"Everting You Need To Create!\"]<strong>loaded with useful, functional options</strong>[/tooltip] that allow users to quickly and easily create stunning websites. But that\'s not all, when you purchase a copy of Avada you will also get the [tooltip title=\"Support Forum, Docs &amp; Videos!\"]<strong>most amazing customer support around!</strong>[/tooltip][/fusion_text][separator style_type=\"none\" top_margin=\"15\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][checklist icon=\"fa-star\" iconcolor=\"dark\" circle=\"no\" circlecolor=\"\" size=\"small\" class=\"\" id=\"\"][li_item icon=\"\"]Fully responsive so your content will always look good on any screen size[/li_item][li_item icon=\"\"]Awesome sliders give you the opportunity to showcase your content[/li_item][li_item icon=\"\"]Advanced theme options panel to easily customize your website[/li_item][/checklist][separator style_type=\"single\" top_margin=\"10\" bottom_margin=\"30\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"default\" size=\"large\" type=\"\" shape=\"\" target=\"_blank\" title=\"\" gradient_colors=\"|\" gradient_hover_colors=\"|\" accent_color=\"\" accent_hover_color=\"\" bevel_color=\"\" border_width=\"1px\" shadow=\"\" icon=\"\" icon_position=\"left\" icon_divider=\"yes\" modal=\"\" animation_type=\"fade\" animation_direction=\"down\" animation_speed=\"1\" alignment=\"\" class=\"\" id=\"\"]Buy Avada Now![/button][/one_half][/fullwidth][fullwidth backgroundcolor=\"\" backgroundimage=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/forest3.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"65px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][tagline_box backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"title=\"&lt;span\"\"\"\" shadow=\"no\" shadowopacity=\"0.1\" border=\"1px\" bordercolor=\"rgba(255,255,255,.4)\" highlightposition=\"top\" content_alignment=\"left\" link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" linktarget=\"_blank\" modal=\"\" button_size=\"large\" button_shape=\"square\" button_type=\"flat\" buttoncolor=\"\" button=\"Purchase Now\" title=\"\" description=\"\" animation_type=\"fade\" animation_direction=\"up\" animation_speed=\"1\" class=\"\" id=\"\"][/tagline_box][separator style_type=\"none\" top_margin=\"-20\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth]", "UPGhome", "", "inherit", "open", "open", "", "10995-revision-v1", "", "", "2015-04-12 22:15:26", "2015-04-12 22:15:26", "", "10995", "http://birminghamupg.com/bhamupg/?p=11001", "0", "revision", "", "0");
INSERT INTO `bupg_posts` VALUES("11002", "1", "2015-04-12 22:18:07", "2015-04-12 22:18:07", "[fullwidth backgroundcolor=\"\" backgroundimage=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/downtown1-300x200.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"100px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][youtube id=\"HxeilZgGWBg\" width=\"1280\" height=\"720\" autoplay=\"yes\" api_params=\"&amp;rel=0\" class=\"\"][separator style_type=\"single\" top_margin=\"-10\" bottom_margin=\"70\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]\r\n<h1 style=\"text-align: center; font-size: 57px; line-height: 75px;\">Avada Is The #1 Selling WP Theme</h1>\r\n<p style=\"text-align: center; margin-top: -20px; font-size: 18px;\">With over [tooltip title=\"Join The Avada Community!\"]<strong>95,000+ Users and counting</strong>[/tooltip], Avada is the most complete and trusted wordpress theme on the market.</p>\r\n[/fusion_text][separator style_type=\"none\" top_margin=\"20\" bottom_margin=\"20\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img src=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/browsers.png\" alt=\"\" />[/imageframe][/fullwidth][fullwidth backgroundcolor=\"#fff\" backgroundimage=\"\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"1px\" bordercolor=\"#e5e4e4\" borderstyle=\"solid\" paddingtop=\"55px\" paddingbottom=\"45px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][flip_boxes columns=\"3\" class=\"\" id=\"\"][flip_box title_front=\"Fully Responsive\" title_back=\"Perfect For All Sizes\" text_front=\"Avada\'s responsive framework ensures your content looks great on all screen sizes.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-compress\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]No matter the size of your screen or device, your site will look fantastic.[/flip_box][flip_box title_front=\"Premium Sliders\" title_back=\"Make Your Content Stand Out\" text_front=\"Avada includes four premium sliders that make your content stand out!\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-rocket\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]Avada includes the Layer Slider, Revolution Slider, Fusion Slider and Elastic Slider.[/flip_box][flip_box title_front=\"Fusion Builder\" title_back=\"Build Something Beautiful\" text_front=\"Fusion Builder is an intuitive visual page builder that is a pleasure to use.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-trophy\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]Fusion Builder includes dozens of shortcodes loaded with options, giving you perfect freedom.[/flip_box][/flip_boxes][flip_boxes columns=\"3\" class=\"\" id=\"\"][flip_box title_front=\"Dedicated Support\" title_back=\"You Can Count On Us\" text_front=\"We care about your site as much as you do, you can count on us for theme support.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-thumbs-o-up\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]We thrive on our users, and want to see everyone happy when using Avada.[/flip_box][flip_box title_front=\"Powerful Options\" title_back=\"Unleash The Power of Avada\" text_front=\"Avada\'s theme options and page options allow you to take control of your website.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-cog\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]We build intuitive, user-friendly options so you can quickly and easily build your site.[/flip_box][flip_box title_front=\"Free Updates With Value\" title_back=\"Its Like Getting A New Theme\" text_front=\"We issue updates that matter; rich with amazing new features and improvements.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-gift\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]Avada just keeps getting better and better, each update is like getting a brand new theme all for free.[/flip_box][/flip_boxes][separator style_type=\"single\" top_margin=\"22\" bottom_margin=\"70\" sep_color=\"rgba(000,000,000,.1)\" icon=\"fa-chevron-down\" width=\"\" class=\"\" id=\"\"][one_half last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][postslider layout=\"posts\" excerpt=\"35\" category=\"design\" limit=\"2\" lightbox=\"yes\" class=\"\" id=\"\"][/postslider][/one_half][one_half last=\"yes\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][fusion_text]\r\n<h2>What Else? We Have The Best Support Around</h2>\r\n[/fusion_text][separator style_type=\"single\" top_margin=\"5\" bottom_margin=\"25\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]Avada is [tooltip title=\"Everting You Need To Create!\"]<strong>loaded with useful, functional options</strong>[/tooltip] that allow users to quickly and easily create stunning websites. But that\'s not all, when you purchase a copy of Avada you will also get the [tooltip title=\"Support Forum, Docs &amp; Videos!\"]<strong>most amazing customer support around!</strong>[/tooltip][/fusion_text][separator style_type=\"none\" top_margin=\"15\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][checklist icon=\"fa-star\" iconcolor=\"dark\" circle=\"no\" circlecolor=\"\" size=\"small\" class=\"\" id=\"\"][li_item icon=\"\"]Fully responsive so your content will always look good on any screen size[/li_item][li_item icon=\"\"]Awesome sliders give you the opportunity to showcase your content[/li_item][li_item icon=\"\"]Advanced theme options panel to easily customize your website[/li_item][/checklist][separator style_type=\"single\" top_margin=\"10\" bottom_margin=\"30\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"default\" size=\"large\" type=\"\" shape=\"\" target=\"_blank\" title=\"\" gradient_colors=\"|\" gradient_hover_colors=\"|\" accent_color=\"\" accent_hover_color=\"\" bevel_color=\"\" border_width=\"1px\" shadow=\"\" icon=\"\" icon_position=\"left\" icon_divider=\"yes\" modal=\"\" animation_type=\"fade\" animation_direction=\"down\" animation_speed=\"1\" alignment=\"\" class=\"\" id=\"\"]Buy Avada Now![/button][/one_half][/fullwidth][fullwidth backgroundcolor=\"\" backgroundimage=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/forest3.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"65px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][tagline_box backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"title=\"&lt;span\"\"\"\"\" shadow=\"no\" shadowopacity=\"0.1\" border=\"1px\" bordercolor=\"rgba(255,255,255,.4)\" highlightposition=\"top\" content_alignment=\"left\" link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" linktarget=\"_blank\" modal=\"\" button_size=\"large\" button_shape=\"square\" button_type=\"flat\" buttoncolor=\"\" button=\"Purchase Now\" title=\"\" description=\"\" animation_type=\"fade\" animation_direction=\"up\" animation_speed=\"1\" class=\"\" id=\"\"][/tagline_box][separator style_type=\"none\" top_margin=\"-20\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth]", "UPGhome", "", "inherit", "open", "open", "", "10995-revision-v1", "", "", "2015-04-12 22:18:07", "2015-04-12 22:18:07", "", "10995", "http://birminghamupg.com/bhamupg/?p=11002", "0", "revision", "", "0");
INSERT INTO `bupg_posts` VALUES("11003", "1", "2015-04-12 22:18:53", "2015-04-12 22:18:53", "[fullwidth backgroundcolor=\"\" backgroundimage=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/downtown1-300x200.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"100px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"single\" top_margin=\"-10\" bottom_margin=\"70\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][youtube id=\"HxeilZgGWBg\" width=\"1280\" height=\"720\" autoplay=\"yes\" api_params=\"&amp;rel=0\" class=\"\"][fusion_text]\r\n<h1 style=\"text-align: center; font-size: 57px; line-height: 75px;\">Avada Is The #1 Selling WP Theme</h1>\r\n<p style=\"text-align: center; margin-top: -20px; font-size: 18px;\">With over [tooltip title=\"Join The Avada Community!\"]<strong>95,000+ Users and counting</strong>[/tooltip], Avada is the most complete and trusted wordpress theme on the market.</p>\r\n[/fusion_text][separator style_type=\"none\" top_margin=\"20\" bottom_margin=\"20\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img src=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/browsers.png\" alt=\"\" />[/imageframe][/fullwidth][fullwidth backgroundcolor=\"#fff\" backgroundimage=\"\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"1px\" bordercolor=\"#e5e4e4\" borderstyle=\"solid\" paddingtop=\"55px\" paddingbottom=\"45px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][flip_boxes columns=\"3\" class=\"\" id=\"\"][flip_box title_front=\"Fully Responsive\" title_back=\"Perfect For All Sizes\" text_front=\"Avada\'s responsive framework ensures your content looks great on all screen sizes.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-compress\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]No matter the size of your screen or device, your site will look fantastic.[/flip_box][flip_box title_front=\"Premium Sliders\" title_back=\"Make Your Content Stand Out\" text_front=\"Avada includes four premium sliders that make your content stand out!\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-rocket\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]Avada includes the Layer Slider, Revolution Slider, Fusion Slider and Elastic Slider.[/flip_box][flip_box title_front=\"Fusion Builder\" title_back=\"Build Something Beautiful\" text_front=\"Fusion Builder is an intuitive visual page builder that is a pleasure to use.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-trophy\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]Fusion Builder includes dozens of shortcodes loaded with options, giving you perfect freedom.[/flip_box][/flip_boxes][flip_boxes columns=\"3\" class=\"\" id=\"\"][flip_box title_front=\"Dedicated Support\" title_back=\"You Can Count On Us\" text_front=\"We care about your site as much as you do, you can count on us for theme support.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-thumbs-o-up\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]We thrive on our users, and want to see everyone happy when using Avada.[/flip_box][flip_box title_front=\"Powerful Options\" title_back=\"Unleash The Power of Avada\" text_front=\"Avada\'s theme options and page options allow you to take control of your website.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-cog\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]We build intuitive, user-friendly options so you can quickly and easily build your site.[/flip_box][flip_box title_front=\"Free Updates With Value\" title_back=\"Its Like Getting A New Theme\" text_front=\"We issue updates that matter; rich with amazing new features and improvements.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-gift\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]Avada just keeps getting better and better, each update is like getting a brand new theme all for free.[/flip_box][/flip_boxes][separator style_type=\"single\" top_margin=\"22\" bottom_margin=\"70\" sep_color=\"rgba(000,000,000,.1)\" icon=\"fa-chevron-down\" width=\"\" class=\"\" id=\"\"][one_half last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][postslider layout=\"posts\" excerpt=\"35\" category=\"design\" limit=\"2\" lightbox=\"yes\" class=\"\" id=\"\"][/postslider][/one_half][one_half last=\"yes\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][fusion_text]\r\n<h2>What Else? We Have The Best Support Around</h2>\r\n[/fusion_text][separator style_type=\"single\" top_margin=\"5\" bottom_margin=\"25\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]Avada is [tooltip title=\"Everting You Need To Create!\"]<strong>loaded with useful, functional options</strong>[/tooltip] that allow users to quickly and easily create stunning websites. But that\'s not all, when you purchase a copy of Avada you will also get the [tooltip title=\"Support Forum, Docs &amp; Videos!\"]<strong>most amazing customer support around!</strong>[/tooltip][/fusion_text][separator style_type=\"none\" top_margin=\"15\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][checklist icon=\"fa-star\" iconcolor=\"dark\" circle=\"no\" circlecolor=\"\" size=\"small\" class=\"\" id=\"\"][li_item icon=\"\"]Fully responsive so your content will always look good on any screen size[/li_item][li_item icon=\"\"]Awesome sliders give you the opportunity to showcase your content[/li_item][li_item icon=\"\"]Advanced theme options panel to easily customize your website[/li_item][/checklist][separator style_type=\"single\" top_margin=\"10\" bottom_margin=\"30\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"default\" size=\"large\" type=\"\" shape=\"\" target=\"_blank\" title=\"\" gradient_colors=\"|\" gradient_hover_colors=\"|\" accent_color=\"\" accent_hover_color=\"\" bevel_color=\"\" border_width=\"1px\" shadow=\"\" icon=\"\" icon_position=\"left\" icon_divider=\"yes\" modal=\"\" animation_type=\"fade\" animation_direction=\"down\" animation_speed=\"1\" alignment=\"\" class=\"\" id=\"\"]Buy Avada Now![/button][/one_half][/fullwidth][fullwidth backgroundcolor=\"\" backgroundimage=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/forest3.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"65px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][tagline_box backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"title=\"&lt;span\"\"\"\"\" shadow=\"no\" shadowopacity=\"0.1\" border=\"1px\" bordercolor=\"rgba(255,255,255,.4)\" highlightposition=\"top\" content_alignment=\"left\" link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" linktarget=\"_blank\" modal=\"\" button_size=\"large\" button_shape=\"square\" button_type=\"flat\" buttoncolor=\"\" button=\"Purchase Now\" title=\"\" description=\"\" animation_type=\"fade\" animation_direction=\"up\" animation_speed=\"1\" class=\"\" id=\"\"][/tagline_box][separator style_type=\"none\" top_margin=\"-20\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth]", "UPGhome", "", "inherit", "open", "open", "", "10995-revision-v1", "", "", "2015-04-12 22:18:53", "2015-04-12 22:18:53", "", "10995", "http://birminghamupg.com/bhamupg/?p=11003", "0", "revision", "", "0");
INSERT INTO `bupg_posts` VALUES("11004", "1", "2015-04-12 22:19:46", "2015-04-12 22:19:46", "[fullwidth backgroundcolor=\"\" backgroundimage=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/downtown1-300x200.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"100px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"single\" top_margin=\"-10\" bottom_margin=\"70\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][youtube id=\"HxeilZgGWBg\" width=\"1280\" height=\"720\" autoplay=\"yes\" api_params=\"&amp;rel=0\" class=\"\"][fusion_text]\r\n<h1 style=\"text-align: center; font-size: 57px; line-height: 75px;\">Avada Is The #1 Selling WP Theme</h1>\r\n<p style=\"text-align: center; margin-top: -20px; font-size: 18px;\">With over [tooltip title=\"Join The Avada Community!\"]<strong>95,000+ Users and counting</strong>[/tooltip], Avada is the most complete and trusted wordpress theme on the market.</p>\r\n[/fusion_text][separator style_type=\"none\" top_margin=\"20\" bottom_margin=\"20\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img src=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/browsers.png\" alt=\"\" />[/imageframe][/fullwidth][fullwidth backgroundcolor=\"#fff\" backgroundimage=\"\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"1px\" bordercolor=\"#e5e4e4\" borderstyle=\"solid\" paddingtop=\"55px\" paddingbottom=\"45px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][flip_boxes columns=\"3\" class=\"\" id=\"\"][flip_box title_front=\"Fully Responsive\" title_back=\"Perfect For All Sizes\" text_front=\"Avada\'s responsive framework ensures your content looks great on all screen sizes.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-compress\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]No matter the size of your screen or device, your site will look fantastic.[/flip_box][flip_box title_front=\"Premium Sliders\" title_back=\"Make Your Content Stand Out\" text_front=\"Avada includes four premium sliders that make your content stand out!\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-rocket\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]Avada includes the Layer Slider, Revolution Slider, Fusion Slider and Elastic Slider.[/flip_box][flip_box title_front=\"Fusion Builder\" title_back=\"Build Something Beautiful\" text_front=\"Fusion Builder is an intuitive visual page builder that is a pleasure to use.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-trophy\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]Fusion Builder includes dozens of shortcodes loaded with options, giving you perfect freedom.[/flip_box][/flip_boxes][flip_boxes columns=\"3\" class=\"\" id=\"\"][flip_box title_front=\"Dedicated Support\" title_back=\"You Can Count On Us\" text_front=\"We care about your site as much as you do, you can count on us for theme support.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-thumbs-o-up\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]We thrive on our users, and want to see everyone happy when using Avada.[/flip_box][flip_box title_front=\"Powerful Options\" title_back=\"Unleash The Power of Avada\" text_front=\"Avada\'s theme options and page options allow you to take control of your website.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-cog\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]We build intuitive, user-friendly options so you can quickly and easily build your site.[/flip_box][flip_box title_front=\"Free Updates With Value\" title_back=\"Its Like Getting A New Theme\" text_front=\"We issue updates that matter; rich with amazing new features and improvements.\" background_color_front=\"\" title_front_color=\"\" text_front_color=\"\" background_color_back=\"\" title_back_color=\"\" text_back_color=\"\" border_size=\"1px\" border_color=\"\" border_radius=\"4px\" icon=\"fa-gift\" icon_color=\"\" circle=\"yes\" circle_color=\"\" circle_border_color=\"\" icon_flip=\"\" icon_rotate=\"\" icon_spin=\"no\" image=\"\" image_width=\"35\" image_height=\"35\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\"]Avada just keeps getting better and better, each update is like getting a brand new theme all for free.[/flip_box][/flip_boxes][separator style_type=\"single\" top_margin=\"22\" bottom_margin=\"70\" sep_color=\"rgba(000,000,000,.1)\" icon=\"fa-chevron-down\" width=\"\" class=\"\" id=\"\"][one_half last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][postslider layout=\"posts\" excerpt=\"35\" category=\"design\" limit=\"2\" lightbox=\"yes\" class=\"\" id=\"\"][/postslider][/one_half][one_half last=\"yes\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][fusion_text]\r\n<h2>What Else? We Have The Best Support Around</h2>\r\n[/fusion_text][separator style_type=\"single\" top_margin=\"5\" bottom_margin=\"25\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]Avada is [tooltip title=\"Everting You Need To Create!\"]<strong>loaded with useful, functional options</strong>[/tooltip] that allow users to quickly and easily create stunning websites. But that\'s not all, when you purchase a copy of Avada you will also get the [tooltip title=\"Support Forum, Docs &amp; Videos!\"]<strong>most amazing customer support around!</strong>[/tooltip][/fusion_text][separator style_type=\"none\" top_margin=\"15\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][checklist icon=\"fa-star\" iconcolor=\"dark\" circle=\"no\" circlecolor=\"\" size=\"small\" class=\"\" id=\"\"][li_item icon=\"\"]Fully responsive so your content will always look good on any screen size[/li_item][li_item icon=\"\"]Awesome sliders give you the opportunity to showcase your content[/li_item][li_item icon=\"\"]Advanced theme options panel to easily customize your website[/li_item][/checklist][separator style_type=\"single\" top_margin=\"10\" bottom_margin=\"30\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"default\" size=\"large\" type=\"\" shape=\"\" target=\"_blank\" title=\"\" gradient_colors=\"|\" gradient_hover_colors=\"|\" accent_color=\"\" accent_hover_color=\"\" bevel_color=\"\" border_width=\"1px\" shadow=\"\" icon=\"\" icon_position=\"left\" icon_divider=\"yes\" modal=\"\" animation_type=\"fade\" animation_direction=\"down\" animation_speed=\"1\" alignment=\"\" class=\"\" id=\"\"]Buy Avada Now![/button][/one_half][/fullwidth][fullwidth backgroundcolor=\"\" backgroundimage=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/forest3.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"65px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][tagline_box backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"title=\"&lt;span\"\"\"\"\"\" shadow=\"no\" shadowopacity=\"0.1\" border=\"1px\" bordercolor=\"rgba(255,255,255,.4)\" highlightposition=\"top\" content_alignment=\"left\" link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" linktarget=\"_blank\" modal=\"\" button_size=\"large\" button_shape=\"square\" button_type=\"flat\" buttoncolor=\"\" button=\"Purchase Now\" title=\"\" description=\"\" animation_type=\"fade\" animation_direction=\"up\" animation_speed=\"1\" class=\"\" id=\"\"][/tagline_box][separator style_type=\"none\" top_margin=\"-20\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth]", "UPGhome", "", "inherit", "open", "open", "", "10995-revision-v1", "", "", "2015-04-12 22:19:46", "2015-04-12 22:19:46", "", "10995", "http://birminghamupg.com/bhamupg/?p=11004", "0", "revision", "", "0");
INSERT INTO `bupg_posts` VALUES("11005", "1", "2015-04-12 22:32:56", "2015-04-12 22:32:56", "[fullwidth backgroundcolor=\"\" backgroundimage=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/downtown1-300x200.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"100px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"single\" top_margin=\"-10\" bottom_margin=\"70\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][youtube id=\"HxeilZgGWBg\" width=\"1280\" height=\"720\" autoplay=\"yes\" api_params=\"&amp;rel=0\" class=\"\"][fusion_text]\r\n<h1 style=\"text-align: center; font-size: 57px; line-height: 75px;\">Avada Is The #1 Selling WP Theme</h1>\r\n<p style=\"text-align: center; margin-top: -20px; font-size: 18px;\">With over [tooltip title=\"Join The Avada Community!\"]<strong>95,000+ Users and counting</strong>[/tooltip], Avada is the most complete and trusted wordpress theme on the market.</p>\r\n[/fusion_text][separator style_type=\"none\" top_margin=\"20\" bottom_margin=\"20\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth][fullwidth backgroundcolor=\"#fff\" backgroundimage=\"\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"1px\" bordercolor=\"#e5e4e4\" borderstyle=\"solid\" paddingtop=\"55px\" paddingbottom=\"45px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"single\" top_margin=\"22\" bottom_margin=\"70\" sep_color=\"rgba(000,000,000,.1)\" icon=\"fa-chevron-down\" width=\"\" class=\"\" id=\"\"][one_half last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][postslider layout=\"posts\" excerpt=\"35\" category=\"design\" limit=\"2\" lightbox=\"yes\" class=\"\" id=\"\"][/postslider][/one_half][one_half last=\"yes\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][fusion_text]\r\n<h2>What Else? We Have The Best Support Around</h2>\r\n[/fusion_text][separator style_type=\"single\" top_margin=\"5\" bottom_margin=\"25\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]Avada is [tooltip title=\"Everting You Need To Create!\"]<strong>loaded with useful, functional options</strong>[/tooltip] that allow users to quickly and easily create stunning websites. But that\'s not all, when you purchase a copy of Avada you will also get the [tooltip title=\"Support Forum, Docs &amp; Videos!\"]<strong>most amazing customer support around!</strong>[/tooltip][/fusion_text][separator style_type=\"none\" top_margin=\"15\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][checklist icon=\"fa-star\" iconcolor=\"dark\" circle=\"no\" circlecolor=\"\" size=\"small\" class=\"\" id=\"\"][li_item icon=\"\"]Fully responsive so your content will always look good on any screen size[/li_item][li_item icon=\"\"]Awesome sliders give you the opportunity to showcase your content[/li_item][li_item icon=\"\"]Advanced theme options panel to easily customize your website[/li_item][/checklist][separator style_type=\"single\" top_margin=\"10\" bottom_margin=\"30\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"default\" size=\"large\" type=\"\" shape=\"\" target=\"_blank\" title=\"\" gradient_colors=\"|\" gradient_hover_colors=\"|\" accent_color=\"\" accent_hover_color=\"\" bevel_color=\"\" border_width=\"1px\" shadow=\"\" icon=\"\" icon_position=\"left\" icon_divider=\"yes\" modal=\"\" animation_type=\"fade\" animation_direction=\"down\" animation_speed=\"1\" alignment=\"\" class=\"\" id=\"\"]Buy Avada Now![/button][/one_half][/fullwidth][fullwidth backgroundcolor=\"\" backgroundimage=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/forest3.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"65px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][tagline_box backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"title=\"&lt;span\"\"\"\"\"\"\" shadow=\"no\" shadowopacity=\"0.1\" border=\"1px\" bordercolor=\"rgba(255,255,255,.4)\" highlightposition=\"top\" content_alignment=\"left\" link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" linktarget=\"_blank\" modal=\"\" button_size=\"large\" button_shape=\"square\" button_type=\"flat\" buttoncolor=\"\" button=\"Purchase Now\" title=\"\" description=\"\" animation_type=\"fade\" animation_direction=\"up\" animation_speed=\"1\" class=\"\" id=\"\"][/tagline_box][separator style_type=\"none\" top_margin=\"-20\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth]", "UPGhome", "", "inherit", "open", "open", "", "10995-revision-v1", "", "", "2015-04-12 22:32:56", "2015-04-12 22:32:56", "", "10995", "http://birminghamupg.com/bhamupg/?p=11005", "0", "revision", "", "0");
INSERT INTO `bupg_posts` VALUES("11006", "1", "2015-04-12 22:46:53", "2015-04-12 22:46:53", "[fullwidth backgroundcolor=\"\" backgroundimage=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/downtown1-300x200.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"100px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"single\" top_margin=\"-10\" bottom_margin=\"70\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][youtube id=\"HxeilZgGWBg\" width=\"1280\" height=\"720\" autoplay=\"yes\" api_params=\"&amp;rel=0\" class=\"\"][fusion_text]\r\n<h1 style=\"text-align: center; font-size: 57px; line-height: 75px;\">Birmingham Unreached People Groups</h1>\r\n<p style=\"text-align: center; margin-top: -20px; font-size: 18px;\">Find, Befriend, and Engage the people groups that God has moved to the Magic City.</p>\r\n[/fusion_text][separator style_type=\"none\" top_margin=\"20\" bottom_margin=\"20\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth][fullwidth backgroundcolor=\"#fff\" backgroundimage=\"\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"1px\" bordercolor=\"#e5e4e4\" borderstyle=\"solid\" paddingtop=\"55px\" paddingbottom=\"45px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"single\" top_margin=\"22\" bottom_margin=\"70\" sep_color=\"rgba(000,000,000,.1)\" icon=\"fa-chevron-down\" width=\"\" class=\"\" id=\"\"][one_half last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][postslider layout=\"posts\" excerpt=\"35\" category=\"design\" limit=\"2\" lightbox=\"yes\" class=\"\" id=\"\"][/postslider][/one_half][one_half last=\"yes\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][fusion_text]\r\n<h2>What Else? We Have The Best Support Around</h2>\r\n[/fusion_text][separator style_type=\"single\" top_margin=\"5\" bottom_margin=\"25\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]Avada is [tooltip title=\"Everting You Need To Create!\"]<strong>loaded with useful, functional options</strong>[/tooltip] that allow users to quickly and easily create stunning websites. But that\'s not all, when you purchase a copy of Avada you will also get the [tooltip title=\"Support Forum, Docs &amp; Videos!\"]<strong>most amazing customer support around!</strong>[/tooltip][/fusion_text][separator style_type=\"none\" top_margin=\"15\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][checklist icon=\"fa-star\" iconcolor=\"dark\" circle=\"no\" circlecolor=\"\" size=\"small\" class=\"\" id=\"\"][li_item icon=\"\"]Fully responsive so your content will always look good on any screen size[/li_item][li_item icon=\"\"]Awesome sliders give you the opportunity to showcase your content[/li_item][li_item icon=\"\"]Advanced theme options panel to easily customize your website[/li_item][/checklist][separator style_type=\"single\" top_margin=\"10\" bottom_margin=\"30\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"default\" size=\"large\" type=\"\" shape=\"\" target=\"_blank\" title=\"\" gradient_colors=\"|\" gradient_hover_colors=\"|\" accent_color=\"\" accent_hover_color=\"\" bevel_color=\"\" border_width=\"1px\" shadow=\"\" icon=\"\" icon_position=\"left\" icon_divider=\"yes\" modal=\"\" animation_type=\"fade\" animation_direction=\"down\" animation_speed=\"1\" alignment=\"\" class=\"\" id=\"\"]Buy Avada Now![/button][/one_half][/fullwidth][fullwidth backgroundcolor=\"\" backgroundimage=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/forest3.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"65px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][tagline_box backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"title=\"&lt;span\"\"\"\"\"\"\"\" shadow=\"no\" shadowopacity=\"0.1\" border=\"1px\" bordercolor=\"rgba(255,255,255,.4)\" highlightposition=\"top\" content_alignment=\"left\" link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" linktarget=\"_blank\" modal=\"\" button_size=\"large\" button_shape=\"square\" button_type=\"flat\" buttoncolor=\"\" button=\"Purchase Now\" title=\"\" description=\"\" animation_type=\"fade\" animation_direction=\"up\" animation_speed=\"1\" class=\"\" id=\"\"][/tagline_box][separator style_type=\"none\" top_margin=\"-20\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth]", "UPGhome", "", "inherit", "open", "open", "", "10995-revision-v1", "", "", "2015-04-12 22:46:53", "2015-04-12 22:46:53", "", "10995", "http://birminghamupg.com/bhamupg/?p=11006", "0", "revision", "", "0");
INSERT INTO `bupg_posts` VALUES("11007", "1", "2015-04-12 23:02:35", "2015-04-12 23:02:35", "[fullwidth backgroundcolor=\"\" backgroundimage=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/downtown1-300x200.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"100px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"single\" top_margin=\"-10\" bottom_margin=\"70\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][youtube id=\"HxeilZgGWBg\" width=\"1280\" height=\"720\" autoplay=\"yes\" api_params=\"&amp;rel=0\" class=\"\"][fusion_text]\r\n<h1 style=\"text-align: center; font-size: 57px; line-height: 75px;\">Birmingham Unreached People Groups</h1>\r\n<p style=\"text-align: center; margin-top: -20px; font-size: 18px;\">Find, Befriend, and Engage the people groups that God has moved to the Magic City.</p>\r\n[/fusion_text][separator style_type=\"none\" top_margin=\"20\" bottom_margin=\"20\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth][fullwidth backgroundcolor=\"#fff\" backgroundimage=\"\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"1px\" bordercolor=\"#e5e4e4\" borderstyle=\"solid\" paddingtop=\"55px\" paddingbottom=\"45px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"single\" top_margin=\"22\" bottom_margin=\"70\" sep_color=\"rgba(000,000,000,.1)\" icon=\"fa-chevron-down\" width=\"\" class=\"\" id=\"\"][one_half last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][postslider layout=\"posts\" excerpt=\"35\" category=\"design\" limit=\"2\" lightbox=\"yes\" class=\"\" id=\"\"][/postslider][/one_half][one_half last=\"yes\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][fusion_text]\r\n<h2>What Else? We Have The Best Support Around</h2>\r\n[/fusion_text][separator style_type=\"single\" top_margin=\"5\" bottom_margin=\"25\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]Avada is [tooltip title=\"Everting You Need To Create!\"]<strong>loaded with useful, functional options</strong>[/tooltip] that allow users to quickly and easily create stunning websites. But that\'s not all, when you purchase a copy of Avada you will also get the [tooltip title=\"Support Forum, Docs &amp; Videos!\"]<strong>most amazing customer support around!</strong>[/tooltip][/fusion_text][separator style_type=\"none\" top_margin=\"15\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][checklist icon=\"fa-star\" iconcolor=\"dark\" circle=\"no\" circlecolor=\"\" size=\"small\" class=\"\" id=\"\"][li_item icon=\"\"]Fully responsive so your content will always look good on any screen size[/li_item][li_item icon=\"\"]Awesome sliders give you the opportunity to showcase your content[/li_item][li_item icon=\"\"]Advanced theme options panel to easily customize your website[/li_item][/checklist][separator style_type=\"single\" top_margin=\"10\" bottom_margin=\"30\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"default\" size=\"large\" type=\"\" shape=\"\" target=\"_blank\" title=\"\" gradient_colors=\"|\" gradient_hover_colors=\"|\" accent_color=\"\" accent_hover_color=\"\" bevel_color=\"\" border_width=\"1px\" shadow=\"\" icon=\"\" icon_position=\"left\" icon_divider=\"yes\" modal=\"\" animation_type=\"fade\" animation_direction=\"down\" animation_speed=\"1\" alignment=\"\" class=\"\" id=\"\"]Buy Avada Now![/button][/one_half][/fullwidth][fullwidth backgroundcolor=\"\" backgroundimage=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/forest3.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"65px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][tagline_box backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"title=\"&lt;span\"\"\"\"\"\"\"\"\" shadow=\"no\" shadowopacity=\"0.1\" border=\"1px\" bordercolor=\"rgba(255,255,255,.4)\" highlightposition=\"top\" content_alignment=\"left\" link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" linktarget=\"_blank\" modal=\"\" button_size=\"large\" button_shape=\"square\" button_type=\"flat\" buttoncolor=\"\" button=\"Purchase Now\" title=\"\" description=\"\" animation_type=\"fade\" animation_direction=\"up\" animation_speed=\"1\" class=\"\" id=\"\"][/tagline_box][separator style_type=\"none\" top_margin=\"-20\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth]", "UPGhome", "", "inherit", "open", "open", "", "10995-revision-v1", "", "", "2015-04-12 23:02:35", "2015-04-12 23:02:35", "", "10995", "http://birminghamupg.com/bhamupg/?p=11007", "0", "revision", "", "0");
INSERT INTO `bupg_posts` VALUES("11008", "1", "2015-04-12 23:03:36", "2015-04-12 23:03:36", "[fullwidth backgroundcolor=\"\" backgroundimage=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/downtown1-300x200.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"100px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"single\" top_margin=\"-10\" bottom_margin=\"70\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][youtube id=\"HxeilZgGWBg\" width=\"1280\" height=\"720\" autoplay=\"yes\" api_params=\"&amp;rel=0\" class=\"\"][fusion_text]\r\n<h1 style=\"text-align: center; font-size: 57px; line-height: 75px;\">Birmingham Unreached People Groups</h1>\r\n<p style=\"text-align: center; margin-top: -20px; font-size: 18px;\">Find, Befriend, and Engage the people groups that God has moved to the Magic City.</p>\r\n[/fusion_text][separator style_type=\"none\" top_margin=\"20\" bottom_margin=\"20\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth][fullwidth backgroundcolor=\"#fff\" backgroundimage=\"\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"1px\" bordercolor=\"#e5e4e4\" borderstyle=\"solid\" paddingtop=\"55px\" paddingbottom=\"45px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"single\" top_margin=\"22\" bottom_margin=\"70\" sep_color=\"rgba(000,000,000,.1)\" icon=\"fa-chevron-down\" width=\"\" class=\"\" id=\"\"][one_half last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][postslider layout=\"posts\" excerpt=\"35\" category=\"design\" limit=\"2\" lightbox=\"yes\" class=\"\" id=\"\"][/postslider][/one_half][one_half last=\"yes\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][fusion_text]\r\n<h2>What Else? We Have The Best Support Around</h2>\r\n[/fusion_text][separator style_type=\"single\" top_margin=\"5\" bottom_margin=\"25\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]Avada is [tooltip title=\"Everting You Need To Create!\"]<strong>loaded with useful, functional options</strong>[/tooltip] that allow users to quickly and easily create stunning websites. But that\'s not all, when you purchase a copy of Avada you will also get the [tooltip title=\"Support Forum, Docs &amp; Videos!\"]<strong>most amazing customer support around!</strong>[/tooltip][/fusion_text][separator style_type=\"none\" top_margin=\"15\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][checklist icon=\"fa-star\" iconcolor=\"dark\" circle=\"no\" circlecolor=\"\" size=\"small\" class=\"\" id=\"\"][li_item icon=\"\"]Fully responsive so your content will always look good on any screen size[/li_item][li_item icon=\"\"]Awesome sliders give you the opportunity to showcase your content[/li_item][li_item icon=\"\"]Advanced theme options panel to easily customize your website[/li_item][/checklist][separator style_type=\"single\" top_margin=\"10\" bottom_margin=\"30\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"default\" size=\"large\" type=\"\" shape=\"\" target=\"_blank\" title=\"\" gradient_colors=\"|\" gradient_hover_colors=\"|\" accent_color=\"\" accent_hover_color=\"\" bevel_color=\"\" border_width=\"1px\" shadow=\"\" icon=\"\" icon_position=\"left\" icon_divider=\"yes\" modal=\"\" animation_type=\"fade\" animation_direction=\"down\" animation_speed=\"1\" alignment=\"\" class=\"\" id=\"\"]Buy Avada Now![/button][/one_half][/fullwidth][fullwidth backgroundcolor=\"\" backgroundimage=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/forest3.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"65px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][tagline_box backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"title=\"&lt;span\"\"\"\"\"\"\"\"\"\" shadow=\"no\" shadowopacity=\"0.1\" border=\"1px\" bordercolor=\"rgba(255,255,255,.4)\" highlightposition=\"top\" content_alignment=\"left\" link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" linktarget=\"_blank\" modal=\"\" button_size=\"large\" button_shape=\"square\" button_type=\"flat\" buttoncolor=\"\" button=\"Purchase Now\" title=\"\" description=\"\" animation_type=\"fade\" animation_direction=\"up\" animation_speed=\"1\" class=\"\" id=\"\"][/tagline_box][separator style_type=\"none\" top_margin=\"-20\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth]", "UPGhome", "", "inherit", "open", "open", "", "10995-revision-v1", "", "", "2015-04-12 23:03:36", "2015-04-12 23:03:36", "", "10995", "http://birminghamupg.com/bhamupg/?p=11008", "0", "revision", "", "0");
INSERT INTO `bupg_posts` VALUES("11009", "1", "2015-04-12 23:04:53", "2015-04-12 23:04:53", "[fullwidth backgroundcolor=\"\" backgroundimage=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/downtown1-300x200.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"100px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"single\" top_margin=\"-10\" bottom_margin=\"70\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][youtube id=\"HxeilZgGWBg\" width=\"1280\" height=\"720\" autoplay=\"yes\" api_params=\"&amp;rel=0\" class=\"\"][fusion_text]\r\n<h1 style=\"text-align: center; font-size: 57px; line-height: 75px;\">Birmingham Unreached People Groups</h1>\r\n<p style=\"text-align: center; margin-top: -20px; font-size: 18px;\">Find, Befriend, and Engage the people groups that God has moved to the Magic City.</p>\r\n[/fusion_text][separator style_type=\"none\" top_margin=\"20\" bottom_margin=\"20\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth][fullwidth backgroundcolor=\"#fff\" backgroundimage=\"\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"1px\" bordercolor=\"#e5e4e4\" borderstyle=\"solid\" paddingtop=\"55px\" paddingbottom=\"45px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"single\" top_margin=\"22\" bottom_margin=\"70\" sep_color=\"rgba(000,000,000,.1)\" icon=\"fa-chevron-down\" width=\"\" class=\"\" id=\"\"][one_half last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][postslider layout=\"posts\" excerpt=\"35\" category=\"design\" limit=\"2\" lightbox=\"yes\" class=\"\" id=\"\"][/postslider][/one_half][one_half last=\"yes\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][fusion_text]\r\n<h2>What Else? We Have The Best Support Around</h2>\r\n[/fusion_text][separator style_type=\"single\" top_margin=\"5\" bottom_margin=\"25\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]Avada is [tooltip title=\"Everting You Need To Create!\"]<strong>loaded with useful, functional options</strong>[/tooltip] that allow users to quickly and easily create stunning websites. But that\'s not all, when you purchase a copy of Avada you will also get the [tooltip title=\"Support Forum, Docs &amp; Videos!\"]<strong>most amazing customer support around!</strong>[/tooltip][/fusion_text][separator style_type=\"none\" top_margin=\"15\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][checklist icon=\"fa-star\" iconcolor=\"dark\" circle=\"no\" circlecolor=\"\" size=\"small\" class=\"\" id=\"\"][li_item icon=\"\"]Fully responsive so your content will always look good on any screen size[/li_item][li_item icon=\"\"]Awesome sliders give you the opportunity to showcase your content[/li_item][li_item icon=\"\"]Advanced theme options panel to easily customize your website[/li_item][/checklist][separator style_type=\"single\" top_margin=\"10\" bottom_margin=\"30\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"default\" size=\"large\" type=\"\" shape=\"\" target=\"_blank\" title=\"\" gradient_colors=\"|\" gradient_hover_colors=\"|\" accent_color=\"\" accent_hover_color=\"\" bevel_color=\"\" border_width=\"1px\" shadow=\"\" icon=\"\" icon_position=\"left\" icon_divider=\"yes\" modal=\"\" animation_type=\"fade\" animation_direction=\"down\" animation_speed=\"1\" alignment=\"\" class=\"\" id=\"\"]Buy Avada Now![/button][/one_half][/fullwidth][fullwidth backgroundcolor=\"\" backgroundimage=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/forest3.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"65px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][tagline_box backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"title=\"&lt;span\"\"\"\"\"\"\"\"\"\"\" shadow=\"no\" shadowopacity=\"0.1\" border=\"1px\" bordercolor=\"rgba(255,255,255,.4)\" highlightposition=\"top\" content_alignment=\"left\" link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" linktarget=\"_blank\" modal=\"\" button_size=\"large\" button_shape=\"square\" button_type=\"flat\" buttoncolor=\"\" button=\"Purchase Now\" title=\"\" description=\"\" animation_type=\"fade\" animation_direction=\"up\" animation_speed=\"1\" class=\"\" id=\"\"][/tagline_box][separator style_type=\"none\" top_margin=\"-20\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth]", "UPGhome", "", "inherit", "open", "open", "", "10995-revision-v1", "", "", "2015-04-12 23:04:53", "2015-04-12 23:04:53", "", "10995", "http://birminghamupg.com/bhamupg/?p=11009", "0", "revision", "", "0");
INSERT INTO `bupg_posts` VALUES("11010", "1", "2015-04-12 23:17:12", "2015-04-12 23:17:12", "[fullwidth backgroundcolor=\"\" backgroundimage=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/downtown1-300x200.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"100px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"single\" top_margin=\"-10\" bottom_margin=\"70\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][youtube id=\"HxeilZgGWBg\" width=\"1280\" height=\"720\" autoplay=\"yes\" api_params=\"&amp;rel=0\" class=\"\"][fusion_text]\r\n<h1 style=\"text-align: center; font-size: 57px; line-height: 75px; color: #ed7c31;\">Birmingham Unreached People Groups</h1>\r\n<p style=\"text-align: center; margin-top: -20px; font-size: 18px;\">Find, Befriend, and Engage the people groups that God has moved to the Magic City.</p>\r\n[/fusion_text][separator style_type=\"none\" top_margin=\"20\" bottom_margin=\"20\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth][fullwidth backgroundcolor=\"#fff\" backgroundimage=\"\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"1px\" bordercolor=\"#e5e4e4\" borderstyle=\"solid\" paddingtop=\"55px\" paddingbottom=\"45px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"single\" top_margin=\"22\" bottom_margin=\"70\" sep_color=\"rgba(000,000,000,.1)\" icon=\"fa-chevron-down\" width=\"\" class=\"\" id=\"\"][one_half last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][postslider layout=\"posts\" excerpt=\"35\" category=\"design\" limit=\"2\" lightbox=\"yes\" class=\"\" id=\"\"][/postslider][/one_half][one_half last=\"yes\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][fusion_text]\r\n<h2>What Else? We Have The Best Support Around</h2>\r\n[/fusion_text][separator style_type=\"single\" top_margin=\"5\" bottom_margin=\"25\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]Avada is [tooltip title=\"Everting You Need To Create!\"]<strong>loaded with useful, functional options</strong>[/tooltip] that allow users to quickly and easily create stunning websites. But that\'s not all, when you purchase a copy of Avada you will also get the [tooltip title=\"Support Forum, Docs &amp; Videos!\"]<strong>most amazing customer support around!</strong>[/tooltip][/fusion_text][separator style_type=\"none\" top_margin=\"15\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][checklist icon=\"fa-star\" iconcolor=\"dark\" circle=\"no\" circlecolor=\"\" size=\"small\" class=\"\" id=\"\"][li_item icon=\"\"]Fully responsive so your content will always look good on any screen size[/li_item][li_item icon=\"\"]Awesome sliders give you the opportunity to showcase your content[/li_item][li_item icon=\"\"]Advanced theme options panel to easily customize your website[/li_item][/checklist][separator style_type=\"single\" top_margin=\"10\" bottom_margin=\"30\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"default\" size=\"large\" type=\"\" shape=\"\" target=\"_blank\" title=\"\" gradient_colors=\"|\" gradient_hover_colors=\"|\" accent_color=\"\" accent_hover_color=\"\" bevel_color=\"\" border_width=\"1px\" shadow=\"\" icon=\"\" icon_position=\"left\" icon_divider=\"yes\" modal=\"\" animation_type=\"fade\" animation_direction=\"down\" animation_speed=\"1\" alignment=\"\" class=\"\" id=\"\"]Buy Avada Now![/button][/one_half][/fullwidth][fullwidth backgroundcolor=\"\" backgroundimage=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/forest3.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"65px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][tagline_box backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"title=\"&lt;span\"\"\"\"\"\"\"\"\"\"\"\" shadow=\"no\" shadowopacity=\"0.1\" border=\"1px\" bordercolor=\"rgba(255,255,255,.4)\" highlightposition=\"top\" content_alignment=\"left\" link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" linktarget=\"_blank\" modal=\"\" button_size=\"large\" button_shape=\"square\" button_type=\"flat\" buttoncolor=\"\" button=\"Purchase Now\" title=\"\" description=\"\" animation_type=\"fade\" animation_direction=\"up\" animation_speed=\"1\" class=\"\" id=\"\"][/tagline_box][separator style_type=\"none\" top_margin=\"-20\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth]", "UPGhome", "", "inherit", "open", "open", "", "10995-revision-v1", "", "", "2015-04-12 23:17:12", "2015-04-12 23:17:12", "", "10995", "http://birminghamupg.com/bhamupg/?p=11010", "0", "revision", "", "0");
INSERT INTO `bupg_posts` VALUES("11011", "1", "2015-04-12 23:21:12", "2015-04-12 23:21:12", "[fullwidth backgroundcolor=\"\" backgroundimage=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/downtown1-300x200.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"100px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"single\" top_margin=\"-10\" bottom_margin=\"70\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][youtube id=\"HxeilZgGWBg\" width=\"1280\" height=\"720\" autoplay=\"yes\" api_params=\"&rel=0\" class=\"\"][fusion_text]<h1 style=\"text-align: center; font-size: 57px; line-height: 75px; color: #ed7c31;\"><strong>Birmingham Unreached People Groups</strong></h1>\r\n<p style=\"text-align: center; margin-top: -20px; font-size: 18px; color:#000;\"><span style=\"color:#ed7c31;\">Find Love Engage</span> the people groups that God has moved to the Magic City.</p>[/fusion_text][separator style_type=\"none\" top_margin=\"20\" bottom_margin=\"20\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth][fullwidth backgroundcolor=\"#fff\" backgroundimage=\"\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"1px\" bordercolor=\"#e5e4e4\" borderstyle=\"solid\" paddingtop=\"55px\" paddingbottom=\"45px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"single\" top_margin=\"22\" bottom_margin=\"70\" sep_color=\"rgba(000,000,000,.1)\" icon=\"fa-chevron-down\" width=\"\" class=\"\" id=\"\"][one_half last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][postslider layout=\"posts\" excerpt=\"35\" category=\"design\" limit=\"2\" lightbox=\"yes\" class=\"\" id=\"\"][/postslider][/one_half][one_half last=\"yes\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][fusion_text]\r\n<h2>What Else? We Have The Best Support Around</h2>\r\n[/fusion_text][separator style_type=\"single\" top_margin=\"5\" bottom_margin=\"25\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]Avada is [tooltip title=\"Everting You Need To Create!\"]<strong>loaded with useful, functional options</strong>[/tooltip] that allow users to quickly and easily create stunning websites. But that\'s not all, when you purchase a copy of Avada you will also get the [tooltip title=\"Support Forum, Docs & Videos!\"]<strong>most amazing customer support around!</strong>[/tooltip][/fusion_text][separator style_type=\"none\" top_margin=\"15\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][checklist icon=\"fa-star\" iconcolor=\"dark\" circle=\"no\" circlecolor=\"\" size=\"small\" class=\"\" id=\"\"][li_item icon=\"\"]Fully responsive so your content will always look good on any screen size[/li_item][li_item icon=\"\"]Awesome sliders give you the opportunity to showcase your content[/li_item][li_item icon=\"\"]Advanced theme options panel to easily customize your website[/li_item][/checklist][separator style_type=\"single\" top_margin=\"10\" bottom_margin=\"30\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"default\" size=\"large\"  type=\"\" shape=\"\" target=\"_blank\" title=\"\" gradient_colors=\"|\" gradient_hover_colors=\"|\" accent_color=\"\" accent_hover_color=\"\" bevel_color=\"\" border_width=\"1px\" shadow=\"\" icon=\"\" icon_position=\"left\" icon_divider=\"yes\" modal=\"\" animation_type=\"fade\" animation_direction=\"down\" animation_speed=\"1\" alignment=\"\" class=\"\" id=\"\"]Buy Avada Now![/button][/one_half][/fullwidth][fullwidth backgroundcolor=\"\" backgroundimage=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/forest3.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"65px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][tagline_box backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"title=\"<span\"\"\"\"\"\"\"\"\"\"\"\"\" shadow=\"no\" shadowopacity=\"0.1\" border=\"1px\" bordercolor=\"rgba(255,255,255,.4)\" highlightposition=\"top\" content_alignment=\"left\" link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" linktarget=\"_blank\" modal=\"\" button_size=\"large\" button_shape=\"square\" button_type=\"flat\" buttoncolor=\"\" button=\"Purchase Now\" title=\"\" description=\"\" animation_type=\"fade\" animation_direction=\"up\" animation_speed=\"1\" class=\"\" id=\"\"][/tagline_box][separator style_type=\"none\" top_margin=\"-20\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth]", "UPGhome", "", "inherit", "open", "open", "", "10995-revision-v1", "", "", "2015-04-12 23:21:12", "2015-04-12 23:21:12", "", "10995", "http://birminghamupg.com/bhamupg/?p=11011", "0", "revision", "", "0");
INSERT INTO `bupg_posts` VALUES("11012", "1", "2015-04-12 23:22:23", "2015-04-12 23:22:23", "[fullwidth backgroundcolor=\"\" backgroundimage=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/downtown1-300x200.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"100px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"single\" top_margin=\"-10\" bottom_margin=\"70\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][youtube id=\"HxeilZgGWBg\" width=\"1280\" height=\"720\" autoplay=\"yes\" api_params=\"&rel=0\" class=\"\"][fusion_text]<h1 style=\"text-align: center; font-size: 57px; line-height: 75px; color: #ed7c31;\"><strong>Birmingham Unreached People Groups</strong></h1>\r\n<p style=\"text-align: center; margin-top: -20px; font-size: 28px; color: #000;\"><span style=\"color: #ed7c31;\">Find Love Engage</span> the people groups that God has moved to the Magic City.</p>[/fusion_text][separator style_type=\"none\" top_margin=\"20\" bottom_margin=\"20\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth][fullwidth backgroundcolor=\"#fff\" backgroundimage=\"\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"1px\" bordercolor=\"#e5e4e4\" borderstyle=\"solid\" paddingtop=\"55px\" paddingbottom=\"45px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"single\" top_margin=\"22\" bottom_margin=\"70\" sep_color=\"rgba(000,000,000,.1)\" icon=\"fa-chevron-down\" width=\"\" class=\"\" id=\"\"][one_half last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][postslider layout=\"posts\" excerpt=\"35\" category=\"design\" limit=\"2\" lightbox=\"yes\" class=\"\" id=\"\"][/postslider][/one_half][one_half last=\"yes\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][fusion_text]\r\n<h2>What Else? We Have The Best Support Around</h2>\r\n[/fusion_text][separator style_type=\"single\" top_margin=\"5\" bottom_margin=\"25\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]Avada is [tooltip title=\"Everting You Need To Create!\"]<strong>loaded with useful, functional options</strong>[/tooltip] that allow users to quickly and easily create stunning websites. But that\'s not all, when you purchase a copy of Avada you will also get the [tooltip title=\"Support Forum, Docs & Videos!\"]<strong>most amazing customer support around!</strong>[/tooltip][/fusion_text][separator style_type=\"none\" top_margin=\"15\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][checklist icon=\"fa-star\" iconcolor=\"dark\" circle=\"no\" circlecolor=\"\" size=\"small\" class=\"\" id=\"\"][li_item icon=\"\"]Fully responsive so your content will always look good on any screen size[/li_item][li_item icon=\"\"]Awesome sliders give you the opportunity to showcase your content[/li_item][li_item icon=\"\"]Advanced theme options panel to easily customize your website[/li_item][/checklist][separator style_type=\"single\" top_margin=\"10\" bottom_margin=\"30\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"default\" size=\"large\"  type=\"\" shape=\"\" target=\"_blank\" title=\"\" gradient_colors=\"|\" gradient_hover_colors=\"|\" accent_color=\"\" accent_hover_color=\"\" bevel_color=\"\" border_width=\"1px\" shadow=\"\" icon=\"\" icon_position=\"left\" icon_divider=\"yes\" modal=\"\" animation_type=\"fade\" animation_direction=\"down\" animation_speed=\"1\" alignment=\"\" class=\"\" id=\"\"]Buy Avada Now![/button][/one_half][/fullwidth][fullwidth backgroundcolor=\"\" backgroundimage=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/forest3.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"65px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][tagline_box backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"title=\"<span\"\"\"\"\"\"\"\"\"\"\"\"\"\" shadow=\"no\" shadowopacity=\"0.1\" border=\"1px\" bordercolor=\"rgba(255,255,255,.4)\" highlightposition=\"top\" content_alignment=\"left\" link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" linktarget=\"_blank\" modal=\"\" button_size=\"large\" button_shape=\"square\" button_type=\"flat\" buttoncolor=\"\" button=\"Purchase Now\" title=\"\" description=\"\" animation_type=\"fade\" animation_direction=\"up\" animation_speed=\"1\" class=\"\" id=\"\"][/tagline_box][separator style_type=\"none\" top_margin=\"-20\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth]", "UPGhome", "", "inherit", "open", "open", "", "10995-revision-v1", "", "", "2015-04-12 23:22:23", "2015-04-12 23:22:23", "", "10995", "http://birminghamupg.com/bhamupg/?p=11012", "0", "revision", "", "0");
INSERT INTO `bupg_posts` VALUES("11013", "1", "2015-04-12 23:26:53", "2015-04-12 23:26:53", "[fullwidth backgroundcolor=\"\" backgroundimage=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/downtown1-300x200.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"100px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"single\" top_margin=\"-10\" bottom_margin=\"70\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][youtube id=\"HxeilZgGWBg\" width=\"1280\" height=\"720\" autoplay=\"yes\" api_params=\"&rel=0\" class=\"\"][fusion_text]<h1 style=\"text-align: center; font-size: 57px; line-height: 75px; color: #ed7c31;\"><strong>Birmingham Unreached People Groups</strong></h1>\r\n<p style=\"text-align: center; margin-top: -20px; font-size: 28px; color: #000;\"><span style=\"color: #ed7c31;\">Find &lt;&gt; Love &lt;&gt; Engage</span> the people groups that God has moved to the Magic City.</p>[/fusion_text][separator style_type=\"none\" top_margin=\"20\" bottom_margin=\"20\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth][fullwidth backgroundcolor=\"#fff\" backgroundimage=\"\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"1px\" bordercolor=\"#e5e4e4\" borderstyle=\"solid\" paddingtop=\"55px\" paddingbottom=\"45px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"single\" top_margin=\"22\" bottom_margin=\"70\" sep_color=\"rgba(000,000,000,.1)\" icon=\"fa-chevron-down\" width=\"\" class=\"\" id=\"\"][one_half last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][postslider layout=\"posts\" excerpt=\"35\" category=\"design\" limit=\"2\" lightbox=\"yes\" class=\"\" id=\"\"][/postslider][/one_half][one_half last=\"yes\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][fusion_text]\r\n<h2>What Else? We Have The Best Support Around</h2>\r\n[/fusion_text][separator style_type=\"single\" top_margin=\"5\" bottom_margin=\"25\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]Avada is [tooltip title=\"Everting You Need To Create!\"]<strong>loaded with useful, functional options</strong>[/tooltip] that allow users to quickly and easily create stunning websites. But that\'s not all, when you purchase a copy of Avada you will also get the [tooltip title=\"Support Forum, Docs & Videos!\"]<strong>most amazing customer support around!</strong>[/tooltip][/fusion_text][separator style_type=\"none\" top_margin=\"15\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][checklist icon=\"fa-star\" iconcolor=\"dark\" circle=\"no\" circlecolor=\"\" size=\"small\" class=\"\" id=\"\"][li_item icon=\"\"]Fully responsive so your content will always look good on any screen size[/li_item][li_item icon=\"\"]Awesome sliders give you the opportunity to showcase your content[/li_item][li_item icon=\"\"]Advanced theme options panel to easily customize your website[/li_item][/checklist][separator style_type=\"single\" top_margin=\"10\" bottom_margin=\"30\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][button link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" color=\"default\" size=\"large\"  type=\"\" shape=\"\" target=\"_blank\" title=\"\" gradient_colors=\"|\" gradient_hover_colors=\"|\" accent_color=\"\" accent_hover_color=\"\" bevel_color=\"\" border_width=\"1px\" shadow=\"\" icon=\"\" icon_position=\"left\" icon_divider=\"yes\" modal=\"\" animation_type=\"fade\" animation_direction=\"down\" animation_speed=\"1\" alignment=\"\" class=\"\" id=\"\"]Buy Avada Now![/button][/one_half][/fullwidth][fullwidth backgroundcolor=\"\" backgroundimage=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/forest3.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"65px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][tagline_box backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"title=\"<span\"\"\"\"\"\"\"\"\"\"\"\"\"\"\" shadow=\"no\" shadowopacity=\"0.1\" border=\"1px\" bordercolor=\"rgba(255,255,255,.4)\" highlightposition=\"top\" content_alignment=\"left\" link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" linktarget=\"_blank\" modal=\"\" button_size=\"large\" button_shape=\"square\" button_type=\"flat\" buttoncolor=\"\" button=\"Purchase Now\" title=\"\" description=\"\" animation_type=\"fade\" animation_direction=\"up\" animation_speed=\"1\" class=\"\" id=\"\"][/tagline_box][separator style_type=\"none\" top_margin=\"-20\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth]", "UPGhome", "", "inherit", "open", "open", "", "10995-revision-v1", "", "", "2015-04-12 23:26:53", "2015-04-12 23:26:53", "", "10995", "http://birminghamupg.com/bhamupg/?p=11013", "0", "revision", "", "0");
INSERT INTO `bupg_posts` VALUES("11014", "1", "2015-04-13 00:01:36", "2015-04-13 00:01:36", "[fullwidth backgroundcolor=\"\" backgroundimage=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/downtown1-300x200.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"100px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"single\" top_margin=\"-10\" bottom_margin=\"70\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][youtube id=\"HxeilZgGWBg\" width=\"1280\" height=\"720\" autoplay=\"yes\" api_params=\"&amp;rel=0\" class=\"\"][fusion_text]\r\n<h1 style=\"text-align: center; font-size: 57px; line-height: 75px; color: #ed7c31;\"><strong>Birmingham Unreached People Groups</strong></h1>\r\n<p style=\"text-align: center; margin-top: -20px; font-size: 28px; color: #000;\"><span style=\"color: #ed7c31;\">Find &lt;&gt; Love &lt;&gt; Engage</span> the people groups that God has moved to the Magic City.</p>\r\n[/fusion_text][separator style_type=\"none\" top_margin=\"20\" bottom_margin=\"20\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth][fullwidth backgroundcolor=\"#fff\" backgroundimage=\"\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"1px\" bordercolor=\"#e5e4e4\" borderstyle=\"solid\" paddingtop=\"55px\" paddingbottom=\"45px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][/fullwidth][one_third last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img alt=\"\" />[/imageframe][fusion_text]Click edit button to change this text.[/fusion_text][/one_third][one_third last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img alt=\"\" />[/imageframe][fusion_text]Click edit button to change this text.[/fusion_text][/one_third][one_third last=\"yes\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img alt=\"\" />[/imageframe][fusion_text]Click edit button to change this text.[/fusion_text][/one_third][fullwidth backgroundcolor=\"\" backgroundimage=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/forest3.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"65px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][tagline_box backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"title=\"&lt;span\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\" shadow=\"no\" shadowopacity=\"0.1\" border=\"1px\" bordercolor=\"rgba(255,255,255,.4)\" highlightposition=\"top\" content_alignment=\"left\" link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" linktarget=\"_blank\" modal=\"\" button_size=\"large\" button_shape=\"square\" button_type=\"flat\" buttoncolor=\"\" button=\"Purchase Now\" title=\"\" description=\"\" animation_type=\"fade\" animation_direction=\"up\" animation_speed=\"1\" class=\"\" id=\"\"][/tagline_box][separator style_type=\"none\" top_margin=\"-20\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth][one_third last=\"yes\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][/one_third][fontawesome icon=\"fa-flag\" circle=\"yes\" size=\"small\" iconcolor=\"\" circlecolor=\"\" circlebordercolor=\"\" flip=\"\" rotate=\"\" spin=\"\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"\" alignment=\"\" class=\"\" id=\"\"]", "UPGhome", "", "inherit", "open", "open", "", "10995-revision-v1", "", "", "2015-04-13 00:01:36", "2015-04-13 00:01:36", "", "10995", "http://birminghamupg.com/bhamupg/?p=11014", "0", "revision", "", "0");
INSERT INTO `bupg_posts` VALUES("11015", "1", "2015-04-13 00:06:29", "2015-04-13 00:06:29", "[fullwidth backgroundcolor=\"\" backgroundimage=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/downtown1-300x200.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"100px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"single\" top_margin=\"-10\" bottom_margin=\"70\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][youtube id=\"HxeilZgGWBg\" width=\"1280\" height=\"720\" autoplay=\"yes\" api_params=\"&amp;rel=0\" class=\"\"][fusion_text]\r\n<h1 style=\"text-align: center; font-size: 57px; line-height: 75px; color: #ed7c31;\"><strong>Birmingham Unreached People Groups</strong></h1>\r\n<p style=\"text-align: center; margin-top: -20px; font-size: 28px; color: #000;\"><span style=\"color: #ed7c31;\">Find &lt;&gt; Love &lt;&gt; Engage</span> the people groups that God has moved to the Magic City.</p>\r\n[/fusion_text][separator style_type=\"none\" top_margin=\"20\" bottom_margin=\"20\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth][fullwidth backgroundcolor=\"#fff\" backgroundimage=\"\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"1px\" bordercolor=\"#e5e4e4\" borderstyle=\"solid\" paddingtop=\"55px\" paddingbottom=\"45px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][/fullwidth][one_third last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img alt=\"\" />[/imageframe][fusion_text]Click edit button to change this text.[/fusion_text][/one_third][one_third last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img alt=\"\" />[/imageframe][fusion_text]Click edit button to change this text.[/fusion_text][/one_third][one_third last=\"yes\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img alt=\"\" />[/imageframe][fusion_text]Click edit button to change this text.[/fusion_text][/one_third][fullwidth backgroundcolor=\"\" backgroundimage=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/forest3.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"65px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][tagline_box backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"title=\"&lt;span\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\" shadow=\"no\" shadowopacity=\"0.1\" border=\"1px\" bordercolor=\"rgba(255,255,255,.4)\" highlightposition=\"top\" content_alignment=\"left\" link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" linktarget=\"_blank\" modal=\"\" button_size=\"large\" button_shape=\"square\" button_type=\"flat\" buttoncolor=\"\" button=\"Purchase Now\" title=\"\" description=\"\" animation_type=\"fade\" animation_direction=\"up\" animation_speed=\"1\" class=\"\" id=\"\"][/tagline_box][separator style_type=\"none\" top_margin=\"-20\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth][one_third last=\"yes\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][/one_third][fontawesome icon=\"fa-flag\" circle=\"yes\" size=\"small\" iconcolor=\"\" circlecolor=\"\" circlebordercolor=\"\" flip=\"\" rotate=\"\" spin=\"\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"\" alignment=\"\" class=\"\" id=\"\"]", "UPGhome", "", "inherit", "open", "open", "", "10995-revision-v1", "", "", "2015-04-13 00:06:29", "2015-04-13 00:06:29", "", "10995", "http://birminghamupg.com/bhamupg/?p=11015", "0", "revision", "", "0");
INSERT INTO `bupg_posts` VALUES("11016", "1", "2015-04-13 00:12:20", "2015-04-13 00:12:20", "[fullwidth backgroundcolor=\"\" backgroundimage=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/downtown1-300x200.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"100px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"single\" top_margin=\"-10\" bottom_margin=\"70\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][youtube id=\"HxeilZgGWBg\" width=\"1280\" height=\"720\" autoplay=\"yes\" api_params=\"&amp;rel=0\" class=\"\"][fusion_text]\r\n<h1 style=\"text-align: center; font-size: 57px; line-height: 75px; color: #ed7c31;\"><strong>Birmingham Unreached People Groups</strong></h1>\r\n<p style=\"text-align: center; margin-top: -20px; font-size: 28px; color: #000;\"><span style=\"color: #ed7c31;\">Find &lt;&gt; Love &lt;&gt; Engage</span> the people groups that God has moved to the Magic City.</p>\r\n[/fusion_text][separator style_type=\"none\" top_margin=\"20\" bottom_margin=\"20\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth][one_third last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img alt=\"\" />[/imageframe][separator style_type=\"none\" top_margin=\"\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]Click edit button to change this text.[/fusion_text][/one_third][one_third last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img alt=\"\" />[/imageframe][separator style_type=\"none\" top_margin=\"\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]Click edit button to change this text.[/fusion_text][/one_third][one_third last=\"yes\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img alt=\"\" />[/imageframe][separator style_type=\"none\" top_margin=\"\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]Click edit button to change this text.[/fusion_text][/one_third][fullwidth backgroundcolor=\"\" backgroundimage=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/forest3.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"65px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][tagline_box backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"title=\"&lt;span\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\" shadow=\"no\" shadowopacity=\"0.1\" border=\"1px\" bordercolor=\"rgba(255,255,255,.4)\" highlightposition=\"top\" content_alignment=\"left\" link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" linktarget=\"_blank\" modal=\"\" button_size=\"large\" button_shape=\"square\" button_type=\"flat\" buttoncolor=\"\" button=\"Purchase Now\" title=\"\" description=\"\" animation_type=\"fade\" animation_direction=\"up\" animation_speed=\"1\" class=\"\" id=\"\"][/tagline_box][separator style_type=\"none\" top_margin=\"-20\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth][one_third last=\"yes\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][/one_third][fontawesome icon=\"fa-flag\" circle=\"yes\" size=\"small\" iconcolor=\"\" circlecolor=\"\" circlebordercolor=\"\" flip=\"\" rotate=\"\" spin=\"\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"\" alignment=\"\" class=\"\" id=\"\"]", "UPGhome", "", "inherit", "open", "open", "", "10995-revision-v1", "", "", "2015-04-13 00:12:20", "2015-04-13 00:12:20", "", "10995", "http://birminghamupg.com/bhamupg/?p=11016", "0", "revision", "", "0");
INSERT INTO `bupg_posts` VALUES("11017", "1", "2015-04-13 00:16:35", "2015-04-13 00:16:35", "[fullwidth backgroundcolor=\"\" backgroundimage=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/downtown1-300x200.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"100px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"single\" top_margin=\"-10\" bottom_margin=\"70\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][youtube id=\"HxeilZgGWBg\" width=\"1280\" height=\"720\" autoplay=\"yes\" api_params=\"&amp;rel=0\" class=\"\"][fusion_text]\r\n<h1 style=\"text-align: center; font-size: 57px; line-height: 75px; color: #ed7c31;\"><strong>Birmingham Unreached People Groups</strong></h1>\r\n<p style=\"text-align: center; margin-top: -20px; font-size: 28px; color: #000;\"><span style=\"color: #ed7c31;\">Find &lt;&gt; Love &lt;&gt; Engage</span> the people groups that God has moved to the Magic City.</p>\r\n[/fusion_text][separator style_type=\"none\" top_margin=\"20\" bottom_margin=\"20\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth][one_third last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img alt=\"\" />[/imageframe][separator style_type=\"none\" top_margin=\"\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]Click edit button to change this text.[/fusion_text][/one_third][one_third last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img alt=\"\" />[/imageframe][separator style_type=\"none\" top_margin=\"\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]Click edit button to change this text.[/fusion_text][/one_third][one_third last=\"yes\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img alt=\"\" />[/imageframe][separator style_type=\"none\" top_margin=\"\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]Click edit button to change this text.[/fusion_text][/one_third][fullwidth backgroundcolor=\"\" backgroundimage=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/forest3.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"65px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][tagline_box backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"title=\"&lt;span\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\" shadow=\"no\" shadowopacity=\"0.1\" border=\"1px\" bordercolor=\"rgba(255,255,255,.4)\" highlightposition=\"top\" content_alignment=\"left\" link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" linktarget=\"_blank\" modal=\"\" button_size=\"large\" button_shape=\"square\" button_type=\"flat\" buttoncolor=\"\" button=\"Purchase Now\" title=\"\" description=\"\" animation_type=\"fade\" animation_direction=\"up\" animation_speed=\"1\" class=\"\" id=\"\"][/tagline_box][separator style_type=\"none\" top_margin=\"-20\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth][one_third last=\"yes\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][/one_third][fontawesome icon=\"fa-flag\" circle=\"yes\" size=\"small\" iconcolor=\"\" circlecolor=\"\" circlebordercolor=\"\" flip=\"\" rotate=\"\" spin=\"\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"\" alignment=\"\" class=\"\" id=\"\"]", "UPGhome", "", "inherit", "open", "open", "", "10995-revision-v1", "", "", "2015-04-13 00:16:35", "2015-04-13 00:16:35", "", "10995", "http://birminghamupg.com/bhamupg/?p=11017", "0", "revision", "", "0");
INSERT INTO `bupg_posts` VALUES("11018", "1", "2015-04-13 00:17:13", "2015-04-13 00:17:13", "[fullwidth backgroundcolor=\"\" backgroundimage=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/downtown1-300x200.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"100px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"single\" top_margin=\"-10\" bottom_margin=\"70\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][youtube id=\"HxeilZgGWBg\" width=\"1280\" height=\"720\" autoplay=\"yes\" api_params=\"&amp;rel=0\" class=\"\"][fusion_text]\r\n<h1 style=\"text-align: center; font-size: 57px; line-height: 75px; color: #ed7c31;\"><strong>Birmingham Unreached People Groups</strong></h1>\r\n<p style=\"text-align: center; margin-top: -20px; font-size: 28px; color: #000;\"><span style=\"color: #ed7c31;\">Find &lt;&gt; Love &lt;&gt; Engage</span> the people groups that God has moved to the Magic City.</p>\r\n[/fusion_text][separator style_type=\"none\" top_margin=\"20\" bottom_margin=\"20\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth][one_third last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img alt=\"\" />[/imageframe][separator style_type=\"none\" top_margin=\"\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]Click edit button to change this text.[/fusion_text][/one_third][one_third last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img alt=\"\" />[/imageframe][separator style_type=\"none\" top_margin=\"\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]Click edit button to change this text.[/fusion_text][/one_third][one_third last=\"yes\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img alt=\"\" />[/imageframe][separator style_type=\"none\" top_margin=\"\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]Click edit button to change this text.[/fusion_text][/one_third][fullwidth backgroundcolor=\"\" backgroundimage=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/forest3.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"65px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][tagline_box backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"title=\"&lt;span\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\" shadow=\"no\" shadowopacity=\"0.1\" border=\"1px\" bordercolor=\"rgba(255,255,255,.4)\" highlightposition=\"top\" content_alignment=\"left\" link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" linktarget=\"_blank\" modal=\"\" button_size=\"large\" button_shape=\"square\" button_type=\"flat\" buttoncolor=\"\" button=\"Purchase Now\" title=\"\" description=\"\" animation_type=\"fade\" animation_direction=\"up\" animation_speed=\"1\" class=\"\" id=\"\"][/tagline_box][separator style_type=\"none\" top_margin=\"-20\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth][fontawesome icon=\"fa-flag\" circle=\"yes\" size=\"small\" iconcolor=\"\" circlecolor=\"\" circlebordercolor=\"\" flip=\"\" rotate=\"\" spin=\"\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"\" alignment=\"\" class=\"\" id=\"\"]", "UPGhome", "", "inherit", "open", "open", "", "10995-revision-v1", "", "", "2015-04-13 00:17:13", "2015-04-13 00:17:13", "", "10995", "http://birminghamupg.com/bhamupg/?p=11018", "0", "revision", "", "0");
INSERT INTO `bupg_posts` VALUES("11019", "1", "2015-04-13 00:30:58", "2015-04-13 00:30:58", "[fullwidth backgroundcolor=\"\" backgroundimage=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/downtown1-300x200.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"100px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"single\" top_margin=\"-10\" bottom_margin=\"70\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][youtube id=\"HxeilZgGWBg\" width=\"1280\" height=\"720\" autoplay=\"yes\" api_params=\"&amp;rel=0\" class=\"\"][fusion_text]\r\n<h1 style=\"text-align: center; font-size: 57px; line-height: 75px; color: #ed7c31;\"><strong>Birmingham Unreached People Groups</strong></h1>\r\n<p style=\"text-align: center; margin-top: -20px; font-size: 28px; color: #000;\"><span style=\"color: #ed7c31;\">Find &lt;&gt; Love &lt;&gt; Engage</span> the people groups that God has moved to the Magic City.</p>\r\n[/fusion_text][separator style_type=\"none\" top_margin=\"20\" bottom_margin=\"20\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth][fullwidth backgroundcolor=\"\" backgroundimage=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/forest3.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"65px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][tagline_box backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"title=\"&lt;span\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\" shadow=\"no\" shadowopacity=\"0.1\" border=\"1px\" bordercolor=\"rgba(255,255,255,.4)\" highlightposition=\"top\" content_alignment=\"left\" link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" linktarget=\"_blank\" modal=\"\" button_size=\"large\" button_shape=\"square\" button_type=\"flat\" buttoncolor=\"\" button=\"Purchase Now\" title=\"\" description=\"\" animation_type=\"fade\" animation_direction=\"up\" animation_speed=\"1\" class=\"\" id=\"\"][/tagline_box][separator style_type=\"none\" top_margin=\"-20\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth][fontawesome icon=\"fa-flag\" circle=\"yes\" size=\"small\" iconcolor=\"\" circlecolor=\"\" circlebordercolor=\"\" flip=\"\" rotate=\"\" spin=\"\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"\" alignment=\"\" class=\"\" id=\"\"]", "UPGhome", "", "inherit", "open", "open", "", "10995-revision-v1", "", "", "2015-04-13 00:30:58", "2015-04-13 00:30:58", "", "10995", "http://birminghamupg.com/bhamupg/?p=11019", "0", "revision", "", "0");
INSERT INTO `bupg_posts` VALUES("11020", "1", "2015-04-13 02:07:06", "2015-04-13 02:07:06", "[fullwidth backgroundcolor=\"\" backgroundimage=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/downtown1-300x200.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"100px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"single\" top_margin=\"-10\" bottom_margin=\"70\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][youtube id=\"HxeilZgGWBg\" width=\"1280\" height=\"720\" autoplay=\"yes\" api_params=\"&amp;rel=0\" class=\"\"][fusion_text]\r\n<h1 style=\"text-align: center; font-size: 57px; line-height: 75px; color: #ed7c31;\"><strong>Birmingham Unreached People Groups</strong></h1>\r\n<p style=\"text-align: center; margin-top: -20px; font-size: 28px; color: #000;\"><span style=\"color: #ed7c31;\">Find &lt;&gt; Love &lt;&gt; Engage</span> the people groups that God has moved to the Magic City.</p>\r\n[/fusion_text][separator style_type=\"none\" top_margin=\"20\" bottom_margin=\"20\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth][fullwidth backgroundcolor=\"\" backgroundimage=\"\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"scroll\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"\" paddingtop=\"20px\" paddingbottom=\"20px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][one_third last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img alt=\"\" />[/imageframe][/one_third][one_third last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img alt=\"\" />[/imageframe][/one_third][one_third last=\"yes\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"solid\" padding=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img alt=\"\" />[/imageframe][/one_third][/fullwidth][fullwidth backgroundcolor=\"\" backgroundimage=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/forest3.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"65px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][tagline_box backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"title=\"&lt;span\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\" shadow=\"no\" shadowopacity=\"0.1\" border=\"1px\" bordercolor=\"rgba(255,255,255,.4)\" highlightposition=\"top\" content_alignment=\"left\" link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" linktarget=\"_blank\" modal=\"\" button_size=\"large\" button_shape=\"square\" button_type=\"flat\" buttoncolor=\"\" button=\"Purchase Now\" title=\"\" description=\"\" animation_type=\"fade\" animation_direction=\"up\" animation_speed=\"1\" class=\"\" id=\"\"][/tagline_box][separator style_type=\"none\" top_margin=\"-20\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth][fontawesome icon=\"fa-flag\" circle=\"yes\" size=\"small\" iconcolor=\"\" circlecolor=\"\" circlebordercolor=\"\" flip=\"\" rotate=\"\" spin=\"\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"\" alignment=\"\" class=\"\" id=\"\"]", "UPGhome", "", "inherit", "open", "open", "", "10995-revision-v1", "", "", "2015-04-13 02:07:06", "2015-04-13 02:07:06", "", "10995", "http://birminghamupg.com/bhamupg/?p=11020", "0", "revision", "", "0");
INSERT INTO `bupg_posts` VALUES("11021", "1", "2015-04-13 02:08:53", "2015-04-13 02:08:53", "[fullwidth backgroundcolor=\"\" backgroundimage=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/downtown1-300x200.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"100px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"single\" top_margin=\"-10\" bottom_margin=\"70\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][youtube id=\"HxeilZgGWBg\" width=\"1280\" height=\"720\" autoplay=\"yes\" api_params=\"&amp;rel=0\" class=\"\"][fusion_text]\r\n<h1 style=\"text-align: center; font-size: 57px; line-height: 75px; color: #ed7c31;\"><strong>Birmingham Unreached People Groups</strong></h1>\r\n<p style=\"text-align: center; margin-top: -20px; font-size: 28px; color: #000;\"><span style=\"color: #ed7c31;\">Find &lt;&gt; Love &lt;&gt; Engage</span> the people groups that God has moved to the Magic City.</p>\r\n[/fusion_text][separator style_type=\"none\" top_margin=\"20\" bottom_margin=\"20\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth][fullwidth backgroundcolor=\"\" backgroundimage=\"\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"scroll\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"\" paddingtop=\"20px\" paddingbottom=\"20px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][one_third last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img alt=\"\" />[/imageframe][separator style_type=\"none\" top_margin=\"\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]Click edit button to change this text.[/fusion_text][/one_third][one_third last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img alt=\"\" />[/imageframe][separator style_type=\"none\" top_margin=\"\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]Click edit button to change this text.[/fusion_text][/one_third][one_third last=\"yes\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"solid\" padding=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img alt=\"\" />[/imageframe][separator style_type=\"none\" top_margin=\"\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]Click edit button to change this text.[/fusion_text][/one_third][/fullwidth][fullwidth backgroundcolor=\"\" backgroundimage=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/forest3.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"65px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][tagline_box backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"title=\"&lt;span\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\" shadow=\"no\" shadowopacity=\"0.1\" border=\"1px\" bordercolor=\"rgba(255,255,255,.4)\" highlightposition=\"top\" content_alignment=\"left\" link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" linktarget=\"_blank\" modal=\"\" button_size=\"large\" button_shape=\"square\" button_type=\"flat\" buttoncolor=\"\" button=\"Purchase Now\" title=\"\" description=\"\" animation_type=\"fade\" animation_direction=\"up\" animation_speed=\"1\" class=\"\" id=\"\"][/tagline_box][separator style_type=\"none\" top_margin=\"-20\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth][fontawesome icon=\"fa-flag\" circle=\"yes\" size=\"small\" iconcolor=\"\" circlecolor=\"\" circlebordercolor=\"\" flip=\"\" rotate=\"\" spin=\"\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"\" alignment=\"\" class=\"\" id=\"\"][fusion_text]Click edit button to change this text.[/fusion_text]", "UPGhome", "", "inherit", "open", "open", "", "10995-revision-v1", "", "", "2015-04-13 02:08:53", "2015-04-13 02:08:53", "", "10995", "http://birminghamupg.com/bhamupg/?p=11021", "0", "revision", "", "0");
INSERT INTO `bupg_posts` VALUES("11022", "1", "2015-04-13 02:12:53", "2015-04-13 02:12:53", "[fullwidth backgroundcolor=\"\" backgroundimage=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/downtown1-300x200.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"100px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"single\" top_margin=\"-10\" bottom_margin=\"70\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][youtube id=\"HxeilZgGWBg\" width=\"1280\" height=\"720\" autoplay=\"yes\" api_params=\"&amp;rel=0\" class=\"\"][fusion_text]\r\n<h1 style=\"text-align: center; font-size: 57px; line-height: 75px; color: #000;\"><strong>Birmingham Unreached People Groups</strong></h1>\r\n<p style=\"text-align: center; margin-top: -20px; font-size: 28px; color: #000;\"><span style=\"color: #ed7c31;\">Find &lt;&gt; Love &lt;&gt; Engage</span> the people groups that God has moved to the Magic City.</p>\r\n[/fusion_text][separator style_type=\"none\" top_margin=\"20\" bottom_margin=\"20\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth][fullwidth backgroundcolor=\"\" backgroundimage=\"\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"scroll\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"\" paddingtop=\"20px\" paddingbottom=\"20px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][one_third last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img alt=\"\" />[/imageframe][separator style_type=\"none\" top_margin=\"\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]Click edit button to change this text.[/fusion_text][/one_third][one_third last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img alt=\"\" />[/imageframe][separator style_type=\"none\" top_margin=\"\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]Click edit button to change this text.[/fusion_text][/one_third][one_third last=\"yes\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"solid\" padding=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img alt=\"\" />[/imageframe][separator style_type=\"none\" top_margin=\"\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]Click edit button to change this text.[/fusion_text][/one_third][/fullwidth][fullwidth backgroundcolor=\"\" backgroundimage=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/forest3.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"65px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][tagline_box backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"title=\"&lt;span\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\" shadow=\"no\" shadowopacity=\"0.1\" border=\"1px\" bordercolor=\"rgba(255,255,255,.4)\" highlightposition=\"top\" content_alignment=\"left\" link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" linktarget=\"_blank\" modal=\"\" button_size=\"large\" button_shape=\"square\" button_type=\"flat\" buttoncolor=\"\" button=\"Purchase Now\" title=\"\" description=\"\" animation_type=\"fade\" animation_direction=\"up\" animation_speed=\"1\" class=\"\" id=\"\"][/tagline_box][separator style_type=\"none\" top_margin=\"-20\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth][fontawesome icon=\"fa-flag\" circle=\"yes\" size=\"small\" iconcolor=\"\" circlecolor=\"\" circlebordercolor=\"\" flip=\"\" rotate=\"\" spin=\"\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"\" alignment=\"\" class=\"\" id=\"\"][fusion_text]Click edit button to change this text.[/fusion_text]", "UPGhome", "", "inherit", "open", "open", "", "10995-revision-v1", "", "", "2015-04-13 02:12:53", "2015-04-13 02:12:53", "", "10995", "http://birminghamupg.com/bhamupg/?p=11022", "0", "revision", "", "0");
INSERT INTO `bupg_posts` VALUES("11023", "1", "2015-04-13 02:19:22", "2015-04-13 02:19:22", "[fullwidth backgroundcolor=\"\" backgroundimage=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/downtown1-300x200.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"100px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"single\" top_margin=\"-10\" bottom_margin=\"70\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][youtube id=\"HxeilZgGWBg\" width=\"1280\" height=\"720\" autoplay=\"yes\" api_params=\"&rel=0\" class=\"\"][fusion_text]\r\n<h1 style=\"text-align: center; font-size: 57px; line-height: 75px; color: #000;\"><strong>Birmingham Unreached People Groups</strong></h1>\r\n<p style=\"text-align: center; margin-top: -20px; font-size: 28px; color: #000;\"><span style=\"color: #ed7c31;\">Find <> Love <> Engage</span> the people groups that God has moved to the Magic City.</p>\r\n[/fusion_text][separator style_type=\"none\" top_margin=\"20\" bottom_margin=\"20\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth][fullwidth backgroundcolor=\"\" backgroundimage=\"\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"scroll\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"\" paddingtop=\"20px\" paddingbottom=\"20px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][one_third last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][imageframe lightbox=\"yes\" style_type=\"glow\" bordercolor=\"\" bordersize=\"2px\" borderradius=\"4\" stylecolor=\"#dd9933\" align=\"center\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img alt=\"\" src=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/3873.jpg\" />[/imageframe][separator style_type=\"none\" top_margin=\"\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]<h2>Responsive Design</h2>\r\nAvada is fully responsive and can adapt to any screen size, its incredibly fast and flexible. Resize your browser window to see the action.[/fusion_text][/one_third][one_third last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"dropshadow\" bordercolor=\"#dd9933\" bordersize=\"4px\" borderradius=\"6\" stylecolor=\"\" align=\"center\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img alt=\"\" src=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/9756.jpg\" />[/imageframe][separator style_type=\"none\" top_margin=\"\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]<h2>Responsive Design</h2>\r\nAvada is fully responsive and can adapt to any screen size, its incredibly fast and flexible. Resize your browser window to see the action.[/fusion_text][/one_third][one_third last=\"yes\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"solid\" padding=\"\" class=\"\" id=\"\"][imageframe lightbox=\"no\" style_type=\"bottomshadow\" bordercolor=\"#dd9933\" bordersize=\"4px\" borderradius=\"8\" stylecolor=\"\" align=\"center\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img alt=\"\" src=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/9757.jpg\" />[/imageframe][separator style_type=\"none\" top_margin=\"\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][fusion_text]<h2>Responsive Design</h2>\r\nAvada is fully responsive and can adapt to any screen size, its incredibly fast and flexible. Resize your browser window to see the action.[/fusion_text][/one_third][/fullwidth][fullwidth backgroundcolor=\"\" backgroundimage=\"http://theme-fusion.com/avada/wp-content/uploads/2013/05/forest3.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"65px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][tagline_box backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"backgroundcolor=\"title=\"<span\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\"\" shadow=\"no\" shadowopacity=\"0.1\" border=\"1px\" bordercolor=\"rgba(255,255,255,.4)\" highlightposition=\"top\" content_alignment=\"left\" link=\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226?ref=ThemeFusion\" linktarget=\"_blank\" modal=\"\" button_size=\"large\" button_shape=\"square\" button_type=\"flat\" buttoncolor=\"\" button=\"Purchase Now\" title=\"\" description=\"\" animation_type=\"fade\" animation_direction=\"up\" animation_speed=\"1\" class=\"\" id=\"\"][/tagline_box][separator style_type=\"none\" top_margin=\"-20\" bottom_margin=\"\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth][fontawesome icon=\"fa-flag\" circle=\"yes\" size=\"small\" iconcolor=\"\" circlecolor=\"\" circlebordercolor=\"\" flip=\"\" rotate=\"\" spin=\"\" animation_type=\"0\" animation_direction=\"\" animation_speed=\"\" alignment=\"\" class=\"\" id=\"\"][fusion_text]Click edit button to change this text.[/fusion_text]", "UPGhome", "", "inherit", "open", "open", "", "10995-revision-v1", "", "", "2015-04-13 02:19:22", "2015-04-13 02:19:22", "", "10995", "http://birminghamupg.com/bhamupg/?p=11023", "0", "revision", "", "0");
INSERT INTO `bupg_posts` VALUES("11025", "1", "2015-04-13 02:37:53", "2015-04-13 02:37:53", "[fullwidth backgroundcolor=\"\" backgroundimage=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/downtown1-300x200.jpg\" backgroundrepeat=\"no-repeat\" backgroundposition=\"center center\" backgroundattachment=\"fixed\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"solid\" paddingtop=\"100px\" paddingbottom=\"0px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][separator style_type=\"single\" top_margin=\"-10\" bottom_margin=\"70\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][youtube id=\"HxeilZgGWBg\" width=\"1280\" height=\"720\" autoplay=\"yes\" api_params=\"&rel=0\" class=\"\"][fusion_text]\r\n<h1 style=\"text-align: center; font-size: 57px; line-height: 75px; color: #000;\"><strong>Birmingham Unreached People Groups</strong></h1>\r\n<p style=\"text-align: center; margin-top: -20px; font-size: 28px; color: #000;\"><span style=\"color: #ed7c31;\">Find <> Love <> Engage</span> the people groups that God has moved to the Magic City.</p>\r\n[/fusion_text][separator style_type=\"none\" top_margin=\"20\" bottom_margin=\"20\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"][/fullwidth][fullwidth backgroundcolor=\"\" backgroundimage=\"\" backgroundrepeat=\"no-repeat\" backgroundposition=\"left top\" backgroundattachment=\"scroll\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" bordersize=\"0px\" bordercolor=\"\" borderstyle=\"\" paddingtop=\"20px\" paddingbottom=\"20px\" paddingleft=\"0px\" paddingright=\"0px\" menu_anchor=\"\" equal_height_columns=\"no\" hundred_percent=\"no\" class=\"\" id=\"\"][one_third last=\"no\" spacing=\"yes\" background_color=\"\" background_image=\"\" background_repeat=\"no-repeat\" background_position=\"left top\" border_size=\"0px\" border_color=\"\" border_style=\"\" padding=\"\" class=\"\" id=\"\"][imageframe lightbox=\"yes\" style_type=\"glow\" bordercolor=\"\" bordersize=\"2px\" borderradius=\"4\" stylecolor=\"#dd9933\" align=\"center\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"] <img alt=\"\" src=\"http://birminghamupg.com/bhamupg/wp-content/uploads/2015/04/3873.jpg\" />[/imageframe][separator sty